/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.semantic.visitor;

import java.util.List;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;
import org.opensearch.sql.legacy.antlr.semantic.visitor.OpenSearchMappingLoader;
import org.opensearch.sql.legacy.antlr.semantic.visitor.TypeChecker;
import org.opensearch.sql.legacy.antlr.visitor.GenericSqlParseTreeVisitor;
import org.opensearch.sql.legacy.utils.StringUtils;

public class SemanticAnalyzer
implements GenericSqlParseTreeVisitor<Type> {
    private final OpenSearchMappingLoader mappingLoader;
    private final TypeChecker typeChecker;

    public SemanticAnalyzer(OpenSearchMappingLoader mappingLoader, TypeChecker typeChecker) {
        this.mappingLoader = mappingLoader;
        this.typeChecker = typeChecker;
    }

    @Override
    public void visitRoot() {
        this.mappingLoader.visitRoot();
        this.typeChecker.visitRoot();
    }

    @Override
    public void visitQuery() {
        this.mappingLoader.visitQuery();
        this.typeChecker.visitQuery();
    }

    @Override
    public void endVisitQuery() {
        this.mappingLoader.endVisitQuery();
        this.typeChecker.endVisitQuery();
    }

    @Override
    public Type visitSelect(List<Type> itemTypes) {
        this.mappingLoader.visitSelect(itemTypes);
        return this.typeChecker.visitSelect((List)itemTypes);
    }

    @Override
    public Type visitSelectAllColumn() {
        this.mappingLoader.visitSelectAllColumn();
        return this.typeChecker.visitSelectAllColumn();
    }

    @Override
    public void visitAs(String alias, Type type2) {
        this.mappingLoader.visitAs(StringUtils.unquoteSingleField(alias), type2);
        this.typeChecker.visitAs(StringUtils.unquoteSingleField(alias), type2);
    }

    @Override
    public Type visitIndexName(String indexName) {
        this.mappingLoader.visitIndexName(StringUtils.unquoteSingleField(indexName));
        return this.typeChecker.visitIndexName(StringUtils.unquoteSingleField(indexName));
    }

    @Override
    public Type visitFieldName(String fieldName) {
        this.mappingLoader.visitFieldName(StringUtils.unquoteFullColumn(fieldName));
        return this.typeChecker.visitFieldName(StringUtils.unquoteFullColumn(fieldName));
    }

    @Override
    public Type visitFunctionName(String funcName) {
        this.mappingLoader.visitFunctionName(funcName);
        return this.typeChecker.visitFunctionName(funcName);
    }

    @Override
    public Type visitOperator(String opName) {
        this.mappingLoader.visitOperator(opName);
        return this.typeChecker.visitOperator(opName);
    }

    @Override
    public Type visitString(String text) {
        this.mappingLoader.visitString(text);
        return this.typeChecker.visitString(text);
    }

    @Override
    public Type visitInteger(String text) {
        this.mappingLoader.visitInteger(text);
        return this.typeChecker.visitInteger(text);
    }

    @Override
    public Type visitFloat(String text) {
        this.mappingLoader.visitFloat(text);
        return this.typeChecker.visitFloat(text);
    }

    @Override
    public Type visitBoolean(String text) {
        this.mappingLoader.visitBoolean(text);
        return this.typeChecker.visitBoolean(text);
    }

    @Override
    public Type visitDate(String text) {
        this.mappingLoader.visitDate(text);
        return this.typeChecker.visitDate(text);
    }

    @Override
    public Type visitNull() {
        this.mappingLoader.visitNull();
        return this.typeChecker.visitNull();
    }

    @Override
    public Type visitConvertedType(String text) {
        this.mappingLoader.visitConvertedType(text);
        return this.typeChecker.visitConvertedType(text);
    }

    @Override
    public Type defaultValue() {
        this.mappingLoader.defaultValue();
        return this.typeChecker.defaultValue();
    }
}

