/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.multi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.lucene.search.TotalHits;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.document.DocumentField;
import org.opensearch.common.util.ArrayUtils;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.sql.legacy.domain.Condition;
import org.opensearch.sql.legacy.domain.Field;
import org.opensearch.sql.legacy.domain.Select;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.domain.hints.Hint;
import org.opensearch.sql.legacy.domain.hints.HintType;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.executor.ElasticHitsExecutor;
import org.opensearch.sql.legacy.executor.multi.ComperableHitResult;
import org.opensearch.sql.legacy.executor.multi.MinusOneFieldAndOptimizationResult;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.legacy.pit.PointInTimeHandlerImpl;
import org.opensearch.sql.legacy.query.DefaultQueryAction;
import org.opensearch.sql.legacy.query.multi.MultiQueryRequestBuilder;
import org.opensearch.sql.legacy.utils.Util;
import org.opensearch.transport.client.Client;

public class MinusExecutor
extends ElasticHitsExecutor {
    private final MultiQueryRequestBuilder builder;
    private SearchHits minusHits;
    private final boolean useTermsOptimization;
    private boolean termsOptimizationWithToLower;
    private boolean useScrolling;
    private int maxDocsToFetchOnFirstTable;
    private int maxDocsToFetchOnSecondTable;
    private int maxDocsToFetchOnEachScrollShard;
    private String[] fieldsOrderFirstTable;
    private String[] fieldsOrderSecondTable;
    private final String seperator;

    public MinusExecutor(Client client, MultiQueryRequestBuilder builder) {
        this.client = client;
        this.builder = builder;
        this.useTermsOptimization = false;
        this.termsOptimizationWithToLower = false;
        this.useScrolling = false;
        this.parseHintsIfAny(builder.getOriginalSelect(true).getHints());
        this.fillFieldsOrder();
        this.seperator = UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws SqlParseException {
        try {
            this.pit = new PointInTimeHandlerImpl(this.client, ArrayUtils.concat((String[])this.builder.getOriginalSelect(true).getIndexArr(), (String[])this.builder.getOriginalSelect(false).getIndexArr()));
            this.pit.create();
            if (this.useTermsOptimization && this.fieldsOrderFirstTable.length != 1) {
                throw new SqlParseException("Terms optimization failed: terms optimization for minus execution is supported with one field");
            }
            if (this.useTermsOptimization && !this.useScrolling) {
                throw new SqlParseException("Terms optimization failed: using scrolling is required for terms optimization");
            }
            if (!this.useScrolling || !this.useTermsOptimization) {
                Set<ComperableHitResult> comperableHitResults = !this.useScrolling ? this.simpleOneTimeQueryEach() : this.runWithScrollings();
                this.fillMinusHitsFromResults(comperableHitResults);
                return;
            }
            Select firstSelect = this.builder.getOriginalSelect(true);
            MinusOneFieldAndOptimizationResult optimizationResult = this.runWithScrollingAndAddFilter(this.fieldsOrderFirstTable[0], this.fieldsOrderSecondTable[0]);
            String fieldName = this.getFieldName(firstSelect.getFields().get(0));
            Set<Object> results = optimizationResult.getFieldValues();
            SearchHit someHit = optimizationResult.getSomeHit();
            this.fillMinusHitsFromOneField(fieldName, results, someHit);
        }
        catch (Exception e) {
            LOG.error("Failed during multi query run.", (Throwable)e);
        }
        finally {
            try {
                this.pit.delete();
            }
            catch (RuntimeException e) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
                LOG.info("Error deleting point in time {} ", (Object)this.pit);
            }
        }
    }

    @Override
    public SearchHits getHits() {
        return this.minusHits;
    }

    private void fillMinusHitsFromOneField(String fieldName, Set<Object> fieldValues, SearchHit someHit) {
        ArrayList<SearchHit> minusHitsList = new ArrayList<SearchHit>();
        int currentId = 1;
        for (Object result2 : fieldValues) {
            HashMap<String, DocumentField> fields2 = new HashMap<String, DocumentField>();
            ArrayList<Object> values2 = new ArrayList<Object>();
            values2.add(result2);
            fields2.put(fieldName, new DocumentField(fieldName, values2));
            HashMap documentFields = new HashMap();
            HashMap metaFields = new HashMap();
            someHit.getFields().forEach((field, docField) -> (MapperService.META_FIELDS_BEFORE_7DOT8.contains(field) ? metaFields : documentFields).put(field, docField));
            SearchHit searchHit = new SearchHit(currentId, "" + currentId, documentFields, metaFields);
            searchHit.sourceRef(someHit.getSourceRef());
            searchHit.getSourceAsMap().clear();
            HashMap<String, Object> sourceAsMap = new HashMap<String, Object>();
            sourceAsMap.put(fieldName, result2);
            searchHit.getSourceAsMap().putAll(sourceAsMap);
            ++currentId;
            minusHitsList.add(searchHit);
        }
        int totalSize = currentId - 1;
        SearchHit[] unionHitsArr = minusHitsList.toArray(new SearchHit[totalSize]);
        this.minusHits = new SearchHits(unionHitsArr, new TotalHits((long)totalSize, TotalHits.Relation.EQUAL_TO), 1.0f);
    }

    private void fillMinusHitsFromResults(Set<ComperableHitResult> comperableHitResults) {
        int currentId = 1;
        ArrayList<SearchHit> minusHitsList = new ArrayList<SearchHit>();
        for (ComperableHitResult result2 : comperableHitResults) {
            ArrayList<ComperableHitResult> values2 = new ArrayList<ComperableHitResult>();
            values2.add(result2);
            SearchHit originalHit = result2.getOriginalHit();
            HashMap documentFields = new HashMap();
            HashMap metaFields = new HashMap();
            originalHit.getFields().forEach((fieldName, docField) -> (MapperService.META_FIELDS_BEFORE_7DOT8.contains(fieldName) ? metaFields : documentFields).put(fieldName, docField));
            SearchHit searchHit = new SearchHit(currentId, originalHit.getId(), documentFields, metaFields);
            searchHit.sourceRef(originalHit.getSourceRef());
            searchHit.getSourceAsMap().clear();
            Map<String, Object> sourceAsMap = result2.getFlattenMap();
            for (Map.Entry<String, String> entry : this.builder.getFirstTableFieldToAlias().entrySet()) {
                if (!sourceAsMap.containsKey(entry.getKey())) continue;
                Object value = sourceAsMap.get(entry.getKey());
                sourceAsMap.remove(entry.getKey());
                sourceAsMap.put(entry.getValue(), value);
            }
            searchHit.getSourceAsMap().putAll(sourceAsMap);
            ++currentId;
            minusHitsList.add(searchHit);
        }
        int totalSize = currentId - 1;
        SearchHit[] unionHitsArr = minusHitsList.toArray(new SearchHit[totalSize]);
        this.minusHits = new SearchHits(unionHitsArr, new TotalHits((long)totalSize, TotalHits.Relation.EQUAL_TO), 1.0f);
    }

    private Set<ComperableHitResult> runWithScrollings() {
        SearchResponse scrollResp = this.getResponseWithHits(this.builder.getFirstSearchRequest(), this.builder.getOriginalSelect(true), this.maxDocsToFetchOnEachScrollShard, null, this.pit);
        HashSet<ComperableHitResult> results = new HashSet<ComperableHitResult>();
        SearchHit[] hits = scrollResp.getHits().getHits();
        if (hits == null || hits.length == 0) {
            return new HashSet<ComperableHitResult>();
        }
        int totalDocsFetchedFromFirstTable = 0;
        while (hits != null && hits.length != 0) {
            this.fillComperableSetFromHits(this.fieldsOrderFirstTable, hits, results);
            if ((totalDocsFetchedFromFirstTable += hits.length) > this.maxDocsToFetchOnFirstTable) break;
            scrollResp = this.getResponseWithHits(this.builder.getFirstSearchRequest(), this.builder.getOriginalSelect(true), this.maxDocsToFetchOnEachScrollShard, scrollResp, this.pit);
            hits = scrollResp.getHits().getHits();
        }
        if ((hits = (scrollResp = this.getResponseWithHits(this.builder.getSecondSearchRequest(), this.builder.getOriginalSelect(false), this.maxDocsToFetchOnEachScrollShard, null, this.pit)).getHits().getHits()) == null || hits.length == 0) {
            return results;
        }
        int totalDocsFetchedFromSecondTable = 0;
        while (hits != null && hits.length != 0) {
            this.removeValuesFromSetAccordingToHits(this.fieldsOrderSecondTable, results, hits);
            if ((totalDocsFetchedFromSecondTable += hits.length) > this.maxDocsToFetchOnSecondTable) break;
            scrollResp = this.getResponseWithHits(this.builder.getSecondSearchRequest(), this.builder.getOriginalSelect(false), this.maxDocsToFetchOnEachScrollShard, scrollResp, this.pit);
            hits = scrollResp.getHits().getHits();
        }
        return results;
    }

    private Set<ComperableHitResult> simpleOneTimeQueryEach() {
        SearchHit[] firstTableHits = ((SearchResponse)this.builder.getFirstSearchRequest().get()).getHits().getHits();
        if (firstTableHits == null || firstTableHits.length == 0) {
            return new HashSet<ComperableHitResult>();
        }
        HashSet<ComperableHitResult> result2 = new HashSet<ComperableHitResult>();
        this.fillComperableSetFromHits(this.fieldsOrderFirstTable, firstTableHits, result2);
        SearchHit[] secondTableHits = ((SearchResponse)this.builder.getSecondSearchRequest().get()).getHits().getHits();
        if (secondTableHits == null || secondTableHits.length == 0) {
            return result2;
        }
        this.removeValuesFromSetAccordingToHits(this.fieldsOrderSecondTable, result2, secondTableHits);
        return result2;
    }

    private void removeValuesFromSetAccordingToHits(String[] fieldsOrder, Set<ComperableHitResult> set, SearchHit[] hits) {
        for (SearchHit hit : hits) {
            ComperableHitResult comperableHitResult = new ComperableHitResult(hit, fieldsOrder, this.seperator);
            if (comperableHitResult.isAllNull()) continue;
            set.remove(comperableHitResult);
        }
    }

    private void fillComperableSetFromHits(String[] fieldsOrder, SearchHit[] hits, Set<ComperableHitResult> setToFill) {
        for (SearchHit hit : hits) {
            ComperableHitResult comperableHitResult = new ComperableHitResult(hit, fieldsOrder, this.seperator);
            if (comperableHitResult.isAllNull()) continue;
            setToFill.add(comperableHitResult);
        }
    }

    private String getFieldName(Field field) {
        String alias = field.getAlias();
        if (alias != null && !alias.isEmpty()) {
            return alias;
        }
        return field.getName();
    }

    private boolean checkIfOnlyOneField(Select firstSelect, Select secondSelect) {
        return firstSelect.getFields().size() == 1 && secondSelect.getFields().size() == 1;
    }

    private MinusOneFieldAndOptimizationResult runWithScrollingAndAddFilter(String firstFieldName, String secondFieldName) throws SqlParseException {
        SearchResponse scrollResp = this.getResponseWithHits(this.builder.getFirstSearchRequest(), this.builder.getOriginalSelect(true), this.maxDocsToFetchOnEachScrollShard, null, this.pit);
        HashSet<Object> results = new HashSet<Object>();
        boolean currentNumOfResults = false;
        SearchHit[] hits = scrollResp.getHits().getHits();
        SearchHit someHit = null;
        if (hits.length != 0) {
            someHit = hits[0];
        }
        int totalDocsFetchedFromFirstTable = 0;
        int totalDocsFetchedFromSecondTable = 0;
        Where originalWhereSecondTable = this.builder.getOriginalSelect(false).getWhere();
        while (hits.length != 0) {
            totalDocsFetchedFromFirstTable += hits.length;
            HashSet<Object> currentSetFromResults = new HashSet<Object>();
            this.fillSetFromHits(firstFieldName, hits, currentSetFromResults);
            Select secondQuerySelect = this.builder.getOriginalSelect(false);
            Where where = this.createWhereWithOrigianlAndTermsFilter(secondFieldName, originalWhereSecondTable, currentSetFromResults);
            secondQuerySelect.setWhere(where);
            DefaultQueryAction queryAction = new DefaultQueryAction(this.client, secondQuerySelect);
            queryAction.explain();
            if (totalDocsFetchedFromSecondTable > this.maxDocsToFetchOnSecondTable) break;
            SearchResponse responseForSecondTable = this.getResponseWithHits(queryAction.getRequestBuilder(), secondQuerySelect, this.maxDocsToFetchOnEachScrollShard, null, this.pit);
            SearchHits secondQuerySearchHits = responseForSecondTable.getHits();
            SearchHit[] secondQueryHits = secondQuerySearchHits.getHits();
            while (secondQueryHits.length > 0) {
                this.removeValuesFromSetAccordingToHits(secondFieldName, currentSetFromResults, secondQueryHits);
                if ((totalDocsFetchedFromSecondTable += secondQueryHits.length) > this.maxDocsToFetchOnSecondTable) break;
                responseForSecondTable = this.getResponseWithHits(queryAction.getRequestBuilder(), secondQuerySelect, this.maxDocsToFetchOnEachScrollShard, responseForSecondTable, this.pit);
                secondQueryHits = responseForSecondTable.getHits().getHits();
            }
            results.addAll(currentSetFromResults);
            if (totalDocsFetchedFromFirstTable > this.maxDocsToFetchOnFirstTable) {
                System.out.println("too many results for first table, stoping at:" + totalDocsFetchedFromFirstTable);
                break;
            }
            scrollResp = this.getResponseWithHits(this.builder.getFirstSearchRequest(), this.builder.getOriginalSelect(true), this.maxDocsToFetchOnEachScrollShard, scrollResp, this.pit);
            hits = scrollResp.getHits().getHits();
        }
        return new MinusOneFieldAndOptimizationResult(results, someHit);
    }

    private void removeValuesFromSetAccordingToHits(String fieldName, Set<Object> setToRemoveFrom, SearchHit[] hits) {
        for (SearchHit hit : hits) {
            Object fieldValue = this.getFieldValue(hit, fieldName);
            if (fieldValue == null || !setToRemoveFrom.contains(fieldValue)) continue;
            setToRemoveFrom.remove(fieldValue);
        }
    }

    private void fillSetFromHits(String fieldName, SearchHit[] hits, Set<Object> setToFill) {
        for (SearchHit hit : hits) {
            Object fieldValue = this.getFieldValue(hit, fieldName);
            if (fieldValue == null) continue;
            setToFill.add(fieldValue);
        }
    }

    private Where createWhereWithOrigianlAndTermsFilter(String secondFieldName, Where originalWhereSecondTable, Set<Object> currentSetFromResults) throws SqlParseException {
        Where where = Where.newInstance();
        where.setConn(Where.CONN.AND);
        where.addWhere(originalWhereSecondTable);
        where.addWhere(this.buildTermsFilterFromResults(currentSetFromResults, secondFieldName));
        return where;
    }

    private Where buildTermsFilterFromResults(Set<Object> results, String fieldName) throws SqlParseException {
        return new Condition(Where.CONN.AND, fieldName, null, Condition.OPERATOR.IN_TERMS, (Object)results.toArray(), null);
    }

    private Object getFieldValue(SearchHit hit, String fieldName) {
        Map sourceAsMap = hit.getSourceAsMap();
        if (fieldName.contains(".")) {
            String[] split = fieldName.split("\\.");
            return Util.searchPathInMap(sourceAsMap, split);
        }
        if (sourceAsMap.containsKey(fieldName)) {
            return sourceAsMap.get(fieldName);
        }
        return null;
    }

    private void fillFieldsOrder() {
        ArrayList<String> fieldsOrAliases = new ArrayList<String>();
        Map<String, String> firstTableFieldToAlias = this.builder.getFirstTableFieldToAlias();
        List<Field> firstTableFields = this.builder.getOriginalSelect(true).getFields();
        for (Field field : firstTableFields) {
            if (firstTableFieldToAlias.containsKey(field.getName())) {
                fieldsOrAliases.add(field.getAlias());
                continue;
            }
            fieldsOrAliases.add(field.getName());
        }
        Collections.sort(fieldsOrAliases);
        int fieldsSize = fieldsOrAliases.size();
        this.fieldsOrderFirstTable = new String[fieldsSize];
        this.fillFieldsArray(fieldsOrAliases, firstTableFieldToAlias, this.fieldsOrderFirstTable);
        this.fieldsOrderSecondTable = new String[fieldsSize];
        this.fillFieldsArray(fieldsOrAliases, this.builder.getSecondTableFieldToAlias(), this.fieldsOrderSecondTable);
    }

    private void fillFieldsArray(List<String> fieldsOrAliases, Map<String, String> fieldsToAlias, String[] fields2) {
        Map<String, String> aliasToField = this.inverseMap(fieldsToAlias);
        for (int i = 0; i < fields2.length; ++i) {
            String field = fieldsOrAliases.get(i);
            if (aliasToField.containsKey(field)) {
                field = aliasToField.get(field);
            }
            fields2[i] = field;
        }
    }

    private Map<String, String> inverseMap(Map<String, String> mapToInverse) {
        HashMap<String, String> inversedMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : mapToInverse.entrySet()) {
            inversedMap.put(entry.getValue(), entry.getKey());
        }
        return inversedMap;
    }

    private void parseHintsIfAny(List<Hint> hints) {
        if (hints == null) {
            return;
        }
        for (Hint hint : hints) {
            Object[] params;
            if (hint.getType() == HintType.MINUS_USE_TERMS_OPTIMIZATION) {
                params = hint.getParams();
                if (params == null || params.length != 1) continue;
                this.termsOptimizationWithToLower = (Boolean)params[0];
                continue;
            }
            if (hint.getType() != HintType.MINUS_FETCH_AND_RESULT_LIMITS) continue;
            params = hint.getParams();
            this.useScrolling = true;
            this.maxDocsToFetchOnFirstTable = (Integer)params[0];
            this.maxDocsToFetchOnSecondTable = (Integer)params[1];
            this.maxDocsToFetchOnEachScrollShard = (Integer)params[2];
        }
    }
}

