/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.converter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.legacy.expression.core.Expression;
import org.opensearch.sql.legacy.expression.core.ExpressionFactory;
import org.opensearch.sql.legacy.expression.core.operator.ScalarOperation;
import org.opensearch.sql.legacy.expression.model.ExprValueFactory;
import org.opensearch.sql.legacy.query.planner.converter.SQLAggregationParser;
import shaded.com.google.common.collect.ImmutableMap;

public class SQLExprToExpressionConverter {
    private static final Map<SQLBinaryOperator, ScalarOperation> binaryOperatorOperationMap = new ImmutableMap.Builder<SQLBinaryOperator, ScalarOperation>().put(SQLBinaryOperator.Add, ScalarOperation.ADD).put(SQLBinaryOperator.Subtract, ScalarOperation.SUBTRACT).put(SQLBinaryOperator.Multiply, ScalarOperation.MULTIPLY).put(SQLBinaryOperator.Divide, ScalarOperation.DIVIDE).put(SQLBinaryOperator.Modulus, ScalarOperation.MODULES).build();
    private static final Map<String, ScalarOperation> methodOperationMap = new ImmutableMap.Builder<String, ScalarOperation>().put(ScalarOperation.ABS.getName(), ScalarOperation.ABS).put(ScalarOperation.ACOS.getName(), ScalarOperation.ACOS).put(ScalarOperation.ASIN.getName(), ScalarOperation.ASIN).put(ScalarOperation.ATAN.getName(), ScalarOperation.ATAN).put(ScalarOperation.ATAN2.getName(), ScalarOperation.ATAN2).put(ScalarOperation.TAN.getName(), ScalarOperation.TAN).put(ScalarOperation.CBRT.getName(), ScalarOperation.CBRT).put(ScalarOperation.CEIL.getName(), ScalarOperation.CEIL).put(ScalarOperation.COS.getName(), ScalarOperation.COS).put(ScalarOperation.COSH.getName(), ScalarOperation.COSH).put(ScalarOperation.EXP.getName(), ScalarOperation.EXP).put(ScalarOperation.FLOOR.getName(), ScalarOperation.FLOOR).put(ScalarOperation.LN.getName(), ScalarOperation.LN).put(ScalarOperation.LOG.getName(), ScalarOperation.LOG).put(ScalarOperation.LOG2.getName(), ScalarOperation.LOG2).put(ScalarOperation.LOG10.getName(), ScalarOperation.LOG10).build();
    private final SQLAggregationParser.Context context;

    public Expression convert(SQLExpr expr) {
        Optional<Expression> resolvedExpression = this.context.resolve(expr);
        if (resolvedExpression.isPresent()) {
            return resolvedExpression.get();
        }
        if (expr instanceof SQLBinaryOpExpr) {
            return this.binaryOperatorToExpression((SQLBinaryOpExpr)expr, this::convert);
        }
        if (expr instanceof SQLMethodInvokeExpr) {
            return this.methodToExpression((SQLMethodInvokeExpr)expr, this::convert);
        }
        if (expr instanceof SQLValuableExpr) {
            return ExpressionFactory.literal(ExprValueFactory.from(((SQLValuableExpr)expr).getValue()));
        }
        if (expr instanceof SQLCastExpr) {
            return ExpressionFactory.cast(this.convert(((SQLCastExpr)expr).getExpr()));
        }
        throw new RuntimeException("unsupported expr: " + String.valueOf(expr));
    }

    private Expression binaryOperatorToExpression(SQLBinaryOpExpr expr, Function<SQLExpr, Expression> converter) {
        if (binaryOperatorOperationMap.containsKey((Object)expr.getOperator())) {
            return ExpressionFactory.of(binaryOperatorOperationMap.get((Object)expr.getOperator()), Arrays.asList(converter.apply(expr.getLeft()), converter.apply(expr.getRight())));
        }
        throw new UnsupportedOperationException("unsupported operator: " + expr.getOperator().getName());
    }

    private Expression methodToExpression(SQLMethodInvokeExpr expr, Function<SQLExpr, Expression> converter) {
        String methodName = expr.getMethodName().toLowerCase();
        if (methodOperationMap.containsKey(methodName)) {
            return ExpressionFactory.of(methodOperationMap.get(methodName), expr.getParameters().stream().map(converter).collect(Collectors.toList()));
        }
        throw new UnsupportedOperationException("unsupported operator: " + expr.getMethodName());
    }

    @Generated
    public SQLExprToExpressionConverter(SQLAggregationParser.Context context) {
        this.context = context;
    }
}

