/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.executor.protector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.monitor.ResourceMonitor;
import org.opensearch.sql.planner.SerializablePlan;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;

public class ResourceMonitorPlan
extends PhysicalPlan
implements SerializablePlan {
    public static final long NUMBER_OF_NEXT_CALL_TO_CHECK = 1000L;
    private final PhysicalPlan delegate;
    private final ResourceMonitor monitor;
    private long nextCallCount = 0L;

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor2, C context) {
        return this.delegate.accept(visitor2, context);
    }

    @Override
    public void open() {
        if (!this.monitor.isHealthy()) {
            throw new IllegalStateException("insufficient resources to run the query, quit.");
        }
        this.delegate.open();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return this.delegate.getChild();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public ExprValue next() {
        boolean shouldCheck;
        boolean bl = shouldCheck = ++this.nextCallCount % 1000L == 0L;
        if (shouldCheck && !this.monitor.isHealthy()) {
            throw new IllegalStateException("insufficient resources to load next row, quit.");
        }
        return (ExprValue)this.delegate.next();
    }

    @Override
    public SerializablePlan getPlanForSerialization() {
        return (SerializablePlan)((Object)this.delegate);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Generated
    public String toString() {
        return "ResourceMonitorPlan(delegate=" + String.valueOf(this.delegate) + ", nextCallCount=" + this.nextCallCount + ")";
    }

    @Generated
    public ResourceMonitorPlan(PhysicalPlan delegate, ResourceMonitor monitor) {
        this.delegate = delegate;
        this.monitor = monitor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceMonitorPlan)) {
            return false;
        }
        ResourceMonitorPlan other = (ResourceMonitorPlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$delegate = this.delegate;
        PhysicalPlan other$delegate = other.delegate;
        if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
            return false;
        }
        ResourceMonitor this$monitor = this.monitor;
        ResourceMonitor other$monitor = other.monitor;
        return !(this$monitor == null ? other$monitor != null : !this$monitor.equals(other$monitor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResourceMonitorPlan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        PhysicalPlan $delegate = this.delegate;
        result2 = result2 * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        ResourceMonitor $monitor = this.monitor;
        result2 = result2 * 59 + ($monitor == null ? 43 : $monitor.hashCode());
        return result2;
    }
}

