/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene;

import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.LiteralExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.data.type.OpenSearchTextType;
import org.opensearch.sql.opensearch.storage.script.StringUtils;
import org.opensearch.sql.opensearch.storage.script.filter.FilterQueryBuilder;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.LuceneQuery;

public class LikeQuery
extends LuceneQuery {
    @Override
    public QueryBuilder doBuild(String fieldName, ExprType fieldType, ExprValue literal) {
        String field = OpenSearchTextType.convertTextToKeyword(fieldName, fieldType);
        return this.createBuilder(field, literal.stringValue());
    }

    protected WildcardQueryBuilder createBuilder(String field, String query) {
        String matchText = StringUtils.convertSqlWildcardToLuceneSafe(query);
        return QueryBuilders.wildcardQuery((String)field, (String)matchText).caseInsensitive(true);
    }

    @Override
    public boolean canSupport(FunctionExpression func) {
        if (func.getArguments().size() == 2 && func.getArguments().get(0) instanceof ReferenceExpression && (func.getArguments().get(1) instanceof LiteralExpression || this.literalExpressionWrappedByCast(func))) {
            ReferenceExpression ref = (ReferenceExpression)func.getArguments().get(0);
            if (OpenSearchTextType.toKeywordSubField(ref.getRawPath(), ref.getType()) != null) {
                return true;
            }
            throw new FilterQueryBuilder.ScriptQueryUnSupportedException("text field wildcard doesn't support script query");
        }
        return false;
    }
}

