/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.dispatcher;

import com.amazonaws.services.emrserverless.model.JobRunState;
import org.json.JSONObject;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryJobMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryContext;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryRequest;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryResponse;
import org.opensearch.sql.spark.execution.statement.StatementState;

public abstract class AsyncQueryHandler {
    public JSONObject getQueryResponse(AsyncQueryJobMetadata asyncQueryJobMetadata, AsyncQueryRequestContext asyncQueryRequestContext) {
        JSONObject result2 = this.getResponseFromResultIndex(asyncQueryJobMetadata, asyncQueryRequestContext);
        if (result2.has("data")) {
            JSONObject items = result2.getJSONObject("data");
            String status = items.optString("status", JobRunState.FAILED.toString());
            result2.put("status", status);
            String error = items.optString("error", "");
            result2.put("error", error);
            return result2;
        }
        JSONObject statement = this.getResponseFromExecutor(asyncQueryJobMetadata, asyncQueryRequestContext);
        if (this.isSuccessState(statement)) {
            statement.put("status", StatementState.RUNNING.getState());
        }
        return statement;
    }

    private boolean isSuccessState(JSONObject statement) {
        return StatementState.SUCCESS.getState().equalsIgnoreCase(statement.optString("status"));
    }

    protected abstract JSONObject getResponseFromResultIndex(AsyncQueryJobMetadata var1, AsyncQueryRequestContext var2);

    protected abstract JSONObject getResponseFromExecutor(AsyncQueryJobMetadata var1, AsyncQueryRequestContext var2);

    public abstract String cancelJob(AsyncQueryJobMetadata var1, AsyncQueryRequestContext var2);

    public abstract DispatchQueryResponse submit(DispatchQueryRequest var1, DispatchQueryContext var2);
}

