\name{FlipImageFilter}
\alias{FlipImageFilter}
\title{FlipImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Flips an image across user specified axes.
FlipImageFilter}
\details{
FlipImageFilter flips an image across user specified axes. The flip axes are set via
method SetFlipAxes( array ) where the input is a
FixedArray<bool,ImageDimension>. The image is flipped across axes for
which array[i] is true.
In terms of grid coordinates the image is flipped within the
LargestPossibleRegion of the input image. As such, the
LargestPossibleRegion of the output image is the same as the input.
In terms of geometric coordinates, the output origin is such that the
image is flipped with respect to the coordinate axes.
See:
Flip for the procedural interface
itk::FlipImageFilter for the Doxygen on the original ITK class.
FlipImageFilter}
%C++ includes: sitkFlipImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FlipAboutOriginOff():}{}
\item{Self FlipAboutOriginOn():}{
Set the value of FlipAboutOrigin to true or false respectfully.
}
\item{ FlipImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{bool GetFlipAboutOrigin() const:}{
Controls how the output origin is computed. If FlipAboutOrigin is
"On", the flip will occur about the origin of the axis, otherwise,
the flip will occur about the center of the axis. Default is "On".
}
\item{std::vector< bool > GetFlipAxes() const:}{
Set/Get the axis to be flipped. The image is flipped along axes for
which array[i] is true. Default is false.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetFlipAboutOrigin(bool FlipAboutOrigin):}{
Controls how the output origin is computed. If FlipAboutOrigin is
"On", the flip will occur about the origin of the axis, otherwise,
the flip will occur about the center of the axis. Default is "On".
}
\item{Self SetFlipAxes(std::vector< bool > FlipAxes):}{
Set/Get the axis to be flipped. The image is flipped along axes for
which array[i] is true. Default is false.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~FlipImageFilter():}{
Destructor
}
}
}
