/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.Normalizer;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Attributes;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.CDataNode;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Comment;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.DataNode;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Document;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Element;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.FormElement;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.LeafNode;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Node;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.TextNode;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.HtmlTreeBuilderState;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.ParseError;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.ParseSettings;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.Parser;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.Tag;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.Token;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.TokeniserState;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.TreeBuilder;

public class HtmlTreeBuilder
extends TreeBuilder {
    static final String[] TagsSearchInScope = new String[]{"applet", "caption", "html", "marquee", "object", "table", "td", "th"};
    static final String[] TagSearchList = new String[]{"ol", "ul"};
    static final String[] TagSearchButton = new String[]{"button"};
    static final String[] TagSearchTableScope = new String[]{"html", "table"};
    static final String[] TagSearchSelectScope = new String[]{"optgroup", "option"};
    static final String[] TagSearchEndTags = new String[]{"dd", "dt", "li", "optgroup", "option", "p", "rb", "rp", "rt", "rtc"};
    static final String[] TagThoroughSearchEndTags = new String[]{"caption", "colgroup", "dd", "dt", "li", "optgroup", "option", "p", "rb", "rp", "rt", "rtc", "tbody", "td", "tfoot", "th", "thead", "tr"};
    static final String[] TagSearchSpecial = new String[]{"address", "applet", "area", "article", "aside", "base", "basefont", "bgsound", "blockquote", "body", "br", "button", "caption", "center", "col", "colgroup", "command", "dd", "details", "dir", "div", "dl", "dt", "embed", "fieldset", "figcaption", "figure", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "iframe", "img", "input", "isindex", "li", "link", "listing", "marquee", "menu", "meta", "nav", "noembed", "noframes", "noscript", "object", "ol", "p", "param", "plaintext", "pre", "script", "section", "select", "style", "summary", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "ul", "wbr", "xmp"};
    static final String[] TagMathMlTextIntegration = new String[]{"mi", "mn", "mo", "ms", "mtext"};
    static final String[] TagSvgHtmlIntegration = new String[]{"desc", "foreignObject", "title"};
    private HtmlTreeBuilderState state;
    private HtmlTreeBuilderState originalState;
    private boolean baseUriSetFromDoc;
    private @Nullable Element headElement;
    private @Nullable FormElement formElement;
    private @Nullable Element contextElement;
    private ArrayList<Element> formattingElements;
    private ArrayList<HtmlTreeBuilderState> tmplInsertMode;
    private List<Token.Character> pendingTableCharacters;
    private Token.EndTag emptyEnd;
    private boolean framesetOk;
    private boolean fosterInserts;
    private boolean fragmentParsing;
    private final String[] specificScopeTarget = new String[]{null};

    @Override
    ParseSettings defaultSettings() {
        return ParseSettings.htmlDefault;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initialiseParse(Reader input, String baseUri, Parser parser) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.initialiseParse((Reader)var1_1, (String)var2_2, (Parser)var3_3);
        this.state = HtmlTreeBuilderState.Initial;
        this.originalState = null;
        this.baseUriSetFromDoc = false;
        this.headElement = null;
        this.formElement = null;
        this.contextElement = null;
        this.formattingElements = new ArrayList();
        this.tmplInsertMode = new ArrayList();
        this.pendingTableCharacters = new ArrayList<Token.Character>();
        this.emptyEnd = new Token.EndTag(this);
        this.framesetOk = true;
        this.fosterInserts = false;
        this.fragmentParsing = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean process(Token token) {
        void var1_1;
        HtmlTreeBuilderState htmlTreeBuilderState = this.useCurrentOrForeignInsert(token) ? this.state : HtmlTreeBuilderState.ForeignContent;
        return htmlTreeBuilderState.process((Token)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    boolean useCurrentOrForeignInsert(Token token) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (this.stack.isEmpty()) {
            return true;
        }
        Element el = this.currentElement();
        String ns = el.tag().namespace();
        if ("http://www.w3.org/1999/xhtml".equals(ns)) {
            return true;
        }
        if (HtmlTreeBuilder.isMathmlTextIntegration(el)) {
            if (token.isStartTag() && !"mglyph".equals(token.asStartTag().normalName) && !"malignmark".equals(token.asStartTag().normalName)) {
                return true;
            }
            if (token.isCharacter()) {
                return true;
            }
        }
        if ("http://www.w3.org/1998/Math/MathML".equals(var3_3) && el.nameIs("annotation-xml") && token.isStartTag() && "svg".equals(token.asStartTag().normalName)) {
            return true;
        }
        if (HtmlTreeBuilder.isHtmlIntegration((Element)var2_2) && (token.isStartTag() || token.isCharacter())) {
            return true;
        }
        return var1_1.isEOF();
    }

    static boolean isMathmlTextIntegration(Element el) {
        Element element;
        return "http://www.w3.org/1998/Math/MathML".equals(el.tag().namespace()) && StringUtil.inSorted(element.normalName(), TagMathMlTextIntegration);
    }

    /*
     * WARNING - void declaration
     */
    static boolean isHtmlIntegration(Element el) {
        Element element;
        void var1_1;
        String encoding;
        if ("http://www.w3.org/1998/Math/MathML".equals(el.tag().namespace()) && el.nameIs("annotation-xml") && ((encoding = Normalizer.normalize(el.attr("encoding"))).equals("text/html") || var1_1.equals("application/xhtml+xml"))) {
            return true;
        }
        return "http://www.w3.org/2000/svg".equals(el.tag().namespace()) && StringUtil.in(element.tagName(), TagSvgHtmlIntegration);
    }

    /*
     * WARNING - void declaration
     */
    boolean process(Token token, HtmlTreeBuilderState state) {
        void var1_1;
        return state.process((Token)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    void transition(HtmlTreeBuilderState state) {
        void var1_1;
        this.state = var1_1;
    }

    HtmlTreeBuilderState state() {
        return this.state;
    }

    void markInsertionMode() {
        this.originalState = this.state;
    }

    HtmlTreeBuilderState originalState() {
        return this.originalState;
    }

    /*
     * WARNING - void declaration
     */
    void framesetOk(boolean framesetOk) {
        void var1_1;
        this.framesetOk = var1_1;
    }

    boolean framesetOk() {
        return this.framesetOk;
    }

    Document getDocument() {
        return this.doc;
    }

    String getBaseUri() {
        return this.baseUri;
    }

    /*
     * WARNING - void declaration
     */
    void maybeSetBaseUri(Element base) {
        if (this.baseUriSetFromDoc) {
            return;
        }
        String href = base.absUrl("href");
        if (href.length() != 0) {
            void var1_1;
            this.baseUri = href;
            this.baseUriSetFromDoc = true;
            this.doc.setBaseUri((String)var1_1);
        }
    }

    boolean isFragmentParsing() {
        return this.fragmentParsing;
    }

    /*
     * WARNING - void declaration
     */
    void error(HtmlTreeBuilderState state) {
        if (this.parser.getErrors().canAddError()) {
            void var1_1;
            this.parser.getErrors().add(new ParseError(this.reader, "Unexpected %s token [%s] when in state [%s]", this.currentToken.tokenType(), this.currentToken, var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    Element createElementFor(Token.StartTag startTag, String namespace, boolean forcePreserveCase) {
        void var3_3;
        void var2_2;
        void var1_1;
        Tag tag;
        int n;
        Attributes attributes = startTag.attributes;
        if (!forcePreserveCase) {
            attributes = this.settings.normalizeAttributes(attributes);
        }
        if (attributes != null && !attributes.isEmpty() && (n = attributes.deduplicate(this.settings)) > 0) {
            this.error("Dropped duplicate attribute(s) in tag [%s]", startTag.normalName);
        }
        if ((tag = this.tagFor(var1_1.tagName, (String)var2_2, var3_3 != false ? ParseSettings.preserveCase : this.settings)).normalName().equals("form")) {
            return new FormElement(tag, null, attributes);
        }
        return new Element(tag, null, attributes);
    }

    /*
     * WARNING - void declaration
     */
    Element insertElementFor(Token.StartTag startTag) {
        void var2_2;
        Element el = this.createElementFor(startTag, "http://www.w3.org/1999/xhtml", false);
        this.doInsertElement(el, startTag);
        if (startTag.isSelfClosing()) {
            Tag tag = el.tag();
            if (tag.isKnownTag()) {
                if (!tag.isEmpty()) {
                    this.tokeniser.error("Tag [%s] cannot be self closing; not a void tag", tag.normalName());
                }
            } else {
                void var1_1;
                var1_1.setSelfClosing();
            }
            this.tokeniser.transition(TokeniserState.Data);
            this.tokeniser.emit(this.emptyEnd.reset().name(el.tagName()));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    Element insertForeignElementFor(Token.StartTag startTag, String namespace) {
        void var2_2;
        void var1_1;
        Element el = this.createElementFor(startTag, namespace, true);
        this.doInsertElement(el, startTag);
        if (var1_1.isSelfClosing()) {
            el.tag().setSelfClosing();
            this.pop();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    Element insertEmptyElementFor(Token.StartTag startTag) {
        void var2_2;
        void var1_1;
        Element el = this.createElementFor(startTag, "http://www.w3.org/1999/xhtml", false);
        this.doInsertElement(el, (Token)var1_1);
        this.pop();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    FormElement insertFormElement(Token.StartTag startTag, boolean onStack, boolean checkTemplateStack) {
        void var2_2;
        void var1_1;
        void var3_3;
        FormElement el = (FormElement)this.createElementFor(startTag, "http://www.w3.org/1999/xhtml", false);
        if (var3_3 == false || !this.onStack("template")) {
            this.setFormElement(el);
        }
        this.doInsertElement(el, (Token)var1_1);
        if (var2_2 == false) {
            this.pop();
        }
        return el;
    }

    /*
     * WARNING - void declaration
     */
    private void doInsertElement(Element el, @Nullable Token token) {
        void var1_1;
        if (el.tag().isFormListed() && this.formElement != null) {
            this.formElement.addElement(el);
        }
        if (this.parser.getErrors().canAddError() && el.hasAttr("xmlns") && !el.attr("xmlns").equals(el.tag().namespace())) {
            this.error("Invalid xmlns attribute [%s] on tag [%s]", el.attr("xmlns"), el.tagName());
        }
        if (this.isFosterInserts() && StringUtil.inSorted(this.currentElement().normalName(), HtmlTreeBuilderState.Constants.InTableFoster)) {
            this.insertInFosterParent(el);
        } else {
            this.currentElement().appendChild(el);
        }
        this.push((Element)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void insertCommentNode(Token.Comment token) {
        void var1_1;
        Comment node = new Comment(token.getData());
        this.currentElement().appendChild(node);
        this.onNodeInserted((Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void insertCharacterNode(Token.Character characterToken) {
        void var2_2;
        void var1_1;
        Element el = this.currentElement();
        this.insertCharacterToElement((Token.Character)var1_1, (Element)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    void insertCharacterToElement(Token.Character characterToken, Element el) {
        void var1_1;
        void var2_2;
        void var3_3;
        String tagName = el.normalName();
        String data = characterToken.getData();
        LeafNode node = characterToken.isCData() ? new CDataNode(data) : (this.isContentForTagData((String)var3_3) ? new DataNode(data) : new TextNode(data));
        var2_2.appendChild(node);
        this.onNodeInserted((Node)var1_1);
    }

    ArrayList<Element> getStack() {
        return this.stack;
    }

    /*
     * WARNING - void declaration
     */
    boolean onStack(Element el) {
        void var1_1;
        return HtmlTreeBuilder.onStack(this.stack, (Element)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    boolean onStack(String elName) {
        void var1_1;
        return this.getFromStack((String)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean onStack(ArrayList<Element> queue, Element element) {
        void pos;
        int upper;
        int bottom = queue.size() - 1;
        int n = upper = bottom >= 256 ? bottom - 256 : 0;
        while (pos >= upper) {
            Element element2 = queue.get((int)pos);
            if (element2 == element) {
                return true;
            }
            --pos;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable Element getFromStack(String elName) {
        void pos;
        int upper;
        int bottom = this.stack.size() - 1;
        int n = upper = bottom >= 256 ? bottom - 256 : 0;
        while (pos >= upper) {
            Element next = (Element)this.stack.get((int)pos);
            if (next.elementIs(elName, "http://www.w3.org/1999/xhtml")) {
                return next;
            }
            --pos;
        }
        return null;
    }

    boolean removeFromStack(Element el) {
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            Element element = (Element)this.stack.get(pos);
            if (element != el) continue;
            this.stack.remove(pos);
            this.onNodeClosed(el);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable Element popStackToClose(String elName) {
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            void var3_3;
            Element el = this.pop();
            if (!el.elementIs(elName, "http://www.w3.org/1999/xhtml")) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable Element popStackToCloseAnyNamespace(String elName) {
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            void var3_3;
            Element el = this.pop();
            if (!el.nameIs(elName)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void popStackToClose(String ... elNames) {
        void var3_3;
        Element el;
        for (int pos = this.stack.size() - 1; !(pos < 0 || StringUtil.inSorted((el = this.pop()).normalName(), elNames) && "http://www.w3.org/1999/xhtml".equals(var3_3.tag().namespace())); --pos) {
        }
    }

    void clearStackToTableContext() {
        this.clearStackToContext("table", "template");
    }

    void clearStackToTableBodyContext() {
        this.clearStackToContext("tbody", "tfoot", "thead", "template");
    }

    void clearStackToTableRowContext() {
        this.clearStackToContext("tr", "template");
    }

    /*
     * WARNING - void declaration
     */
    private void clearStackToContext(String ... nodeNames) {
        void var3_3;
        Element next;
        for (int pos = this.stack.size() - 1; !(pos < 0 || "http://www.w3.org/1999/xhtml".equals((next = (Element)this.stack.get(pos)).tag().namespace()) && (StringUtil.in(next.normalName(), nodeNames) || var3_3.nameIs("html"))); --pos) {
            this.pop();
        }
    }

    @Nullable Element aboveOnStack(Element el) {
        assert (this.onStack(el));
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            Element element = (Element)this.stack.get(pos);
            if (element != el) continue;
            return (Element)this.stack.get(pos - 1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void insertOnStackAfter(Element after, Element in) {
        void var2_3;
        void var1_2;
        int i = this.stack.lastIndexOf(after);
        Validate.isTrue(i != -1);
        this.stack.add((int)(var1_2 + true), var2_3);
    }

    /*
     * WARNING - void declaration
     */
    void replaceOnStack(Element out, Element in) {
        void var2_2;
        void var1_1;
        HtmlTreeBuilder.replaceInQueue(this.stack, (Element)var1_1, (Element)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void replaceInQueue(ArrayList<Element> queue, Element out, Element in) {
        void var2_3;
        void var1_2;
        ArrayList<Element> arrayList;
        int i = queue.lastIndexOf(out);
        Validate.isTrue(i != -1);
        arrayList.set((int)var1_2, (Element)var2_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    boolean resetInsertionMode() {
        void pos;
        boolean last = false;
        int bottom = this.stack.size() - 1;
        int upper = bottom >= 256 ? bottom - 256 : 0;
        HtmlTreeBuilderState origState = this.state;
        if (this.stack.size() == 0) {
            this.transition(HtmlTreeBuilderState.InBody);
        }
        while (pos >= upper) {
            String name;
            Element node = (Element)this.stack.get((int)pos);
            if (pos == upper) {
                last = true;
                if (this.fragmentParsing) {
                    node = this.contextElement;
                }
            }
            String string = name = node != null ? node.normalName() : "";
            if ("http://www.w3.org/1999/xhtml".equals(node.tag().namespace())) {
                void var1_1;
                switch (name) {
                    case "select": {
                        this.transition(HtmlTreeBuilderState.InSelect);
                        return this.state != origState;
                    }
                    case "td": 
                    case "th": {
                        if (last) break;
                        this.transition(HtmlTreeBuilderState.InCell);
                        return this.state != origState;
                    }
                    case "tr": {
                        this.transition(HtmlTreeBuilderState.InRow);
                        return this.state != origState;
                    }
                    case "tbody": 
                    case "thead": 
                    case "tfoot": {
                        this.transition(HtmlTreeBuilderState.InTableBody);
                        return this.state != origState;
                    }
                    case "caption": {
                        this.transition(HtmlTreeBuilderState.InCaption);
                        return this.state != origState;
                    }
                    case "colgroup": {
                        this.transition(HtmlTreeBuilderState.InColumnGroup);
                        return this.state != origState;
                    }
                    case "table": {
                        this.transition(HtmlTreeBuilderState.InTable);
                        return this.state != origState;
                    }
                    case "template": {
                        void var1_2;
                        HtmlTreeBuilderState tmplState = this.currentTemplateMode();
                        Validate.notNull((Object)tmplState, "Bug: no template insertion mode on stack!");
                        this.transition((HtmlTreeBuilderState)var1_2);
                        return this.state != origState;
                    }
                    case "head": {
                        if (var1_1 != false) break;
                        this.transition(HtmlTreeBuilderState.InHead);
                        return this.state != origState;
                    }
                    case "body": {
                        this.transition(HtmlTreeBuilderState.InBody);
                        return this.state != origState;
                    }
                    case "frameset": {
                        this.transition(HtmlTreeBuilderState.InFrameset);
                        return this.state != origState;
                    }
                    case "html": {
                        HtmlTreeBuilder htmlTreeBuilder = this;
                        htmlTreeBuilder.transition(htmlTreeBuilder.headElement == null ? HtmlTreeBuilderState.BeforeHead : HtmlTreeBuilderState.AfterHead);
                        return this.state != origState;
                    }
                }
                if (var1_1 != false) {
                    this.transition(HtmlTreeBuilderState.InBody);
                    return this.state != origState;
                }
            }
            --pos;
        }
        return this.state != origState;
    }

    void resetBody() {
        if (!this.onStack("body")) {
            this.stack.add(this.doc.body());
        }
        this.transition(HtmlTreeBuilderState.InBody);
    }

    /*
     * WARNING - void declaration
     */
    private boolean inSpecificScope(String targetName, String[] baseTypes, String[] extraTypes) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.specificScopeTarget[0] = var1_1;
        HtmlTreeBuilder htmlTreeBuilder = this;
        return htmlTreeBuilder.inSpecificScope(htmlTreeBuilder.specificScopeTarget, (String[])var2_2, (String[])var3_3);
    }

    private boolean inSpecificScope(String[] targetNames, String[] baseTypes, @Nullable String[] extraTypes) {
        int bottom = this.stack.size() - 1;
        int top = bottom > 100 ? bottom - 100 : 0;
        for (int pos = bottom; pos >= top; --pos) {
            Element el = (Element)this.stack.get(pos);
            if (!el.tag().namespace().equals("http://www.w3.org/1999/xhtml")) continue;
            String elName = el.normalName();
            if (StringUtil.inSorted(elName, targetNames)) {
                return true;
            }
            if (StringUtil.inSorted(elName, baseTypes)) {
                return false;
            }
            if (extraTypes == null || !StringUtil.inSorted(elName, extraTypes)) continue;
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    boolean inScope(String[] targetNames) {
        void var1_1;
        return this.inSpecificScope((String[])var1_1, TagsSearchInScope, null);
    }

    /*
     * WARNING - void declaration
     */
    boolean inScope(String targetName) {
        void var1_1;
        return this.inScope((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    boolean inScope(String targetName, String[] extras) {
        void var2_2;
        void var1_1;
        return this.inSpecificScope((String)var1_1, TagsSearchInScope, (String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    boolean inListItemScope(String targetName) {
        void var1_1;
        return this.inScope((String)var1_1, TagSearchList);
    }

    /*
     * WARNING - void declaration
     */
    boolean inButtonScope(String targetName) {
        void var1_1;
        return this.inScope((String)var1_1, TagSearchButton);
    }

    /*
     * WARNING - void declaration
     */
    boolean inTableScope(String targetName) {
        void var1_1;
        return this.inSpecificScope((String)var1_1, TagSearchTableScope, null);
    }

    boolean inSelectScope(String targetName) {
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            Element element = (Element)this.stack.get(pos);
            String elName = element.normalName();
            if (elName.equals(targetName)) {
                return true;
            }
            if (StringUtil.inSorted((String)((Object)element), TagSearchSelectScope)) continue;
            return false;
        }
        Validate.fail("Should not be reachable");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    boolean onStackNot(String[] allowedTags) {
        void pos;
        int top;
        int bottom = this.stack.size() - 1;
        int n = top = bottom > 100 ? bottom - 100 : 0;
        while (pos >= top) {
            String string = ((Element)this.stack.get((int)pos)).normalName();
            if (!StringUtil.inSorted(string, allowedTags)) {
                return true;
            }
            --pos;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    void setHeadElement(Element headElement) {
        void var1_1;
        this.headElement = var1_1;
    }

    Element getHeadElement() {
        return this.headElement;
    }

    boolean isFosterInserts() {
        return this.fosterInserts;
    }

    /*
     * WARNING - void declaration
     */
    void setFosterInserts(boolean fosterInserts) {
        void var1_1;
        this.fosterInserts = var1_1;
    }

    @Nullable FormElement getFormElement() {
        return this.formElement;
    }

    /*
     * WARNING - void declaration
     */
    void setFormElement(FormElement formElement) {
        void var1_1;
        this.formElement = var1_1;
    }

    void resetPendingTableCharacters() {
        this.pendingTableCharacters.clear();
    }

    List<Token.Character> getPendingTableCharacters() {
        return this.pendingTableCharacters;
    }

    /*
     * WARNING - void declaration
     */
    void addPendingTableCharacters(Token.Character c) {
        void var1_1;
        Token.Character clone = c.clone();
        this.pendingTableCharacters.add((Token.Character)var1_1);
    }

    void generateImpliedEndTags(String excludeTag) {
        while (StringUtil.inSorted(this.currentElement().normalName(), TagSearchEndTags) && (excludeTag == null || !this.currentElementIs(excludeTag))) {
            this.pop();
        }
    }

    void generateImpliedEndTags() {
        this.generateImpliedEndTags(false);
    }

    void generateImpliedEndTags(boolean thorough) {
        String[] search;
        String[] stringArray = search = thorough ? TagThoroughSearchEndTags : TagSearchEndTags;
        while ("http://www.w3.org/1999/xhtml".equals(this.currentElement().tag().namespace()) && StringUtil.inSorted(this.currentElement().normalName(), search)) {
            this.pop();
        }
    }

    /*
     * WARNING - void declaration
     */
    void closeElement(String name) {
        void var1_1;
        this.generateImpliedEndTags(name);
        if (!name.equals(this.currentElement().normalName())) {
            HtmlTreeBuilder htmlTreeBuilder = this;
            htmlTreeBuilder.error(htmlTreeBuilder.state());
        }
        this.popStackToClose((String)var1_1);
    }

    static boolean isSpecial(Element el) {
        String string = el.normalName();
        return StringUtil.inSorted(string, TagSearchSpecial);
    }

    Element lastFormattingElement() {
        if (this.formattingElements.size() > 0) {
            return this.formattingElements.get(this.formattingElements.size() - 1);
        }
        return null;
    }

    int positionOfElement(Element el) {
        for (int i = 0; i < this.formattingElements.size(); ++i) {
            if (el != this.formattingElements.get(i)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    Element removeLastFormattingElement() {
        int size = this.formattingElements.size();
        if (size > 0) {
            void var1_1;
            return this.formattingElements.remove((int)(var1_1 - true));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void pushActiveFormattingElements(Element in) {
        void var1_1;
        this.checkActiveFormattingElements(in);
        this.formattingElements.add((Element)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void pushWithBookmark(Element in, int bookmark) {
        this.checkActiveFormattingElements(in);
        try {
            void var2_2;
            this.formattingElements.add((int)var2_2, in);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            void var1_1;
            this.formattingElements.add((Element)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void checkActiveFormattingElements(Element in) {
        Element el;
        void pos;
        int numSeen = 0;
        int size = this.formattingElements.size() - 1;
        int ceil = size - 12;
        if (ceil < 0) {
            ceil = 0;
        }
        while (pos >= ceil && (el = this.formattingElements.get((int)pos)) != null) {
            if (HtmlTreeBuilder.isSameFormattingElement(in, el)) {
                ++numSeen;
            }
            if (numSeen == 3) {
                this.formattingElements.remove((int)pos);
                return;
            }
            --pos;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isSameFormattingElement(Element a, Element b) {
        void var1_1;
        Element element;
        return a.normalName().equals(b.normalName()) && element.attributes().equals(var1_1.attributes());
    }

    /*
     * WARNING - void declaration
     */
    void reconstructFormattingElements() {
        Element entry;
        if (this.stack.size() > 256) {
            return;
        }
        Element last = this.lastFormattingElement();
        if (last == null || this.onStack(last)) {
            return;
        }
        int size = this.formattingElements.size();
        int ceil = size - 12;
        if (ceil < 0) {
            ceil = 0;
        }
        int pos = size - 1;
        boolean skip = false;
        do {
            if (pos != ceil) continue;
            skip = true;
            break;
        } while ((entry = this.formattingElements.get(--pos)) != null && !this.onStack(entry));
        do {
            void var3_4;
            if (!skip) {
                entry = this.formattingElements.get(++pos);
            }
            Validate.notNull(entry);
            skip = false;
            Element newEl = new Element(this.tagFor(entry.normalName(), this.settings), null, entry.attributes().clone());
            this.doInsertElement(newEl, null);
            this.formattingElements.set(pos, (Element)var3_4);
        } while (pos != size - 1);
    }

    void clearFormattingElementsToLastMarker() {
        Element element;
        while (!this.formattingElements.isEmpty() && (element = this.removeLastFormattingElement()) != null) {
        }
    }

    void removeFromActiveFormattingElements(Element el) {
        for (int pos = this.formattingElements.size() - 1; pos >= 0; --pos) {
            Element element = this.formattingElements.get(pos);
            if (element != el) continue;
            this.formattingElements.remove(pos);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isInActiveFormattingElements(Element el) {
        void var1_1;
        return HtmlTreeBuilder.onStack(this.formattingElements, (Element)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable Element getActiveFormattingElement(String nodeName) {
        Element next;
        for (int pos = this.formattingElements.size() - 1; pos >= 0 && (next = this.formattingElements.get(pos)) != null; --pos) {
            void var3_3;
            if (!next.nameIs(nodeName)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void replaceActiveFormattingElement(Element out, Element in) {
        void var2_2;
        void var1_1;
        HtmlTreeBuilder.replaceInQueue(this.formattingElements, (Element)var1_1, (Element)var2_2);
    }

    void insertMarkerToFormattingElements() {
        this.formattingElements.add(null);
    }

    /*
     * WARNING - void declaration
     */
    void insertInFosterParent(Node in) {
        void var1_1;
        void var2_4;
        Element fosterParent;
        Element lastTable = this.getFromStack("table");
        boolean isLastTableParent = false;
        if (lastTable != null) {
            if (lastTable.parent() != null) {
                lastTable.parent();
                fosterParent = null;
                isLastTableParent = true;
            } else {
                fosterParent = this.aboveOnStack(lastTable);
            }
        } else {
            fosterParent = (Element)this.stack.get(0);
        }
        if (isLastTableParent) {
            void var3_2;
            Validate.notNull(lastTable);
            var3_2.before(in);
            return;
        }
        var2_4.appendChild((Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void pushTemplateMode(HtmlTreeBuilderState state) {
        void var1_1;
        this.tmplInsertMode.add((HtmlTreeBuilderState)var1_1);
    }

    @Nullable HtmlTreeBuilderState popTemplateMode() {
        if (this.tmplInsertMode.size() > 0) {
            return this.tmplInsertMode.remove(this.tmplInsertMode.size() - 1);
        }
        return null;
    }

    int templateModeSize() {
        return this.tmplInsertMode.size();
    }

    @Nullable HtmlTreeBuilderState currentTemplateMode() {
        if (this.tmplInsertMode.size() > 0) {
            return this.tmplInsertMode.get(this.tmplInsertMode.size() - 1);
        }
        return null;
    }

    public String toString() {
        return "TreeBuilder{currentToken=" + this.currentToken + ", state=" + (Object)((Object)this.state) + ", currentElement=" + this.currentElement() + '}';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isContentForTagData(String normalName) {
        void var1_1;
        return normalName.equals("script") || var1_1.equals("style");
    }
}

