/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagDescriptor<T extends Directory> {
    @NotNull
    protected final T _directory;

    public TagDescriptor(@NotNull T directory) {
        this._directory = directory;
    }

    @Nullable
    public String getDescription(int tagType) {
        Object object = ((Directory)this._directory).getObject(tagType);
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            Class<?> componentType = object.getClass().getComponentType();
            boolean isByteArray = componentType.getName().equals("byte");
            int length = Array.getLength(object);
            if (isByteArray && length > 12) {
                return String.format("[%d byte%s]", length, length == 1 ? "" : "s");
            }
        }
        return ((Directory)this._directory).getString(tagType);
    }

    @Nullable
    public static String convertBytesToVersionString(@Nullable int[] components, int majorDigits) {
        if (components == null) {
            return null;
        }
        StringBuilder version = new StringBuilder();
        for (int i = 0; i < 4 && i < components.length; ++i) {
            char c;
            if (i == majorDigits) {
                version.append('.');
            }
            if ((c = (char)components[i]) < '0') {
                c = (char)(c + 48);
            }
            if (i == 0 && c == '0') continue;
            version.append(c);
        }
        return version.toString();
    }
}

