/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.preprocess.tokenize;

import java.util.ArrayList;
import java.util.List;
import opennlp.common.util.ObjectIntPair;
import opennlp.maxent.ContextGenerator;

public class TokContextGenerator
implements ContextGenerator {
    public String[] getContext(Object o) {
        StringBuffer sb = (StringBuffer)((ObjectIntPair)o).a;
        int id = ((ObjectIntPair)o).b;
        ArrayList preds = new ArrayList();
        if (id > 0) {
            this.addCharPreds("p1", sb.charAt(id - 1), preds);
            if (id > 1) {
                this.addCharPreds("p2", sb.charAt(id - 2), preds);
            }
        }
        this.addCharPreds("f1", sb.charAt(id), preds);
        if (id + 1 < sb.length()) {
            this.addCharPreds("f2", sb.charAt(id + 1), preds);
        }
        String[] context = new String[preds.size()];
        preds.toArray(context);
        return context;
    }

    private void addCharPreds(String key, char c, List preds) {
        preds.add(key + "=" + c);
        if (Character.isLetter(c)) {
            preds.add(key + "_alpha");
            if (Character.isUpperCase(c)) {
                preds.add(key + "_caps");
            }
        } else if (Character.isDigit(c)) {
            preds.add(key + "_num");
        } else if (Character.isWhitespace(c)) {
            preds.add(key + "_ws");
        } else if (c == '.' || c == '?' || c == '!') {
            preds.add(key + "_eos");
        } else if (c == '`' || c == '\"' || c == '\'') {
            preds.add(key + "_quote");
        } else if (c == '[' || c == '{' || c == '(') {
            preds.add(key + "_lp");
        } else if (c == ']' || c == '}' || c == ')') {
            preds.add(key + "_rp");
        }
    }
}

