/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import opennlp.common.util.Pair;
import opennlp.grok.util.ParamListener;
import opennlp.grok.util.Params;

public class Cache
implements ParamListener,
Serializable {
    String paramPrefix;
    Block[][] cache;
    int size;
    int assoc;
    boolean enabled;

    public Cache(String id, int length, int assoc) {
        this.paramPrefix = "Caches:" + id + ":";
        String userHome = System.getProperties().getProperty("user.home");
        Params.register(this.paramPrefix + "size", length + "x" + assoc);
        Params.register(this.paramPrefix + "file", userHome + File.separator + ".grok" + File.separator + "caches" + File.separator + id);
        Params.register(this.paramPrefix + "save on exit", "true");
        Params.register(this.paramPrefix + "enabled", "true");
        Pair p = this.splitSize(Params.getProperty(this.paramPrefix + "size"));
        this.size = Integer.parseInt((String)p.a);
        this.assoc = Integer.parseInt((String)p.b);
        this.enabled = Params.getBoolean(this.paramPrefix + "enabled");
        File f = new File(Params.getProperty(this.paramPrefix + "file"));
        if (f.exists()) {
            try {
                FileInputStream istream = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(istream);
                this.cache = (Block[][])ois.readObject();
            }
            catch (Exception E) {
                System.out.println("Inconsistent objects-- clearing cache.");
                this.cache = new Block[this.size][this.assoc];
            }
        } else {
            this.cache = new Block[this.size][this.assoc];
        }
        Params.addParamListener(this);
    }

    public void clear() {
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < this.assoc) {
                this.cache[i][j] = null;
                ++j;
            }
            ++i;
        }
    }

    private Pair splitSize(String size) {
        int split = size.indexOf("x");
        Pair p = new Pair((Object)size.substring(0, split), (Object)size.substring(split + 1));
        return p;
    }

    private int getRow(Object o, int size) {
        return Math.abs(o.hashCode()) % size;
    }

    public void put(Object key, Object val) {
        if (!this.enabled) {
            return;
        }
        int row = this.getRow(key, this.size);
        long time = System.currentTimeMillis();
        int lru = -1;
        long lruTime = time;
        boolean ok = false;
        int col = 0;
        while (col < this.assoc) {
            Block b = this.cache[row][col];
            if (b == null) {
                this.cache[row][col] = new Block(key, val, time);
                ok = true;
                break;
            }
            if (b.key.equals(key)) {
                b.time = time;
                ok = true;
                break;
            }
            if (b.time < lruTime) {
                lru = col;
                lruTime = b.time;
            }
            ++col;
        }
        if (!ok) {
            this.cache[row][lru] = new Block(key, val, time);
        }
    }

    public Object get(Object key) {
        if (!this.enabled) {
            return null;
        }
        int row = this.getRow(key, this.size);
        int col = 0;
        while (col < this.assoc) {
            Block b = this.cache[row][col];
            if (b != null && b.key.equals(key)) {
                b.time = System.currentTimeMillis();
                return b.value;
            }
            ++col;
        }
        return null;
    }

    public void paramChanged(String param, String value) {
        if (param.equals(this.paramPrefix + "enabled")) {
            this.enabled = Boolean.getBoolean(value);
        } else if (param.equals(this.paramPrefix + "size")) {
            Block[][] oldCache = this.cache;
            int oldSize = this.size;
            int oldAssoc = this.assoc;
            Pair p = this.splitSize(value);
            this.size = Integer.parseInt((String)p.a);
            this.assoc = Integer.parseInt((String)p.b);
            this.cache = new Block[this.size][this.assoc];
            int i = 0;
            while (i < oldSize) {
                int j = 0;
                while (j < oldAssoc) {
                    if (oldCache[i][j] != null) {
                        this.put(oldCache[i][j].key, oldCache[i][j].value);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void paramSaving() {
        if (Params.getBoolean(this.paramPrefix + "save on exit")) {
            try {
                File f = new File(Params.getProperty(this.paramPrefix + "file"));
                f.getParentFile().mkdirs();
                f.createNewFile();
                FileOutputStream ostream = new FileOutputStream(f);
                ObjectOutputStream p = new ObjectOutputStream(ostream);
                p.writeObject(this.cache);
                p.flush();
                ostream.close();
            }
            catch (Exception E) {
                System.out.println(E);
            }
        }
    }

    public void paramRegistered(String param, String value) {
    }

    class Block
    implements Serializable {
        Object key;
        Object value;
        long time;

        Block(Object k, Object v, long d) {
            this.key = k;
            this.value = v;
            this.time = d;
        }
    }
}

