/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TObjectHash;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class THashIterator
implements Iterator {
    protected final TObjectHash _hash;
    protected int _expectedSize;
    protected int _index;

    public Object next() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        this.moveToNextIndex();
        return this.objectAtIndex(this._index);
    }

    public boolean hasNext() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        return this.nextIndex() >= 0;
    }

    public void remove() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        this._hash.removeAt(this._index);
        --this._expectedSize;
    }

    protected final void moveToNextIndex() {
        this._index = this.nextIndex();
        if (this._index < 0) {
            throw new NoSuchElementException();
        }
    }

    protected final int nextIndex() {
        Object[] set = this._hash._set;
        int i = this._index;
        while (i-- > 0 && (set[i] == null || set[i] == TObjectHash.REMOVED)) {
        }
        return i;
    }

    protected abstract Object objectAtIndex(int var1);

    public THashIterator(TObjectHash hash) {
        this._hash = hash;
        this._expectedSize = hash.size();
        this._index = hash.capacity();
    }
}

