// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[non_exhaustive]
#[derive(Debug)]
pub struct InvokeModelWithBidirectionalStreamInputErrorMarshaller;

impl InvokeModelWithBidirectionalStreamInputErrorMarshaller {
    pub fn new() -> Self {
        InvokeModelWithBidirectionalStreamInputErrorMarshaller
    }
}
impl ::aws_smithy_eventstream::frame::MarshallMessage for InvokeModelWithBidirectionalStreamInputErrorMarshaller {
    type Input = crate::types::error::InvokeModelWithBidirectionalStreamInputError;
    fn marshall(
        &self,
        _input: Self::Input,
    ) -> std::result::Result<::aws_smithy_types::event_stream::Message, ::aws_smithy_eventstream::error::Error> {
        let mut headers = Vec::new();
        headers.push(::aws_smithy_types::event_stream::Header::new(
            ":message-type",
            ::aws_smithy_types::event_stream::HeaderValue::String("exception".into()),
        ));
        let payload = Vec::new();
        Ok(::aws_smithy_types::event_stream::Message::new_from_parts(headers, payload))
    }
}

#[non_exhaustive]
#[derive(Debug)]
pub struct InvokeModelWithBidirectionalStreamInputMarshaller;

impl InvokeModelWithBidirectionalStreamInputMarshaller {
    pub fn new() -> Self {
        InvokeModelWithBidirectionalStreamInputMarshaller
    }
}
impl ::aws_smithy_eventstream::frame::MarshallMessage for InvokeModelWithBidirectionalStreamInputMarshaller {
    type Input = crate::types::InvokeModelWithBidirectionalStreamInput;
    fn marshall(&self, input: Self::Input) -> std::result::Result<::aws_smithy_types::event_stream::Message, ::aws_smithy_eventstream::error::Error> {
        let mut headers = Vec::new();
        headers.push(::aws_smithy_types::event_stream::Header::new(
            ":message-type",
            ::aws_smithy_types::event_stream::HeaderValue::String("event".into()),
        ));
        let payload = match input {
            Self::Input::Chunk(inner) =>  {
                headers.push(::aws_smithy_types::event_stream::Header::new(":event-type", ::aws_smithy_types::event_stream::HeaderValue::String("chunk".into())));
                headers.push(::aws_smithy_types::event_stream::Header::new(":content-type", ::aws_smithy_types::event_stream::HeaderValue::String("application/json".into())));
                crate::protocol_serde::shape_invoke_model_with_bidirectional_stream_input::ser_chunk_payload(&inner)
                                            .map_err(|err| ::aws_smithy_eventstream::error::Error::marshalling(format!("{}", err)))?
            }
            Self::Input::Unknown => return Err(
                                            ::aws_smithy_eventstream::error::Error::marshalling("Cannot serialize `InvokeModelWithBidirectionalStreamInput::Unknown` for the request. The `Unknown` variant is intended for responses only. It occurs when an outdated client is used after a new enum variant was added on the server side.".to_owned())
                                        )
        }
        ;
        Ok(::aws_smithy_types::event_stream::Message::new_from_parts(headers, payload))
    }
}

#[non_exhaustive]
#[derive(Debug)]
pub struct ConverseStreamOutputUnmarshaller;

impl ConverseStreamOutputUnmarshaller {
    pub fn new() -> Self {
        ConverseStreamOutputUnmarshaller
    }
}
impl ::aws_smithy_eventstream::frame::UnmarshallMessage for ConverseStreamOutputUnmarshaller {
    type Output = crate::types::ConverseStreamOutput;
    type Error = crate::types::error::ConverseStreamOutputError;
    fn unmarshall(
        &self,
        message: &::aws_smithy_types::event_stream::Message,
    ) -> std::result::Result<::aws_smithy_eventstream::frame::UnmarshalledMessage<Self::Output, Self::Error>, ::aws_smithy_eventstream::error::Error>
    {
        let response_headers = ::aws_smithy_eventstream::smithy::parse_response_headers(message)?;
        match response_headers.message_type.as_str() {
            "event" => match response_headers.smithy_type.as_str() {
                "messageStart" => {
                    let parsed =
                        crate::protocol_serde::shape_message_start_event::de_message_start_event_payload(&message.payload()[..]).map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall MessageStart: {}", err))
                        })?;
                    Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                        crate::types::ConverseStreamOutput::MessageStart(parsed),
                    ))
                }
                "contentBlockStart" => {
                    let parsed = crate::protocol_serde::shape_content_block_start_event::de_content_block_start_event_payload(&message.payload()[..])
                        .map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall ContentBlockStart: {}", err))
                        })?;
                    Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                        crate::types::ConverseStreamOutput::ContentBlockStart(parsed),
                    ))
                }
                "contentBlockDelta" => {
                    let parsed = crate::protocol_serde::shape_content_block_delta_event::de_content_block_delta_event_payload(&message.payload()[..])
                        .map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall ContentBlockDelta: {}", err))
                        })?;
                    Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                        crate::types::ConverseStreamOutput::ContentBlockDelta(parsed),
                    ))
                }
                "contentBlockStop" => {
                    let parsed = crate::protocol_serde::shape_content_block_stop_event::de_content_block_stop_event_payload(&message.payload()[..])
                        .map_err(|err| {
                        ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall ContentBlockStop: {}", err))
                    })?;
                    Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                        crate::types::ConverseStreamOutput::ContentBlockStop(parsed),
                    ))
                }
                "messageStop" => {
                    let parsed = crate::protocol_serde::shape_message_stop_event::de_message_stop_event_payload(&message.payload()[..])
                        .map_err(|err| ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall MessageStop: {}", err)))?;
                    Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                        crate::types::ConverseStreamOutput::MessageStop(parsed),
                    ))
                }
                "metadata" => {
                    let parsed = crate::protocol_serde::shape_converse_stream_metadata_event::de_converse_stream_metadata_event_payload(
                        &message.payload()[..],
                    )
                    .map_err(|err| ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall Metadata: {}", err)))?;
                    Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                        crate::types::ConverseStreamOutput::Metadata(parsed),
                    ))
                }
                _unknown_variant => Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                    crate::types::ConverseStreamOutput::Unknown,
                )),
            },
            "exception" => {
                let generic = match crate::protocol_serde::parse_event_stream_error_metadata(message.payload()) {
                    Ok(builder) => builder.build(),
                    Err(err) => {
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::ConverseStreamOutputError::unhandled(err),
                        ))
                    }
                };
                match response_headers.smithy_type.as_str() {
                    "internalServerException" => {
                        let mut builder = crate::types::error::builders::InternalServerExceptionBuilder::default();
                        builder = crate::protocol_serde::shape_internal_server_exception::de_internal_server_exception_json_err(
                            &message.payload()[..],
                            builder,
                        )
                        .map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall internalServerException: {}", err))
                        })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::ConverseStreamOutputError::InternalServerException(builder.build()),
                        ));
                    }
                    "modelStreamErrorException" => {
                        let mut builder = crate::types::error::builders::ModelStreamErrorExceptionBuilder::default();
                        builder = crate::protocol_serde::shape_model_stream_error_exception::de_model_stream_error_exception_json_err(
                            &message.payload()[..],
                            builder,
                        )
                        .map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall modelStreamErrorException: {}", err))
                        })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::ConverseStreamOutputError::ModelStreamErrorException(builder.build()),
                        ));
                    }
                    "validationException" => {
                        let mut builder = crate::types::error::builders::ValidationExceptionBuilder::default();
                        builder =
                            crate::protocol_serde::shape_validation_exception::de_validation_exception_json_err(&message.payload()[..], builder)
                                .map_err(|err| {
                                    ::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                                        "failed to unmarshall validationException: {}",
                                        err
                                    ))
                                })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::ConverseStreamOutputError::ValidationException(builder.build()),
                        ));
                    }
                    "throttlingException" => {
                        let mut builder = crate::types::error::builders::ThrottlingExceptionBuilder::default();
                        builder =
                            crate::protocol_serde::shape_throttling_exception::de_throttling_exception_json_err(&message.payload()[..], builder)
                                .map_err(|err| {
                                    ::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                                        "failed to unmarshall throttlingException: {}",
                                        err
                                    ))
                                })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::ConverseStreamOutputError::ThrottlingException(builder.build()),
                        ));
                    }
                    "serviceUnavailableException" => {
                        let mut builder = crate::types::error::builders::ServiceUnavailableExceptionBuilder::default();
                        builder = crate::protocol_serde::shape_service_unavailable_exception::de_service_unavailable_exception_json_err(
                            &message.payload()[..],
                            builder,
                        )
                        .map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                                "failed to unmarshall serviceUnavailableException: {}",
                                err
                            ))
                        })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::ConverseStreamOutputError::ServiceUnavailableException(builder.build()),
                        ));
                    }
                    _ => {}
                }
                Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                    crate::types::error::ConverseStreamOutputError::generic(generic),
                ))
            }
            value => {
                return Err(::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                    "unrecognized :message-type: {}",
                    value
                )));
            }
        }
    }
}

#[non_exhaustive]
#[derive(Debug)]
pub struct InvokeModelWithBidirectionalStreamOutputUnmarshaller;

impl InvokeModelWithBidirectionalStreamOutputUnmarshaller {
    pub fn new() -> Self {
        InvokeModelWithBidirectionalStreamOutputUnmarshaller
    }
}
impl ::aws_smithy_eventstream::frame::UnmarshallMessage for InvokeModelWithBidirectionalStreamOutputUnmarshaller {
    type Output = crate::types::InvokeModelWithBidirectionalStreamOutput;
    type Error = crate::types::error::InvokeModelWithBidirectionalStreamOutputError;
    fn unmarshall(
        &self,
        message: &::aws_smithy_types::event_stream::Message,
    ) -> std::result::Result<::aws_smithy_eventstream::frame::UnmarshalledMessage<Self::Output, Self::Error>, ::aws_smithy_eventstream::error::Error>
    {
        let response_headers = ::aws_smithy_eventstream::smithy::parse_response_headers(message)?;
        match response_headers.message_type.as_str() {
            "event" => match response_headers.smithy_type.as_str() {
                "chunk" => {
                    let parsed = crate::protocol_serde::shape_bidirectional_output_payload_part::de_bidirectional_output_payload_part_payload(
                        &message.payload()[..],
                    )
                    .map_err(|err| ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall Chunk: {}", err)))?;
                    Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                        crate::types::InvokeModelWithBidirectionalStreamOutput::Chunk(parsed),
                    ))
                }
                _unknown_variant => Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                    crate::types::InvokeModelWithBidirectionalStreamOutput::Unknown,
                )),
            },
            "exception" => {
                let generic = match crate::protocol_serde::parse_event_stream_error_metadata(message.payload()) {
                    Ok(builder) => builder.build(),
                    Err(err) => {
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::unhandled(err),
                        ))
                    }
                };
                match response_headers.smithy_type.as_str() {
                    "internalServerException" => {
                        let mut builder = crate::types::error::builders::InternalServerExceptionBuilder::default();
                        builder = crate::protocol_serde::shape_internal_server_exception::de_internal_server_exception_json_err(
                            &message.payload()[..],
                            builder,
                        )
                        .map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall internalServerException: {}", err))
                        })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::InternalServerException(builder.build()),
                        ));
                    }
                    "modelStreamErrorException" => {
                        let mut builder = crate::types::error::builders::ModelStreamErrorExceptionBuilder::default();
                        builder = crate::protocol_serde::shape_model_stream_error_exception::de_model_stream_error_exception_json_err(
                            &message.payload()[..],
                            builder,
                        )
                        .map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall modelStreamErrorException: {}", err))
                        })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::ModelStreamErrorException(builder.build()),
                        ));
                    }
                    "validationException" => {
                        let mut builder = crate::types::error::builders::ValidationExceptionBuilder::default();
                        builder =
                            crate::protocol_serde::shape_validation_exception::de_validation_exception_json_err(&message.payload()[..], builder)
                                .map_err(|err| {
                                    ::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                                        "failed to unmarshall validationException: {}",
                                        err
                                    ))
                                })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::ValidationException(builder.build()),
                        ));
                    }
                    "throttlingException" => {
                        let mut builder = crate::types::error::builders::ThrottlingExceptionBuilder::default();
                        builder =
                            crate::protocol_serde::shape_throttling_exception::de_throttling_exception_json_err(&message.payload()[..], builder)
                                .map_err(|err| {
                                    ::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                                        "failed to unmarshall throttlingException: {}",
                                        err
                                    ))
                                })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::ThrottlingException(builder.build()),
                        ));
                    }
                    "modelTimeoutException" => {
                        let mut builder = crate::types::error::builders::ModelTimeoutExceptionBuilder::default();
                        builder = crate::protocol_serde::shape_model_timeout_exception::de_model_timeout_exception_json_err(
                            &message.payload()[..],
                            builder,
                        )
                        .map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall modelTimeoutException: {}", err))
                        })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::ModelTimeoutException(builder.build()),
                        ));
                    }
                    "serviceUnavailableException" => {
                        let mut builder = crate::types::error::builders::ServiceUnavailableExceptionBuilder::default();
                        builder = crate::protocol_serde::shape_service_unavailable_exception::de_service_unavailable_exception_json_err(
                            &message.payload()[..],
                            builder,
                        )
                        .map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                                "failed to unmarshall serviceUnavailableException: {}",
                                err
                            ))
                        })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::ServiceUnavailableException(builder.build()),
                        ));
                    }
                    _ => {}
                }
                Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                    crate::types::error::InvokeModelWithBidirectionalStreamOutputError::generic(generic),
                ))
            }
            value => {
                return Err(::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                    "unrecognized :message-type: {}",
                    value
                )));
            }
        }
    }
}

#[non_exhaustive]
#[derive(Debug)]
pub struct ResponseStreamUnmarshaller;

impl ResponseStreamUnmarshaller {
    pub fn new() -> Self {
        ResponseStreamUnmarshaller
    }
}
impl ::aws_smithy_eventstream::frame::UnmarshallMessage for ResponseStreamUnmarshaller {
    type Output = crate::types::ResponseStream;
    type Error = crate::types::error::ResponseStreamError;
    fn unmarshall(
        &self,
        message: &::aws_smithy_types::event_stream::Message,
    ) -> std::result::Result<::aws_smithy_eventstream::frame::UnmarshalledMessage<Self::Output, Self::Error>, ::aws_smithy_eventstream::error::Error>
    {
        let response_headers = ::aws_smithy_eventstream::smithy::parse_response_headers(message)?;
        match response_headers.message_type.as_str() {
            "event" => match response_headers.smithy_type.as_str() {
                "chunk" => {
                    let parsed = crate::protocol_serde::shape_payload_part::de_payload_part_payload(&message.payload()[..])
                        .map_err(|err| ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall Chunk: {}", err)))?;
                    Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                        crate::types::ResponseStream::Chunk(parsed),
                    ))
                }
                _unknown_variant => Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                    crate::types::ResponseStream::Unknown,
                )),
            },
            "exception" => {
                let generic = match crate::protocol_serde::parse_event_stream_error_metadata(message.payload()) {
                    Ok(builder) => builder.build(),
                    Err(err) => {
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::ResponseStreamError::unhandled(err),
                        ))
                    }
                };
                match response_headers.smithy_type.as_str() {
                    "internalServerException" => {
                        let mut builder = crate::types::error::builders::InternalServerExceptionBuilder::default();
                        builder = crate::protocol_serde::shape_internal_server_exception::de_internal_server_exception_json_err(
                            &message.payload()[..],
                            builder,
                        )
                        .map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall internalServerException: {}", err))
                        })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::ResponseStreamError::InternalServerException(builder.build()),
                        ));
                    }
                    "modelStreamErrorException" => {
                        let mut builder = crate::types::error::builders::ModelStreamErrorExceptionBuilder::default();
                        builder = crate::protocol_serde::shape_model_stream_error_exception::de_model_stream_error_exception_json_err(
                            &message.payload()[..],
                            builder,
                        )
                        .map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall modelStreamErrorException: {}", err))
                        })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::ResponseStreamError::ModelStreamErrorException(builder.build()),
                        ));
                    }
                    "validationException" => {
                        let mut builder = crate::types::error::builders::ValidationExceptionBuilder::default();
                        builder =
                            crate::protocol_serde::shape_validation_exception::de_validation_exception_json_err(&message.payload()[..], builder)
                                .map_err(|err| {
                                    ::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                                        "failed to unmarshall validationException: {}",
                                        err
                                    ))
                                })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::ResponseStreamError::ValidationException(builder.build()),
                        ));
                    }
                    "throttlingException" => {
                        let mut builder = crate::types::error::builders::ThrottlingExceptionBuilder::default();
                        builder =
                            crate::protocol_serde::shape_throttling_exception::de_throttling_exception_json_err(&message.payload()[..], builder)
                                .map_err(|err| {
                                    ::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                                        "failed to unmarshall throttlingException: {}",
                                        err
                                    ))
                                })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::ResponseStreamError::ThrottlingException(builder.build()),
                        ));
                    }
                    "modelTimeoutException" => {
                        let mut builder = crate::types::error::builders::ModelTimeoutExceptionBuilder::default();
                        builder = crate::protocol_serde::shape_model_timeout_exception::de_model_timeout_exception_json_err(
                            &message.payload()[..],
                            builder,
                        )
                        .map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall modelTimeoutException: {}", err))
                        })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::ResponseStreamError::ModelTimeoutException(builder.build()),
                        ));
                    }
                    "serviceUnavailableException" => {
                        let mut builder = crate::types::error::builders::ServiceUnavailableExceptionBuilder::default();
                        builder = crate::protocol_serde::shape_service_unavailable_exception::de_service_unavailable_exception_json_err(
                            &message.payload()[..],
                            builder,
                        )
                        .map_err(|err| {
                            ::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                                "failed to unmarshall serviceUnavailableException: {}",
                                err
                            ))
                        })?;
                        builder.set_meta(Some(generic));
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::ResponseStreamError::ServiceUnavailableException(builder.build()),
                        ));
                    }
                    _ => {}
                }
                Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                    crate::types::error::ResponseStreamError::generic(generic),
                ))
            }
            value => {
                return Err(::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                    "unrecognized :message-type: {}",
                    value
                )));
            }
        }
    }
}
