/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.gradle;

import com.intellij.diagram.gradle.GradleElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import icons.GradleIcons;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.util.GradleModuleData;

public class GradleRootElement
implements GradleElement {
    private static final String GRADLE_PROJECT_PATH_SEPARATOR = ":";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Module myModule;
    @NotNull
    private final String myGradlePath;
    @Nullable
    private final GradleModuleData myGradleModuleData;

    public GradleRootElement(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            GradleRootElement.$$$reportNull$$$0(0);
        }
        if (module == null) {
            GradleRootElement.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myModule = module;
        this.myGradleModuleData = CachedModuleDataFinder.getGradleModuleData((Module)module);
        this.myGradlePath = Optional.ofNullable(this.myGradleModuleData).map(it -> it.getGradleIdentityPathOrNull()).orElse(GRADLE_PROJECT_PATH_SEPARATOR);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GradleRootElement.$$$reportNull$$$0(2);
        }
        return project;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.getProject().getName() + "/" + this.myModule.getName();
        if (string == null) {
            GradleRootElement.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHtmlDescription() {
        String string = StringEscapeUtils.escapeHtml4((String)this.myModule.getName());
        if (string == null) {
            GradleRootElement.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return GradleIcons.Gradle;
    }

    @Override
    @NotNull
    public String getName() {
        if (GRADLE_PROJECT_PATH_SEPARATOR.equals(this.myGradlePath)) {
            String string = this.myModule.getName();
            if (string == null) {
                GradleRootElement.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.myGradlePath;
        if (string == null) {
            GradleRootElement.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            GradleRootElement.$$$reportNull$$$0(7);
        }
        return module;
    }

    @Nullable
    public GradleModuleData getGradleModuleData() {
        return this.myGradleModuleData;
    }

    @NotNull
    public String getGradlePath() {
        String string = this.myGradlePath;
        if (string == null) {
            GradleRootElement.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleRootElement element = (GradleRootElement)o;
        return this.myProject.equals(element.myProject) && this.myModule.equals(element.myModule) && this.myGradlePath.equals(element.myGradlePath);
    }

    public int hashCode() {
        return Objects.hash(this.myProject, this.myModule, this.myGradlePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/gradle/GradleRootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/gradle/GradleRootElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlDescription";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradlePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

