/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.BaseDmlHelper;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.script.generator.dml.ColumnRefs;
import com.intellij.database.script.generator.dml.CountAll;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.ExpressionColumn;
import com.intellij.database.script.generator.dml.QueryColumns;
import com.intellij.database.script.generator.dml.QueryColumnsGenerationResult;
import com.intellij.database.script.generator.dml.QueryColumnsTask;
import com.intellij.database.util.DdlBuilder;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u001c\n\u0000\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u0002H\u0016J8\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014J(\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/base/generator/dml/BaseQueryColumnsGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "Lcom/intellij/database/script/generator/dml/QueryColumnsGenerationResult;", "Lcom/intellij/database/script/generator/dml/QueryColumnsTask;", "task", "dbms", "Lcom/intellij/database/Dbms;", "helper", "Lcom/intellij/database/dialects/base/BaseDmlHelper;", "<init>", "(Lcom/intellij/database/script/generator/dml/QueryColumnsTask;Lcom/intellij/database/Dbms;Lcom/intellij/database/dialects/base/BaseDmlHelper;)V", "getHelper", "()Lcom/intellij/database/dialects/base/BaseDmlHelper;", "generate", "appendColumns", "", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "table", "Lcom/intellij/database/model/DasObject;", "columns", "Lcom/intellij/database/data/types/ColumnRef;", "alias", "", "appendColumnList", "", "", "intellij.database.dialects.base"})
public class BaseQueryColumnsGenerator
extends DmlGenerator<QueryColumnsGenerationResult, QueryColumnsTask> {
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final BaseDmlHelper helper;

    public BaseQueryColumnsGenerator(@NotNull QueryColumnsTask task, @NotNull Dbms dbms, @NotNull BaseDmlHelper helper) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        super((DmlTask)task);
        this.dbms = dbms;
        this.helper = helper;
    }

    @NotNull
    protected final BaseDmlHelper getHelper() {
        return this.helper;
    }

    @Override
    @NotNull
    public QueryColumnsGenerationResult generate() {
        Integer rowIdx = null;
        List columnsToHide = CollectionsKt.emptyList();
        QueryColumns columns = ((QueryColumnsTask)this.getTask()).getColumns();
        if (columns instanceof ColumnRefs) {
            DasObject table = ((QueryColumnsTask)this.getTask()).getTable();
            columnsToHide = this.appendColumns(((QueryColumnsTask)this.getTask()).getOutput(), table, ((ColumnRefs)columns).getColumns(), ((QueryColumnsTask)this.getTask()).getAlias());
            if (table instanceof DasTable && this.helper.hasRowId((DasTable)table, ((QueryColumnsTask)this.getTask()).getVersion()) && ((QueryColumnsTask)this.getTask()).getAppendRowId()) {
                this.helper.appendRowId(((QueryColumnsTask)this.getTask()).getOutput(), ((QueryColumnsTask)this.getTask()).getAlias());
                if (this.helper.getHideRowId()) {
                    columnsToHide = CollectionsKt.plus((Collection)columnsToHide, (Object)-1);
                }
                rowIdx = -1;
            }
        } else if (columns instanceof CountAll) {
            ((QueryColumnsTask)this.getTask()).getOutput().keyword("COUNT").symbol("(").symbol("*").symbol(")");
        }
        for (ExpressionColumn e : ((QueryColumnsTask)this.getTask()).getExpressionColumns()) {
            this.helper.appendExpressionColumn(((QueryColumnsTask)this.getTask()).getOutput(), e);
        }
        return new QueryColumnsGenerationResult(((QueryColumnsTask)this.getTask()).getOutput(), rowIdx, columnsToHide);
    }

    @NotNull
    protected List<Integer> appendColumns(@NotNull DdlBuilder builder, @Nullable DasObject table, @NotNull List<? extends ColumnRef> columns, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        if (columns.isEmpty()) {
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            DdlBuilder ddlBuilder = builder.symbol("*");
            Intrinsics.checkNotNull((Object)ddlBuilder);
        } else {
            this.appendColumnList(alias, builder, (Iterable<? extends ColumnRef>)columns);
        }
        return CollectionsKt.emptyList();
    }

    private final void appendColumnList(String alias, DdlBuilder builder, Iterable<? extends ColumnRef> columns) {
        DialectUtils.appendCommaSeparated(builder, ContainerUtil.map(columns, arg_0 -> BaseQueryColumnsGenerator.appendColumnList$lambda$2(arg_0 -> BaseQueryColumnsGenerator.appendColumnList$lambda$1(alias, arg_0), arg_0)));
    }

    private static final void appendColumnList$lambda$1$lambda$0(String $alias, ColumnRef $column, DdlBuilder b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNull((Object)$column);
        PredicatesUtilKt.identifier(b, $alias, $column);
    }

    private static final Consumer appendColumnList$lambda$1(String $alias, ColumnRef column2) {
        return arg_0 -> BaseQueryColumnsGenerator.appendColumnList$lambda$1$lambda$0($alias, column2, arg_0);
    }

    private static final Consumer appendColumnList$lambda$2(Function1 $tmp0, Object p0) {
        return (Consumer)$tmp0.invoke(p0);
    }
}

