/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.DataType;
import com.intellij.openapi.util.text.StringUtil;
import java.math.BigDecimal;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdbcUtil {
    private JdbcUtil() {
    }

    public static boolean hasScaleAndPrecision(int jdbcType) {
        return switch (jdbcType) {
            case 2, 3, 6, 7, 8 -> true;
            default -> false;
        };
    }

    public static boolean hasLength(int jdbcType) {
        return switch (jdbcType) {
            case -1, 1, 12 -> true;
            default -> false;
        };
    }

    @NotNull
    public static String getJdbcTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            JdbcUtil.$$$reportNull$$$0(0);
        }
        return JdbcUtil.getJdbcTypeName(dataType, true);
    }

    @NotNull
    public static String getJdbcTypeName(@NotNull DataType dataType, boolean addLength) {
        String typeName;
        String sqlType;
        if (dataType == null) {
            JdbcUtil.$$$reportNull$$$0(1);
        }
        if (StringUtil.isNotEmpty((String)(sqlType = dataType.typeName)) && sqlType.indexOf(40) > -1) {
            String string = sqlType;
            if (string == null) {
                JdbcUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        int jdbcType = dataType.jdbcType;
        String string = typeName = StringUtil.isNotEmpty((String)sqlType) ? sqlType : JdbcUtil.getJdbcTypeName(jdbcType);
        if (addLength) {
            int scale;
            boolean hasLength = JdbcUtil.hasLength(jdbcType);
            boolean hasScaleAndPrecision = !hasLength && JdbcUtil.hasScaleAndPrecision(jdbcType);
            int length = hasLength || hasScaleAndPrecision ? dataType.getLength() : -1;
            int n = scale = hasScaleAndPrecision ? dataType.getScale() : -1;
            if (hasLength && length > 0) {
                String string2 = typeName + "(" + length + ")";
                if (string2 == null) {
                    JdbcUtil.$$$reportNull$$$0(3);
                }
                return string2;
            }
            if (hasScaleAndPrecision && length > 0 && scale >= 0) {
                String string3 = typeName + "(" + length + ", " + scale + ")";
                if (string3 == null) {
                    JdbcUtil.$$$reportNull$$$0(4);
                }
                return string3;
            }
        }
        String string4 = typeName;
        if (string4 == null) {
            JdbcUtil.$$$reportNull$$$0(5);
        }
        return string4;
    }

    @NotNull
    public static String getJdbcTypeName(int jdbcType) {
        String result2;
        String string = result2 = (switch (jdbcType) {
            case -7 -> "BIT";
            case -6 -> "TINYINT";
            case 5 -> "SMALLINT";
            case 4 -> "INTEGER";
            case -5 -> "BIGINT";
            case 6 -> "FLOAT";
            case 7 -> "REAL";
            case 8 -> "DOUBLE";
            case 2 -> "NUMERIC";
            case 3 -> "DECIMAL";
            case 1 -> "CHAR";
            case 12 -> "VARCHAR";
            case -1 -> "LONGVARCHAR";
            case 91 -> "DATE";
            case 92 -> "TIME";
            case 93 -> "TIMESTAMP";
            case -2 -> "BINARY";
            case -3 -> "VARBINARY";
            case -4 -> "LONGVARBINARY";
            case 0 -> "NULL";
            case 1111 -> "OTHER";
            case 2000 -> "JAVA_OBJECT";
            case 2001 -> "DISTINCT";
            case 2002 -> "STRUCT";
            case 2003 -> "ARRAY";
            case 2004 -> "BLOB";
            case 2005 -> "CLOB";
            case 2006 -> "REF";
            case 70 -> "DATALINK";
            case 16 -> "BOOLEAN";
            default -> "UNKNOWN";
        });
        if (string == null) {
            JdbcUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static int guessJdbcTypeByName(String name2) {
        if (StringUtil.isEmpty((String)name2)) {
            return 1111;
        }
        @NonNls String fixed = StringUtil.toUpperCase((String)name2);
        if (fixed.contains("BINARY_FLOAT")) {
            return 6;
        }
        if (fixed.contains("BINARY")) {
            return -3;
        }
        if (fixed.contains("BIT")) {
            return -7;
        }
        if (fixed.contains("BOOL")) {
            return 16;
        }
        if (fixed.endsWith("RANGE")) {
            return 1111;
        }
        if (fixed.contains("DATE")) {
            return 91;
        }
        if (fixed.contains("TIMESTAMP")) {
            return 93;
        }
        if (fixed.contains("TIME")) {
            return 92;
        }
        if (fixed.contains("REAL") || fixed.contains("NUMBER")) {
            return 7;
        }
        if (fixed.contains("FLOAT")) {
            return 6;
        }
        if (fixed.contains("DOUBLE")) {
            return 8;
        }
        if (fixed.equals("CHAR")) {
            return 1;
        }
        if (fixed.contains("INT") && !fixed.contains("INTERVAL") && !fixed.contains("POINT")) {
            return 4;
        }
        if (fixed.contains("DECIMAL")) {
            return 3;
        }
        if (fixed.contains("NUMERIC")) {
            return 2;
        }
        if (fixed.contains("CHAR") || fixed.contains("TEXT")) {
            return 12;
        }
        if (fixed.contains("BLOB")) {
            return 2004;
        }
        if (fixed.contains("CLOB")) {
            return 2005;
        }
        if (fixed.contains("REFERENCE")) {
            return 2006;
        }
        return 1111;
    }

    public static boolean isDouble(@Nullable String clazz) {
        return Double.class.getName().equals(clazz) || "oracle.sql.BINARY_DOUBLE".equals(clazz);
    }

    public static boolean isFloat(@Nullable String clazz) {
        return Float.class.getName().equals(clazz) || "oracle.sql.BINARY_FLOAT".equals(clazz);
    }

    public static boolean isBigDecimal(@Nullable String clazz) {
        return BigDecimal.class.getName().equals(clazz);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/JdbcUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/JdbcUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdbcTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJdbcTypeName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

