/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.psi;

import com.intellij.database.dialects.oracle.types.OraIntervalType;
import com.intellij.database.dialects.oracle.types.OraTimeAwareType;
import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinTypeClassWithSuffix;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.base.SqlCommonTypes;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlBuiltinTypeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraBuiltinTypeElementImpl
extends SqlBuiltinTypeElementImpl {
    public OraBuiltinTypeElementImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    @NotNull
    protected LengthUnit getLengthUnit() {
        PsiElement lParen = this.findPsiChildByType(SqlCommonTypes.SQL_LEFT_PAREN);
        if (lParen == null) {
            LengthUnit lengthUnit = LengthUnit.NONE;
            if (lengthUnit == null) {
                OraBuiltinTypeElementImpl.$$$reportNull$$$0(1);
            }
            return lengthUnit;
        }
        LengthUnit lengthUnit = PsiTreeUtil.findSiblingForward((PsiElement)lParen, (IElementType)OraTypes.ORA_BYTE, null) != null ? LengthUnit.BYTE : (PsiTreeUtil.findSiblingForward((PsiElement)lParen, (IElementType)OraTypes.ORA_CHAR, null) != null ? LengthUnit.CHAR : LengthUnit.NONE);
        if (lengthUnit == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(2);
        }
        return lengthUnit;
    }

    @NotNull
    private OraTimeAwareType adjustTimeAwareType(@NotNull OraTimeAwareType dasType) {
        if (dasType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(3);
        }
        OraTimeAwareType oraTimeAwareType = dasType.copy(dasType.getTypeClass(), this.getIntAttribute());
        if (oraTimeAwareType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(4);
        }
        return oraTimeAwareType;
    }

    @NotNull
    private OraIntervalType.YearToMonth adjustYMInterval(@NotNull OraIntervalType.YearToMonth dasType) {
        if (dasType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(5);
        }
        OraIntervalType.YearToMonth yearToMonth = dasType.copy(this.getIntAttribute());
        if (yearToMonth == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(6);
        }
        return yearToMonth;
    }

    @NotNull
    private OraIntervalType.DayToSecond adjustDSInterval(@NotNull OraIntervalType.DayToSecond dasType) {
        PsiElement secondPsi;
        if (dasType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(7);
        }
        PsiElement dayKeyword = this.findPsiChildByType(SqlCommonKeywords.SQL_DAY);
        PsiElement secondKeyword = this.findPsiChildByType(SqlCommonKeywords.SQL_SECOND);
        PsiElement dayPsi = this.getIntAttributePsi(dayKeyword);
        if (dayPsi == (secondPsi = this.getIntAttributePsi(secondKeyword))) {
            dayPsi = null;
        }
        int dayLength = OraBuiltinTypeElementImpl.parseIntAttribute(dayPsi, -1);
        int secondLength = OraBuiltinTypeElementImpl.parseIntAttribute(secondPsi, 0);
        OraIntervalType.DayToSecond dayToSecond = dasType.copy(dayLength, secondLength);
        if (dayToSecond == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(8);
        }
        return dayToSecond;
    }

    private static boolean isCharacterSet(@NotNull PsiElement element) {
        if (element == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(9);
        }
        return PsiUtilCore.getElementType((PsiElement)element) == OraTypes.ORA_CHARACTER && PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element)) == OraTypes.ORA_SET;
    }

    @Override
    @Nullable
    protected DasType parseBuiltinTypeBase() {
        DasBuiltinType builtinType;
        Object name2;
        PsiElement starter = this.getFirstChild();
        IElementType starterType = PsiUtilCore.getElementType((PsiElement)starter);
        if (starterType == OraTypes.ORA_INTERVAL) {
            PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)starter);
            name2 = starter.getText() + " " + next.getText();
        } else {
            JBIterable keywords = SqlImplUtil.sqlChildren((PsiElement)this).filter(e -> {
                if (e instanceof PsiWhiteSpace || e instanceof PsiComment) {
                    return false;
                }
                IElementType elementType = PsiUtilCore.getElementType((PsiElement)e);
                return elementType != SqlCommonKeywords.SQL_SYS && elementType != SqlCommonTokens.SQL_PERIOD;
            }).takeWhile(e -> {
                if (OraBuiltinTypeElementImpl.isCharacterSet(e)) {
                    return false;
                }
                IElementType elementType = PsiUtilCore.getElementType((PsiElement)e);
                return elementType == SqlTokens.SQL_IDENT || elementType instanceof SqlKeywordTokenType && elementType != OraTypes.ORA_WITH;
            });
            name2 = StringUtil.join((Iterable)keywords, kw -> kw.getText(), (String)" ");
        }
        DasBuiltinType dasType = OraTypeSystem.predefinedTypes.get(StringUtil.toUpperCase((String)name2));
        if (dasType instanceof DasBuiltinType && !(builtinType = (DasBuiltinType)dasType).getTypeClass().getName().equals(name2)) {
            dasType = DasTypeUtilsKt.withName(builtinType, (String)name2);
        }
        return dasType;
    }

    @NotNull
    protected DasBuiltinType<?> adjustType(@NotNull DasBuiltinType dasType) {
        if (dasType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(10);
        }
        dasType = dasType instanceof OraTimeAwareType ? this.adjustTimeAwareType((OraTimeAwareType)dasType) : (dasType instanceof OraIntervalType.YearToMonth ? this.adjustYMInterval((OraIntervalType.YearToMonth)dasType) : (dasType instanceof OraIntervalType.DayToSecond ? this.adjustDSInterval((OraIntervalType.DayToSecond)dasType) : super.adjustType(dasType)));
        IElementType starterType = PsiUtilCore.getElementType((PsiElement)this.getFirstChild());
        if (dasType.getTypeClass() instanceof DasBuiltinTypeClassWithSuffix) {
            JBIterable suffixKeywords = SqlImplUtil.sqlChildren((PsiElement)this).filter(e -> PsiUtilCore.getElementType((PsiElement)e) instanceof SqlKeywordTokenType).skip(starterType == SqlCommonKeywords.SQL_INTERVAL ? 2 : 1);
            String suffix = StringUtil.join((Iterable)suffixKeywords, kw -> kw.getText(), (String)" ");
            dasType = DasTypeUtilsKt.withSuffix(dasType, suffix);
        }
        OraIntervalType.DayToSecond dayToSecond = dasType;
        if (dayToSecond == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(11);
        }
        return dayToSecond;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6, 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/psi/OraBuiltinTypeElementImpl";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/psi/OraBuiltinTypeElementImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLengthUnit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustTimeAwareType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustYMInterval";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustDSInterval";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "adjustTimeAwareType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustYMInterval";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustDSInterval";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCharacterSet";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6, 8, 11 -> new IllegalStateException(string);
        };
    }
}

