/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.comment;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSChangeToDocCommentIntention
extends JSIntention {
    private static final String INDENT_COMMENT_WS = " ";

    @IntentionName
    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message("comment.change-to-doc-comment.display-name", new Object[0]);
        if (string == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("comment.change-to-doc-comment.family-name", new Object[0]);
        if (string == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        return new CommentsPredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        IElementType elementType;
        if (project == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(3);
        }
        if ((elementType = PsiUtilCore.getElementType((PsiElement)element)) == JSTokenTypes.END_OF_LINE_COMMENT) {
            this.processEolComment(project, editor, (PsiComment)element);
        } else if (elementType == JSTokenTypes.C_STYLE_COMMENT) {
            this.processBlockComment(project, editor, (PsiComment)element);
        }
    }

    public void processEolComment(@NotNull Project project, @Nullable Editor editor, @NotNull PsiComment element) {
        if (project == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(5);
        }
        PsiFile file = element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return;
        }
        List<PsiComment> comments = JSChangeToDocCommentIntention.findConsecutiveEolComments(element);
        assert (!comments.isEmpty());
        List<String> lines = JSChangeToDocCommentIntention.buildEolCommentsLines(comments);
        String indent = JSChangeToDocCommentIntention.getEolCommentsIndent(comments, document, file);
        boolean prependNewLine = JSChangeToDocCommentIntention.shouldPrependNewLine(file, document, comments.get(0).getTextRange());
        String comment = JSChangeToDocCommentIntention.createCommentFromLines(lines, indent, prependNewLine);
        TextRange range = JSChangeToDocCommentIntention.getRangeToRemove(comments);
        JSChangeToDocCommentIntention.performInsertion(document, editor, file, comment, range);
    }

    @NotNull
    private static String getEolCommentsIndent(@NotNull List<PsiComment> comments, @NotNull Document document, @NotNull PsiFile file) {
        if (comments == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(6);
        }
        if (document == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(7);
        }
        if (file == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(8);
        }
        if (comments.isEmpty()) {
            return "";
        }
        PsiComment comment = comments.get(0);
        if (JSChangeToDocCommentIntention.isAtFirstInjectionLine(file, document, comment.getTextRange())) {
            comment = comments.size() > 1 ? comments.get(1) : null;
        }
        return JSChangeToDocCommentIntention.getIndentFromWhiteSpace((PsiElement)comment);
    }

    private static void performInsertion(@NotNull Document document, @Nullable Editor editor, @NotNull PsiFile file, @NotNull String comment, @NotNull TextRange range) {
        int offset;
        if (document == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(9);
        }
        if (file == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(10);
        }
        if (comment == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(11);
        }
        if (range == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(12);
        }
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)comment);
        RangeMarker rangeMarker = document.createRangeMarker(TextRange.from((int)range.getStartOffset(), (int)comment.length()));
        FormatFixer.create((PsiFile)file, (TextRange)rangeMarker.getTextRange(), (FormatFixer.Mode)FormatFixer.Mode.ReformatExactRange).fixFormat();
        if (editor != null && rangeMarker.isValid() && DocumentUtil.isValidOffset((int)(offset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)rangeMarker.getStartOffset(), (String)" \t\n")), (Document)document)) {
            editor.getCaretModel().moveToOffset(offset);
        }
    }

    private static boolean shouldPrependNewLine(@NotNull PsiFile file, @NotNull Document document, @NotNull TextRange range) {
        if (file == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(13);
        }
        if (document == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(14);
        }
        if (range == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(15);
        }
        if (JSChangeToDocCommentIntention.isAtFirstInjectionLine(file, document, range)) {
            return true;
        }
        CharSequence chars = document.getCharsSequence();
        int prevCharIdx = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(range.getStartOffset() - 1), (String)" \t");
        return prevCharIdx >= 0 && !StringUtil.isChar((CharSequence)chars, (int)prevCharIdx, (char)'\n');
    }

    private static boolean isAtFirstInjectionLine(@NotNull PsiFile file, @NotNull Document document, @NotNull TextRange range) {
        if (file == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(16);
        }
        if (document == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(17);
        }
        if (range == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(18);
        }
        return file.getContext() != null && document.getLineNumber(range.getStartOffset()) == 0;
    }

    @NotNull
    private static TextRange getRangeToRemove(@NotNull List<PsiComment> comments) {
        if (comments == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(19);
        }
        if (comments.isEmpty()) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                JSChangeToDocCommentIntention.$$$reportNull$$$0(20);
            }
            return textRange;
        }
        PsiComment first = (PsiComment)ContainerUtil.getFirstItem(comments);
        PsiComment last = (PsiComment)ContainerUtil.getLastItem(comments);
        assert (first != null && last != null);
        TextRange textRange = TextRange.create((int)first.getTextRange().getStartOffset(), (int)last.getTextRange().getEndOffset());
        if (textRange == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(21);
        }
        return textRange;
    }

    private static List<PsiComment> findConsecutiveEolComments(@NotNull PsiComment element) {
        if (element == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(22);
        }
        PsiComment first = element;
        PsiComment curr = element;
        while (JSChangeToDocCommentIntention.isConsequentEolComment((PsiElement)curr)) {
            first = curr;
            curr = JSChangeToDocCommentIntention.skipWhitespaceBackward((PsiElement)curr);
        }
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        comments.add(first);
        curr = JSChangeToDocCommentIntention.skipWhitespaceForward((PsiElement)first);
        while (JSChangeToDocCommentIntention.isConsequentEolComment((PsiElement)curr)) {
            comments.add(curr);
            curr = JSChangeToDocCommentIntention.skipWhitespaceForward((PsiElement)curr);
        }
        return comments;
    }

    @Nullable
    private static PsiElement skipWhitespaceBackward(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement prevSibling = element.getPrevSibling();
        return JSChangeToDocCommentIntention.isOneLineFeedWhiteSpace(prevSibling) ? prevSibling.getPrevSibling() : null;
    }

    @Nullable
    private static PsiElement skipWhitespaceForward(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement nextSibling = element.getNextSibling();
        return JSChangeToDocCommentIntention.isOneLineFeedWhiteSpace(nextSibling) ? nextSibling.getNextSibling() : null;
    }

    private static boolean isConsequentEolComment(@Nullable PsiElement element) {
        return PsiUtilCore.getElementType((PsiElement)element) == JSTokenTypes.END_OF_LINE_COMMENT && JSChangeToDocCommentIntention.isAcceptableComment(element);
    }

    private static boolean isOneLineFeedWhiteSpace(@Nullable PsiElement element) {
        if (!(element instanceof PsiWhiteSpace)) {
            return false;
        }
        String text = element.getText();
        int i = text.indexOf("\n");
        return i >= 0 && text.lastIndexOf(10) == i;
    }

    @NotNull
    private static List<String> buildEolCommentsLines(@NotNull List<PsiComment> comments) {
        if (comments == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(23);
        }
        List list = ContainerUtil.map(comments, comment -> JSChangeToDocCommentIntention.processEolComment(comment.getText()));
        if (list == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    private static String processEolComment(@NotNull String line) {
        if (line == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(25);
        }
        line = line.substring(2);
        line = StringUtil.trimStart((String)line, (String)INDENT_COMMENT_WS);
        String string = line = line.replace("*/", "* /");
        if (string == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(26);
        }
        return string;
    }

    public void processBlockComment(@NotNull Project project, @Nullable Editor editor, @NotNull PsiComment element) {
        if (project == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(27);
        }
        if (element == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(28);
        }
        PsiFile file = element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return;
        }
        String indent = JSChangeToDocCommentIntention.getBlockIndent((PsiElement)element);
        List<String> lines = JSChangeToDocCommentIntention.buildBlockCommentLines(element, indent);
        boolean prependNewLine = JSChangeToDocCommentIntention.shouldPrependNewLine(file, document, element.getTextRange());
        String comment = JSChangeToDocCommentIntention.createCommentFromLines(lines, indent, prependNewLine);
        JSChangeToDocCommentIntention.performInsertion(document, editor, file, comment, element.getTextRange());
    }

    @NotNull
    private static List<String> buildBlockCommentLines(@NotNull PsiComment element, @NotNull String indent) {
        if (element == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(29);
        }
        if (indent == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(30);
        }
        String text = element.getText();
        text = StringUtil.trimStart((String)text, (String)"/*");
        text = StringUtil.trimEnd((String)text, (String)"*/");
        String[] rawLines = text.split("\n");
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < rawLines.length; ++i) {
            String line = JSChangeToDocCommentIntention.processBlockComment(rawLines[i], indent, i == 0);
            if (!line.isEmpty()) {
                lines.add(line);
                continue;
            }
            if (i == 0 || i == rawLines.length - 1) continue;
            lines.add(line);
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    private static String processBlockComment(@NotNull String line, @NotNull String indent, boolean isFirst) {
        if (line == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(32);
        }
        if (indent == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(33);
        }
        line = StringUtil.trimTrailing((String)line);
        line = StringUtil.trimStart((String)line, (String)indent);
        boolean startsWithAsterisk = false;
        if (line.startsWith("*")) {
            line = StringUtil.trimStart((String)line, (String)"*");
            startsWithAsterisk = true;
        } else if (line.startsWith(" *")) {
            line = StringUtil.trimStart((String)line, (String)" *");
            startsWithAsterisk = true;
        }
        if (startsWithAsterisk || isFirst) {
            line = StringUtil.trimStart((String)line, (String)INDENT_COMMENT_WS);
        }
        String string = line;
        if (string == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static String createCommentFromLines(@NotNull List<String> lines, @NotNull String indent, boolean prependNewLine) {
        if (lines == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(35);
        }
        if (indent == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(36);
        }
        StringBuilder builder = new StringBuilder();
        if (prependNewLine) {
            builder.append('\n').append(indent);
        }
        builder.append("/**").append('\n');
        if (!lines.isEmpty()) {
            for (String line : lines) {
                builder.append(indent).append(" *");
                if (!line.isEmpty()) {
                    builder.append(INDENT_COMMENT_WS).append(line);
                }
                builder.append('\n');
            }
        } else {
            builder.append(indent).append(" *").append(INDENT_COMMENT_WS).append('\n');
        }
        builder.append(indent).append(" */");
        String string = builder.toString();
        if (string == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(37);
        }
        return string;
    }

    private static boolean isAcceptableComment(@NotNull PsiElement element) {
        if (element == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(38);
        }
        if (!(element instanceof PsiComment)) {
            return false;
        }
        PsiElement prevSibling = element.getPrevSibling();
        if (prevSibling instanceof PsiWhiteSpace && prevSibling.textContains('\n')) {
            return true;
        }
        PsiElement parent = element.getParent();
        boolean isTopLevel = parent instanceof PsiFile || parent instanceof JSEmbeddedContent;
        return isTopLevel && PsiTreeUtil.skipWhitespacesBackward((PsiElement)element) == null;
    }

    @NotNull
    public static String getBlockIndent(@NotNull PsiElement element) {
        if (element == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(39);
        }
        String baseIndent = JSChangeToDocCommentIntention.getIndentFromWhiteSpace(element);
        if (!element.textContains('\n')) {
            String string = baseIndent;
            if (string == null) {
                JSChangeToDocCommentIntention.$$$reportNull$$$0(40);
            }
            return string;
        }
        String[] lines = element.getText().split("\n");
        String blockIndent = null;
        for (String line : lines) {
            int i = CharArrayUtil.shiftForward((CharSequence)line, (int)0, (String)" \t");
            if (i >= line.length() || StringUtil.startsWith((CharSequence)line, (int)i, (CharSequence)"/*") || StringUtil.startsWith((CharSequence)line, (int)i, (CharSequence)"*/")) continue;
            char c = line.charAt(i);
            if (c == '*') {
                String string = baseIndent;
                if (string == null) {
                    JSChangeToDocCommentIntention.$$$reportNull$$$0(41);
                }
                return string;
            }
            String current = line.substring(0, i);
            blockIndent = blockIndent == null ? current : (current.length() < blockIndent.length() ? current : blockIndent);
        }
        String string = blockIndent != null && blockIndent.length() > baseIndent.length() ? blockIndent : baseIndent;
        if (string == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    public static String getIndentFromWhiteSpace(@Nullable PsiElement element) {
        String siblingText;
        int newLinePos;
        String indent = "";
        if (element != null && !(element instanceof PsiWhiteSpace)) {
            element = element.getPrevSibling();
        }
        if (element instanceof PsiWhiteSpace && (newLinePos = (siblingText = element.getText()).lastIndexOf(10)) >= 0) {
            indent = siblingText.substring(newLinePos + 1);
        }
        String string = indent;
        if (string == null) {
            JSChangeToDocCommentIntention.$$$reportNull$$$0(43);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 22, 23, 25, 27, 28, 29, 30, 32, 33, 35, 36, 38, 39 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/comment/JSChangeToDocCommentIntention";
                break;
            }
            case 2: 
            case 4: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 22: 
            case 28: 
            case 29: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 7: 
            case 9: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 30: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/comment/JSChangeToDocCommentIntention";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRemove";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEolCommentsLines";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "processEolComment";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "buildBlockCommentLines";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "processBlockComment";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommentFromLines";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockIndent";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentFromWhiteSpace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 4: 
            case 5: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processEolComment";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEolCommentsIndent";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performInsertion";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldPrependNewLine";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isAtFirstInjectionLine";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRemove";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findConsecutiveEolComments";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "buildEolCommentsLines";
                break;
            }
            case 27: 
            case 28: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processBlockComment";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "buildBlockCommentLines";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createCommentFromLines";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableComment";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getBlockIndent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 22, 23, 25, 27, 28, 29, 30, 32, 33, 35, 36, 38, 39 -> new IllegalArgumentException(string);
        };
    }

    private static class CommentsPredicate
    implements JSElementPredicate {
        private CommentsPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                CommentsPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof PsiComment)) {
                return false;
            }
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)element);
            if (elementType != JSTokenTypes.C_STYLE_COMMENT && elementType != JSTokenTypes.END_OF_LINE_COMMENT) {
                return false;
            }
            return JSChangeToDocCommentIntention.isAcceptableComment(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/comment/JSChangeToDocCommentIntention$CommentsPredicate", "satisfiedBy"));
        }
    }
}

