/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.impl.util.table.CssVendorSpecificPropertyUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssPropertyUtil {
    @Deprecated
    @NotNull
    public static String getVendorPrefix(@NotNull String propertyName) {
        if (propertyName == null) {
            CssPropertyUtil.$$$reportNull$$$0(0);
        }
        String string = CssVendorSpecificPropertyUtil.getVendorPrefix(propertyName);
        if (string == null) {
            CssPropertyUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Deprecated
    public static boolean isVendorSpecificElement(@NotNull String propertyName) {
        if (propertyName == null) {
            CssPropertyUtil.$$$reportNull$$$0(2);
        }
        return CssVendorSpecificPropertyUtil.isVendorSpecificElement(propertyName);
    }

    @Deprecated
    @NotNull
    public static String getElementNameWithoutVendorPrefix(@NotNull String elementName) {
        if (elementName == null) {
            CssPropertyUtil.$$$reportNull$$$0(3);
        }
        String string = CssVendorSpecificPropertyUtil.getElementNameWithoutVendorPrefix(elementName);
        if (string == null) {
            CssPropertyUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static Map<String, String> getExpandedShorthandValues(@NotNull CssDeclaration declaration, String @NotNull [] properties) {
        if (declaration == null) {
            CssPropertyUtil.$$$reportNull$$$0(5);
        }
        if (properties == null) {
            CssPropertyUtil.$$$reportNull$$$0(6);
        }
        HashSet<String> usedValues = new HashSet<String>();
        HashMap<String, Set<String>> ambiguousValues = new HashMap<String, Set<String>>();
        String importantSuffix = declaration.isImportant() ? " !important" : "";
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (String name : properties) {
            String[] value = declaration.getShorthandValue(name);
            if (value == null || value.length <= 0) continue;
            LinkedHashSet<String> valuesSet = new LinkedHashSet<String>(Arrays.asList(value));
            if (valuesSet.size() == 1) {
                result.put(name, StringUtil.join(valuesSet, (String)CssPropertyUtil.getValuesDelimiter(declaration, name)) + importantSuffix);
                usedValues.addAll(valuesSet);
                continue;
            }
            ambiguousValues.put(name, valuesSet);
        }
        CssPropertyUtil.fillAmbiguousValuesProperties(result, ambiguousValues, usedValues, declaration);
        return result;
    }

    private static void fillAmbiguousValuesProperties(@NotNull Map<String, String> name2value, @NotNull Map<String, Set<String>> ambiguousValues, @NotNull Set<String> usedValues, @NotNull CssDeclaration declaration) {
        if (name2value == null) {
            CssPropertyUtil.$$$reportNull$$$0(7);
        }
        if (ambiguousValues == null) {
            CssPropertyUtil.$$$reportNull$$$0(8);
        }
        if (usedValues == null) {
            CssPropertyUtil.$$$reportNull$$$0(9);
        }
        if (declaration == null) {
            CssPropertyUtil.$$$reportNull$$$0(10);
        }
        String importantSuffix = declaration.isImportant() ? " !important" : "";
        List<Map.Entry<String, Set<String>>> sortedAmbiguousValues = CssPropertyUtil.getSortedAmbiguousValuesBySuggestionsCount(ambiguousValues);
        for (Map.Entry<String, Set<String>> entry : sortedAmbiguousValues) {
            String propertyName = entry.getKey();
            Set<String> values = entry.getValue();
            values.removeAll((Collection<?>)Sets.intersection(usedValues, values));
            if (values.isEmpty()) continue;
            name2value.put(propertyName, StringUtil.join(values, (String)CssPropertyUtil.getValuesDelimiter(declaration, propertyName)) + importantSuffix);
            usedValues.addAll(values);
        }
    }

    private static List<Map.Entry<String, Set<String>>> getSortedAmbiguousValuesBySuggestionsCount(Map<String, Set<String>> ambiguousValues) {
        return Ordering.from(Comparator.comparingInt(o -> ((Set)o.getValue()).size())).sortedCopy(ambiguousValues.entrySet());
    }

    private static String getValuesDelimiter(CssDeclaration cssDeclaration, String propertyName) {
        CssPropertyDescriptor descriptor = cssDeclaration.getDescriptor();
        CssPropertyValue cssPropertyValue = descriptor != null ? descriptor.getReferencedPropertyValue(propertyName) : null;
        return cssPropertyValue != null ? cssPropertyValue.getValuesDelimiter() : " ";
    }

    @Contract(value="null -> false")
    public static boolean isComposesProperty(@Nullable CssDeclaration declaration) {
        return declaration != null && "composes".equals(declaration.getPropertyName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssPropertyUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ambiguousValues";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssPropertyUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVendorPrefix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementNameWithoutVendorPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVendorPrefix";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isVendorSpecificElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementNameWithoutVendorPrefix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExpandedShorthandValues";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillAmbiguousValuesProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

