/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.karma.KarmaBundle;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.scope.KarmaScopeKind;
import com.intellij.javascript.karma.scope.KarmaScopeView;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.ui.PathShortener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaRunConfigurationEditor
extends SettingsEditor<KarmaRunConfiguration> {
    private final Project myProject;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final NodePackageField myKarmaPackageField;
    private final TextFieldWithBrowseButton myWorkingDirComponent;
    private final TextFieldWithHistoryWithBrowseButton myConfigPathField;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final RawCommandLineEditor myKarmaOptionsEditor;
    private final Map<KarmaScopeKind, JRadioButton> myRadioButtonMap;
    private final Map<KarmaScopeKind, KarmaScopeView> myScopeKindViewMap;
    private final JPanel mySelectedScopeKindPanel;
    private final JPanel myRootComponent;
    private final int myLongestLabelWidth;

    public KarmaRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myRadioButtonMap = new HashMap<KarmaScopeKind, JRadioButton>();
        this.myScopeKindViewMap = new HashMap<KarmaScopeKind, KarmaScopeView>();
        this.myLongestLabelWidth = new JLabel((String)UIUtil.removeMnemonic((String)KarmaBundle.message((String)"runConfiguration.environment.label", (Object[])new Object[0]))).getPreferredSize().width;
        this.myProject = project;
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, true);
        this.myNodeOptionsEditor = KarmaRunConfigurationEditor.createOptionsEditor(null);
        this.myKarmaPackageField = new NodePackageField(this.myNodeInterpreterField, KarmaUtil.PKG_DESCRIPTOR, null);
        this.myWorkingDirComponent = KarmaRunConfigurationEditor.createWorkingDirComponent(project);
        this.myConfigPathField = KarmaRunConfigurationEditor.createConfigurationFileTextField(project);
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myKarmaOptionsEditor = KarmaRunConfigurationEditor.createOptionsEditor(KarmaBundle.message("run_config.karma_options.placeholder.text", new Object[0]));
        JPanel scopeKindPanel = this.createScopeKindRadioButtonPanel();
        this.mySelectedScopeKindPanel = new JPanel(new BorderLayout());
        this.myRootComponent = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent(KarmaBundle.message("runConfiguration.config_file.label", new Object[0]), (JComponent)this.myConfigPathField).addLabeledComponent(KarmaBundle.message("runConfiguration.karmaOptions.label", new Object[0]), (JComponent)this.myKarmaOptionsEditor).addComponent((JComponent)new JSeparator(), 8).addLabeledComponent(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)this.myNodeInterpreterField, 8).addLabeledComponent(JavaScriptBundle.message((String)"rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(KarmaBundle.message("runConfiguration.karma_package_dir.label", new Object[0]), (JComponent)this.myKarmaPackageField).addLabeledComponent(JavaScriptBundle.message((String)"rc.workingDirectory.label", (Object[])new Object[0]), (JComponent)this.myWorkingDirComponent).addLabeledComponent(KarmaBundle.message("runConfiguration.environment.label", new Object[0]), (JComponent)this.myEnvVarsComponent).addSeparator(8).addComponent((JComponent)scopeKindPanel).addComponent((JComponent)this.mySelectedScopeKindPanel).getPanel();
    }

    @NotNull
    private static RawCommandLineEditor createOptionsEditor(@NlsContexts.StatusText @Nullable String emptyText) {
        RawCommandLineEditor editor = new RawCommandLineEditor();
        JTextField field = editor.getTextField();
        if (field instanceof ExpandableTextField) {
            ((ExpandableTextField)field).setMonospaced(false);
        }
        if (field instanceof ComponentWithEmptyText && emptyText != null) {
            ((ComponentWithEmptyText)field).getEmptyText().setText(emptyText);
        }
        RawCommandLineEditor rawCommandLineEditor = editor;
        if (rawCommandLineEditor == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        return rawCommandLineEditor;
    }

    @NotNull
    private static TextFieldWithBrowseButton createWorkingDirComponent(@NotNull Project project) {
        if (project == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(JavaScriptBundle.message((String)"rc.workingDirectory.browseDialogTitle", (Object[])new Object[0]));
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (FileChooserDescriptor)descriptor);
        PathShortener.enablePathShortening((JTextField)textFieldWithBrowseButton.getTextField(), null);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    private JPanel createScopeKindRadioButtonPanel() {
        JPanel testKindPanel = new JPanel(new FlowLayout(1, JBUIScale.scale((int)40), 0));
        testKindPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final KarmaScopeKind scopeKind : KarmaScopeKind.values()) {
            JRadioButton radioButton = new JRadioButton(UIUtil.replaceMnemonicAmpersand((String)scopeKind.getName()));
            radioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KarmaRunConfigurationEditor.this.setScopeKind(scopeKind);
                }
            });
            this.myRadioButtonMap.put(scopeKind, radioButton);
            testKindPanel.add(radioButton);
            buttonGroup.add(radioButton);
        }
        JPanel jPanel = testKindPanel;
        if (jPanel == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private void setScopeKind(@NotNull KarmaScopeKind scopeKind) {
        KarmaScopeKind selectedScopeKind;
        if (scopeKind == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        if ((selectedScopeKind = this.getScopeKind()) != scopeKind) {
            JRadioButton radioButton = this.myRadioButtonMap.get((Object)scopeKind);
            radioButton.setSelected(true);
        }
        KarmaScopeView view = this.getScopeKindView(scopeKind);
        KarmaRunConfigurationEditor.setCenterBorderLayoutComponent(this.mySelectedScopeKindPanel, view.getComponent());
    }

    @Nullable
    private KarmaScopeKind getScopeKind() {
        for (Map.Entry<KarmaScopeKind, JRadioButton> entry : this.myRadioButtonMap.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            return entry.getKey();
        }
        return null;
    }

    @NotNull
    private KarmaScopeView getScopeKindView(@NotNull KarmaScopeKind scopeKind) {
        KarmaScopeView view;
        if (scopeKind == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        if ((view = this.myScopeKindViewMap.get((Object)scopeKind)) == null) {
            view = scopeKind.createView(this.myProject);
            this.myScopeKindViewMap.put(scopeKind, view);
            JComponent component = view.getComponent();
            if (component.getLayout() instanceof GridBagLayout) {
                component.add(Box.createHorizontalStrut(this.myLongestLabelWidth), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insetsRight((int)10), 0, 0));
            }
        }
        KarmaScopeView karmaScopeView = view;
        if (karmaScopeView == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        return karmaScopeView;
    }

    private static void setCenterBorderLayoutComponent(@NotNull JPanel panel, @NotNull Component child) {
        Component prevChild;
        if (panel == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(8);
        }
        if (child == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(9);
        }
        if ((prevChild = ((BorderLayout)panel.getLayout()).getLayoutComponent("Center")) != null) {
            panel.remove(prevChild);
        }
        panel.add(child, "Center");
        panel.revalidate();
        panel.repaint();
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createConfigurationFileTextField(@NotNull Project project) {
        if (project == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(10);
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        textFieldWithHistory.setHistory(Collections.singletonList(""));
        PathShortener.enablePathShortening((JTextField)textFieldWithHistory.getTextEditor(), null);
        SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> {
            textFieldWithHistory.setHistory(Collections.emptyList());
            List<VirtualFile> newFiles = KarmaUtil.listPossibleConfigFilesInProject(project);
            return ContainerUtil.sorted((Collection)ContainerUtil.map(newFiles, file -> {
                String path = FileUtil.toSystemDependentName((String)file.getPath());
                return FileUtil.getLocationRelativeToUserHome((String)path, (boolean)false);
            }));
        });
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(KarmaBundle.message("runConfiguration.config_file.browse_dialog.title", new Object[0]));
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithHistoryWithBrowseButton)textFieldWithHistoryWithBrowseButton, (FileChooserDescriptor)descriptor);
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton2 = textFieldWithHistoryWithBrowseButton;
        if (textFieldWithHistoryWithBrowseButton2 == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(11);
        }
        return textFieldWithHistoryWithBrowseButton2;
    }

    protected void resetEditorFrom(@NotNull KarmaRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(12);
        }
        KarmaRunSettings runSettings = runConfiguration.getRunSettings();
        this.myNodeInterpreterField.setInterpreterRef(runSettings.getInterpreterRef());
        this.myNodeOptionsEditor.setText(runSettings.getNodeOptions());
        this.myKarmaPackageField.setSelected(runConfiguration.getKarmaPackage());
        this.myConfigPathField.setTextAndAddToHistory(runSettings.getConfigPathSystemDependent());
        this.myKarmaOptionsEditor.setText(runSettings.getKarmaOptions());
        this.myWorkingDirComponent.setText(runSettings.getWorkingDirectorySystemDependent());
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        this.setScopeKind(runSettings.getScopeKind());
        KarmaScopeView view = this.getScopeKindView(runSettings.getScopeKind());
        view.resetFrom(runSettings);
        this.updatePreferredWidth();
    }

    private void updatePreferredWidth() {
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)this.myRootComponent);
        if (dialogWrapper instanceof SingleConfigurableEditor) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            this.myKarmaPackageField.setPreferredWidthToFitText();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myConfigPathField);
            ApplicationManager.getApplication().invokeLater(() -> SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)dialogWrapper), ModalityState.any());
        }
    }

    protected void applyEditorTo(@NotNull KarmaRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(13);
        }
        KarmaRunSettings.Builder builder = new KarmaRunSettings.Builder();
        builder.setConfigPath(PathShortener.getAbsolutePath((JTextField)((TextFieldWithHistory)this.myConfigPathField.getChildComponent()).getTextEditor()));
        builder.setKarmaOptions(StringUtil.notNullize((String)this.myKarmaOptionsEditor.getText()));
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder.setKarmaPackage(this.myKarmaPackageField.getSelected());
        builder.setWorkingDirectory(PathShortener.getAbsolutePath((JTextField)this.myWorkingDirComponent.getTextField()));
        builder.setEnvData(this.myEnvVarsComponent.getData());
        KarmaScopeKind scopeKind = this.getScopeKind();
        if (scopeKind != null) {
            builder.setScopeKind(scopeKind);
            KarmaScopeView view = this.getScopeKindView(scopeKind);
            view.applyTo(builder);
        }
        runConfiguration.setRunSettings(builder.build());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myRootComponent;
        if (jPanel == null) {
            KarmaRunConfigurationEditor.$$$reportNull$$$0(14);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 7, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaRunConfigurationEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeKind";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaRunConfigurationEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createWorkingDirComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeKindRadioButtonPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeKindView";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurationFileTextField";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWorkingDirComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setScopeKind";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getScopeKindView";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCenterBorderLayoutComponent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationFileTextField";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 7, 11, 14 -> new IllegalStateException(string);
        };
    }
}

