/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005H\u0007J \u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0007J \u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0007J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/BitUtil;", "", "<init>", "()V", "isSet", "", "value", "", "mask", "", "flags", "", "set", "setBit", "clear", "assertOneBitMask", "", "invalidMaskError", "", "intellij.platform.util.multiplatform"})
@SourceDebugExtension(value={"SMAP\nBitUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitUtil.kt\ncom/intellij/util/BitUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class BitUtil {
    @NotNull
    public static final BitUtil INSTANCE = new BitUtil();

    private BitUtil() {
    }

    @JvmStatic
    @Contract(pure=true)
    public static final boolean isSet(byte value, byte mask) {
        INSTANCE.assertOneBitMask(mask);
        return (value & mask) == mask;
    }

    @JvmStatic
    @Contract(pure=true)
    public static final boolean isSet(int value, int mask) {
        BitUtil.assertOneBitMask(mask);
        return (value & mask) == mask;
    }

    @JvmStatic
    @Contract(pure=true)
    public static final boolean isSet(long flags, long mask) {
        INSTANCE.assertOneBitMask(mask);
        return (flags & mask) == mask;
    }

    @JvmStatic
    @Contract(pure=true)
    public static final byte set(byte value, byte mask, boolean setBit) {
        INSTANCE.assertOneBitMask(mask);
        int result = setBit ? value | mask : value & (byte)(~mask);
        return (byte)result;
    }

    @JvmStatic
    @Contract(pure=true)
    public static final int set(int value, int mask, boolean setBit) {
        BitUtil.assertOneBitMask(mask);
        return setBit ? value | mask : value & ~mask;
    }

    @JvmStatic
    @Contract(pure=true)
    public static final long set(long value, long mask, boolean setBit) {
        INSTANCE.assertOneBitMask(mask);
        return setBit ? value | mask : value & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @JvmStatic
    @Contract(pure=true)
    public static final byte clear(byte value, byte mask) {
        return BitUtil.set(value, mask, false);
    }

    @JvmStatic
    @Contract(pure=true)
    public static final int clear(int value, int mask) {
        return BitUtil.set(value, mask, false);
    }

    @JvmStatic
    @Contract(pure=true)
    public static final long clear(long value, long mask) {
        return BitUtil.set(value, mask, false);
    }

    private final void assertOneBitMask(byte mask) {
        this.assertOneBitMask((long)mask & 0xFFL);
    }

    @JvmStatic
    public static final void assertOneBitMask(int mask) {
        if (!((mask & mask - 1) == 0)) {
            boolean bl = false;
            String string = INSTANCE.invalidMaskError(mask);
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void assertOneBitMask(long mask) {
        if (!((mask & mask - 1L) == 0L)) {
            boolean bl = false;
            String string = INSTANCE.invalidMaskError(mask);
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final String invalidMaskError(long mask) {
        return "Mask must have only one bit set, but got: " + mask;
    }
}

