/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.library.core.NodeCoreSourcesFetchSession;
import com.intellij.javascript.nodejs.library.core.NodeCoreSourcesSnapshot;
import com.intellij.javascript.nodejs.library.core.NodeTypingsDownloadSession;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class NodeCoreLibraryConfigurator
implements Disposable {
    static final Logger LOG = Logger.getInstance(NodeCoreLibraryConfigurator.class);
    private static final String NODE_CORE_LIBRARY_CONFIGURED_VERSION = "javascript.nodejs.core.library.configured.version";
    private static final String NODE_CORE_LIBRARY_TYPINGS_VERSION = "javascript.nodejs.core.library.typings.version";
    private final Project myProject;
    private final NodeCoreLibraryManager myCoreLibraryManager;
    volatile List<VirtualFile> myTestCoreModuleFiles;

    public NodeCoreLibraryConfigurator(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myCoreLibraryManager = NodeCoreLibraryManager.getInstance(project);
    }

    public void dispose() {
    }

    @NotNull
    public static NodeCoreLibraryConfigurator getInstance(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(1);
        }
        NodeCoreLibraryConfigurator nodeCoreLibraryConfigurator = (NodeCoreLibraryConfigurator)project.getService(NodeCoreLibraryConfigurator.class);
        if (nodeCoreLibraryConfigurator == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(2);
        }
        return nodeCoreLibraryConfigurator;
    }

    @Nullable
    public NodeLibraryVersion getConfiguredCoreLibraryVersion() {
        return NodeCoreLibraryConfigurator.getConfiguredCoreLibraryVersion(this.myProject);
    }

    @Nullable
    public static NodeLibraryVersion getConfiguredCoreLibraryVersion(@NotNull Project project) {
        PropertiesComponent propertiesComponent;
        String nodeVersionStr;
        if (project == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(3);
        }
        if ((nodeVersionStr = (propertiesComponent = PropertiesComponent.getInstance((Project)project)).getValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION)) == null) {
            return null;
        }
        String nodeTypingsVersionStr = propertiesComponent.getValue(NODE_CORE_LIBRARY_TYPINGS_VERSION);
        SemVer nodeVersion = SemVer.parseFromText((String)nodeVersionStr);
        SemVer nodeTypingsVersion = SemVer.parseFromText((String)nodeTypingsVersionStr);
        return nodeVersion == null ? null : new NodeLibraryVersion(nodeVersion, nodeTypingsVersion);
    }

    private void setCoreLibraryConfigured(@NotNull SemVer nodeVersion, @Nullable SemVer nodeTypingsVersion) {
        if (nodeVersion == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(4);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        propertiesComponent.setValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION, nodeVersion.getRawVersion(), null);
        String version2 = nodeTypingsVersion != null ? nodeTypingsVersion.getRawVersion() : "";
        propertiesComponent.setValue(NODE_CORE_LIBRARY_TYPINGS_VERSION, version2, null);
    }

    public boolean isAvailable(@NotNull NodeJsInterpreter interpreter2) {
        if (interpreter2 == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(5);
        }
        try {
            NodeCommandLineConfigurator.find(interpreter2);
            return true;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    private void configure(@NotNull ProgressIndicator indicator, @NotNull NodeJsInterpreter interpreter2, @NotNull SemVer version2, @NotNull List<VirtualFile> rootsToAssociateWith, @Nullable Runnable onDone) {
        block8: {
            if (indicator == null) {
                NodeCoreLibraryConfigurator.$$$reportNull$$$0(6);
            }
            if (interpreter2 == null) {
                NodeCoreLibraryConfigurator.$$$reportNull$$$0(7);
            }
            if (version2 == null) {
                NodeCoreLibraryConfigurator.$$$reportNull$$$0(8);
            }
            if (rootsToAssociateWith == null) {
                NodeCoreLibraryConfigurator.$$$reportNull$$$0(9);
            }
            try {
                File nodeVersionDir = NodeCoreLibraryConfigurator.getNodeVersionDir(version2);
                FileUtil.delete((File)nodeVersionDir);
                File coreModulesSrcDir = NodeCoreLibraryConfigurator.getCoreModulesSrcDir(version2);
                FileUtil.createDirectory((File)coreModulesSrcDir);
                CompletableFuture<SemVer> typingsVersionFuture = NodeTypingsDownloadSession.start(version2, this.myProject, indicator);
                NodeCoreSourcesFetchSession.fetchSourcesSync(this.myProject, interpreter2, coreModulesSrcDir);
                SemVer typingsVersion = null;
                try {
                    typingsVersion = typingsVersionFuture.get();
                }
                catch (Exception e) {
                    String title = JavaScriptBundle.message("notification.title.cannot.download.types.node", new Object[0]);
                    LOG.warn(title, (Throwable)e);
                    @NlsSafe String message = ExceptionUtil.getMessage((Throwable)e);
                    this.notify(title, StringUtil.notNullize((String)message));
                }
                this.setCoreLibraryConfigured(version2, typingsVersion);
                NodeCoreLibraryConfigurator.refresh(nodeVersionDir, () -> {
                    ReadAction.run(() -> {
                        NodeCoreSourcesSnapshot snapshot = NodeCoreLibraryConfigurator.getSnapshot(coreModulesSrcDir);
                        this.myCoreLibraryManager.setSnapshot(snapshot);
                    });
                    this.scheduleLibrariesUpdate(indicator, rootsToAssociateWith, onDone);
                });
            }
            catch (ExecutionException | IOException e) {
                @NlsSafe String message = ExceptionUtil.getMessage((Throwable)e);
                this.notify(JavaScriptBundle.message("notification.title.cannot.enable.node.js.coding.assistance", new Object[0]), StringUtil.notNullize((String)message));
                LOG.warn("Cannot configure Node.js Core library", e);
                if (onDone == null) break block8;
                ApplicationManager.getApplication().invokeLater(onDone);
            }
        }
    }

    private void notify(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String content) {
        if (title == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(10);
        }
        if (content == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(11);
        }
        NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup("Node.js coding assistance");
        group.createNotification(title, content, NotificationType.ERROR).notify(this.myProject);
    }

    @Nullable
    static NodeCoreSourcesSnapshot getSnapshot(@NotNull File coreModulesSrcDir) {
        VirtualFile coreModulesSrcVirtualDir;
        if (coreModulesSrcDir == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(12);
        }
        if ((coreModulesSrcVirtualDir = LocalFileSystem.getInstance().findFileByIoFile(coreModulesSrcDir)) != null) {
            return new NodeCoreSourcesSnapshot(coreModulesSrcVirtualDir);
        }
        LOG.warn("Cannot find " + String.valueOf(coreModulesSrcDir));
        return null;
    }

    private static void refresh(@NotNull File nodeVersionDir, @NotNull Runnable finishRunnable) {
        if (nodeVersionDir == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(13);
        }
        if (finishRunnable == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (File[])new File[]{nodeVersionDir});
            finishRunnable.run();
        });
    }

    private void scheduleLibrariesUpdate(@NotNull ProgressIndicator indicator, @NotNull List<VirtualFile> rootsToAssociateWith, @Nullable Runnable onDone) {
        if (indicator == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(15);
        }
        if (rootsToAssociateWith == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                JSLibraryManager.getInstance(this.myProject).commitChanges(null);
                this.associateWith(rootsToAssociateWith);
                JSLibraryManager.getInstance(this.myProject).commitChangesWithReason(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED, "adding 'Node.js Core' library");
            });
            if (onDone != null) {
                ApplicationManager.getApplication().invokeLater(onDone, indicator.getModalityState());
            }
        }, indicator.getModalityState());
    }

    private void associateWith(@NotNull List<VirtualFile> rootsToAssociateWith) {
        if (rootsToAssociateWith == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(17);
        }
        JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance(this.myProject);
        for (VirtualFile root : rootsToAssociateWith) {
            libraryMappings.associate(root, "Node.js Core", true);
            LOG.info("Library 'Node.js Core' have been associated with " + (root == null ? "project" : root.getPath()));
        }
    }

    @NotNull
    static File getNodeVersionDir(@NotNull SemVer version2) {
        if (version2 == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(18);
        }
        return new File(JSUtils.getConfigJavaScriptDirPath() + File.separatorChar + "nodejs" + File.separatorChar + version2.getRawVersion());
    }

    @NotNull
    public static File getCoreModulesSrcDir(@NotNull SemVer nodeVersion) {
        if (nodeVersion == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(19);
        }
        return new File(NodeCoreLibraryConfigurator.getNodeVersionDir(nodeVersion), "core-modules");
    }

    @TestOnly
    public void setCoreModulesForTests(VirtualFile ... testCoreModuleFiles) {
        if (testCoreModuleFiles == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(20);
        }
        this.myTestCoreModuleFiles = Arrays.asList(testCoreModuleFiles);
        if (this.myTestCoreModuleFiles.isEmpty()) {
            this.myCoreLibraryManager.setSnapshot(null);
        } else {
            VirtualFile parentDir = Objects.requireNonNull((VirtualFile)ContainerUtil.getFirstItem(this.myTestCoreModuleFiles)).getParent();
            this.myCoreLibraryManager.setSnapshot(new NodeCoreSourcesSnapshot(parentDir));
        }
        JSLibraryManager.getInstance(this.myProject).commitChanges(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
    }

    @TestOnly
    public void removeAllCoreModulesForTests() {
        this.myTestCoreModuleFiles = null;
        this.myCoreLibraryManager.setSnapshot(null);
        JSLibraryManager.getInstance(this.myProject).commitChanges(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
    }

    public void configureAndAssociateWithProject(@NotNull NodeJsInterpreter interpreter2, @NotNull SemVer version2, @Nullable Runnable onDone) {
        if (interpreter2 == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(21);
        }
        if (version2 == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(22);
        }
        this.configureAndAssociateWith(interpreter2, version2, Collections.singletonList(null), onDone);
    }

    public void configureAndAssociateWith(final @NotNull NodeJsInterpreter interpreter2, final @NotNull SemVer version2, final @NotNull List<VirtualFile> rootsToAssociateWith, final @Nullable Runnable onDone) {
        if (interpreter2 == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(23);
        }
        if (version2 == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(24);
        }
        if (rootsToAssociateWith == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(25);
        }
        ThreadingAssertions.assertEventDispatchThread();
        new Task.Backgroundable(this.myProject, JavaScriptBundle.message("progress.title.configuring.node.js.coding.assistance", new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                NodeCoreLibraryConfigurator.this.configure(indicator, interpreter2, version2, rootsToAssociateWith, onDone);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryConfigurator$1", "run"));
            }
        }.queue();
    }

    public void disable() {
        ThreadingAssertions.assertEventDispatchThread();
        NodeLibraryVersion version2 = this.getConfiguredCoreLibraryVersion();
        if (version2 != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
                propertiesComponent.unsetValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION);
                propertiesComponent.unsetValue(NODE_CORE_LIBRARY_TYPINGS_VERSION);
                JSLibraryManager.getInstance(this.myProject).commitChanges(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryConfigurator";
                break;
            }
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeVersion";
                break;
            }
            case 5: 
            case 7: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 18: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 9: 
            case 16: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToAssociateWith";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreModulesSrcDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeVersionDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishRunnable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCoreModuleFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryConfigurator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredCoreLibraryVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCoreLibraryConfigured";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSnapshot";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "scheduleLibrariesUpdate";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "associateWith";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNodeVersionDir";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCoreModulesSrcDir";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setCoreModulesForTests";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "configureAndAssociateWithProject";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "configureAndAssociateWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class NodeLibraryVersion {
        private final SemVer myNodeVersion;
        private final SemVer myNodeTypingsVersion;

        public NodeLibraryVersion(@NotNull SemVer nodeVersion, @Nullable SemVer nodeTypingsVersion) {
            if (nodeVersion == null) {
                NodeLibraryVersion.$$$reportNull$$$0(0);
            }
            this.myNodeVersion = nodeVersion;
            this.myNodeTypingsVersion = nodeTypingsVersion;
        }

        @NotNull
        public SemVer getNodeVersion() {
            SemVer semVer = this.myNodeVersion;
            if (semVer == null) {
                NodeLibraryVersion.$$$reportNull$$$0(1);
            }
            return semVer;
        }

        @Nullable
        public SemVer getNodeTypingsVersion() {
            return this.myNodeTypingsVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeVersion";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryConfigurator$NodeLibraryVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryConfigurator$NodeLibraryVersion";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

