/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.editing.JavaScriptTypedHandler;
import com.intellij.lang.javascript.editor.JSEditorOptions;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringTemplateTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JSStringTemplateTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JSStringTemplateTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            JSStringTemplateTypedHandler.$$$reportNull$$$0(2);
        }
        if ((editor = JSStringTemplateTypedHandler.getEditorIfApplicable(c, project, editor, file, false)) == null) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                JSStringTemplateTypedHandler.$$$reportNull$$$0(3);
            }
            return result2;
        }
        int startOffset = editor.getCaretModel().getOffset();
        HighlighterIterator iterator = JavaScriptTypedHandler.createHighlighterIterator(editor, startOffset - 1);
        IElementType tokenType = iterator.getTokenType();
        if (tokenType == JSTokenTypes.STRING_TEMPLATE_PART) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"{}");
            editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
            TabOutScopesTracker.getInstance().registerEmptyScope(editor, startOffset + 1);
            TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.STOP;
            if (result3 == null) {
                JSStringTemplateTypedHandler.$$$reportNull$$$0(4);
            }
            return result3;
        }
        TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.CONTINUE;
        if (result4 == null) {
            JSStringTemplateTypedHandler.$$$reportNull$$$0(5);
        }
        return result4;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JSStringTemplateTypedHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            JSStringTemplateTypedHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            JSStringTemplateTypedHandler.$$$reportNull$$$0(8);
        }
        if ((editor = JSStringTemplateTypedHandler.getEditorIfApplicable(c, project, editor, file, true)) == null) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                JSStringTemplateTypedHandler.$$$reportNull$$$0(9);
            }
            return result2;
        }
        int startOffset = editor.getSelectionModel().getSelectionStart();
        int endOffset = editor.getSelectionModel().getSelectionEnd();
        boolean caretBefore = editor.getCaretModel().getOffset() <= startOffset;
        HighlighterIterator iterator = JavaScriptTypedHandler.createHighlighterIterator(editor, startOffset);
        if (iterator.getTokenType() == JSTokenTypes.STRING_TEMPLATE_PART && iterator.getEnd() >= endOffset) {
            String insertedText = "${" + editor.getSelectionModel().getSelectedText() + "}";
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)insertedText);
            if (caretBefore) {
                editor.getCaretModel().moveCaretRelatively(-insertedText.length(), 0, false, false, true);
            }
            TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.STOP;
            if (result3 == null) {
                JSStringTemplateTypedHandler.$$$reportNull$$$0(10);
            }
            return result3;
        }
        TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.CONTINUE;
        if (result4 == null) {
            JSStringTemplateTypedHandler.$$$reportNull$$$0(11);
        }
        return result4;
    }

    @Nullable
    private static Editor getEditorIfApplicable(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, boolean fromSelection) {
        int offset;
        if (project == null) {
            JSStringTemplateTypedHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            JSStringTemplateTypedHandler.$$$reportNull$$$0(13);
        }
        if (file == null) {
            JSStringTemplateTypedHandler.$$$reportNull$$$0(14);
        }
        if (c != '$' || !JSEditorOptions.getInstance().START_STRING_INTERPOLATION_ON_TYPING) {
            return null;
        }
        if (fromSelection && !editor.getSelectionModel().hasSelection()) {
            return null;
        }
        int n = offset = fromSelection ? editor.getSelectionModel().getSelectionEnd() : editor.getCaretModel().getOffset();
        if (InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)file) instanceof JSStringTemplateExpression && editor instanceof EditorWindow) {
            EditorWindow editorWindow = (EditorWindow)editor;
            editor = editorWindow.getDelegate();
        } else if (!JavaScriptTypedHandler.isJSDialectAtOffset(file, offset)) {
            return null;
        }
        return editor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/JSStringTemplateTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/JSStringTemplateTypedHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelectionRemoved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "beforeSelectionRemoved";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getEditorIfApplicable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

