/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks.alignment;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSBinaryOperatorAlignmentFactory
implements ASTNodeBasedAlignmentFactory {
    private final IElementType myOperatorType;
    private final CommonCodeStyleSettings myJSCommonSettings;
    private final Alignment myAlignment;

    @Nullable
    public static JSBinaryOperatorAlignmentFactory getInstance(@NotNull ASTNode binaryExpression, @Nullable ASTNodeBasedAlignmentFactory currentFactory, @NotNull CommonCodeStyleSettings jsCommonSettings) {
        IElementType currentType;
        if (binaryExpression == null) {
            JSBinaryOperatorAlignmentFactory.$$$reportNull$$$0(0);
        }
        if (jsCommonSettings == null) {
            JSBinaryOperatorAlignmentFactory.$$$reportNull$$$0(1);
        }
        IElementType binaryOperatorType = JSBinaryOperatorAlignmentFactory.getBinaryOperatorType(binaryExpression);
        if (currentFactory instanceof JSBinaryOperatorAlignmentFactory && (currentType = ((JSBinaryOperatorAlignmentFactory)currentFactory).myOperatorType) == binaryOperatorType) {
            return (JSBinaryOperatorAlignmentFactory)currentFactory;
        }
        return new JSBinaryOperatorAlignmentFactory(binaryExpression, jsCommonSettings);
    }

    private JSBinaryOperatorAlignmentFactory(@NotNull ASTNode binaryExpression, @NotNull CommonCodeStyleSettings jsCommonSettings) {
        if (binaryExpression == null) {
            JSBinaryOperatorAlignmentFactory.$$$reportNull$$$0(2);
        }
        if (jsCommonSettings == null) {
            JSBinaryOperatorAlignmentFactory.$$$reportNull$$$0(3);
        }
        this.myAlignment = Alignment.createAlignment();
        this.myOperatorType = JSBinaryOperatorAlignmentFactory.getBinaryOperatorType(binaryExpression);
        this.myJSCommonSettings = jsCommonSettings;
    }

    @Override
    public Alignment getAlignment(@NotNull ASTNode child) {
        ASTNode parent;
        if (child == null) {
            JSBinaryOperatorAlignmentFactory.$$$reportNull$$$0(4);
        }
        if (this.myJSCommonSettings.ALIGN_MULTILINE_BINARY_OPERATION && (parent = child.getTreeParent()) != null && parent.getElementType() == JSElementTypes.BINARY_EXPRESSION) {
            return this.myAlignment;
        }
        return null;
    }

    @Nullable
    private static IElementType getBinaryOperatorType(ASTNode node) {
        if (node.getPsi() instanceof JSBinaryExpression) {
            return ((JSBinaryExpression)node.getPsi()).getOperationSign();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsCommonSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/formatter/blocks/alignment/JSBinaryOperatorAlignmentFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAlignment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

