/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.controlflow.instruction;

import com.intellij.codeInsight.controlflow.impl.DetachedInstructionImpl;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSConditionInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSInstructionWithReachability;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSBranchInstruction
extends DetachedInstructionImpl
implements JSInstructionWithReachability {
    @NotNull
    private final BranchOwner myKind;
    @NotNull
    private final JSConditionInstruction.ConditionState myState;
    private final boolean myCondition;

    public JSBranchInstruction(@Nullable PsiElement element2, @NotNull BranchOwner kind, boolean conditionValue, @NotNull JSConditionInstruction.ConditionState state) {
        if (kind == null) {
            JSBranchInstruction.$$$reportNull$$$0(0);
        }
        if (state == null) {
            JSBranchInstruction.$$$reportNull$$$0(1);
        }
        super(element2);
        this.myKind = kind;
        this.myCondition = conditionValue;
        this.myState = state;
    }

    @Override
    public boolean isReachable() {
        if (this.myState == JSConditionInstruction.ConditionState.UNKNOWN) {
            return true;
        }
        JSConditionInstruction.ConditionState expected = JSConditionInstruction.ConditionState.toCondition(this.myCondition);
        return expected == this.myState;
    }

    @NotNull
    public String getElementPresentation() {
        String string = super.getElementPresentation() + " " + String.valueOf((Object)this.myKind) + " (branch) " + this.myCondition + (String)(this.myState == JSConditionInstruction.ConditionState.UNKNOWN ? "" : " " + String.valueOf((Object)this.myState));
        if (string == null) {
            JSBranchInstruction.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/controlflow/instruction/JSBranchInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/controlflow/instruction/JSBranchInstruction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static enum BranchOwner {
        IF,
        CONDITIONAL_EXPRESSION,
        LOGICAL_EXPRESSION,
        FOR,
        WHILE,
        DO_WHILE;

    }
}

