/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSSuperExpressionImpl
extends JSExpressionImpl
implements JSSuperExpression,
PsiPolyVariantReference {
    private static final ResolveCache.PolyVariantResolver<JSSuperExpressionImpl> RESOLVER = (superExpression, incompleteCode) -> {
        JSClass contextClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)superExpression, JSClass.class);
        Collection<PsiElement> classLikeElements = superExpression.findClass(contextClass);
        PsiElement parentExpression = superExpression.getParent();
        if (parentExpression instanceof JSCallExpression) {
            for (PsiElement element2 : classLikeElements) {
                PsiElement constructor;
                if (!(element2 instanceof JSClass)) continue;
                JSCallExpression expression = (JSCallExpression)parentExpression;
                if (contextClass != null && (constructor = JSSuperExpressionImpl.matchSuperConstructor(expression, contextClass)) != null) {
                    return new ResolveResult[]{new PsiElementResolveResult(constructor)};
                }
                PsiElement processor = JSSuperExpressionImpl.findConstructorInClass((JSClass)element2, expression, (PsiElement)superExpression);
                if (processor == null) continue;
                return new ResolveResult[]{new PsiElementResolveResult(processor)};
            }
        }
        return (ResolveResult[])ContainerUtil.map2Array(classLikeElements, ResolveResult.class, PsiElementResolveResult::new);
    };

    public JSSuperExpressionImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSSuperExpression(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiReference getReference() {
        return this;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = super.getReferences();
        if (psiReferenceArray == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiElement getElement() {
        JSSuperExpressionImpl jSSuperExpressionImpl = this;
        if (jSSuperExpressionImpl == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(2);
        }
        return jSSuperExpressionImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, RESOLVER, false, false);
        if (resolveResultArray == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    @Nullable
    public PsiElement resolve() {
        return (PsiElement)ContainerUtil.getFirstItem((List)ContainerUtil.map((Object[])this.multiResolve(false), ResolveResult::getElement));
    }

    @NotNull
    private Collection<PsiElement> findClass(@Nullable JSClass jsClass) {
        if (jsClass != null) {
            Object[] superClasses = jsClass.getSuperClasses();
            if (superClasses.length > 0) {
                return new SmartList(superClasses);
            }
        } else {
            JSFile jsFile = (JSFile)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), JSFile.class);
            if (jsFile != null) {
                List list = ContainerUtil.createMaybeSingletonList((Object)JSResolveUtil.getClassReferenceForXmlFromContext(jsFile));
                if (list == null) {
                    JSSuperExpressionImpl.$$$reportNull$$$0(4);
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(7);
        }
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(8);
        }
        return this;
    }

    public boolean isReferenceTo(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(9);
        }
        return this.resolve() == element2;
    }

    public boolean isSoft() {
        return true;
    }

    @Nullable
    public static PsiElement findConstructorInClass(@NotNull JSClass clazz, @NotNull JSCallExpression expression, @NotNull PsiElement place) {
        PsiElement constructorOverload;
        String superConstructor;
        if (clazz == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(10);
        }
        if (expression == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(11);
        }
        if (place == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(12);
        }
        String string = superConstructor = place.getContainingFile().getLanguage().isKindOf((Language)FlexSupportLoader.ECMA_SCRIPT_L4) ? clazz.getName() : "constructor";
        if (superConstructor == null) {
            return null;
        }
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(superConstructor, place, new ResolveResultSink(place, superConstructor));
        clazz.processDeclarations(processor, ResolveState.initial(), clazz, place);
        if (DialectDetector.isTypeScript(clazz) && (constructorOverload = JSSuperExpressionImpl.resolveTypeScriptConstructorOverload(processor, expression)) != null) {
            return constructorOverload;
        }
        return processor.getResult();
    }

    @Nullable
    private static PsiElement resolveTypeScriptConstructorOverload(@NotNull SinkResolveProcessor processor, @NotNull JSCallExpression expression) {
        if (processor == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(13);
        }
        if (expression == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(14);
        }
        ResolveResult[] results = processor.getResultsAsResolveResults();
        boolean valid = true;
        ArrayList<TypeScriptFunction> ctors = new ArrayList<TypeScriptFunction>();
        for (ResolveResult result2 : results) {
            if (!result2.isValidResult()) {
                valid = false;
                break;
            }
            PsiElement element2 = result2.getElement();
            if (!(element2 instanceof TypeScriptFunction)) {
                valid = false;
                break;
            }
            ctors.add((TypeScriptFunction)element2);
        }
        if (valid) {
            if (ctors.size() == 1) {
                return (PsiElement)ctors.get(0);
            }
            JSExpression methodExpression = expression.getMethodExpression();
            if (methodExpression != null) {
                return TypeScriptSignatureChooser.resolveOverloads(expression, ctors);
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement matchSuperConstructor(@NotNull JSCallExpression expression, @NotNull JSClass jsClass) {
        JSReferenceList extendsList;
        if (expression == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(15);
        }
        if (jsClass == null) {
            JSSuperExpressionImpl.$$$reportNull$$$0(16);
        }
        if (!((extendsList = jsClass.getExtendsList()) instanceof ES6ReferenceList)) {
            return null;
        }
        Collection<JSFunction> constructors = ((ES6ReferenceList)extendsList).getIndirectSuperConstructors();
        if (!constructors.isEmpty()) {
            JSFunctionItem function = new JSTypeSignatureChooser(expression).chooseOverloadFunction(constructors, true);
            if (function != null) {
                return function;
            }
            return (PsiElement)ContainerUtil.getFirstItem(constructors);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSSuperExpressionImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSSuperExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findConstructorInClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeScriptConstructorOverload";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "matchSuperConstructor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

