/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSStubElementTypeHolder {
    private final String mySerializedType;
    private final JSType myJSType;
    private JSType myTypeOrFromSerialized;

    public JSStubElementTypeHolder(@NotNull String serializedType) {
        if (serializedType == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(0);
        }
        this.mySerializedType = serializedType;
        this.myJSType = null;
    }

    public JSStubElementTypeHolder(@NotNull JSType type2) {
        if (type2 == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(1);
        }
        this.mySerializedType = null;
        this.myJSType = type2;
    }

    @NotNull
    public String getSerializedTypeString() {
        String string = this.mySerializedType != null ? this.mySerializedType : Objects.requireNonNull(JSTypeUtils.serializeType(this.myJSType));
        if (string == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public JSType getJSType() {
        return this.myJSType;
    }

    @NotNull
    JSType getTypeOrFromSerialized() {
        JSType typeOrFromSerialized = this.myTypeOrFromSerialized;
        if (typeOrFromSerialized != null) {
            JSType jSType = typeOrFromSerialized;
            if (jSType == null) {
                JSStubElementTypeHolder.$$$reportNull$$$0(3);
            }
            return jSType;
        }
        this.myTypeOrFromSerialized = typeOrFromSerialized = this.myJSType != null ? this.myJSType : JSTypeParser.parseSerializedType(this.mySerializedType, JSTypeSource.EMPTY);
        if (typeOrFromSerialized != null) {
            JSType jSType = typeOrFromSerialized;
            if (jSType == null) {
                JSStubElementTypeHolder.$$$reportNull$$$0(4);
            }
            return jSType;
        }
        JSAnyType jSAnyType = JSAnyType.get(JSTypeSource.EMPTY);
        if (jSAnyType == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(5);
        }
        return jSAnyType;
    }

    @NotNull
    public JSType getTypeOrFromSerialized(@NotNull PsiElement sourceElement, boolean isFromJSDoc, boolean isTypeStrict) {
        JSType typeOrFromSerialized;
        if (sourceElement == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(6);
        }
        if ((typeOrFromSerialized = this.myTypeOrFromSerialized) != null && typeOrFromSerialized.getSourceElement() != null) {
            JSType jSType = typeOrFromSerialized;
            if (jSType == null) {
                JSStubElementTypeHolder.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        if (this.myJSType != null) {
            typeOrFromSerialized = this.myJSType;
        } else {
            JSDocComment docComment;
            String serializedType = Objects.requireNonNull(this.mySerializedType);
            if (isFromJSDoc && (docComment = JSStubBasedPsiTreeUtil.findOwnDocComment(sourceElement)) != null) {
                sourceElement = docComment;
            }
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(sourceElement, isTypeStrict);
            typeOrFromSerialized = JSTypeParser.parseSerializedType(sourceElement.getProject(), serializedType, source);
        }
        this.myTypeOrFromSerialized = typeOrFromSerialized;
        if (typeOrFromSerialized != null) {
            JSType jSType = typeOrFromSerialized;
            if (jSType == null) {
                JSStubElementTypeHolder.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        JSAnyType jSAnyType = JSAnyType.get(JSTypeSource.EMPTY);
        if (jSAnyType == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(9);
        }
        return jSAnyType;
    }

    public static void serialize(@NotNull JSStubElementTypeHolder holder, @NotNull DataOutput out) throws IOException {
        String typeString;
        if (holder == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(10);
        }
        if (out == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(11);
        }
        String string = typeString = holder.mySerializedType != null ? holder.mySerializedType : JSTypeUtils.serializeType(holder.myJSType);
        if (out instanceof StubOutputStream) {
            ((StubOutputStream)out).writeName(typeString);
        } else {
            IOUtil.writeUTF((DataOutput)out, (String)typeString);
        }
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static JSStubElementTypeHolder fromJSType(@Nullable JSType type2) {
        return type2 != null ? new JSStubElementTypeHolder(type2) : null;
    }

    @NotNull
    public static JSStubElementTypeHolder fromDataStream(@NotNull DataInput in) throws IOException {
        String name;
        if (in == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(12);
        }
        String string = name = in instanceof StubInputStream ? ((StubInputStream)in).readNameString() : IOUtil.readUTF((DataInput)in);
        if (name == null) {
            Logger.getInstance(JSStubElementTypeHolder.class).error("name is null");
            name = "";
        }
        return new JSStubElementTypeHolder(name);
    }

    public String toString() {
        return this.getSerializedTypeString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSStubElementTypeHolder holder = (JSStubElementTypeHolder)o;
        return Objects.equals(this.getSerializedTypeString(), holder.getSerializedTypeString());
    }

    public int hashCode() {
        return Objects.hash(this.getSerializedTypeString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializedType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSStubElementTypeHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSStubElementTypeHolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializedTypeString";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeOrFromSerialized";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOrFromSerialized";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fromDataStream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

