/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.surroundWith.JSWithBlockSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithDoWhileSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithForSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithFunctionExpressionSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithFunctionSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithIfElseSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithIfSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithTryCatchFinallySurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithTryCatchSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithTryFinallySurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithWhileSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithWithSurrounder;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSStatementsSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new JSWithIfSurrounder(), new JSWithIfElseSurrounder(), new JSWithWhileSurrounder(), new JSWithDoWhileSurrounder(), new JSWithForSurrounder(), new JSWithTryCatchSurrounder(), new JSWithTryFinallySurrounder(), new JSWithTryCatchFinallySurrounder(), new JSWithWithSurrounder(), new JSWithFunctionSurrounder(), new JSWithBlockSurrounder(), new JSWithFunctionExpressionSurrounder()};

    public PsiElement @NotNull [] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        PsiElement[] statements = JSStatementsSurroundDescriptor.findStatementsInRange(file, startOffset, endOffset);
        if (statements == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                JSStatementsSurroundDescriptor.$$$reportNull$$$0(0);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (statements == null) {
            JSStatementsSurroundDescriptor.$$$reportNull$$$0(1);
        }
        return statements;
    }

    public Surrounder @NotNull [] getSurrounders() {
        if (SURROUNDERS == null) {
            JSStatementsSurroundDescriptor.$$$reportNull$$$0(2);
        }
        return SURROUNDERS;
    }

    public boolean isExclusive() {
        return false;
    }

    private static PsiElement[] findStatementsInRange(PsiFile file, int startOffset, int endOffset) {
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element1, JSStatement.class);
        JSStatement statement2 = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, JSStatement.class);
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        while (!(parent instanceof JSBlockStatement || (parent instanceof JSEmbeddedContent || parent instanceof JSFile) && statement != null && statement2 != null && PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)statement, (boolean)false) && PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)statement2, (boolean)false))) {
            if (parent instanceof JSStatement) {
                parent = parent.getParent();
                break;
            }
            if (parent instanceof PsiFile) {
                return null;
            }
            parent = parent.getParent();
        }
        while (!element1.getParent().equals(parent)) {
            element1 = element1.getParent();
        }
        if (startOffset != element1.getTextRange().getStartOffset()) {
            return null;
        }
        while (!element2.getParent().equals(parent)) {
            element2 = element2.getParent();
        }
        if (endOffset != element2.getTextRange().getEndOffset()) {
            return null;
        }
        ASTNode[] astNodes = parent.getNode().getChildren(null);
        ArrayList<PsiElement> children = new ArrayList<PsiElement>(astNodes.length);
        for (ASTNode node : astNodes) {
            children.add(node.getPsi());
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        boolean flag = false;
        for (PsiElement child : children) {
            if (child.equals(element1)) {
                flag = true;
            }
            if (flag) {
                array.add(child);
            }
            if (!child.equals(element2)) continue;
            break;
        }
        for (PsiElement element3 : array) {
            if (element3 instanceof JSStatement || element3 instanceof PsiWhiteSpace || element3 instanceof PsiComment) continue;
            return null;
        }
        return PsiUtilCore.toPsiElementArray(array);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/surroundWith/JSStatementsSurroundDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToSurround";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurrounders";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

