/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.settings;

import com.intellij.charts.core.axes.settings.AxesSettings;
import com.intellij.charts.core.settings.ChartSettings;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.dataframe.columns.Column;
import com.intellij.charts.dataframe.columns.ColumnId;
import com.intellij.charts.settings.data.BarSeriesSettings;
import com.intellij.charts.settings.data.ColumnSettings;
import com.intellij.charts.settings.data.LineSeriesSettings;
import com.intellij.charts.settings.data.ScatterSeriesSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import com.intellij.charts.settings.series.BaseSeriesPanel;
import com.intellij.charts.settings.ui.TokenFieldColumnList;
import com.intellij.charts.settings.ui.TokenFieldElementColumn;
import com.intellij.charts.statistics.ChartsUsagesCollector;
import com.intellij.charts.utils.ChartMessagesBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 12\u00020\u00012\u00020\u0002:\u000201B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0019\u001a\u00020\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020\u0014H\u0002J\b\u0010*\u001a\u00020\u0014H\u0002J\b\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0006\u0010.\u001a\u00020\u0006J\u0006\u0010/\u001a\u00020\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00062"}, d2={"Lcom/intellij/charts/settings/SeriesSettingsPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "chartSettings", "Lcom/intellij/charts/core/settings/ChartSettings;", "mode", "Lcom/intellij/charts/settings/SeriesSettingsPanel$Mode;", "<init>", "(Lcom/intellij/charts/dataframe/DataFrame;Lcom/intellij/charts/core/settings/ChartSettings;Lcom/intellij/charts/settings/SeriesSettingsPanel$Mode;)V", "getDataFrame", "()Lcom/intellij/charts/dataframe/DataFrame;", "panel", "mergeXAxesCheckBox", "Ljavax/swing/JCheckBox;", "mergeYAxesCheckBox", "bottomPanel", "onChange", "Lkotlin/Function0;", "", "getOnChange", "()Lkotlin/jvm/functions/Function0;", "setOnChange", "(Lkotlin/jvm/functions/Function0;)V", "init", "getMinimumSize", "Ljava/awt/Dimension;", "couldProduceMultipleAxes", "", "settingsChanged", "dispose", "removeSeriesPanel", "baseSeriesPanel", "Lcom/intellij/charts/settings/series/BaseSeriesPanel;", "rigidArea", "Ljava/awt/Component;", "createSeriesPanel", "settings", "Lcom/intellij/charts/settings/data/SeriesSettings;", "addSeriesPanel", "hideBottomPanel", "showBottomPanel", "createCloseButton", "Ljavax/swing/JComponent;", "createColumnsListPanel", "getSettings", "revalidateFields", "Mode", "Companion", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nSeriesSettingsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesSettingsPanel.kt\ncom/intellij/charts/settings/SeriesSettingsPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,267:1\n1869#2,2:268\n1869#2,2:281\n1869#2,2:294\n1869#2,2:307\n1869#2,2:310\n4135#3,11:270\n4135#3,11:283\n4135#3,11:296\n1#4:309\n*S KotlinDebug\n*F\n+ 1 SeriesSettingsPanel.kt\ncom/intellij/charts/settings/SeriesSettingsPanel\n*L\n95#1:268,2\n135#1:281,2\n149#1:294,2\n176#1:307,2\n221#1:310,2\n135#1:270,11\n147#1:283,11\n175#1:296,11\n*E\n"})
public class SeriesSettingsPanel
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataFrame dataFrame;
    @NotNull
    private final ChartSettings chartSettings;
    @NotNull
    private final Mode mode;
    @NotNull
    private final JPanel panel;
    @NotNull
    private JCheckBox mergeXAxesCheckBox;
    @NotNull
    private JCheckBox mergeYAxesCheckBox;
    @Nullable
    private JPanel bottomPanel;
    @Nullable
    private Function0<Unit> onChange;
    public static final int TOKENS_LIMIT = 15;

    /*
     * WARNING - void declaration
     */
    public SeriesSettingsPanel(@NotNull DataFrame dataFrame, @NotNull ChartSettings chartSettings, @NotNull Mode mode) {
        void $this$mergeYAxesCheckBox_u24lambda_u241;
        JCheckBox $this$mergeXAxesCheckBox_u24lambda_u240;
        JCheckBox jCheckBox;
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)chartSettings, (String)"chartSettings");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        super(new BorderLayout(0, 5));
        this.dataFrame = dataFrame;
        this.chartSettings = chartSettings;
        this.mode = mode;
        this.panel = new JPanel();
        JCheckBox jCheckBox2 = jCheckBox = new JCheckBox(ChartMessagesBundle.message("series.mergeX", new Object[0]));
        SeriesSettingsPanel seriesSettingsPanel = this;
        boolean bl = false;
        $this$mergeXAxesCheckBox_u24lambda_u240.setHorizontalTextPosition(2);
        seriesSettingsPanel.mergeXAxesCheckBox = jCheckBox;
        $this$mergeXAxesCheckBox_u24lambda_u240 = jCheckBox = new JCheckBox(ChartMessagesBundle.message("series.mergeY", new Object[0]));
        seriesSettingsPanel = this;
        boolean bl2 = false;
        $this$mergeYAxesCheckBox_u24lambda_u241.setHorizontalTextPosition(2);
        seriesSettingsPanel.mergeYAxesCheckBox = jCheckBox;
    }

    @NotNull
    public final DataFrame getDataFrame() {
        return this.dataFrame;
    }

    @Nullable
    public final Function0<Unit> getOnChange() {
        return this.onChange;
    }

    public final void setOnChange(@Nullable Function0<Unit> function0) {
        this.onChange = function0;
    }

    /*
     * WARNING - void declaration
     */
    public final void init() {
        JBScrollPane jBScrollPane;
        void $this$init_u24lambda_u246;
        JPanel $this$init_u24lambda_u244;
        JPanel jPanel;
        JPanel jPanel2;
        this.setOpaque(false);
        this.panel.setOpaque(false);
        this.setBorder(JBUI.Borders.empty((int)10));
        this.mergeXAxesCheckBox.setSelected(this.chartSettings.getAxesSettings().getMergeXAxes());
        this.mergeXAxesCheckBox.addActionListener(arg_0 -> SeriesSettingsPanel.init$lambda$2(this, arg_0));
        this.mergeYAxesCheckBox.setSelected(this.chartSettings.getAxesSettings().getMergeYAxes());
        this.mergeYAxesCheckBox.addActionListener(arg_0 -> SeriesSettingsPanel.init$lambda$3(this, arg_0));
        if (this.mode == Mode.WITH_COLUMNS_LIST) {
            this.add((Component)this.createColumnsListPanel(this.dataFrame), "First");
        } else {
            JPanel jPanel3 = jPanel2 = new JPanel(new BorderLayout());
            jPanel = this;
            boolean bl = false;
            $this$init_u24lambda_u244.setOpaque(false);
            $this$init_u24lambda_u244.add(new JLabel(ChartMessagesBundle.message("series.settings.title", new Object[0])));
            $this$init_u24lambda_u244.add((Component)this.createCloseButton(), "After");
            jPanel.add((Component)jPanel2, "First");
        }
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.setBorder((Border)JBUI.Borders.empty());
        this.panel.setOpaque(false);
        $this$init_u24lambda_u244 = jPanel2 = new ActionLink(ChartMessagesBundle.message("series.addNew", new Object[0]), arg_0 -> SeriesSettingsPanel.init$lambda$5(this, arg_0));
        jPanel = this.panel;
        boolean bl = false;
        $this$init_u24lambda_u246.setAlignmentX(0.5f);
        $this$init_u24lambda_u246.setOpaque(false);
        jPanel.add(jPanel2);
        if (this.chartSettings.getSeriesSettings().isEmpty()) {
            this.addSeriesPanel(new LineSeriesSettings(null, null, null, false, false, false, 63, null));
        } else {
            Iterable $this$forEach$iv = this.chartSettings.getSeriesSettings();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SeriesSettings it = (SeriesSettings)element$iv;
                boolean bl2 = false;
                this.addSeriesPanel(it);
            }
        }
        JBScrollPane $this$init_u24lambda_u248 = jBScrollPane = new JBScrollPane((Component)this.panel, 20, 31);
        boolean bl3 = false;
        $this$init_u24lambda_u248.setBorder((Border)JBUI.Borders.empty());
        $this$init_u24lambda_u248.setOpaque(false);
        $this$init_u24lambda_u248.getViewport().setOpaque(false);
        JBScrollPane scroll = jBScrollPane;
        this.add((Component)scroll, "Center");
        this.hideBottomPanel();
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return new Dimension(Math.max(super.getMinimumSize().width, 300), super.getMinimumSize().height);
    }

    private final boolean couldProduceMultipleAxes() {
        for (SeriesSettings settings : this.getSettings().getSeriesSettings()) {
            SeriesSettings seriesSettings = settings;
            boolean bl = seriesSettings instanceof LineSeriesSettings ? ((LineSeriesSettings)settings).getValues().size() > 1 || !((Collection)((LineSeriesSettings)settings).getGroups()).isEmpty() : (seriesSettings instanceof ScatterSeriesSettings ? ((ScatterSeriesSettings)settings).getValues().size() > 1 || !((Collection)((ScatterSeriesSettings)settings).getGroups()).isEmpty() : (seriesSettings instanceof BarSeriesSettings ? ((BarSeriesSettings)settings).getValues().size() > 1 : false));
            boolean result2 = bl;
            if (!result2) continue;
            return true;
        }
        return false;
    }

    private final void settingsChanged() {
        block0: {
            Function0<Unit> function0 = this.onChange;
            if (function0 == null) break block0;
            function0.invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dispose() {
        void $this$filterIsInstanceTo$iv$iv;
        Component[] componentArray = this.panel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$filterIsInstance$iv = componentArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BaseSeriesPanel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseSeriesPanel it = (BaseSeriesPanel)element$iv;
            boolean bl = false;
            it.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeSeriesPanel(BaseSeriesPanel baseSeriesPanel, Component rigidArea) {
        void $this$filterIsInstanceTo$iv$iv;
        this.panel.remove(baseSeriesPanel);
        this.panel.remove(rigidArea);
        this.panel.revalidate();
        this.panel.repaint();
        this.settingsChanged();
        Component[] componentArray = this.panel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$filterIsInstance$iv = componentArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BaseSeriesPanel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List seriesPanels = (List)destination$iv$iv;
        Iterable $this$forEach$iv = seriesPanels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseSeriesPanel it = (BaseSeriesPanel)element$iv;
            boolean bl = false;
            it.setShowDeleteButton(seriesPanels.size() > 1);
        }
    }

    @NotNull
    protected BaseSeriesPanel createSeriesPanel(@NotNull SeriesSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new BaseSeriesPanel(this.dataFrame, settings);
    }

    /*
     * WARNING - void declaration
     */
    private final void addSeriesPanel(SeriesSettings settings) {
        void $this$filterIsInstanceTo$iv$iv;
        BaseSeriesPanel baseSeriesPanel = this.createSeriesPanel(settings);
        baseSeriesPanel.setOnChange((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                SeriesSettingsPanel.access$settingsChanged((SeriesSettingsPanel)this.receiver);
            }
        }));
        this.panel.add((Component)baseSeriesPanel, this.panel.getComponentCount() - 1);
        Component rigidArea = Box.createRigidArea((Dimension)JBUI.size((int)0, (int)15));
        this.panel.add(rigidArea, this.panel.getComponentCount() - 1);
        baseSeriesPanel.setOnRemove((Function0<Unit>)((Function0)() -> SeriesSettingsPanel.addSeriesPanel$lambda$11(this, baseSeriesPanel, rigidArea)));
        baseSeriesPanel.revalidateFields();
        this.panel.revalidate();
        this.panel.repaint();
        Component[] componentArray = this.panel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$filterIsInstance$iv = componentArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BaseSeriesPanel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List seriesPanels = (List)destination$iv$iv;
        Iterable $this$forEach$iv = seriesPanels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseSeriesPanel it = (BaseSeriesPanel)element$iv;
            boolean bl = false;
            it.setShowDeleteButton(seriesPanels.size() > 1);
        }
    }

    private final void hideBottomPanel() {
        block0: {
            JPanel jPanel = this.bottomPanel;
            if (jPanel == null) break block0;
            JPanel it = jPanel;
            boolean bl = false;
            this.remove(this.bottomPanel);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showBottomPanel() {
        if (this.bottomPanel == null) {
            void $this$showBottomPanel_u24lambda_u2418;
            GridBagConstraints c;
            GridBagConstraints gridBagConstraints;
            JPanel jPanel;
            JPanel jPanel2 = jPanel = new JPanel(new GridBagLayout());
            SeriesSettingsPanel seriesSettingsPanel = this;
            boolean bl = false;
            GridBagConstraints $this$showBottomPanel_u24lambda_u2418_u24lambda_u2414 = gridBagConstraints = new GridBagConstraints();
            boolean bl2 = false;
            $this$showBottomPanel_u24lambda_u2418_u24lambda_u2414.anchor = 21;
            $this$showBottomPanel_u24lambda_u2418_u24lambda_u2414 = gridBagConstraints = (c = gridBagConstraints);
            Component component2 = Box.createRigidArea((Dimension)JBUI.size((int)0, (int)5));
            void var9_10 = $this$showBottomPanel_u24lambda_u2418;
            boolean bl3 = false;
            $this$showBottomPanel_u24lambda_u2418_u24lambda_u2415.fill = 2;
            $this$showBottomPanel_u24lambda_u2418_u24lambda_u2415.weightx = 1.0;
            $this$showBottomPanel_u24lambda_u2418_u24lambda_u2415.gridwidth = 2;
            Unit unit = Unit.INSTANCE;
            var9_10.add(component2, gridBagConstraints);
            GridBagConstraints $this$showBottomPanel_u24lambda_u2418_u24lambda_u2415 = gridBagConstraints = c;
            component2 = this.mergeXAxesCheckBox;
            var9_10 = $this$showBottomPanel_u24lambda_u2418;
            boolean bl4 = false;
            $this$showBottomPanel_u24lambda_u2418_u24lambda_u2416.fill = 0;
            $this$showBottomPanel_u24lambda_u2418_u24lambda_u2416.gridx = 0;
            $this$showBottomPanel_u24lambda_u2418_u24lambda_u2416.gridwidth = 1;
            $this$showBottomPanel_u24lambda_u2418_u24lambda_u2416.weightx = 1.0;
            unit = Unit.INSTANCE;
            var9_10.add(component2, gridBagConstraints);
            GridBagConstraints $this$showBottomPanel_u24lambda_u2418_u24lambda_u2416 = gridBagConstraints = c;
            component2 = this.mergeYAxesCheckBox;
            var9_10 = $this$showBottomPanel_u24lambda_u2418;
            boolean bl5 = false;
            $this$showBottomPanel_u24lambda_u2418_u24lambda_u2417.fill = 0;
            $this$showBottomPanel_u24lambda_u2418_u24lambda_u2417.gridx = 1;
            $this$showBottomPanel_u24lambda_u2418_u24lambda_u2417.weightx = 1.0;
            unit = Unit.INSTANCE;
            var9_10.add(component2, gridBagConstraints);
            $this$showBottomPanel_u24lambda_u2418.setBorder(IdeBorderFactory.createBorder((int)2));
            seriesSettingsPanel.bottomPanel = jPanel;
        }
        JPanel jPanel = this.bottomPanel;
        Intrinsics.checkNotNull((Object)jPanel);
        this.add((Component)jPanel, "Last");
    }

    private final JComponent createCloseButton() {
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)ChartMessagesBundle.message("series.action.close", new Object[0]), (Icon)AllIcons.Actions.Close, arg_0 -> SeriesSettingsPanel.createCloseButton$lambda$20(arg_0 -> SeriesSettingsPanel.createCloseButton$lambda$19(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        DumbAwareAction action2 = dumbAwareAction;
        return (JComponent)new ActionButton((AnAction)action2, null, "CHART_SERIES_PANEL", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createColumnsListPanel(DataFrame dataFrame) {
        void $this$createColumnsListPanel_u24lambda_u2423_u24lambda_u2422;
        JPanel jPanel;
        Object indexedColumn;
        TokenFieldColumnList columnsTokenField = new TokenFieldColumnList(dataFrame.getColumns());
        columnsTokenField.setTokensLimit(15);
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)dataFrame.getColumns());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            indexedColumn = (IndexedValue)element$iv;
            boolean bl = false;
            if (indexedColumn.getIndex() > 15) continue;
            columnsTokenField.addColumn(new ColumnSettings(new ColumnId(((Column)indexedColumn.getValue()).getName(), indexedColumn.getIndex()), null, 2, null), TokenFieldElementColumn.Companion.getColumnTypeIcon((Column)indexedColumn.getValue()));
        }
        JPanel $this$createColumnsListPanel_u24lambda_u2423 = jPanel = new JPanel();
        boolean bl = false;
        $this$createColumnsListPanel_u24lambda_u2423.setLayout(new BoxLayout($this$createColumnsListPanel_u24lambda_u2423, 1));
        $this$createColumnsListPanel_u24lambda_u2423.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        indexedColumn = jPanel2;
        JPanel jPanel3 = $this$createColumnsListPanel_u24lambda_u2423;
        boolean bl2 = false;
        $this$createColumnsListPanel_u24lambda_u2423_u24lambda_u2422.add((Component)new JLabel(ChartMessagesBundle.message("series.availableColumns", new Object[0])), "West");
        $this$createColumnsListPanel_u24lambda_u2423_u24lambda_u2422.add((Component)this.createCloseButton(), "East");
        jPanel3.add(jPanel2);
        $this$createColumnsListPanel_u24lambda_u2423.add(columnsTokenField);
        return jPanel;
    }

    @NotNull
    public final ChartSettings getSettings() {
        ArrayList<SeriesSettings> seriesSettings = new ArrayList<SeriesSettings>();
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.panel.getComponents());
        while (iterator2.hasNext()) {
            Component comp = (Component)iterator2.next();
            if (!(comp instanceof BaseSeriesPanel)) continue;
            seriesSettings.add(((BaseSeriesPanel)comp).getSeriesSettings());
        }
        AxesSettings axesSettings = new AxesSettings(this.mergeXAxesCheckBox.isSelected(), this.mergeYAxesCheckBox.isSelected());
        return new ChartSettings(axesSettings, (List<? extends SeriesSettings>)seriesSettings);
    }

    public final void revalidateFields() {
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.panel.getComponents());
        while (iterator2.hasNext()) {
            Component comp = (Component)iterator2.next();
            if (!(comp instanceof BaseSeriesPanel)) continue;
            ((BaseSeriesPanel)comp).revalidateFields();
        }
    }

    private static final void init$lambda$2(SeriesSettingsPanel this$0, ActionEvent it) {
        this$0.settingsChanged();
    }

    private static final void init$lambda$3(SeriesSettingsPanel this$0, ActionEvent it) {
        this$0.settingsChanged();
    }

    private static final Unit init$lambda$5(SeriesSettingsPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.addSeriesPanel(new LineSeriesSettings(null, null, null, false, false, false, 63, null));
        ChartsUsagesCollector.INSTANCE.getSeriesAdded().log();
        return Unit.INSTANCE;
    }

    private static final Unit addSeriesPanel$lambda$11(SeriesSettingsPanel this$0, BaseSeriesPanel $baseSeriesPanel, Component $rigidArea) {
        Intrinsics.checkNotNull((Object)$rigidArea);
        this$0.removeSeriesPanel($baseSeriesPanel, $rigidArea);
        $baseSeriesPanel.dispose();
        return Unit.INSTANCE;
    }

    private static final Unit createCloseButton$lambda$19(SeriesSettingsPanel this$0, AnActionEvent it) {
        Container container = this$0.getParent();
        if (container == null) {
            return Unit.INSTANCE;
        }
        Container parentComponent = container;
        if (parentComponent instanceof OnePixelSplitter && Intrinsics.areEqual((Object)((OnePixelSplitter)parentComponent).getSecondComponent(), (Object)this$0)) {
            ((OnePixelSplitter)parentComponent).setSecondComponent(null);
        } else {
            this$0.getParent().remove(this$0);
            this$0.getParent().revalidate();
        }
        ChartsUsagesCollector.INSTANCE.getSettingsClosed().log();
        return Unit.INSTANCE;
    }

    private static final void createCloseButton$lambda$20(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$settingsChanged(SeriesSettingsPanel $this) {
        $this.settingsChanged();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/charts/settings/SeriesSettingsPanel$Companion;", "", "<init>", "()V", "TOKENS_LIMIT", "", "intellij.charts"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/charts/settings/SeriesSettingsPanel$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "WITH_COLUMNS_LIST", "WITHOUT_COLUMNS_LIST", "intellij.charts"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode WITH_COLUMNS_LIST = new Mode();
        public static final /* enum */ Mode WITHOUT_COLUMNS_LIST = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.WITH_COLUMNS_LIST, Mode.WITHOUT_COLUMNS_LIST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

