/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.BaseStat;
import org.jetbrains.letsPlot.core.plot.base.stat.BinHexStat;
import org.jetbrains.letsPlot.core.plot.base.stat.BinStatUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0002*+B;\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ;\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0014H\u0016Jt\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001d2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010$\u001a\u00020\u0006H\u0002Jt\u0010%\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030'\u0012\u0004\u0012\u00020\u00060&2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001d2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0014H\u0002J\u0012\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030)0\u001dH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/BinHexStat;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BaseStat;", "binCountX", "", "binCountY", "binWidthX", "", "binWidthY", "drop", "", "(IILjava/lang/Double;Ljava/lang/Double;Z)V", "binOptionsX", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$BinOptions;", "binOptionsY", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "statCtx", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "computeBins", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinHexStat$BinsHexData;", "xValues", "", "yValues", "xStart", "yStart", "binWidth", "binHeight", "weightAtIndex", "densityNormalizingFactor", "computeCounts", "", "Lkotlin/Pair;", "consumes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "BinsHexData", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nBinHexStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinHexStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/BinHexStat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,358:1\n1#2:359\n1549#3:360\n1620#3,3:361\n1549#3:364\n1620#3,3:365\n288#3,2:368\n766#3:370\n857#3,2:371\n1549#3:373\n1620#3,3:374\n1045#3:377\n959#3,7:378\n1549#3:385\n1620#3,3:386\n*S KotlinDebug\n*F\n+ 1 BinHexStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/BinHexStat\n*L\n86#1:360\n86#1:361,3\n99#1:364\n99#1:365,3\n283#1:368,2\n216#1:370\n216#1:371,2\n265#1:373\n265#1:374,3\n266#1:377\n269#1:378,7\n270#1:385\n270#1:386,3\n*E\n"})
public final class BinHexStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean drop;
    @NotNull
    private final BinStatUtil.BinOptions binOptionsX;
    @NotNull
    private final BinStatUtil.BinOptions binOptionsY;
    public static final int DEF_BINS = 30;
    @Nullable
    private static final Double DEF_BINWIDTH;
    public static final boolean DEF_DROP = true;
    private static final double EPSILON = 1.0E-4;
    private static final double HEIGHT_TO_BINHEIGHT;
    private static final double BINHEIGHT_TO_HEIGHT;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    /*
     * WARNING - void declaration
     */
    public BinHexStat(int binCountX, int binCountY, @Nullable Double binWidthX, @Nullable Double binWidthY, boolean drop) {
        super(DEF_MAPPING);
        Double d;
        this.drop = drop;
        this.binOptionsX = new BinStatUtil.BinOptions(binCountX, binWidthX);
        BinHexStat binHexStat = this;
        int n = binCountY;
        Double d2 = binWidthY;
        if (d2 != null) {
            void it;
            double d3 = ((Number)d2).doubleValue();
            int n2 = n;
            BinHexStat binHexStat2 = binHexStat;
            boolean bl = false;
            Double d4 = (double)(it * HEIGHT_TO_BINHEIGHT);
            binHexStat = binHexStat2;
            n = n2;
            d = d4;
        } else {
            d = null;
        }
        Double d5 = d;
        int n3 = n;
        binHexStat.binOptionsY = new BinStatUtil.BinOptions(n3, d5);
    }

    public /* synthetic */ BinHexStat(int n, int n2, Double d, Double d2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 30;
        }
        if ((n3 & 2) != 0) {
            n2 = 30;
        }
        if ((n3 & 4) != 0) {
            d = DEF_BINWIDTH;
        }
        if ((n3 & 8) != 0) {
            d2 = DEF_BINWIDTH;
        }
        if ((n3 & 0x10) != 0) {
            bl = true;
        }
        this(n, n2, d, d2, bl);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getWEIGHT()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data2, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        Collection<Double> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()};
        if (!this.hasRequiredValues(data2, aesArray)) {
            return this.withEmptyStatValues();
        }
        DoubleSpan xRange = statCtx.overallXRange();
        DoubleSpan yRange = statCtx.overallYRange();
        if (xRange == null || yRange == null) {
            return this.withEmptyStatValues();
        }
        DoubleSpan xRangeInit = BinHexStat.Companion.adjustRangeInitial(xRange);
        DoubleSpan yRangeInit = BinHexStat.Companion.adjustRangeInitial(yRange);
        Function2 countToWidth2 = apply.countToWidth.1.INSTANCE;
        BinStatUtil.CountAndWidth xCountAndWidthInit = BinStatUtil.INSTANCE.binCountAndWidth(xRangeInit.getLength(), this.binOptionsX, (Function2<? super Double, ? super Integer, Double>)countToWidth2);
        BinStatUtil.CountAndWidth yCountAndWidthInit = BinStatUtil.INSTANCE.binCountAndWidth(yRangeInit.getLength(), this.binOptionsY, (Function2<? super Double, ? super Integer, Double>)countToWidth2);
        Pair pair2 = !this.binOptionsX.hasBinWidth() && xCountAndWidthInit.getCount() == 1 && yCountAndWidthInit.getCount() > 1 ? new Pair((Object)(xCountAndWidthInit.getWidth() * 2.0), (Object)-0.75) : new Pair((Object)xCountAndWidthInit.getWidth(), (Object)0.0);
        double xWidthInit = ((Number)pair2.component1()).doubleValue();
        double xExpandCenter = ((Number)pair2.component2()).doubleValue();
        DoubleSpan xRangeFinal = BinHexStat.Companion.adjustRangeFinal(xRange, xWidthInit, xExpandCenter);
        DoubleSpan yRangeFinal = org.jetbrains.letsPlot.core.plot.base.stat.BinHexStat$Companion.adjustRangeFinal$default(Companion, yRange, yCountAndWidthInit.getWidth(), 0.0, 4, null);
        BinStatUtil.CountAndWidth xCountAndWidthFinal = BinStatUtil.binCountAndWidth$default(BinStatUtil.INSTANCE, xRangeFinal.getLength(), this.binOptionsX, null, 4, null);
        BinStatUtil.CountAndWidth yCountAndWidthFinal = BinStatUtil.binCountAndWidth$default(BinStatUtil.INSTANCE, yRangeFinal.getLength(), this.binOptionsY, null, 4, null);
        int countTotal = xCountAndWidthFinal.getCount() * yCountAndWidthFinal.getCount();
        double densityNormalizingFactor = BinHexStat.Companion.densityNormalizingFactor(xRangeFinal.getLength(), yRangeFinal.getLength(), countTotal);
        double height = yCountAndWidthFinal.getWidth() * BINHEIGHT_TO_HEIGHT;
        double ratio = xCountAndWidthFinal.getWidth() / height;
        Iterable iterable = data2.getNumeric(TransformVar.INSTANCE.getY());
        Object object = data2.getNumeric(TransformVar.INSTANCE.getX());
        Object object2 = this;
        boolean $i$f$map = false;
        void var30_26 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Double d;
            void y2;
            Double d2 = (Double)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v0 = y2;
            if (v0 != null) {
                double it = ((Number)v0).doubleValue();
                boolean bl2 = false;
                d = it * ratio;
            } else {
                d = null;
            }
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        BinsHexData binsData = ((BinHexStat)object2).computeBins((List<Double>)object, (List<Double>)collection, xRangeFinal.getLowerEnd(), yRangeFinal.getLowerEnd() * ratio, xCountAndWidthFinal.getCount(), yCountAndWidthFinal.getCount(), xCountAndWidthFinal.getWidth(), yCountAndWidthFinal.getWidth() * ratio, (Function1<? super Integer, Double>)BinStatUtil.INSTANCE.weightAtIndex(data2), densityNormalizingFactor);
        $this$map$iv = binsData.getY$plot_base();
        object = Stats.INSTANCE.getY();
        object2 = new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), binsData.getX$plot_base());
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            double y2 = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(y2 / ratio);
        }
        collection = (List)destination$iv$iv;
        return ((DataFrame.Builder)object2).putNumeric((DataFrame.Variable)object, (List<Double>)collection).putNumeric(Stats.INSTANCE.getCOUNT(), binsData.getCount$plot_base()).putNumeric(Stats.INSTANCE.getDENSITY(), binsData.getDensity$plot_base()).build();
    }

    private final BinsHexData computeBins(List<Double> xValues, List<Double> yValues, double xStart, double yStart, int binCountX, int binCountY, double binWidth, double binHeight, Function1<? super Integer, Double> weightAtIndex2, double densityNormalizingFactor) {
        if (!(Math.abs(binWidth / binHeight - BINHEIGHT_TO_HEIGHT) < 1.0E-4)) {
            boolean $i$a$-require-BinHexStat$computeBins$22 = false;
            String $i$a$-require-BinHexStat$computeBins$22 = "Hexagons should be regular";
            throw new IllegalArgumentException($i$a$-require-BinHexStat$computeBins$22.toString());
        }
        Map<Pair<Integer, Integer>, Double> countByBinIndexKey = this.computeCounts(xValues, yValues, xStart, yStart, binWidth, binHeight, weightAtIndex2);
        double totalCount = CollectionsKt.sumOfDouble((Iterable)countByBinIndexKey.values());
        ArrayList<Double> xs = new ArrayList<Double>();
        ArrayList<Double> ys = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> densities = new ArrayList<Double>();
        double x0 = xStart + binWidth / 2.0;
        double y0 = yStart + binHeight / 2.0;
        for (int yIndex = 0; yIndex < binCountY; ++yIndex) {
            for (int xIndex = 0; xIndex < binCountX; ++xIndex) {
                double count2;
                Pair binIndexKey = new Pair((Object)xIndex, (Object)yIndex);
                Double d = countByBinIndexKey.get(binIndexKey);
                double d2 = count2 = d != null ? d : 0.0;
                if (this.drop && count2 == 0.0) {
                    Object[] objectArray;
                    if (xIndex == 0 && yIndex == 0) {
                        Collection collection = xs;
                        objectArray = new Double[]{x0, Double.NaN};
                        CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                        collection = ys;
                        objectArray = new Double[]{Double.NaN, y0};
                        CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                        collection = counts;
                        objectArray = new Double[]{Double.NaN, Double.NaN};
                        CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                        collection = densities;
                        objectArray = new Double[]{Double.NaN, Double.NaN};
                        CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                        continue;
                    }
                    if (xIndex == 0 && yIndex == 1) {
                        Collection collection = xs;
                        objectArray = new Double[]{x0 + binWidth / 2.0, Double.NaN};
                        CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                        collection = ys;
                        objectArray = new Double[]{Double.NaN, y0 + binHeight};
                        CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                        collection = counts;
                        objectArray = new Double[]{Double.NaN, Double.NaN};
                        CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                        collection = densities;
                        objectArray = new Double[]{Double.NaN, Double.NaN};
                        CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                        continue;
                    }
                    if (xIndex != 1 || yIndex != 0) continue;
                    Collection collection = xs;
                    objectArray = new Double[]{x0 + binWidth, Double.NaN};
                    CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                    collection = ys;
                    objectArray = new Double[]{Double.NaN, y0};
                    CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                    collection = counts;
                    objectArray = new Double[]{Double.NaN, Double.NaN};
                    CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                    collection = densities;
                    objectArray = new Double[]{Double.NaN, Double.NaN};
                    CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                    continue;
                }
                if (yIndex % 2 == 0) {
                    xs.add(x0 + (double)xIndex * binWidth);
                } else {
                    xs.add(x0 + (double)xIndex * binWidth + binWidth / 2.0);
                }
                ys.add(y0 + (double)yIndex * binHeight);
                counts.add(count2);
                double density2 = count2 / totalCount * densityNormalizingFactor;
                densities.add(density2);
            }
        }
        return new BinsHexData((List<Double>)xs, (List<Double>)ys, (List<Double>)counts, (List<Double>)densities);
    }

    private final Map<Pair<Integer, Integer>, Double> computeCounts(List<Double> xValues, List<Double> yValues, double xStart, double yStart, double binWidth, double binHeight, Function1<? super Integer, Double> weightAtIndex2) {
        HashMap countByBinIndexKey = new HashMap();
        int n = xValues.size();
        for (int dataIndex = 0; dataIndex < n; ++dataIndex) {
            Pair hexIndexKey2;
            Pair pair2;
            Object v3;
            Function1[] $this$firstOrNull$iv;
            Set<Pair<Integer, Integer>> suspectedHexagons;
            DoubleVector p;
            Double y2;
            Double x2;
            block5: {
                x2 = xValues.get(dataIndex);
                if (!SeriesUtil.INSTANCE.allFinite(x2, y2 = yValues.get(dataIndex))) continue;
                Double d = x2;
                Intrinsics.checkNotNull((Object)d);
                double d2 = d;
                Double d3 = y2;
                Intrinsics.checkNotNull((Object)d3);
                p = new DoubleVector(d2, d3);
                suspectedHexagons = BinHexStat.computeCounts$hexWithNeighbours(BinHexStat.computeCounts$getCoarseGridIndex(yStart, binHeight, xStart, binWidth, p));
                $this$firstOrNull$iv = (Function1[])suspectedHexagons;
                boolean $i$f$firstOrNull = false;
                for (Object t : $this$firstOrNull$iv) {
                    Pair it = (Pair)t;
                    boolean bl = false;
                    if (!BinHexStat.computeCounts$isPointInHexagon(binHeight, binWidth, xStart, yStart, p, (Pair<Integer, Integer>)it)) continue;
                    v3 = t;
                    break block5;
                }
                v3 = null;
            }
            if ((pair2 = (Pair)v3) == null) {
                $this$firstOrNull$iv = new Function1[]{computeCounts.hexIndexKey.2.INSTANCE, computeCounts.hexIndexKey.3.INSTANCE};
                pair2 = (Pair)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)BinHexStat.computeCounts$getAllTouchingHexagons(xStart, binWidth, yStart, binHeight, p, suspectedHexagons), (Comparator)ComparisonsKt.compareBy((Function1[])$this$firstOrNull$iv)));
            }
            if (!((hexIndexKey2 = pair2) != null)) {
                boolean bl = false;
                String string = "Unexpected state: no hexagon found for point (" + x2 + ", " + y2 + ')';
                throw new IllegalArgumentException(string.toString());
            }
            if (!countByBinIndexKey.containsKey(hexIndexKey2)) {
                ((Map)countByBinIndexKey).put(hexIndexKey2, 0.0);
            }
            ((Map)countByBinIndexKey).put(hexIndexKey2, ((Number)MapsKt.getValue((Map)countByBinIndexKey, (Object)hexIndexKey2)).doubleValue() + ((Number)weightAtIndex2.invoke((Object)dataIndex)).doubleValue());
        }
        return countByBinIndexKey;
    }

    private static final Pair<Integer, Integer> computeCounts$getCoarseGridIndex(double $yStart, double $binHeight, double $xStart, double $binWidth, DoubleVector p) {
        int j = (int)Math.floor((p.getY() - $yStart) / $binHeight);
        double hexXStart = $xStart + (double)(j % 2) * $binWidth / 2.0;
        int i = (int)Math.floor((p.getX() - hexXStart) / $binWidth);
        return new Pair((Object)i, (Object)j);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<Pair<Integer, Integer>> computeCounts$hexWithNeighbours(Pair<Integer, Integer> hexagonIndex) {
        void $this$filterTo$iv$iv;
        List list2;
        Object[] objectArray;
        if (((Number)hexagonIndex.getSecond()).intValue() % 2 == 0) {
            objectArray = new Pair[]{hexagonIndex, new Pair(hexagonIndex.getFirst(), (Object)(((Number)hexagonIndex.getSecond()).intValue() + 1)), new Pair((Object)(((Number)hexagonIndex.getFirst()).intValue() + 1), hexagonIndex.getSecond()), new Pair(hexagonIndex.getFirst(), (Object)(((Number)hexagonIndex.getSecond()).intValue() - 1)), new Pair((Object)(((Number)hexagonIndex.getFirst()).intValue() - 1), (Object)(((Number)hexagonIndex.getSecond()).intValue() - 1)), new Pair((Object)(((Number)hexagonIndex.getFirst()).intValue() - 1), hexagonIndex.getSecond()), new Pair((Object)(((Number)hexagonIndex.getFirst()).intValue() - 1), (Object)(((Number)hexagonIndex.getSecond()).intValue() + 1))};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            objectArray = new Pair[]{hexagonIndex, new Pair((Object)(((Number)hexagonIndex.getFirst()).intValue() + 1), (Object)(((Number)hexagonIndex.getSecond()).intValue() + 1)), new Pair((Object)(((Number)hexagonIndex.getFirst()).intValue() + 1), hexagonIndex.getSecond()), new Pair((Object)(((Number)hexagonIndex.getFirst()).intValue() + 1), (Object)(((Number)hexagonIndex.getSecond()).intValue() - 1)), new Pair(hexagonIndex.getFirst(), (Object)(((Number)hexagonIndex.getSecond()).intValue() - 1)), new Pair((Object)(((Number)hexagonIndex.getFirst()).intValue() - 1), hexagonIndex.getSecond()), new Pair(hexagonIndex.getFirst(), (Object)(((Number)hexagonIndex.getSecond()).intValue() + 1))};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        List hexIds = list2;
        Iterable $this$filter$iv = hexIds;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair p = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)p.getFirst()).intValue() >= 0 && ((Number)p.getSecond()).intValue() >= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final DoubleVector computeCounts$getHexagonCenter(double $xStart, double $binWidth, double $yStart, double $binHeight, Pair<Integer, Integer> hexagonIndex) {
        return new DoubleVector($xStart + $binWidth / 2.0 + (((Number)hexagonIndex.getSecond()).intValue() % 2 == 0 ? ((Number)hexagonIndex.getFirst()).doubleValue() * $binWidth : ((Number)hexagonIndex.getFirst()).doubleValue() * $binWidth + $binWidth / 2.0), $yStart + $binHeight / 2.0 + ((Number)hexagonIndex.getSecond()).doubleValue() * $binHeight);
    }

    private static final boolean computeCounts$isPointInHexagon(double $binHeight, double $binWidth, double $xStart, double $yStart, DoubleVector p, Pair<Integer, Integer> hexagonIndex) {
        double halfHexHeight = 2.0 * $binHeight / 3.0;
        DoubleVector q = p.subtract(BinHexStat.computeCounts$getHexagonCenter($xStart, $binWidth, $yStart, $binHeight, hexagonIndex));
        DoubleVector v1 = new DoubleVector(0.0, halfHexHeight);
        DoubleVector v2 = new DoubleVector($binWidth / 2.0, halfHexHeight / 2.0);
        DoubleVector v3 = new DoubleVector($binWidth / 2.0, -halfHexHeight / 2.0);
        DoubleVector v4 = new DoubleVector(0.0, -halfHexHeight);
        DoubleVector v5 = new DoubleVector(-$binWidth / 2.0, -halfHexHeight / 2.0);
        DoubleVector v6 = new DoubleVector(-$binWidth / 2.0, halfHexHeight / 2.0);
        Object[] objectArray = new DoubleVector[]{v1, v2, v3, v4, v5, v6, v1};
        return MathKt.polygonContainsCoordinate(CollectionsKt.listOf((Object[])objectArray), q);
    }

    private static final double computeCounts$distanceToHexagonCenter(double $xStart, double $binWidth, double $yStart, double $binHeight, DoubleVector p, Pair<Integer, Integer> hexagonIndex) {
        DoubleVector center = BinHexStat.computeCounts$getHexagonCenter($xStart, $binWidth, $yStart, $binHeight, hexagonIndex);
        return Math.sqrt(Math.pow(p.getX() - center.getX(), 2) + Math.pow(p.getY() - center.getY(), 2));
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<Pair<Integer, Integer>> computeCounts$getAllTouchingHexagons(double $xStart, double $binWidth, double $yStart, double $binHeight, DoubleVector p, Set<Pair<Integer, Integer>> allHexagons) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$takeWhile$iv;
        void $this$sortedBy$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        Iterable iterable = allHexagons;
        boolean $i$f$map = false;
        void var13_9 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void hexagonIndex;
            Pair pair2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)hexagonIndex, (Object)BinHexStat.computeCounts$distanceToHexagonCenter($xStart, $binWidth, $yStart, $binHeight, p, (Pair<Integer, Integer>)hexagonIndex)));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List sortedHexagonsWithDistances = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                Pair it = (Pair)a2;
                boolean bl = false;
                Comparable comparable = (Double)it.getSecond();
                it = (Pair)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getSecond()));
            }
        });
        double minimalDistance = ((Number)((Pair)CollectionsKt.first((List)sortedHexagonsWithDistances)).getSecond()).doubleValue();
        $this$mapTo$iv$iv2 = sortedHexagonsWithDistances;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            Pair it = (Pair)item$iv;
            boolean bl = false;
            if (!(Math.abs(((Number)it.getSecond()).doubleValue() / minimalDistance - 1.0) < 1.0E-4)) break;
            list$iv.add(item$iv);
        }
        $this$takeWhile$iv = list$iv;
        boolean $i$f$map2 = false;
        list$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair3 = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add((Pair)it.getFirst());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
    }

    public BinHexStat() {
        this(0, 0, null, null, false, 31, null);
    }

    static {
        HEIGHT_TO_BINHEIGHT = 3.0 / (2.0 * Math.sqrt(3.0));
        BINHEIGHT_TO_HEIGHT = 2.0 * Math.sqrt(3.0) / 3.0;
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY()), TuplesKt.to(Aes.Companion.getFILL(), (Object)Stats.INSTANCE.getCOUNT())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\n\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/BinHexStat$BinsHexData;", "", "x", "", "", "y", "count", "density", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getCount$plot_base", "()Ljava/util/List;", "getDensity$plot_base", "getX$plot_base", "getY$plot_base", "plot-base"})
    public static final class BinsHexData {
        @NotNull
        private final List<Double> x;
        @NotNull
        private final List<Double> y;
        @NotNull
        private final List<Double> count;
        @NotNull
        private final List<Double> density;

        public BinsHexData(@NotNull List<Double> x2, @NotNull List<Double> y2, @NotNull List<Double> count2, @NotNull List<Double> density2) {
            Intrinsics.checkNotNullParameter(x2, (String)"x");
            Intrinsics.checkNotNullParameter(y2, (String)"y");
            Intrinsics.checkNotNullParameter(count2, (String)"count");
            Intrinsics.checkNotNullParameter(density2, (String)"density");
            this.x = x2;
            this.y = y2;
            this.count = count2;
            this.density = density2;
        }

        @NotNull
        public final List<Double> getX$plot_base() {
            return this.x;
        }

        @NotNull
        public final List<Double> getY$plot_base() {
            return this.y;
        }

        @NotNull
        public final List<Double> getCount$plot_base() {
            return this.count;
        }

        @NotNull
        public final List<Double> getDensity$plot_base() {
            return this.density;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010\u0017\u001a\u00020\u0004H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J \u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/BinHexStat$Companion;", "", "()V", "BINHEIGHT_TO_HEIGHT", "", "DEF_BINS", "", "DEF_BINWIDTH", "getDEF_BINWIDTH", "()Ljava/lang/Double;", "Ljava/lang/Double;", "DEF_DROP", "", "DEF_MAPPING", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "EPSILON", "HEIGHT_TO_BINHEIGHT", "adjustRangeFinal", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "r", "binWidth", "expandCenter", "adjustRangeInitial", "densityNormalizingFactor", "xSpan", "ySpan", "count", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Double getDEF_BINWIDTH() {
            return DEF_BINWIDTH;
        }

        private final DoubleSpan adjustRangeInitial(DoubleSpan r) {
            return SeriesUtil.ensureApplicableRange$default(SeriesUtil.INSTANCE, r, null, 2, null);
        }

        private final DoubleSpan adjustRangeFinal(DoubleSpan r, double binWidth, double expandCenter) {
            DoubleSpan it = r.expanded(binWidth / 2.0);
            boolean bl = false;
            it = new DoubleSpan(it.getLowerEnd() + expandCenter * binWidth / 2.0, it.getUpperEnd() + expandCenter * binWidth / 2.0);
            boolean bl2 = false;
            return SeriesUtil.INSTANCE.isBeyondPrecision(it) ? it.expanded(0.5) : it;
        }

        static /* synthetic */ DoubleSpan adjustRangeFinal$default(Companion companion, DoubleSpan doubleSpan, double d, double d2, int n, Object object) {
            if ((n & 4) != 0) {
                d2 = 0.0;
            }
            return companion.adjustRangeFinal(doubleSpan, d, d2);
        }

        private final double densityNormalizingFactor(double xSpan, double ySpan, int count2) {
            double area2 = xSpan * ySpan;
            double binArea = area2 / (double)count2;
            return 1.0 / binArea;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

