/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.jinja.Jinja2CodeInsightSettings;
import com.intellij.jinja.template.DjangoTemplateFileViewProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class DjangoBracesInterpolationTypedHandler
extends TypedHandlerDelegate {
    private static final char[] ourInterestingChars = new char[]{'{', '%', '#'};

    private static boolean isInteresting(char c) {
        return Arrays.binarySearch(ourInterestingChars, c) >= 0;
    }

    static void typeInStringAndMoveCaret(Editor editor, String str, int caretShift) {
        EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)str, (boolean)true, (int)caretShift);
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(3);
        }
        if (file.getViewProvider() instanceof DjangoTemplateFileViewProvider && Jinja2CodeInsightSettings.Companion.getInstance().getJINJA2_AUTOINSERT_TAG_CLOSE() && DjangoBracesInterpolationTypedHandler.isInteresting(c)) {
            Document document = editor.getDocument();
            int offset = editor.getCaretModel().getOffset();
            CharSequence chars = document.getCharsSequence();
            if (offset > 0 && chars.charAt(offset - 1) == '{') {
                if (DjangoBracesInterpolationTypedHandler.interpolateCommentBetweenBraces(editor, chars, c, offset)) {
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(4);
                    }
                    return result;
                }
                if (offset < 2 || chars.charAt(offset - 2) != '{') {
                    if (DjangoBracesInterpolationTypedHandler.alreadyHasEnding(chars, c, offset)) {
                        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                        if (result == null) {
                            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(5);
                        }
                        return result;
                    }
                    Object interpolation = null;
                    if (c == '{') {
                        interpolation = "{  }";
                    } else if (c == '%') {
                        interpolation = "%  %";
                    } else if (c == '#') {
                        interpolation = "#  #";
                    }
                    if (interpolation != null) {
                        if (offset == chars.length() || offset < chars.length() && chars.charAt(offset) != '}') {
                            interpolation = (String)interpolation + "}";
                        }
                        DjangoBracesInterpolationTypedHandler.typeInStringAndMoveCaret(editor, (String)interpolation, 2);
                        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                        if (result == null) {
                            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(6);
                        }
                        return result;
                    }
                }
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(7);
        }
        return result;
    }

    private static boolean alreadyHasEnding(CharSequence chars, char c, int offset) {
        int i;
        char endChar = c == '{' ? (char)'}' : (char)c;
        for (i = offset; i < chars.length() && chars.charAt(i) != '{' && chars.charAt(i) != endChar && chars.charAt(i) != '\n'; ++i) {
        }
        return i + 1 < chars.length() && chars.charAt(i) == endChar && chars.charAt(i + 1) == '}';
    }

    private static boolean interpolateCommentBetweenBraces(Editor editor, CharSequence chars, char c, int offset) {
        if (chars.length() <= offset) {
            return false;
        }
        char cc = chars.charAt(offset);
        if (c != '#' || cc != '%') {
            return false;
        }
        for (int i = offset; i < chars.length() && chars.charAt(i) != '\n'; ++i) {
            if (chars.charAt(i) != '}' || i - 1 <= offset || chars.charAt(i - 1) != chars.charAt(offset)) continue;
            DjangoBracesInterpolationTypedHandler.typeInStringAndMoveCaret(editor, "#", i + 1 - offset);
            DjangoBracesInterpolationTypedHandler.typeInStringAndMoveCaret(editor, "#", offset - i - 1);
            return true;
        }
        return false;
    }

    static {
        Arrays.sort(ourInterestingChars);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jinja/template/editor/DjangoBracesInterpolationTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jinja/template/editor/DjangoBracesInterpolationTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

