/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.google.common.collect.Maps;
import com.intellij.python.profiler.CallTreeNode;
import com.intellij.python.profiler.CallTreeStat;
import com.intellij.python.profiler.FuncStat;
import com.intellij.python.profiler.Function;
import com.intellij.python.profiler.ProfileDataKt;
import com.intellij.python.profiler.Sample;
import com.intellij.python.profiler.Stats;
import com.intellij.python.profiler.UtilsKt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\rH\u0016J\b\u0010 \u001a\u00020\u0005H\u0016J\b\u0010!\u001a\u00020\u0005H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010#H\u0016J\b\u0010$\u001a\u00020\rH\u0016J\b\u0010%\u001a\u00020\u001eH\u0016J\b\u0010&\u001a\u00020\rH\u0016J\b\u0010'\u001a\u00020\rH\u0016J\b\u0010(\u001a\u00020\rH\u0016J\b\u0010)\u001a\u00020\rH\u0016J\b\u0010*\u001a\u00020\rH\u0016J\b\u0010+\u001a\u00020\u001eH\u0016J\b\u0010,\u001a\u00020\u001eH\u0016J\u0014\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0.H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0012j\b\u0012\u0004\u0012\u00020\u0001`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0015j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/python/profiler/CallTreeNodeData;", "Lcom/intellij/python/profiler/CallTreeNode;", "treeStats", "Lcom/intellij/python/profiler/CallTreeStat;", "percent", "", "percentOfParent", "samplingInterval", "stats", "Lcom/intellij/python/profiler/Stats;", "<init>", "(Lcom/intellij/python/profiler/CallTreeStat;DDDLcom/intellij/python/profiler/Stats;)V", "hits", "", "parsedSample", "Lcom/intellij/python/profiler/Sample;", "ownTime", "children", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "lineHits", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "addChild", "", "node", "getFuncStat", "Lcom/intellij/python/profiler/FuncStat;", "isVisible", "getName", "", "getHits", "getPercent", "getPercentOfParent", "getChildren", "", "getTime", "getFile", "getLine", "getCallCount", "getTotalTimeMs", "getOwnTimeMs", "getBaseTotalTime", "getThreadName", "getThreadId", "getLineHits", "", "intellij.python.profiler"})
@SourceDebugExtension(value={"SMAP\nProfileData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileData.kt\ncom/intellij/python/profiler/CallTreeNodeData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,387:1\n1#2:388\n1068#3:389\n*S KotlinDebug\n*F\n+ 1 ProfileData.kt\ncom/intellij/python/profiler/CallTreeNodeData\n*L\n98#1:389\n*E\n"})
public final class CallTreeNodeData
implements CallTreeNode {
    private final double percent;
    private final double percentOfParent;
    @Nullable
    private final Stats stats;
    private final int hits;
    @NotNull
    private final Sample parsedSample;
    private final int ownTime;
    @NotNull
    private final ArrayList<CallTreeNode> children;
    @NotNull
    private final HashMap<Integer, Integer> lineHits;

    public CallTreeNodeData(@NotNull CallTreeStat treeStats, double percent, double percentOfParent, double samplingInterval, @Nullable Stats stats) {
        Intrinsics.checkNotNullParameter((Object)treeStats, (String)"treeStats");
        this.percent = percent;
        this.percentOfParent = percentOfParent;
        this.stats = stats;
        this.hits = treeStats.count;
        String string = treeStats.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        this.parsedSample = UtilsKt.parseVmProfSampleName(string);
        this.ownTime = ProfileDataKt.hitsToOwnTimeMs(samplingInterval, treeStats.count);
        this.children = new ArrayList();
        HashMap hashMap = Maps.newHashMap(treeStats.line_count);
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
        this.lineHits = hashMap;
    }

    public final boolean addChild(@NotNull CallTreeNodeData node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.children.add(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FuncStat getFuncStat() {
        Object v3;
        Object object;
        block1: {
            Stats stats = this.stats;
            object = stats;
            if (stats == null) return null;
            List<Function> list = ((Stats)object).func_stats;
            object = list;
            if (list == null) return null;
            Iterable iterable = (Iterable)object;
            for (Object t : iterable) {
                Function it = (Function)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.func_stat.func_name, (Object)this.getName())) continue;
                v3 = t;
                break block1;
            }
            v3 = null;
        }
        Function function = v3;
        object = function;
        if (function == null) return null;
        FuncStat funcStat = ((Function)object).func_stat;
        return funcStat;
    }

    @Override
    public boolean isVisible() {
        return this.parsedSample.isVisible();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.parsedSample.getName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public int getHits() {
        return this.hits;
    }

    @Override
    public double getPercent() {
        return this.percent;
    }

    @Override
    public double getPercentOfParent() {
        return this.percentOfParent;
    }

    @Override
    @NotNull
    public List<CallTreeNode> getChildren() {
        Iterable $this$sortedByDescending$iv = this.children;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                CallTreeNode node = (CallTreeNode)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(node.getTime());
                node = (CallTreeNode)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(node.getTime()));
            }
        });
    }

    @Override
    public int getTime() {
        return this.ownTime;
    }

    @Override
    @NotNull
    public String getFile() {
        String string = this.parsedSample.getFile();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public int getLine() {
        Integer n = this.parsedSample.getLine();
        return n != null ? n : -1;
    }

    @Override
    public int getCallCount() {
        return this.hits;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getTotalTimeMs() {
        int n;
        Iterable iterable = this.children;
        int n2 = this.ownTime;
        int n3 = 0;
        for (Object t : iterable) {
            void child;
            CallTreeNode callTreeNode = (CallTreeNode)t;
            n = n3;
            boolean bl = false;
            int n4 = child.getTime();
            n3 = n + n4;
        }
        n = n3;
        return n2 + n;
    }

    @Override
    public int getOwnTimeMs() {
        return this.ownTime;
    }

    @Override
    public int getBaseTotalTime() {
        return this.getTotalTimeMs();
    }

    @Override
    @NotNull
    public String getThreadName() {
        Object object = this.getFuncStat();
        if (object == null || (object = ((FuncStat)object).threadName) == null) {
            object = "MainThread";
        }
        return object;
    }

    @Override
    @NotNull
    public String getThreadId() {
        Object object = this.getFuncStat();
        if (object == null || (object = ((FuncStat)object).threadId) == null) {
            object = "0";
        }
        return object;
    }

    @Override
    @NotNull
    public Map<Integer, Integer> getLineHits() {
        return this.lineHits;
    }
}

