/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter.add.wizard;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.python.remoteInterpreter.add.wizard.AbstractConnectingState;
import com.intellij.python.remoteInterpreter.add.wizard.CreateSshInterpreterWizardState;
import com.intellij.python.remoteInterpreter.add.wizard.FinishExistingSshConfigState;
import com.intellij.python.remoteInterpreter.add.wizard.InternalStateListener;
import com.intellij.python.remoteInterpreter.add.wizard.SshConnectionFailureState;
import com.intellij.python.remoteInterpreter.add.wizard.ui.ConnectingToSshServerForm;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.config.unified.SshConfig;
import com.jetbrains.plugins.remotesdk.RemoteCredentialsProducer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/intellij/python/remoteInterpreter/add/wizard/ConnectingToSshConfigState;", "Lcom/intellij/python/remoteInterpreter/add/wizard/AbstractConnectingState;", "sshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "listener", "Lcom/intellij/python/remoteInterpreter/add/wizard/InternalStateListener;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "previousState", "Lcom/intellij/python/remoteInterpreter/add/wizard/CreateSshInterpreterWizardState;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "<init>", "(Lcom/intellij/ssh/config/unified/SshConfig;Lcom/intellij/python/remoteInterpreter/add/wizard/InternalStateListener;Lcom/intellij/openapi/application/ModalityState;Lcom/intellij/python/remoteInterpreter/add/wizard/CreateSshInterpreterWizardState;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;)V", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "username", "", "getUsername", "()Ljava/lang/String;", "host", "getHost", "port", "", "getPort", "()I", "form", "Lcom/intellij/python/remoteInterpreter/add/wizard/ui/ConnectingToSshServerForm;", "getForm", "()Lcom/intellij/python/remoteInterpreter/add/wizard/ui/ConnectingToSshServerForm;", "connectionThread", "Ljava/lang/Thread;", "getConnectionThread", "()Ljava/lang/Thread;", "intellij.python.remoteInterpreter"})
public final class ConnectingToSshConfigState
extends AbstractConnectingState {
    @NotNull
    private final SshConfig sshConfig;
    @Nullable
    private final Project project;
    @Nullable
    private final Module module;
    @NotNull
    private final List<Sdk> existingSdks;
    @NotNull
    private final RemoteCredentials credentials;
    @NotNull
    private final ConnectingToSshServerForm form;
    @NotNull
    private final Thread connectionThread;

    public ConnectingToSshConfigState(@NotNull SshConfig sshConfig, @NotNull InternalStateListener listener, @NotNull ModalityState modalityState, @NotNull CreateSshInterpreterWizardState previousState, @Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkNotNullParameter((Object)sshConfig, (String)"sshConfig");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        Intrinsics.checkNotNullParameter((Object)previousState, (String)"previousState");
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        super(listener, previousState);
        this.sshConfig = sshConfig;
        this.project = project;
        this.module = module;
        this.existingSdks = existingSdks;
        RemoteCredentials remoteCredentials = RemoteCredentialsProducer.getCredentialsBySshConfigName(null, (String)this.sshConfig.getName());
        if (remoteCredentials == null) {
            throw new IllegalArgumentException();
        }
        this.credentials = remoteCredentials;
        String string = this.credentials.getUserName();
        if (string == null) {
            string = "";
        }
        this.form = new ConnectingToSshServerForm(string, this.credentials.getHost(), this.credentials.getPort());
        this.connectionThread = new Thread(() -> ConnectingToSshConfigState._init_$lambda$2(this, modalityState, listener, previousState), "ConnectingToDeploymentServerState connection thread");
        this.getConnectionThread().start();
    }

    private final String getUsername() {
        String string = this.credentials.getUserName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final String getHost() {
        String string = this.credentials.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        return string;
    }

    private final int getPort() {
        return this.credentials.getPort();
    }

    @Override
    @NotNull
    protected ConnectingToSshServerForm getForm() {
        return this.form;
    }

    @Override
    @NotNull
    protected Thread getConnectionThread() {
        return this.connectionThread;
    }

    private static final void lambda$2$lambda$0(ConnectingToSshConfigState this$0, InternalStateListener $listener, SshSession $sshSession, CreateSshInterpreterWizardState $previousState) {
        if (!this$0.getPreviousHit()) {
            $listener.onStateChanged(new FinishExistingSshConfigState(this$0.getUsername(), this$0.getHost(), this$0.getPort(), $listener, $sshSession, this$0.project, this$0.module, this$0.existingSdks, this$0.sshConfig, $previousState));
        }
    }

    private static final void lambda$2$lambda$1(ConnectingToSshConfigState this$0, InternalStateListener $listener, CreateSshInterpreterWizardState $previousState, Exception $e) {
        if (!this$0.getPreviousHit()) {
            String string = this$0.getUsername();
            String string2 = this$0.getHost();
            int n = this$0.getPort();
            Throwable throwable = $e.getCause();
            if (throwable == null) {
                throwable = $e;
            }
            String string3 = throwable.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLocalizedMessage(...)");
            $listener.onStateChanged(new SshConnectionFailureState(string, string2, n, $listener, $previousState, string3));
        }
    }

    private static final void _init_$lambda$2(ConnectingToSshConfigState this$0, ModalityState $modalityState, InternalStateListener $listener, CreateSshInterpreterWizardState $previousState) {
        try {
            ConnectionBuilder builder = RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)this$0.credentials, null, null, (boolean)false, null, (int)15, null);
            SshSession sshSession = builder.connect();
            ApplicationManager.getApplication().invokeLater(() -> ConnectingToSshConfigState.lambda$2$lambda$0(this$0, $listener, sshSession, $previousState), $modalityState);
        }
        catch (Exception e) {
            ApplicationManager.getApplication().invokeLater(() -> ConnectingToSshConfigState.lambda$2$lambda$1(this$0, $listener, $previousState, e), $modalityState);
        }
    }
}

