/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.powerfuldataviewer;

import com.intellij.icons.AllIcons;
import com.intellij.python.scientific.powerfuldataviewer.DataViewTableImpl;
import com.intellij.python.scientific.powerfuldataviewer.HeaderCellComponent;
import com.intellij.python.scientific.powerfuldataviewer.HeaderCellRendererBase;
import com.intellij.python.scientific.powerfuldataviewer.HeaderClickable;
import com.intellij.ui.SideBorder;
import com.intellij.util.Producer;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeaderCellRenderer
extends HeaderCellRendererBase
implements HeaderClickable {
    @NotNull
    private final HeaderCellComponent myPanel;
    @Nullable
    private final Producer<Integer> myHeaderCellHoverProducer;
    private final boolean myCorner;

    public HeaderCellRenderer(@NotNull DataViewTableImpl parentTable, boolean corner, @Nullable Producer<Integer> headerCellHoverProducer) {
        if (parentTable == null) {
            HeaderCellRenderer.$$$reportNull$$$0(0);
        }
        super(parentTable, false);
        this.myCorner = corner;
        this.myHeaderCellHoverProducer = headerCellHoverProducer;
        this.myPanel = new HeaderCellComponent(parentTable, this);
        this.myPanel.setBorder(new CompoundBorder((Border)new SideBorder(parentTable.getGridColor(), 14), this.myPanel.getBorder()));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.myCorner) {
            column = -1;
            row = -1;
        }
        super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
        this.myPanel.init(this.myHeaderCellHoverProducer != null && column == (Integer)this.myHeaderCellHoverProducer.produce(), this.myParentTable.getColumnFilter(column));
        if (this.myCorner) {
            return this.myPanel;
        }
        if (this.myParentTable.getSortKey().getColumn() == column) {
            SortOrder order = this.myParentTable.getSortKey().getSortOrder();
            if (order == SortOrder.ASCENDING) {
                this.setIcon(AllIcons.General.ArrowUp);
            } else if (order == SortOrder.DESCENDING) {
                this.setIcon(AllIcons.General.ArrowDown);
            } else {
                this.setIcon(AllIcons.General.ArrowSplitCenterV);
            }
        } else {
            this.setIcon(AllIcons.General.ArrowSplitCenterV);
        }
        return this.myPanel;
    }

    @Override
    public void click(MouseEvent event, int column) {
        this.myParentTable.toggleSortOrder(column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentTable", "com/intellij/python/scientific/powerfuldataviewer/HeaderCellRenderer", "<init>"));
    }
}

