/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.viewManagemenet;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.viewManagemenet.TemplateReferenceCollector;
import com.jetbrains.django.model.viewManagemenet.TemplateReferenceType;
import com.jetbrains.django.model.viewManagemenet.ViewManager;
import com.jetbrains.django.model.viewManagemenet.defaultViews.DefaultViewManager;
import com.jetbrains.django.model.viewManagemenet.genericObjectViews.GenericObjectViewManager;
import com.jetbrains.django.model.viewManagemenet.genericTemplateViews.GenericTemplateViewManager;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ViewManagementFacade {
    @Nullable
    private final PyFile myUrlConfFile;
    private static final ViewManager[] VIEW_MANAGERS = new ViewManager[]{new GenericObjectViewManager(), new DefaultViewManager(), new GenericTemplateViewManager()};

    public ViewManagementFacade(@NotNull Module module) {
        if (module == null) {
            ViewManagementFacade.$$$reportNull$$$0(0);
        }
        this((DjangoModelApi)DjangoModelApi.create(module).getSuccessOrNull());
    }

    public ViewManagementFacade(@NotNull PyElement hook) {
        if (hook == null) {
            ViewManagementFacade.$$$reportNull$$$0(1);
        }
        this((DjangoModelApi)DjangoModelApi.create(hook).getSuccessOrNull());
    }

    private ViewManagementFacade(@Nullable DjangoModelApi api) {
        this.myUrlConfFile = api != null ? api.getURLConfFile() : null;
    }

    @NotNull
    public MultiMap<String, NavigatablePsiElement> getTemplateReferences(@NotNull PyElement elementWithTemplateRefs, @Nullable String possibleTemplateName, @Nullable Class<?> stopAtFirstClass, @NotNull TypeEvalContext context) {
        if (elementWithTemplateRefs == null) {
            ViewManagementFacade.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ViewManagementFacade.$$$reportNull$$$0(3);
        }
        MultiMap result = new MultiMap();
        for (ViewManager manager : VIEW_MANAGERS) {
            TemplateReferenceCollector collector = manager.createCollector(context);
            if (elementWithTemplateRefs instanceof PyFile) {
                PyFile file = (PyFile)elementWithTemplateRefs;
                boolean fileIsUrlConf = file.equals(this.myUrlConfFile) || file.getName().endsWith("urls.py");
                Set<TemplateReferenceType> supportedReferenceTypes = manager.getSupportedReferenceTypes();
                if (!fileIsUrlConf && supportedReferenceTypes.equals(EnumSet.of(TemplateReferenceType.FROM_URL_FILE)) || possibleTemplateName != null && collector.noReferenceFromFileToTemplate(file, possibleTemplateName)) continue;
            }
            elementWithTemplateRefs.accept((PsiElementVisitor)collector);
            result.putAllValues(collector.myReferences);
            if (stopAtFirstClass == null) continue;
            for (NavigatablePsiElement element : collector.myReferences.values()) {
                if (!stopAtFirstClass.isInstance(element)) continue;
                MultiMap multiMap = result;
                if (multiMap == null) {
                    ViewManagementFacade.$$$reportNull$$$0(4);
                }
                return multiMap;
            }
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            ViewManagementFacade.$$$reportNull$$$0(5);
        }
        return multiMap;
    }

    @NotNull
    public static Set<LookupElement> getTemplateVariables(@NotNull NavigatablePsiElement templateReference) {
        if (templateReference == null) {
            ViewManagementFacade.$$$reportNull$$$0(6);
        }
        HashSet<LookupElement> result = new HashSet<LookupElement>();
        for (ViewManager manager : VIEW_MANAGERS) {
            result.addAll(manager.getTemplateVariables(templateReference));
        }
        HashSet<LookupElement> hashSet = result;
        if (hashSet == null) {
            ViewManagementFacade.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hook";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementWithTemplateRefs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/viewManagemenet/ViewManagementFacade";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/viewManagemenet/ViewManagementFacade";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateReferences";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateReferences";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateVariables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

