/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.CustomFormattingModelBuilder;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.formatter.PyBlock;
import com.jetbrains.python.formatter.PyBlockContext;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class PythonFormattingModelBuilder
implements FormattingModelBuilder,
CustomFormattingModelBuilder {
    private static final boolean DUMP_FORMATTING_AST = false;
    static final TokenSet STATEMENT_OR_DECLARATION = (TokenSet)Cancellation.forceNonCancellableSectionInClassInitializer(() -> PythonDialectsTokenSetProvider.getInstance().getStatementTokens());
    private static final TokenSet STAR_PATTERNS = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.SINGLE_STAR_PATTERN, PyElementTypes.DOUBLE_STAR_PATTERN});
    private static final TokenSet EXPRESSIONS_WITH_COLON = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.KEY_VALUE_EXPRESSION, PyElementTypes.KEY_VALUE_PATTERN, PyElementTypes.LAMBDA_EXPRESSION});
    private static final TokenSet SINGLE_SPACE_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.IN_KEYWORD, PyTokenTypes.AND_KEYWORD, PyTokenTypes.OR_KEYWORD, PyTokenTypes.IS_KEYWORD, PyTokenTypes.IF_KEYWORD, PyTokenTypes.ELIF_KEYWORD, PyTokenTypes.ELSE_KEYWORD, PyTokenTypes.FOR_KEYWORD, PyTokenTypes.RETURN_KEYWORD, PyTokenTypes.RAISE_KEYWORD, PyTokenTypes.ASSERT_KEYWORD, PyTokenTypes.CLASS_KEYWORD, PyTokenTypes.DEF_KEYWORD, PyTokenTypes.DEL_KEYWORD, PyTokenTypes.EXEC_KEYWORD, PyTokenTypes.GLOBAL_KEYWORD, PyTokenTypes.NONLOCAL_KEYWORD, PyTokenTypes.IMPORT_KEYWORD, PyTokenTypes.LAMBDA_KEYWORD, PyTokenTypes.NOT_KEYWORD, PyTokenTypes.WHILE_KEYWORD, PyTokenTypes.YIELD_KEYWORD, PyTokenTypes.AS_KEYWORD, PyTokenTypes.MATCH_KEYWORD, PyTokenTypes.CASE_KEYWORD, PyTokenTypes.TYPE_KEYWORD});

    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        if (formattingContext == null) {
            PythonFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        PsiElement element = formattingContext.getPsiElement();
        CodeStyleSettings settings = formattingContext.getCodeStyleSettings();
        PyBlockContext context = new PyBlockContext(settings, this.createSpacingBuilder(settings), formattingContext.getFormattingMode());
        PyBlock block = new PyBlock(null, element.getNode(), null, Indent.getNoneIndent(), null, context);
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)element.getContainingFile(), (Block)block, (CodeStyleSettings)settings);
        if (formattingModel == null) {
            PythonFormattingModelBuilder.$$$reportNull$$$0(1);
        }
        return formattingModel;
    }

    protected SpacingBuilder createSpacingBuilder(CodeStyleSettings settings) {
        PyCodeStyleSettings pySettings = (PyCodeStyleSettings)settings.getCustomSettings(PyCodeStyleSettings.class);
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)PythonLanguage.getInstance());
        return new SpacingBuilder(commonSettings).before((IElementType)PyTokenTypes.END_OF_LINE_COMMENT).spacing(2, 0, 0, commonSettings.KEEP_LINE_BREAKS, commonSettings.KEEP_BLANK_LINES_IN_CODE).after((IElementType)PyTokenTypes.END_OF_LINE_COMMENT).spacing(0, 0, 1, commonSettings.KEEP_LINE_BREAKS, commonSettings.KEEP_BLANK_LINES_IN_CODE).around(PyElementTypes.CLASS_DECLARATION).blankLines(commonSettings.BLANK_LINES_AROUND_CLASS).around(PyElementTypes.FUNCTION_DECLARATION).blankLines(commonSettings.BLANK_LINES_AROUND_METHOD).between(PyElementTypes.IMPORT_STATEMENTS, PyElementTypes.IMPORT_STATEMENTS).spacing(0, Integer.MAX_VALUE, 1, false, 1).between(STATEMENT_OR_DECLARATION, STATEMENT_OR_DECLARATION).spacing(0, Integer.MAX_VALUE, 1, false, 1).between((IElementType)PyTokenTypes.COLON, PyElementTypes.STATEMENT_LIST).spacing(1, Integer.MAX_VALUE, 0, true, 0).afterInside((IElementType)PyTokenTypes.COLON, EXPRESSIONS_WITH_COLON).spaceIf(pySettings.SPACE_AFTER_PY_COLON).afterInside((IElementType)PyTokenTypes.GT, PyElementTypes.ANNOTATION).spaces(1).betweenInside((IElementType)PyTokenTypes.MINUS, (IElementType)PyTokenTypes.GT, PyElementTypes.ANNOTATION).none().beforeInside(PyElementTypes.ANNOTATION, PyElementTypes.FUNCTION_DECLARATION).spaces(1).beforeInside(PyElementTypes.ANNOTATION, PyElementTypes.NAMED_PARAMETER).none().beforeInside(PyElementTypes.ANNOTATION, (IElementType)PyElementTypes.TYPE_DECLARATION_STATEMENT).none().beforeInside(PyElementTypes.ANNOTATION, (IElementType)PyElementTypes.ASSIGNMENT_STATEMENT).none().afterInside((IElementType)PyTokenTypes.COLON, PyElementTypes.ANNOTATION).spaces(1).afterInside((IElementType)PyTokenTypes.RARROW, PyElementTypes.ANNOTATION).spaces(1).between(PythonFormattingModelBuilder.allButLambda(), PyElementTypes.PARAMETER_LIST).spaceIf(commonSettings.SPACE_BEFORE_METHOD_PARENTHESES).betweenInside((IElementType)PyTokenTypes.COMMA, (IElementType)PyTokenTypes.RBRACE, (IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION).spaceIf(pySettings.SPACE_WITHIN_BRACES || commonSettings.SPACE_AFTER_COMMA, pySettings.DICT_NEW_LINE_BEFORE_RIGHT_BRACE).afterInside((IElementType)PyTokenTypes.LBRACE, (IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION).spaceIf(pySettings.SPACE_WITHIN_BRACES, pySettings.DICT_NEW_LINE_AFTER_LEFT_BRACE).beforeInside((IElementType)PyTokenTypes.RBRACE, (IElementType)PyElementTypes.DICT_LITERAL_EXPRESSION).spaceIf(pySettings.SPACE_WITHIN_BRACES, pySettings.DICT_NEW_LINE_BEFORE_RIGHT_BRACE).betweenInside((IElementType)PyTokenTypes.COMMA, (IElementType)PyTokenTypes.RBRACKET, (IElementType)PyElementTypes.LIST_LITERAL_EXPRESSION).spaceIf(commonSettings.SPACE_WITHIN_BRACKETS || commonSettings.SPACE_AFTER_COMMA, pySettings.LIST_NEW_LINE_BEFORE_RIGHT_BRACKET).beforeInside((IElementType)PyTokenTypes.RBRACKET, (IElementType)PyElementTypes.LIST_LITERAL_EXPRESSION).spaceIf(commonSettings.SPACE_WITHIN_BRACKETS, pySettings.LIST_NEW_LINE_BEFORE_RIGHT_BRACKET).afterInside((IElementType)PyTokenTypes.LBRACKET, (IElementType)PyElementTypes.LIST_LITERAL_EXPRESSION).spaceIf(commonSettings.SPACE_WITHIN_BRACKETS, pySettings.LIST_NEW_LINE_AFTER_LEFT_BRACKET).betweenInside((IElementType)PyTokenTypes.COMMA, (IElementType)PyTokenTypes.RBRACE, (IElementType)PyElementTypes.SET_LITERAL_EXPRESSION).spaceIf(pySettings.SPACE_WITHIN_BRACES || commonSettings.SPACE_AFTER_COMMA, pySettings.SET_NEW_LINE_BEFORE_RIGHT_BRACE).beforeInside((IElementType)PyTokenTypes.RBRACE, (IElementType)PyElementTypes.SET_LITERAL_EXPRESSION).spaceIf(pySettings.SPACE_WITHIN_BRACES, pySettings.SET_NEW_LINE_BEFORE_RIGHT_BRACE).afterInside((IElementType)PyTokenTypes.LBRACE, (IElementType)PyElementTypes.SET_LITERAL_EXPRESSION).spaceIf(pySettings.SPACE_WITHIN_BRACES, pySettings.SET_NEW_LINE_AFTER_LEFT_BRACE).betweenInside((IElementType)PyTokenTypes.COMMA, (IElementType)PyTokenTypes.RPAR, (IElementType)PyElementTypes.PARENTHESIZED_EXPRESSION).spaceIf(commonSettings.SPACE_WITHIN_PARENTHESES || commonSettings.SPACE_AFTER_COMMA, pySettings.SET_NEW_LINE_BEFORE_RIGHT_BRACE).betweenInside((IElementType)PyTokenTypes.LPAR, (IElementType)PyElementTypes.TUPLE_EXPRESSION, (IElementType)PyElementTypes.PARENTHESIZED_EXPRESSION).spaceIf(commonSettings.SPACE_WITHIN_PARENTHESES, pySettings.TUPLE_NEW_LINE_AFTER_LEFT_PARENTHESIS).betweenInside((IElementType)PyElementTypes.TUPLE_EXPRESSION, (IElementType)PyTokenTypes.RPAR, (IElementType)PyElementTypes.PARENTHESIZED_EXPRESSION).spaceIf(commonSettings.SPACE_WITHIN_PARENTHESES, pySettings.TUPLE_NEW_LINE_BEFORE_RIGHT_PARENTHESIS).between((IElementType)PyTokenTypes.COMMA, (IElementType)PyTokenTypes.RBRACE).spaceIf(pySettings.SPACE_WITHIN_BRACES || commonSettings.SPACE_AFTER_COMMA).withinPair((IElementType)PyTokenTypes.LBRACE, (IElementType)PyTokenTypes.RBRACE).spaceIf(pySettings.SPACE_WITHIN_BRACES).between((IElementType)PyTokenTypes.COMMA, (IElementType)PyTokenTypes.RBRACKET).spaceIf(commonSettings.SPACE_WITHIN_BRACKETS || commonSettings.SPACE_AFTER_COMMA).withinPair((IElementType)PyTokenTypes.LBRACKET, (IElementType)PyTokenTypes.RBRACKET).spaceIf(commonSettings.SPACE_WITHIN_BRACKETS).between((IElementType)PyTokenTypes.COMMA, PyElementTypes.TYPE_PARAMETER).spaceIf(commonSettings.SPACE_WITHIN_BRACKETS || commonSettings.SPACE_AFTER_COMMA).withinPair((IElementType)PyTokenTypes.FSTRING_FRAGMENT_START, (IElementType)PyTokenTypes.FSTRING_FRAGMENT_END).spaces(0).before((IElementType)PyTokenTypes.COLON).spaceIf(pySettings.SPACE_BEFORE_PY_COLON).afterInside((IElementType)PyTokenTypes.LPAR, PyElementTypes.FROM_IMPORT_STATEMENT).spaces(0, pySettings.FROM_IMPORT_NEW_LINE_AFTER_LEFT_PARENTHESIS).betweenInside((IElementType)PyTokenTypes.COMMA, (IElementType)PyTokenTypes.RPAR, PyElementTypes.FROM_IMPORT_STATEMENT).spaceIf(commonSettings.SPACE_AFTER_COMMA, pySettings.FROM_IMPORT_NEW_LINE_BEFORE_RIGHT_PARENTHESIS).beforeInside((IElementType)PyTokenTypes.RPAR, PyElementTypes.FROM_IMPORT_STATEMENT).spaces(0, pySettings.FROM_IMPORT_NEW_LINE_BEFORE_RIGHT_PARENTHESIS).after((IElementType)PyTokenTypes.COMMA).spaceIf(commonSettings.SPACE_AFTER_COMMA).before((IElementType)PyTokenTypes.COMMA).spaceIf(commonSettings.SPACE_BEFORE_COMMA).after((IElementType)PyTokenTypes.FROM_KEYWORD).spaces(1).between((IElementType)PyTokenTypes.DOT, (IElementType)PyTokenTypes.IMPORT_KEYWORD).spaces(1).around((IElementType)PyTokenTypes.DOT).spaces(0).aroundInside((IElementType)PyTokenTypes.AT, PyElementTypes.DECORATOR_CALL).none().before((IElementType)PyTokenTypes.SEMICOLON).spaceIf(commonSettings.SPACE_BEFORE_SEMICOLON).betweenInside((IElementType)PyTokenTypes.LPAR, (IElementType)PyTokenTypes.RPAR, (IElementType)PyElementTypes.ARGUMENT_LIST).spaceIf(commonSettings.SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES).afterInside((IElementType)PyTokenTypes.LPAR, (IElementType)PyElementTypes.ARGUMENT_LIST).spaceIf(commonSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, commonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE).beforeInside((IElementType)PyTokenTypes.RPAR, (IElementType)PyElementTypes.ARGUMENT_LIST).spaceIf(commonSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, commonSettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE).betweenInside((IElementType)PyTokenTypes.LPAR, (IElementType)PyTokenTypes.RPAR, PyElementTypes.PARAMETER_LIST).spaceIf(commonSettings.SPACE_WITHIN_EMPTY_METHOD_PARENTHESES).afterInside((IElementType)PyTokenTypes.LPAR, PyElementTypes.PARAMETER_LIST).spaceIf(commonSettings.SPACE_WITHIN_METHOD_PARENTHESES, commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE).beforeInside((IElementType)PyTokenTypes.RPAR, PyElementTypes.PARAMETER_LIST).spaceIf(commonSettings.SPACE_WITHIN_METHOD_PARENTHESES, commonSettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE).betweenInside((IElementType)PyTokenTypes.LPAR, (IElementType)PyTokenTypes.RPAR, (IElementType)PyElementTypes.PATTERN_ARGUMENT_LIST).spaceIf(commonSettings.SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES).withinPairInside((IElementType)PyTokenTypes.LPAR, (IElementType)PyTokenTypes.RPAR, (IElementType)PyElementTypes.PATTERN_ARGUMENT_LIST).spaceIf(commonSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES).withinPairInside((IElementType)PyTokenTypes.LPAR, (IElementType)PyTokenTypes.RPAR, (IElementType)PyElementTypes.GENERATOR_EXPRESSION).spaces(0).withinPairInside((IElementType)PyTokenTypes.LPAR, (IElementType)PyTokenTypes.RPAR, (IElementType)PyElementTypes.PARENTHESIZED_EXPRESSION).spaces(0).before((IElementType)PyTokenTypes.LBRACKET).spaceIf(pySettings.SPACE_BEFORE_LBRACKET).before((IElementType)PyElementTypes.ARGUMENT_LIST).spaceIf(commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES).before((IElementType)PyElementTypes.PATTERN_ARGUMENT_LIST).spaceIf(commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES).around(PyElementTypes.DECORATOR_CALL).spacing(1, Integer.MAX_VALUE, 0, true, 0).after(PyElementTypes.DECORATOR_LIST).spacing(1, Integer.MAX_VALUE, 1, true, 0).aroundInside((IElementType)PyTokenTypes.EQ, (IElementType)PyElementTypes.ASSIGNMENT_STATEMENT).spaceIf(commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS).aroundInside((IElementType)PyTokenTypes.EQ, PyElementTypes.TYPE_ALIAS_STATEMENT).spaceIf(commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS).aroundInside((IElementType)PyTokenTypes.EQ, PyElementTypes.NAMED_PARAMETER).spaceIf(pySettings.SPACE_AROUND_EQ_IN_NAMED_PARAMETER).aroundInside((IElementType)PyTokenTypes.EQ, (IElementType)PyElementTypes.KEYWORD_ARGUMENT_EXPRESSION).spaceIf(pySettings.SPACE_AROUND_EQ_IN_KEYWORD_ARGUMENT).aroundInside((IElementType)PyTokenTypes.EQ, (IElementType)PyElementTypes.KEYWORD_PATTERN).spaceIf(pySettings.SPACE_AROUND_EQ_IN_KEYWORD_ARGUMENT).around((IElementType)PyTokenTypes.COLONEQ).spaceIf(commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS).around(PyTokenTypes.AUG_ASSIGN_OPERATIONS).spaceIf(commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS).aroundInside(PyTokenTypes.ADDITIVE_OPERATIONS, (IElementType)PyElementTypes.BINARY_EXPRESSION).spaceIf(commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS).aroundInside(PyTokenTypes.STAR_OPERATORS, PyElementTypes.STAR_PARAMETERS).none().aroundInside(PyTokenTypes.STAR_OPERATORS, STAR_PATTERNS).none().aroundInside(PyTokenTypes.STAR_OPERATORS, PyElementTypes.TYPE_PARAMETER).none().between((IElementType)PyTokenTypes.EXCEPT_KEYWORD, (IElementType)PyTokenTypes.MULT).none().between((IElementType)PyTokenTypes.PERC, TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.PERC, PyTokenTypes.IDENTIFIER, PyElementTypes.EXPRESSION_STATEMENT})).none().around(PyTokenTypes.MULTIPLICATIVE_OPERATIONS).spaceIf(commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS).around((IElementType)PyTokenTypes.EXP).spaceIf(pySettings.SPACE_AROUND_POWER_OPERATOR).around(PyTokenTypes.SHIFT_OPERATIONS).spaceIf(commonSettings.SPACE_AROUND_SHIFT_OPERATORS).around(PyTokenTypes.BITWISE_OPERATIONS).spaceIf(commonSettings.SPACE_AROUND_BITWISE_OPERATORS).around(PyTokenTypes.EQUALITY_OPERATIONS).spaceIf(commonSettings.SPACE_AROUND_EQUALITY_OPERATORS).around(PyTokenTypes.RELATIONAL_OPERATIONS).spaceIf(commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS).around(SINGLE_SPACE_KEYWORDS).spaces(1);
    }

    private static TokenSet allButLambda() {
        PythonLanguage pythonLanguage = PythonLanguage.getInstance();
        return TokenSet.create((IElementType[])IElementType.enumerate(type -> type != PyTokenTypes.LAMBDA_KEYWORD && type.getLanguage().isKindOf((Language)pythonLanguage)));
    }

    private static void printAST(ASTNode node, int indent) {
        while (node != null) {
            for (int i = 0; i < indent; ++i) {
                System.out.print(" ");
            }
            System.out.println(String.valueOf(node) + " " + String.valueOf(node.getTextRange()));
            PythonFormattingModelBuilder.printAST(node.getFirstChildNode(), indent + 2);
            node = node.getTreeNext();
        }
    }

    public boolean isEngagedToFormat(PsiElement context) {
        PsiFile file = context.getContainingFile();
        return file != null && file.getLanguage() == PythonLanguage.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/formatter/PythonFormattingModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/formatter/PythonFormattingModelBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

