/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.exasol;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.exasol.ExaLexer;
import com.intellij.sql.dialects.exasol.ExaTokens;
import com.intellij.sql.dialects.exasol.ExaTypes;
import com.intellij.sql.dialects.exasol.refactoring.ExaExtractFunctionHelper;
import com.intellij.sql.dialects.exasol.refactoring.ExaExtractVariableHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExaDialect
extends SqlLanguageDialectBase {
    public static final ExaDialect INSTANCE = new ExaDialect();

    private ExaDialect() {
        super("Exasol");
    }

    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(ExaTokens.class);
        if (tokensHelper == null) {
            ExaDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.EXASOL;
        if (dbms == null) {
            ExaDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"HASHTYPE", (String)"HASHTYPE", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"GEOMETRY", (String)"GEOMETRY", (SqlLanguageDialectEx)this);
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            ExaDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    protected TreePattern getBaseImports(@Nullable DbDataSource dataSource, ObjectName @Nullable [] dsNames) {
        ObjectName exaDb = ObjectName.quoted((String)"EXA_DB");
        DasNamespace namespace = ExaDialect.getDefaultNamespace((DbDataSource)dataSource, (ObjectName)exaDb);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[0]);
            if (treePattern == null) {
                ExaDialect.$$$reportNull$$$0(3);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources((ObjectName[])dsNames, (TreePatternNode.Group[])new TreePatternNode.Group[]{SqlImportUtil.createNodeIfNotNull((ObjectName)exaDb, (ObjectKind)ObjectKind.DATABASE, (TreePatternNode.Group[])new TreePatternNode.Group[0])}));
    }

    protected boolean canBeWithoutCurrentSchema() {
        return true;
    }

    public boolean isValidRawToken(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            ExaDialect.$$$reportNull$$$0(4);
        }
        if (text == null) {
            ExaDialect.$$$reportNull$$$0(5);
        }
        return ExaLexer.isValidRawToken(text);
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            ExaDialect.$$$reportNull$$$0(6);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlInsertStatement.class, SqlDeleteStatement.class, SqlUpdateStatement.class, SqlMergeStatement.class}) != null;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve, @NotNull SqlScopeProcessor processor2) {
        if (place == null) {
            ExaDialect.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            ExaDialect.$$$reportNull$$$0(8);
        }
        if (!this.processReservedEntitiesWithTypeDual(name2, place, resolve, processor2)) {
            return false;
        }
        return super.processReservedEntitiesWithType(name2, place, resolve, processor2);
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            ExaDialect.$$$reportNull$$$0(9);
        }
        return 128;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            ExaDialect.$$$reportNull$$$0(10);
        }
        if (!strict) {
            if (expectedTypes.contains(ObjectKind.ROUTINE) && type == ObjectKind.SCRIPT) {
                return true;
            }
            if (expectedTypes.contains(ObjectKind.SCHEMA) && type == ObjectKind.EXTERNAL_SCHEMA) {
                return true;
            }
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        if (PsiUtilCore.getElementType((PsiElement)o.getFirstChild()) == ExaTypes.EXA_LOCAL) {
            return null;
        }
        return super.checkIdentifierText(o, manager, onTheFly);
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return ExaExtractVariableHelper.INSTANCE;
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return ExaExtractFunctionHelper.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/exasol/ExaDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/exasol/ExaDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_IN, SqlTokens.SQL_INTERVAL, SqlTokens.SQL_SECOND, SqlTokens.SQL_MINUTE, SqlTokens.SQL_HOUR, SqlTokens.SQL_DAY, SqlTokens.SQL_MONTH, SqlTokens.SQL_YEAR);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_DIV})});

        LazyData() {
        }
    }
}

