/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerComposeCredentialsHolder {
    public static final String DOCKER_ACCOUNT_NAME = "DOCKER_ACCOUNT_NAME";
    public static final String DOCKER_COMPOSE_FILE_PATH = "DOCKER_COMPOSE_FILE_PATH";
    public static final String DOCKER_COMPOSE_SERVICE_NAME = "DOCKER_COMPOSE_SERVICE_NAME";
    public static final String DOCKER_REMOTE_PROJECT_PATH = "DOCKER_REMOTE_PROJECT_PATH";
    private static final String DOCKER_COMPOSE_CONFIGURATION_PATHS_TAG = "dockerComposeConfigurationPaths";
    private static final String ITEM_TAG = "item";
    private static final String VALUE_ATTRIBUTE = "value";
    private String myAccountName;
    private List<String> myComposeFilePaths;
    private String myComposeServiceName;
    private String myRemoteProjectPath;
    @NotNull
    private EnvironmentVariablesData myEnvs = EnvironmentVariablesData.DEFAULT;

    @NlsSafe
    public String getAccountName() {
        return this.myAccountName;
    }

    public void setAccountName(String accountName) {
        this.myAccountName = accountName;
    }

    public List<@NlsSafe String> getComposeFilePaths() {
        return this.myComposeFilePaths;
    }

    public void setComposeFilePaths(List<String> composeFilePaths) {
        this.myComposeFilePaths = composeFilePaths;
    }

    @NlsSafe
    public String getComposeServiceName() {
        return this.myComposeServiceName;
    }

    public void setComposeServiceName(String composeServiceName) {
        this.myComposeServiceName = composeServiceName;
    }

    @NlsSafe
    public String getRemoteProjectPath() {
        return this.myRemoteProjectPath;
    }

    public void setRemoteProjectPath(String remoteProjectPath) {
        this.myRemoteProjectPath = remoteProjectPath;
    }

    @NotNull
    public EnvironmentVariablesData getEnvs() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvs;
        if (environmentVariablesData == null) {
            DockerComposeCredentialsHolder.$$$reportNull$$$0(0);
        }
        return environmentVariablesData;
    }

    public void setEnvs(@NotNull EnvironmentVariablesData envs) {
        if (envs == null) {
            DockerComposeCredentialsHolder.$$$reportNull$$$0(1);
        }
        this.myEnvs = envs;
    }

    public void save(@NotNull Element element) {
        if (element == null) {
            DockerComposeCredentialsHolder.$$$reportNull$$$0(2);
        }
        DockerComposeCredentialsHolder.setAttribute(element, DOCKER_ACCOUNT_NAME, this.myAccountName);
        if (this.myComposeFilePaths != null) {
            Element configurationsTag = new Element(DOCKER_COMPOSE_CONFIGURATION_PATHS_TAG);
            for (String path : this.myComposeFilePaths) {
                Element itemElement = new Element(ITEM_TAG);
                itemElement.setAttribute(VALUE_ATTRIBUTE, PathUtil.toSystemIndependentName((String)path));
                configurationsTag.addContent(itemElement);
            }
            element.addContent(configurationsTag);
        }
        DockerComposeCredentialsHolder.setAttribute(element, DOCKER_COMPOSE_SERVICE_NAME, this.myComposeServiceName);
        DockerComposeCredentialsHolder.setAttribute(element, DOCKER_REMOTE_PROJECT_PATH, this.myRemoteProjectPath);
        this.myEnvs.writeExternal(element);
    }

    private static void setAttribute(@NotNull Element element, @NotNull String name2, @Nullable String value) {
        if (element == null) {
            DockerComposeCredentialsHolder.$$$reportNull$$$0(3);
        }
        if (name2 == null) {
            DockerComposeCredentialsHolder.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)value)) {
            element.setAttribute(name2, value);
        }
    }

    public void load(@NotNull Element element) {
        if (element == null) {
            DockerComposeCredentialsHolder.$$$reportNull$$$0(5);
        }
        this.myAccountName = element.getAttributeValue(DOCKER_ACCOUNT_NAME);
        String composeFilePath = element.getAttributeValue(DOCKER_COMPOSE_FILE_PATH);
        this.myComposeFilePaths = new ArrayList<String>();
        if (composeFilePath != null) {
            this.myComposeFilePaths.add(PathUtil.toSystemDependentName((String)composeFilePath));
        } else {
            Element configurationPathsTag = element.getChild(DOCKER_COMPOSE_CONFIGURATION_PATHS_TAG);
            if (configurationPathsTag != null) {
                for (Element item : configurationPathsTag.getChildren(ITEM_TAG)) {
                    String value = item.getAttributeValue(VALUE_ATTRIBUTE);
                    if (!StringUtil.isNotEmpty((String)value)) continue;
                    this.myComposeFilePaths.add(PathUtil.toSystemDependentName((String)value));
                }
            }
        }
        this.myComposeServiceName = element.getAttributeValue(DOCKER_COMPOSE_SERVICE_NAME);
        this.myRemoteProjectPath = element.getAttributeValue(DOCKER_REMOTE_PROJECT_PATH);
        this.myEnvs = EnvironmentVariablesData.readExternal((Element)element);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerComposeCredentialsHolder holder = (DockerComposeCredentialsHolder)o;
        if (!Objects.equals(this.myAccountName, holder.myAccountName)) {
            return false;
        }
        if (!Objects.equals(this.myComposeFilePaths, holder.myComposeFilePaths)) {
            return false;
        }
        if (!Objects.equals(this.myComposeServiceName, holder.myComposeServiceName)) {
            return false;
        }
        if (!Objects.equals(this.myRemoteProjectPath, holder.myRemoteProjectPath)) {
            return false;
        }
        return this.myEnvs.equals((Object)holder.myEnvs);
    }

    public int hashCode() {
        int result2 = this.myAccountName != null ? this.myAccountName.hashCode() : 0;
        result2 = 31 * result2 + (this.myComposeFilePaths != null ? this.myComposeFilePaths.hashCode() : 0);
        result2 = 31 * result2 + (this.myComposeServiceName != null ? this.myComposeServiceName.hashCode() : 0);
        result2 = 31 * result2 + (this.myRemoteProjectPath != null ? this.myRemoteProjectPath.hashCode() : 0);
        result2 = 31 * result2 + this.myEnvs.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerComposeCredentialsHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerComposeCredentialsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

