/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.common;

import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.util.DockerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class EnvsBuilder {
    private static final String PATH_ENV = "PATH";
    @NotNull
    private final Map<String, String> myEnvsMap = new LinkedHashMap<String, String>();
    private boolean myPassParentEnvironment;

    private EnvsBuilder() {
    }

    @NotNull
    public static EnvsBuilder builder() {
        return new EnvsBuilder();
    }

    @NotNull
    public EnvsBuilder addEnvs(@NotNull List<DockerEnvVarImpl> vars) {
        if (vars == null) {
            EnvsBuilder.$$$reportNull$$$0(0);
        }
        for (DockerEnvVarImpl var : vars) {
            this.myEnvsMap.put(var.getName(), var.getValue());
        }
        EnvsBuilder envsBuilder = this;
        if (envsBuilder == null) {
            EnvsBuilder.$$$reportNull$$$0(1);
        }
        return envsBuilder;
    }

    @NotNull
    public EnvsBuilder addEnvs(@NotNull Map<String, String> env2) {
        if (env2 == null) {
            EnvsBuilder.$$$reportNull$$$0(2);
        }
        this.myEnvsMap.putAll(env2);
        EnvsBuilder envsBuilder = this;
        if (envsBuilder == null) {
            EnvsBuilder.$$$reportNull$$$0(3);
        }
        return envsBuilder;
    }

    @NotNull
    public EnvsBuilder addEnv(@NotNull String key, @NotNull String value) {
        if (key == null) {
            EnvsBuilder.$$$reportNull$$$0(4);
        }
        if (value == null) {
            EnvsBuilder.$$$reportNull$$$0(5);
        }
        this.myEnvsMap.put(key, value);
        EnvsBuilder envsBuilder = this;
        if (envsBuilder == null) {
            EnvsBuilder.$$$reportNull$$$0(6);
        }
        return envsBuilder;
    }

    private static void addEnv(@NotNull List<DockerEnvVar> envVars, @Nullable String name2, @Nullable String value) {
        if (envVars == null) {
            EnvsBuilder.$$$reportNull$$$0(7);
        }
        if (name2 != null) {
            DockerEnvVarImpl envVar = new DockerEnvVarImpl();
            envVar.setName(name2);
            envVar.setValue(value);
            envVars.add(envVar);
        }
    }

    @NotNull
    public EnvsBuilder withPassParentEnvironment(boolean passParentEnvironment) {
        this.myPassParentEnvironment = passParentEnvironment;
        EnvsBuilder envsBuilder = this;
        if (envsBuilder == null) {
            EnvsBuilder.$$$reportNull$$$0(8);
        }
        return envsBuilder;
    }

    @TestOnly
    public String @NotNull [] build() {
        String[] stringArray = DockerUtil.mapArray(this.buildEnvs(), String.class, source -> source.getName() + "=" + source.getValue());
        if (stringArray == null) {
            EnvsBuilder.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    public DockerEnvVar[] buildEnvs() {
        ArrayList<DockerEnvVar> result2 = new ArrayList<DockerEnvVar>();
        for (Map.Entry<String, String> entry : this.myEnvsMap.entrySet()) {
            if (this.myPassParentEnvironment && PATH_ENV.equalsIgnoreCase(entry.getKey())) {
                if (entry.getValue() == null) continue;
                EnvsBuilder.addEnv(result2, entry.getKey(), entry.getValue() + ":$PATH");
                continue;
            }
            EnvsBuilder.addEnv(result2, entry.getKey(), entry.getValue());
        }
        return result2.toArray(new DockerEnvVar[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/common/EnvsBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/common/EnvsBuilder";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addEnvs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addEnv";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withPassParentEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addEnvs";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addEnv";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6, 8, 9 -> new IllegalStateException(string);
        };
    }
}

