/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollDomainDatagramChannel;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.unix.DomainDatagramChannel;
import io.netty.channel.unix.DomainSocketChannel;
import io.netty.channel.unix.ServerDomainSocketChannel;
import java.util.concurrent.ThreadFactory;
import reactor.netty.resources.ColocatedEventLoopGroup;
import reactor.netty.resources.DefaultLoop;
import reactor.util.Logger;
import reactor.util.Loggers;

final class DefaultLoopEpoll
implements DefaultLoop {
    static final Logger log = Loggers.getLogger(DefaultLoopEpoll.class);
    static final boolean isEpollAvailable;

    DefaultLoopEpoll() {
    }

    @Override
    public <CHANNEL extends Channel> CHANNEL getChannel(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return (CHANNEL)new EpollSocketChannel();
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return (CHANNEL)new EpollServerSocketChannel();
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return (CHANNEL)new EpollDatagramChannel();
        }
        if (channelClass.equals(DomainSocketChannel.class)) {
            return (CHANNEL)new EpollDomainSocketChannel();
        }
        if (channelClass.equals(ServerDomainSocketChannel.class)) {
            return (CHANNEL)new EpollServerDomainSocketChannel();
        }
        if (channelClass.equals(DomainDatagramChannel.class)) {
            return (CHANNEL)new EpollDomainDatagramChannel();
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public <CHANNEL extends Channel> Class<? extends CHANNEL> getChannelClass(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return EpollSocketChannel.class;
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return EpollServerSocketChannel.class;
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return EpollDatagramChannel.class;
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public String getName() {
        return "epoll";
    }

    @Override
    public EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory) {
        return new EpollEventLoopGroup(threads, factory);
    }

    @Override
    public boolean supportGroup(EventLoopGroup group) {
        if (group instanceof ColocatedEventLoopGroup) {
            group = ((ColocatedEventLoopGroup)group).get();
        }
        return group instanceof EpollEventLoopGroup;
    }

    static {
        boolean epollCheck = false;
        try {
            Class.forName("io.netty.channel.epoll.Epoll");
            epollCheck = Epoll.isAvailable();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isEpollAvailable = epollCheck;
        if (log.isDebugEnabled()) {
            log.debug("Default Epoll support : " + isEpollAvailable);
        }
    }
}

