// Code generated by ifacemaker; DO NOT EDIT.

package hcloud

import (
	"context"
)

// IStorageBoxClient ...
type IStorageBoxClient interface {
	// GetByID retrieves a [StorageBox] by its ID. If the [StorageBox] does not exist, nil is returned.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-boxes-get-a-storage-box
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	GetByID(ctx context.Context, id int64) (*StorageBox, *Response, error)
	// GetByName retrieves a [StorageBox] by its name. If the [StorageBox] does not exist, nil is returned.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-boxes-list-storage-boxes
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	GetByName(ctx context.Context, name string) (*StorageBox, *Response, error)
	// Get retrieves a [StorageBox] either by its ID or by its name, depending on whether
	// the input can be parsed as an integer. If no matching [StorageBox] is found, it returns nil.
	//
	// When fetching by ID, see https://docs.hetzner.cloud/reference/hetzner#storage-boxes-get-a-storage-box
	// When fetching by name, see https://docs.hetzner.cloud/reference/hetzner#storage-boxes-list-storage-boxes
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	Get(ctx context.Context, idOrName string) (*StorageBox, *Response, error)
	// List returns a list of [StorageBox] for a specific page.
	//
	// Please note that filters specified in opts are not taken into account
	// when their value corresponds to their zero value or when they are empty.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-boxes-list-storage-boxes
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	List(ctx context.Context, opts StorageBoxListOpts) ([]*StorageBox, *Response, error)
	// All returns all [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-boxes-list-storage-boxes
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	All(ctx context.Context) ([]*StorageBox, error)
	// AllWithOpts returns all [StorageBox] with the given options.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-boxes-list-storage-boxes
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	AllWithOpts(ctx context.Context, opts StorageBoxListOpts) ([]*StorageBox, error)
	// Create creates a new [StorageBox] with the given options.
	//
	// To provide SSH keys, populate the PublicKey field for each [SSHKey]
	// in the SSHKeys slice of [StorageBoxCreateOpts]. Only the PublicKey field
	// is sent to the API. They are not addressable by ID or name.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-boxes-create-a-storage-box
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	Create(ctx context.Context, opts StorageBoxCreateOpts) (StorageBoxCreateResult, *Response, error)
	// Update updates a [StorageBox] with the given options.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-boxes-update-a-storage-box
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	Update(ctx context.Context, storageBox *StorageBox, opts StorageBoxUpdateOpts) (*StorageBox, *Response, error)
	// Delete deletes a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-boxes-delete-a-storage-box
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	Delete(ctx context.Context, storageBox *StorageBox) (StorageBoxDeleteResult, *Response, error)
	// Folders lists folders in a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-boxes-list-folders-of-a-storage-box
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	Folders(ctx context.Context, storageBox *StorageBox, opts StorageBoxFoldersOpts) (StorageBoxFoldersResult, *Response, error)
	// ChangeProtection changes the protection level of a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-actions-change-protection
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	ChangeProtection(ctx context.Context, storageBox *StorageBox, opts StorageBoxChangeProtectionOpts) (*Action, *Response, error)
	// ChangeType changes the type of a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-actions-change-type
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	ChangeType(ctx context.Context, storageBox *StorageBox, opts StorageBoxChangeTypeOpts) (*Action, *Response, error)
	// ResetPassword resets the password of a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-actions-reset-password
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	ResetPassword(ctx context.Context, storageBox *StorageBox, opts StorageBoxResetPasswordOpts) (*Action, *Response, error)
	// UpdateAccessSettings updates the [StorageBoxAccessSettings] of a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-actions-update-access-settings
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	UpdateAccessSettings(ctx context.Context, storageBox *StorageBox, opts StorageBoxUpdateAccessSettingsOpts) (*Action, *Response, error)
	// RollbackSnapshot rolls back a [StorageBox] to a [StorageBoxSnapshot].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-actions-rollback-snapshot
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	RollbackSnapshot(ctx context.Context, storageBox *StorageBox, opts StorageBoxRollbackSnapshotOpts) (*Action, *Response, error)
	// EnableSnapshotPlan enables a [StorageBoxSnapshotPlan] for a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-actions-enable-snapshot-plan
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	EnableSnapshotPlan(ctx context.Context, storageBox *StorageBox, opts StorageBoxEnableSnapshotPlanOpts) (*Action, *Response, error)
	// DisableSnapshotPlan disables the [StorageBoxSnapshotPlan] for a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-actions-disable-snapshot-plan
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	DisableSnapshotPlan(ctx context.Context, storageBox *StorageBox) (*Action, *Response, error)
	// GetSnapshotByID gets a [StorageBoxSnapshot] by its ID.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-snapshots-get-a-snapshot
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	GetSnapshotByID(ctx context.Context, storageBox *StorageBox, id int64) (*StorageBoxSnapshot, *Response, error)
	// GetSnapshotByName gets a [StorageBoxSnapshot] by its name.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-snapshots-list-snapshots
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	GetSnapshotByName(ctx context.Context, storageBox *StorageBox, name string) (*StorageBoxSnapshot, *Response, error)
	// GetSnapshot retrieves a [StorageBoxSnapshot] either by its ID or by its name, depending on whether
	// the input can be parsed as an integer. If no matching [StorageBoxSnapshot] is found, it returns nil.
	//
	// When fetching by ID, see https://docs.hetzner.cloud/reference/hetzner#storage-box-snapshots-get-a-snapshot
	// When fetching by name, see https://docs.hetzner.cloud/reference/hetzner#storage-box-snapshots-list-snapshots
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	GetSnapshot(ctx context.Context, storageBox *StorageBox, idOrName string) (*StorageBoxSnapshot, *Response, error)
	// ListSnapshots lists all [StorageBoxSnapshot] of a [StorageBox] with the given options.
	//
	// Pagination is not supported, so this will return all [StorageBoxSnapshot] at once.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-snapshots-list-snapshots
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	ListSnapshots(ctx context.Context, storageBox *StorageBox, opts StorageBoxSnapshotListOpts) ([]*StorageBoxSnapshot, *Response, error)
	// AllSnapshotsWithOpts lists all [StorageBoxSnapshot] of a [StorageBox] with the given options.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-snapshots-list-snapshots
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	AllSnapshotsWithOpts(ctx context.Context, storageBox *StorageBox, opts StorageBoxSnapshotListOpts) ([]*StorageBoxSnapshot, error)
	// AllSnapshots lists all [StorageBoxSnapshot] of a [StorageBox] without any options.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-snapshots-list-snapshots
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	AllSnapshots(ctx context.Context, storageBox *StorageBox) ([]*StorageBoxSnapshot, error)
	// CreateSnapshot creates a new [StorageBoxSnapshot] for the given [StorageBox] with the provided options.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-snapshots-create-a-snapshot
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	CreateSnapshot(ctx context.Context, storageBox *StorageBox, opts StorageBoxSnapshotCreateOpts) (StorageBoxSnapshotCreateResult, *Response, error)
	// UpdateSnapshot updates the given [StorageBoxSnapshot] of a [StorageBox] with the provided options.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-snapshots-update-a-snapshot
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	UpdateSnapshot(ctx context.Context, snapshot *StorageBoxSnapshot, opts StorageBoxSnapshotUpdateOpts) (*StorageBoxSnapshot, *Response, error)
	// DeleteSnapshot deletes the given [StorageBoxSnapshot] of a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-snapshots-delete-a-snapshot
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	DeleteSnapshot(ctx context.Context, snapshot *StorageBoxSnapshot) (StorageBoxSnapshotDeleteResult, *Response, error)
	// GetSubaccount retrieves a [StorageBoxSubaccount] either by its ID or by its username, depending on whether
	// the input can be parsed as an integer. If no matching [StorageBoxSubaccount] is found, it returns nil.
	//
	// When fetching by ID, see https://docs.hetzner.cloud/reference/hetzner#storage-box-subaccounts-get-a-subaccount
	// When fetching by name, see https://docs.hetzner.cloud/reference/hetzner#storage-box-subaccounts-list-subaccounts
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	GetSubaccount(ctx context.Context, storageBox *StorageBox, idOrUsername string) (*StorageBoxSubaccount, *Response, error)
	// GetSubaccountByID retrieves a [StorageBoxSubaccount] by its ID.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-subaccounts-get-a-subaccount
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	GetSubaccountByID(ctx context.Context, storageBox *StorageBox, id int64) (*StorageBoxSubaccount, *Response, error)
	// GetSubaccountByUsername retrieves a [StorageBoxSubaccount] by its username.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-subaccounts-list-subaccounts
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	GetSubaccountByUsername(ctx context.Context, storageBox *StorageBox, username string) (*StorageBoxSubaccount, *Response, error)
	// ListSubaccounts lists all [StorageBoxSubaccount] of a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-subaccounts-list-subaccounts
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	ListSubaccounts(ctx context.Context, storageBox *StorageBox, opts StorageBoxSubaccountListOpts) ([]*StorageBoxSubaccount, *Response, error)
	// AllSubaccountsWithOpts retrieves all [StorageBoxSubaccount] of a [StorageBox] with the given options.
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-subaccounts-list-subaccounts
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	AllSubaccountsWithOpts(ctx context.Context, storageBox *StorageBox, opts StorageBoxSubaccountListOpts) ([]*StorageBoxSubaccount, error)
	// AllSubaccounts retrieves all [StorageBoxSubaccount] of a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-subaccounts-list-subaccounts
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	AllSubaccounts(ctx context.Context, storageBox *StorageBox) ([]*StorageBoxSubaccount, error)
	// CreateSubaccount creates a new [StorageBoxSubaccount] for a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-subaccounts-create-a-subaccount
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	CreateSubaccount(ctx context.Context, storageBox *StorageBox, opts StorageBoxSubaccountCreateOpts) (StorageBoxSubaccountCreateResult, *Response, error)
	// UpdateSubaccount updates a [StorageBoxSubaccount] of a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-subaccounts-update-a-subaccount
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	UpdateSubaccount(ctx context.Context, subaccount *StorageBoxSubaccount, opts StorageBoxSubaccountUpdateOpts) (*StorageBoxSubaccount, *Response, error)
	// DeleteSubaccount deletes a [StorageBoxSubaccount] from a [StorageBox].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-subaccounts-delete-a-subaccount
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	DeleteSubaccount(ctx context.Context, subaccount *StorageBoxSubaccount) (StorageBoxSubaccountDeleteResult, *Response, error)
	// ResetSubaccountPassword resets the password of a [StorageBoxSubaccount].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-subaccount-actions-reset-password
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	ResetSubaccountPassword(ctx context.Context, subaccount *StorageBoxSubaccount, opts StorageBoxSubaccountResetPasswordOpts) (*Action, *Response, error)
	// UpdateSubaccountAccessSettings updates the [StorageBoxSubaccountAccessSettings] of a [StorageBoxSubaccount].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-subaccount-actions-update-access-settings
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	UpdateSubaccountAccessSettings(ctx context.Context, subaccount *StorageBoxSubaccount, opts StorageBoxSubaccountUpdateAccessSettingsOpts) (*Action, *Response, error)
	// UpdateSubaccountAccessSettings changes the home directory of a [StorageBoxSubaccount].
	//
	// See https://docs.hetzner.cloud/reference/hetzner#storage-box-subaccount-actions-change-home-directory
	//
	// Experimental: [StorageBoxClient] is experimental, breaking changes may occur within minor releases.
	ChangeSubaccountHomeDirectory(ctx context.Context, subaccount *StorageBoxSubaccount, opts StorageBoxSubaccountChangeHomeDirectoryOpts) (*Action, *Response, error)
}
