# guildmaster

[GNU Make jobserver protocol](https://www.gnu.org/software/make/manual/html_node/Job-Slots.html)
does not have provisions for implicitly returning job tokens when a client is terminated
without a chance to write its tokens back. This poses a problem if you want to have just one
jobserver FIFO per machine, intended to be shared by all build jobs.

*guildmaster* implements a FIFO-like jobserver node via CUSE (character device in userspace,
a subsystem of FUSE) and keeps account of retrieved and returned tokens per each open file
description. When the node is closed with non-zero balance (i.e. a client returned fewer
tokens that it retrieved), it assumes that the client is about to terminate without fulfilling
the protocol, and replenishes the token pool.

## See Also
* [steve](https://gitweb.gentoo.org/proj/steve.git/) (developed simultaneously)
* [nixos-jobserver](https://github.com/NixOS/nixpkgs/pull/314888) (prior art, FUSE-based)

## Usage

### gm
`gm` is a CUSE server providing `/dev/guild` FIFO-like jobserver node, intended to be run
as a service. Can be run unprivileged, provided it has access to `/dev/cuse`, but `/dev/guild`
is limited to root by default (udev rules can be used to grant wider permissions).

### gm-run
`gm-run <command>` opens `/dev/guild`, retrieves one token, and runs `<command>` with
`--jobserver-auth=fifo:/dev/guild` appended to `MAKEFLAGS`. Hence, it is a wrapper
for jobserver-aware tools such as GNU Make and Ninja.