/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ar extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "توقيت غرينتش",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "التوقيت الرسمي لآبيا",
               "",
               "التوقيت الصيفي لأبيا",
               "",
               "توقيت آبيا",
               "",
            };
        final String[] Cook = new String[] {
               "توقيت جزر كوك الرسمي",
               "",
               "توقيت جزر كوك الصيفي",
               "",
               "توقيت جزر كووك",
               "",
            };
        final String[] Cuba = new String[] {
               "توقيت كوبا الرسمي",
               "CST",
               "توقيت كوبا الصيفي",
               "CDT",
               "توقيت كوبا",
               "CT",
            };
        final String[] Fiji = new String[] {
               "توقيت فيجي الرسمي",
               "",
               "توقيت فيجي الصيفي",
               "",
               "توقيت فيجي",
               "",
            };
        final String[] Gulf = new String[] {
               "توقيت الخليج",
               "GST",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "توقيت هوفد الرسمي",
               "",
               "توقيت هوفد الصيفي",
               "",
               "توقيت هوفد",
               "",
            };
        final String[] Iran = new String[] {
               "توقيت إيران الرسمي",
               "",
               "توقيت إيران الصيفي",
               "",
               "توقيت إيران",
               "",
            };
        final String[] Niue = new String[] {
               "توقيت نيوي",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "توقيت أومسك الرسمي",
               "",
               "توقيت أومسك الصيفي",
               "",
               "توقيت أومسك",
               "",
            };
        final String[] Peru = new String[] {
               "توقيت بيرو الرسمي",
               "",
               "توقيت بيرو الصيفي",
               "",
               "توقيت بيرو",
               "",
            };
        final String[] Truk = new String[] {
               "توقيت شوك",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "توقيت جزيرة ويك",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "توقيت تشيلي الرسمي",
               "",
               "توقيت تشيلي الصيفي",
               "",
               "توقيت تشيلي",
               "",
            };
        final String[] China = new String[] {
               "توقيت الصين الرسمي",
               "CST",
               "توقيت الصين الصيفي",
               "CDT",
               "توقيت الصين",
               "CT",
            };
        final String[] Cocos = new String[] {
               "توقيت جزر كوكوس",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "توقيت دافيز",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "توقيت الهند",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "توقيت اليابان الرسمي",
               "JST",
               "توقيت اليابان الصيفي",
               "JDT",
               "توقيت اليابان",
               "JT",
            };
        final String[] Korea = new String[] {
               "توقيت كوريا الرسمي",
               "KST",
               "توقيت كوريا الصيفي",
               "KST",
               "توقيت كوريا",
               "KST",
            };
        final String[] Nauru = new String[] {
               "توقيت ناورو",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "توقيت نيبال",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "توقيت بالاو",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "توقيت ساموا الرسمي",
               "SST",
               "توقيت ساموا الصيفي",
               "SST",
               "توقيت ساموا",
               "SST",
            };
        final String[] Syowa = new String[] {
               "توقيت سايووا",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "توقيت تونغا الرسمي",
               "",
               "توقيت تونغا الصيفي",
               "",
               "توقيت تونغا",
               "",
            };
        final String[] Yukon = new String[] {
               "توقيت يوكون",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "التوقيت الرسمي لألاسكا",
               "AKST",
               "توقيت ألاسكا الصيفي",
               "AKDT",
               "توقيت ألاسكا",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "توقيت الأمازون الرسمي",
               "",
               "توقيت الأمازون الصيفي",
               "",
               "توقيت الأمازون",
               "",
            };
        final String[] Anadyr = new String[] {
               "توقيت أنادير الرسمي",
               "",
               "التوقيت الصيفي لأنادير",
               "",
               "توقيت أنادير",
               "",
            };
        final String[] Azores = new String[] {
               "توقيت أزورس الرسمي",
               "",
               "توقيت أزورس الصيفي",
               "",
               "توقيت أزورس",
               "",
            };
        final String[] Bhutan = new String[] {
               "توقيت بوتان",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "توقيت بروناي",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "توقيت جزيرة استر الرسمي",
               "",
               "توقيت جزيرة استر الصيفي",
               "",
               "توقيت جزيرة استر",
               "",
            };
        final String[] Guyana = new String[] {
               "توقيت غيانا",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "توقيت إسرائيل الرسمي",
               "IST",
               "توقيت إسرائيل الصيفي",
               "IDT",
               "توقيت إسرائيل",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "توقيت كوسرا",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "توقيت ماوسون",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "توقيت موسكو الرسمي",
               "MSK",
               "توقيت موسكو الصيفي",
               "MSK",
               "توقيت موسكو",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "توقيت بونابي",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "توقيت سمارا",
               "",
               "توقيت سمارا الصيفي",
               "",
               "توقيت سامارا",
               "",
            };
        final String[] Tahiti = new String[] {
               "توقيت تاهيتي",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "توقيت تايبيه الرسمي",
               "CST",
               "توقيت تايبيه الصيفي",
               "CDT",
               "توقيت تايبيه",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "توقيت توفالو",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "توقيت فوستوك",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "توقيت واليس و فوتونا",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "التوقيت العربي الرسمي",
               "",
               "التوقيت العربي الصيفي",
               "",
               "التوقيت العربي",
               "",
            };
        final String[] Armenia = new String[] {
               "توقيت أرمينيا الرسمي",
               "",
               "توقيت أرمينيا الصيفي",
               "",
               "توقيت أرمينيا",
               "",
            };
        final String[] Bolivia = new String[] {
               "توقيت بوليفيا",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "توقيت تشاتام الرسمي",
               "",
               "توقيت تشاتام الصيفي",
               "",
               "توقيت تشاتام",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "التوقيت العالمي المنسق",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "توقيت الإكوادور",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "توقيت جامبير",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "توقيت جورجيا الرسمي",
               "",
               "توقيت جورجيا الصيفي",
               "",
               "توقيت جورجيا",
               "",
            };
        final String[] Irkutsk = new String[] {
               "توقيت إركوتسك الرسمي",
               "",
               "توقيت إركوتسك الصيفي",
               "",
               "توقيت إركوتسك",
               "",
            };
        final String[] Magadan = new String[] {
               "توقيت ماغادان الرسمي",
               "",
               "توقيت ماغادان الصيفي",
               "",
               "توقيت ماغادان",
               "",
            };
        final String[] Myanmar = new String[] {
               "توقيت ميانمار",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "توقيت جزيرة نورفولك الرسمي",
               "",
               "توقيت جزيرة نورفولك الصيفي",
               "",
               "توقيت جزيرة نورفولك",
               "",
            };
        final String[] Noronha = new String[] {
               "توقيت فرناندو دي نورونها الرسمي",
               "",
               "توقيت فرناندو دي نورونها الصيفي",
               "",
               "توقيت فيرناندو دي نورونها",
               "",
            };
        final String[] Reunion = new String[] {
               "توقيت روينيون",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "توقيت روثيرا",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "توقيت جزر سليمان",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "توقيت توكيلاو",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "توقيت أوروغواي الرسمي",
               "",
               "توقيت أوروغواي الصيفي",
               "",
               "توقيت أوروغواي",
               "",
            };
        final String[] Vanuatu = new String[] {
               "توقيت فانواتو الرسمي",
               "",
               "توقيت فانواتو الصيفي",
               "",
               "توقيت فانواتو",
               "",
            };
        final String[] Yakutsk = new String[] {
               "توقيت ياكوتسك الرسمي",
               "",
               "توقيت ياكوتسك الصيفي",
               "",
               "توقيت ياكوتسك",
               "",
            };
        final String[] Atlantic = new String[] {
               "التوقيت الرسمي الأطلسي",
               "AST",
               "التوقيت الصيفي الأطلسي",
               "AST",
               "توقيت الأطلسي",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "توقيت برازيليا الرسمي",
               "",
               "توقيت برازيليا الصيفي",
               "",
               "توقيت برازيليا",
               "",
            };
        final String[] Chamorro = new String[] {
               "توقيت تشامورو",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "توقيت كولومبيا الرسمي",
               "",
               "توقيت كولومبيا الصيفي",
               "",
               "توقيت كولومبيا",
               "",
            };
        final String[] Falkland = new String[] {
               "توقيت جزر فوكلاند الرسمي",
               "",
               "توقيت جزر فوكلاند الصيفي",
               "",
               "توقيت جزر فوكلاند",
               "",
            };
        final String[] Malaysia = new String[] {
               "توقيت ماليزيا",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "توقيت جزر المالديف",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "توقيت أولان باتور الرسمي",
               "",
               "توقيت أولان باتور الصيفي",
               "",
               "توقيت أولان باتور",
               "",
            };
        final String[] Pakistan = new String[] {
               "توقيت باكستان الرسمي",
               "PKT",
               "توقيت باكستان الصيفي",
               "PKST",
               "توقيت باكستان",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "توقيت باراغواي الرسمي",
               "",
               "توقيت باراغواي الصيفي",
               "",
               "توقيت باراغواي",
               "",
            };
        final String[] Pitcairn = new String[] {
               "توقيت بيتكيرن",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "توقيت ساخالين الرسمي",
               "",
               "توقيت ساخالين الصيفي",
               "",
               "توقيت ساخالين",
               "",
            };
        final String[] Suriname = new String[] {
               "توقيت سورينام",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "توقيت الأرجنتين الرسمي",
               "",
               "توقيت الأرجنتين الصيفي",
               "",
               "توقيت الأرجنتين",
               "",
            };
        final String[] Christmas = new String[] {
               "توقيت جزر الكريسماس",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "توقيت غلاباغوس",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "توقيت هونغ كونغ الرسمي",
               "HKT",
               "توقيت هونغ كونغ الصيفي",
               "HKST",
               "توقيت هونغ كونغ",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "توقيت الهند الصينية",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "توقيت بيتروبافلوفسك-كامتشاتسكي",
               "",
               "توقيت بيتروبافلوفسك-كامتشاتسكي الصيفي",
               "",
               "توقيت كامشاتكا",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "توقيت قيرغيزستان",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "توقيت لورد هاو الرسمي",
               "",
               "التوقيت الصيفي للورد هاو",
               "",
               "توقيت لورد هاو",
               "",
            };
        final String[] Marquesas = new String[] {
               "توقيت ماركيساس",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "توقيت موريشيوس الرسمي",
               "",
               "توقيت موريشيوس الصيفي",
               "",
               "توقيت موريشيوس",
               "",
            };
        final String[] Singapore = new String[] {
               "توقيت سنغافورة",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "توقيت فنزويلا",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "توقيت فولغوغراد الرسمي",
               "MSK",
               "توقيت فولغوغراد الصيفي",
               "MSK",
               "توقيت فولغوغراد",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "توقيت أذربيجان الرسمي",
               "",
               "توقيت أذربيجان الصيفي",
               "",
               "توقيت أذربيجان",
               "",
            };
        final String[] Bangladesh = new String[] {
               "توقيت بنغلاديش الرسمي",
               "",
               "توقيت بنغلاديش الصيفي",
               "",
               "توقيت بنغلاديش",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "توقيت الرأس الأخضر الرسمي",
               "",
               "توقيت الرأس الأخضر الصيفي",
               "",
               "توقيت الرأس الأخضر",
               "",
            };
        final String[] East_Timor = new String[] {
               "توقيت تيمور الشرقية",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "توقيت كازاخستان",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "توقيت سيشل",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "توقيت طاجكستان",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "توقيت أوزبكستان الرسمي",
               "",
               "توقيت أوزبكستان الصيفي",
               "",
               "توقيت أوزبكستان",
               "",
            };
        final String[] Afghanistan = new String[] {
               "توقيت أفغانستان",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "توقيت كراسنويارسك الرسمي",
               "",
               "التوقيت الصيفي لكراسنويارسك",
               "",
               "توقيت كراسنويارسك",
               "",
            };
        final String[] New_Zealand = new String[] {
               "توقيت نيوزيلندا الرسمي",
               "NZST",
               "توقيت نيوزيلندا الصيفي",
               "NZDT",
               "توقيت نيوزيلندا",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "توقيت نوفوسيبيرسك الرسمي",
               "",
               "توقيت نوفوسيبيرسك الصيفي",
               "",
               "توقيت نوفوسيبيرسك",
               "",
            };
        final String[] Philippines = new String[] {
               "توقيت الفيلبين الرسمي",
               "PST",
               "توقيت الفيلبين الصيفي",
               "PDT",
               "توقيت الفيلبين",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "توقيت فلاديفوستوك الرسمي",
               "",
               "توقيت فلاديفوستوك الصيفي",
               "",
               "توقيت فلاديفوستوك",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "توقيت المحيط الهندي",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "توقيت جزر لاين",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "توقيت نيوفاوندلاند الرسمي",
               "NST",
               "توقيت نيوفاوندلاند الصيفي",
               "NDT",
               "توقيت نيوفاوندلاند",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "توقيت تركمانستان الرسمي",
               "",
               "توقيت تركمانستان الصيفي",
               "",
               "توقيت تركمانستان",
               "",
            };
        final String[] French_Guiana = new String[] {
               "توقيت غويانا الفرنسية",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "توقيت كاليدونيا الجديدة الرسمي",
               "",
               "توقيت كاليدونيا الجديدة الصيفي",
               "",
               "توقيت كاليدونيا الجديدة",
               "",
            };
        final String[] South_Georgia = new String[] {
               "توقيت جنوب جورجيا",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "توقيت يكاترينبورغ الرسمي",
               "",
               "توقيت يكاترينبورغ الصيفي",
               "",
               "توقيت يكاترينبورغ",
               "",
            };
        final String[] Africa_Central = new String[] {
               "توقيت وسط أفريقيا",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "توقيت شرق أفريقيا",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "توقيت غرب أفريقيا الرسمي",
               "WAT",
               "توقيت غرب أفريقيا الصيفي",
               "WAT",
               "توقيت غرب أفريقيا",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "توقيت دي مونت دو روفيل",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "توقيت وسط أوروبا الرسمي",
               "CET",
               "توقيت وسط أوروبا الصيفي",
               "CEST",
               "توقيت وسط أوروبا",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "توقيت شرق أوروبا الرسمي",
               "EET",
               "توقيت شرق أوروبا الصيفي",
               "EEST",
               "توقيت شرق أوروبا",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "توقيت غرب أوروبا الرسمي",
               "WET",
               "توقيت غرب أوروبا الصيفي",
               "WEST",
               "توقيت غرب أوروبا",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "توقيت المحيط الهادي الرسمي للمكسيك",
               "MST",
               "توقيت المحيط الهادي الصيفي للمكسيك",
               "MDT",
               "توقيت المحيط الهادي للمكسيك",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "توقيت جنوب أفريقيا",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "التوقيت الرسمي المركزي لأمريكا الشمالية",
               "CST",
               "التوقيت الصيفي المركزي لأمريكا الشمالية",
               "CDT",
               "التوقيت المركزي لأمريكا الشمالية",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "التوقيت الرسمي الشرقي لأمريكا الشمالية",
               "EST",
               "التوقيت الصيفي الشرقي لأمريكا الشمالية",
               "EST",
               "التوقيت الشرقي لأمريكا الشمالية",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "توقيت المحيط الهادي الرسمي",
               "PST",
               "توقيت المحيط الهادي الصيفي",
               "PDT",
               "توقيت المحيط الهادي",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "توقيت المقاطعات الفرنسية الجنوبية والأنتارتيكية",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "توقيت جزر جيلبرت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "توقيت هاواي ألوتيان الرسمي",
               "HST",
               "توقيت هاواي ألوتيان الصيفي",
               "HST",
               "توقيت هاواي ألوتيان",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "توقيت جزر فينكس",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "توقيت سانت بيير وميكولون الرسمي",
               "",
               "توقيت سانت بيير وميكولون الصيفي",
               "",
               "توقيت سانت بيير وميكولون",
               "",
            };
        final String[] America_Mountain = new String[] {
               "التوقيت الجبلي الرسمي لأمريكا الشمالية",
               "MST",
               "التوقيت الجبلي الصيفي لأمريكا الشمالية",
               "MST",
               "التوقيت الجبلي لأمريكا الشمالية",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "توقيت جزر مارشال",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "توقيت بابوا غينيا الجديدة",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "توقيت وسط أستراليا الرسمي",
               "ACST",
               "توقيت وسط أستراليا الصيفي",
               "ACDT",
               "توقيت وسط أستراليا",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "توقيت شرق أستراليا الرسمي",
               "AEST",
               "توقيت شرق أستراليا الصيفي",
               "AEDT",
               "توقيت شرق أستراليا",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "توقيت غرب أستراليا الرسمي",
               "AWST",
               "توقيت غرب أستراليا الصيفي",
               "AWDT",
               "توقيت غرب أستراليا",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "توقيت وسط إندونيسيا",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "توقيت شرق إندونيسيا",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "توقيت غرب إندونيسيا",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "توقيت غرب وسط أستراليا الرسمي",
               "",
               "توقيت غرب وسط أستراليا الصيفي",
               "",
               "توقيت غرب وسط أستراليا",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "توقيت غرينتش",
                    "GMT",
                    "توقيت بريطانيا الصيفي",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "التوقيت العالمي المنسق",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "توقيت غرينتش",
                    "GMT",
                    "توقيت أيرلندا الرسمي",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "التوقيت العالمي المنسق",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "التوقيت العالمي المنسق",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "توقيت غرينتش",
                    "GMT",
                    "توقيت بريطانيا الصيفي",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "التوقيت العالمي المنسق",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "التوقيت العالمي المنسق",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "التوقيت العالمي المنسق",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "توقيت غرينتش",
                    "GMT",
                    "توقيت أيرلندا الرسمي",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "توقيت غرينتش",
                    "GMT",
                    "توقيت بريطانيا الصيفي",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "توقيت غرينتش",
                    "GMT",
                    "توقيت بريطانيا الصيفي",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "توقيت غرينتش",
                    "GMT",
                    "توقيت بريطانيا الصيفي",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "توقيت غرينتش",
                    "GMT",
                    "توقيت بريطانيا الصيفي",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "توقيت غرينتش",
                    "GMT",
                    "توقيت بريطانيا الصيفي",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "عدن" },
            { "timezone.excity.Asia/Baku", "باكو" },
            { "timezone.excity.Asia/Dili", "ديلي" },
            { "timezone.excity.Asia/Gaza", "غزة" },
            { "timezone.excity.Asia/Hovd", "هوفد" },
            { "timezone.excity.Asia/Omsk", "أومسك" },
            { "timezone.excity.Asia/Oral", "أورال" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "عمّان" },
            { "timezone.excity.Asia/Aqtau", "أكتاو" },
            { "timezone.excity.Asia/Chita", "تشيتا" },
            { "timezone.excity.Asia/Dhaka", "دكا" },
            { "timezone.excity.Asia/Dubai", "دبي" },
            { "timezone.excity.Asia/Kabul", "كابول" },
            { "timezone.excity.Asia/Macau", "ماكاو" },
            { "timezone.excity.Asia/Qatar", "قطر" },
            { "timezone.excity.Asia/Seoul", "سول" },
            { "timezone.excity.Asia/Tokyo", "طوكيو" },
            { "timezone.excity.Asia/Tomsk", "تومسك" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "جوبا" },
            { "timezone.excity.Africa/Lome", "لومي" },
            { "timezone.excity.Asia/Almaty", "ألماتي" },
            { "timezone.excity.Asia/Anadyr", "أندير" },
            { "timezone.excity.Asia/Aqtobe", "أكتوب" },
            { "timezone.excity.Asia/Atyrau", "أتيراو" },
            { "timezone.excity.Asia/Beirut", "بيروت" },
            { "timezone.excity.Asia/Brunei", "بروناي" },
            { "timezone.excity.Asia/Hebron", "هيبرون (مدينة الخليل)" },
            { "timezone.excity.Asia/Kuwait", "الكويت" },
            { "timezone.excity.Asia/Manila", "مانيلا" },
            { "timezone.excity.Asia/Muscat", "مسقط" },
            { "timezone.excity.Asia/Riyadh", "الرياض" },
            { "timezone.excity.Asia/Saigon", "مدينة هو تشي منة" },
            { "timezone.excity.Asia/Taipei", "تايبيه" },
            { "timezone.excity.Asia/Tehran", "طهران" },
            { "timezone.excity.Asia/Urumqi", "أرومكي" },
            { "timezone.excity.Etc/Unknown", "مدينة غير معروفة" },
            { "timezone.excity.Europe/Kiev", "كييف" },
            { "timezone.excity.Europe/Oslo", "أوسلو" },
            { "timezone.excity.Europe/Riga", "ريغا" },
            { "timezone.excity.Europe/Rome", "روما" },
            { "timezone.excity.Indian/Mahe", "ماهي" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "أكرا" },
            { "timezone.excity.Africa/Cairo", "القاهرة" },
            { "timezone.excity.Africa/Ceuta", "سيتا" },
            { "timezone.excity.Africa/Dakar", "داكار" },
            { "timezone.excity.Africa/Lagos", "لاغوس" },
            { "timezone.excity.Africa/Tunis", "تونس" },
            { "timezone.excity.America/Adak", "أداك" },
            { "timezone.excity.America/Lima", "ليما" },
            { "timezone.excity.America/Nome", "نوم" },
            { "timezone.excity.Asia/Baghdad", "بغداد" },
            { "timezone.excity.Asia/Bahrain", "البحرين" },
            { "timezone.excity.Asia/Bangkok", "بانكوك" },
            { "timezone.excity.Asia/Barnaul", "بارناول" },
            { "timezone.excity.Asia/Bishkek", "بشكيك" },
            { "timezone.excity.Asia/Colombo", "كولومبو" },
            { "timezone.excity.Asia/Irkutsk", "ايركيتسك" },
            { "timezone.excity.Asia/Jakarta", "جاكرتا" },
            { "timezone.excity.Asia/Karachi", "كراتشي" },
            { "timezone.excity.Asia/Kuching", "كيشينج" },
            { "timezone.excity.Asia/Magadan", "مجادن" },
            { "timezone.excity.Asia/Nicosia", "نيقوسيا" },
            { "timezone.excity.Asia/Rangoon", "رانغون" },
            { "timezone.excity.Asia/Tbilisi", "تبليسي" },
            { "timezone.excity.Asia/Thimphu", "تيمفو" },
            { "timezone.excity.Asia/Yakutsk", "ياكتسك" },
            { "timezone.excity.Asia/Yerevan", "يريفان" },
            { "timezone.excity.Europe/Kirov", "كيروف" },
            { "timezone.excity.Europe/Malta", "مالطة" },
            { "timezone.excity.Europe/Minsk", "مينسك" },
            { "timezone.excity.Europe/Paris", "باريس" },
            { "timezone.excity.Europe/Sofia", "صوفيا" },
            { "timezone.excity.Europe/Vaduz", "فادوز" },
            { "timezone.excity.Indian/Cocos", "كوكوس" },
            { "timezone.excity.Pacific/Apia", "أبيا" },
            { "timezone.excity.Pacific/Fiji", "فيجي" },
            { "timezone.excity.Pacific/Guam", "غوام" },
            { "timezone.excity.Pacific/Niue", "نيوي" },
            { "timezone.excity.Pacific/Truk", "ترك" },
            { "timezone.excity.Pacific/Wake", "واك" },
            { "timezone.excity.Africa/Asmera", "أسمرة" },
            { "timezone.excity.Africa/Bamako", "باماكو" },
            { "timezone.excity.Africa/Bangui", "بانغوي" },
            { "timezone.excity.Africa/Banjul", "بانجول" },
            { "timezone.excity.Africa/Bissau", "بيساو" },
            { "timezone.excity.Africa/Douala", "دوالا" },
            { "timezone.excity.Africa/Harare", "هراري" },
            { "timezone.excity.Africa/Kigali", "كيغالي" },
            { "timezone.excity.Africa/Luanda", "لواندا" },
            { "timezone.excity.Africa/Lusaka", "لوساكا" },
            { "timezone.excity.Africa/Malabo", "مالابو" },
            { "timezone.excity.Africa/Maputo", "مابوتو" },
            { "timezone.excity.Africa/Maseru", "ماسيرو" },
            { "timezone.excity.Africa/Niamey", "نيامي" },
            { "timezone.excity.America/Aruba", "أروبا" },
            { "timezone.excity.America/Bahia", "باهيا" },
            { "timezone.excity.America/Belem", "بلم" },
            { "timezone.excity.America/Boise", "بويس" },
            { "timezone.excity.America/Jujuy", "جوجو" },
            { "timezone.excity.America/Sitka", "سيتكا" },
            { "timezone.excity.America/Thule", "ثيل" },
            { "timezone.excity.Asia/Ashgabat", "عشق آباد" },
            { "timezone.excity.Asia/Calcutta", "كالكتا" },
            { "timezone.excity.Asia/Damascus", "دمشق" },
            { "timezone.excity.Asia/Dushanbe", "دوشانبي" },
            { "timezone.excity.Asia/Jayapura", "جايابيورا" },
            { "timezone.excity.Asia/Katmandu", "كاتماندو" },
            { "timezone.excity.Asia/Khandyga", "خانديجا" },
            { "timezone.excity.Asia/Makassar", "ماكسار" },
            { "timezone.excity.Asia/Qostanay", "قوستاناي" },
            { "timezone.excity.Asia/Sakhalin", "سكالين" },
            { "timezone.excity.Asia/Shanghai", "شنغهاي" },
            { "timezone.excity.Asia/Tashkent", "طشقند" },
            { "timezone.excity.Asia/Ust-Nera", "أوست نيرا" },
            { "timezone.excity.Europe/Athens", "أثينا" },
            { "timezone.excity.Europe/Berlin", "برلين" },
            { "timezone.excity.Europe/Dublin", "دبلن" },
            { "timezone.excity.Europe/Jersey", "جيرسي" },
            { "timezone.excity.Europe/Lisbon", "لشبونة" },
            { "timezone.excity.Europe/London", "لندن" },
            { "timezone.excity.Europe/Madrid", "مدريد" },
            { "timezone.excity.Europe/Monaco", "موناكو" },
            { "timezone.excity.Europe/Moscow", "موسكو" },
            { "timezone.excity.Europe/Prague", "براغ" },
            { "timezone.excity.Europe/Samara", "سمراء" },
            { "timezone.excity.Europe/Skopje", "سكوبي" },
            { "timezone.excity.Europe/Tirane", "تيرانا" },
            { "timezone.excity.Europe/Vienna", "فيينا" },
            { "timezone.excity.Europe/Warsaw", "وارسو" },
            { "timezone.excity.Europe/Zagreb", "زغرب" },
            { "timezone.excity.Europe/Zurich", "زيورخ" },
            { "timezone.excity.Indian/Chagos", "تشاغوس" },
            { "timezone.excity.Indian/Comoro", "جزر القمر" },
            { "timezone.excity.Pacific/Efate", "إيفات" },
            { "timezone.excity.Pacific/Nauru", "ناورو" },
            { "timezone.excity.Pacific/Palau", "بالاو" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "أبيدجان" },
            { "timezone.excity.Africa/Algiers", "الجزائر" },
            { "timezone.excity.Africa/Conakry", "كوناكري" },
            { "timezone.excity.Africa/Kampala", "كامبالا" },
            { "timezone.excity.Africa/Mbabane", "مباباني" },
            { "timezone.excity.Africa/Nairobi", "نيروبي" },
            { "timezone.excity.Africa/Tripoli", "طرابلس" },
            { "timezone.excity.America/Belize", "بليز" },
            { "timezone.excity.America/Bogota", "بوغوتا" },
            { "timezone.excity.America/Cancun", "كانكون" },
            { "timezone.excity.America/Cayman", "كايمان" },
            { "timezone.excity.America/Cuiaba", "كيابا" },
            { "timezone.excity.America/Dawson", "داوسان" },
            { "timezone.excity.America/Denver", "دنفر" },
            { "timezone.excity.America/Guyana", "غيانا" },
            { "timezone.excity.America/Havana", "هافانا" },
            { "timezone.excity.America/Inuvik", "اينوفيك" },
            { "timezone.excity.America/Juneau", "جوني" },
            { "timezone.excity.America/La_Paz", "لا باز" },
            { "timezone.excity.America/Maceio", "ماشيو" },
            { "timezone.excity.America/Manaus", "ماناوس" },
            { "timezone.excity.America/Merida", "ميريدا" },
            { "timezone.excity.America/Nassau", "ناسو" },
            { "timezone.excity.America/Panama", "بنما" },
            { "timezone.excity.America/Recife", "ريسيف" },
            { "timezone.excity.America/Regina", "ريجينا" },
            { "timezone.excity.Asia/Famagusta", "فاماغوستا" },
            { "timezone.excity.Asia/Hong_Kong", "هونغ كونغ" },
            { "timezone.excity.Asia/Jerusalem", "القدس" },
            { "timezone.excity.Asia/Kamchatka", "كامتشاتكا" },
            { "timezone.excity.Asia/Pontianak", "بونتيانك" },
            { "timezone.excity.Asia/Pyongyang", "بيونغ يانغ" },
            { "timezone.excity.Asia/Qyzylorda", "كيزيلوردا" },
            { "timezone.excity.Asia/Samarkand", "سمرقند" },
            { "timezone.excity.Asia/Singapore", "سنغافورة" },
            { "timezone.excity.Asia/Vientiane", "فيانتيان" },
            { "timezone.excity.Europe/Andorra", "أندورا" },
            { "timezone.excity.Europe/Saratov", "ساراتوف" },
            { "timezone.excity.Europe/Tallinn", "تالين" },
            { "timezone.excity.Europe/Vatican", "الفاتيكان" },
            { "timezone.excity.Europe/Vilnius", "فيلنيوس" },
            { "timezone.excity.Indian/Mayotte", "مايوت" },
            { "timezone.excity.Indian/Reunion", "ريونيون" },
            { "timezone.excity.Pacific/Easter", "استر" },
            { "timezone.excity.Pacific/Kanton", "كانتون" },
            { "timezone.excity.Pacific/Kosrae", "كوسرا" },
            { "timezone.excity.Pacific/Majuro", "ماجورو" },
            { "timezone.excity.Pacific/Midway", "ميدواي" },
            { "timezone.excity.Pacific/Noumea", "نوميا" },
            { "timezone.excity.Pacific/Ponape", "باناب" },
            { "timezone.excity.Pacific/Saipan", "سايبان" },
            { "timezone.excity.Pacific/Tahiti", "تاهيتي" },
            { "timezone.excity.Pacific/Tarawa", "تاراوا" },
            { "timezone.excity.Pacific/Wallis", "واليس" },
            { "timezone.excity.Africa/Blantyre", "بلانتاير" },
            { "timezone.excity.Africa/Djibouti", "جيبوتي" },
            { "timezone.excity.Africa/El_Aaiun", "العيون" },
            { "timezone.excity.Africa/Freetown", "فري تاون" },
            { "timezone.excity.Africa/Gaborone", "غابورون" },
            { "timezone.excity.Africa/Khartoum", "الخرطوم" },
            { "timezone.excity.Africa/Kinshasa", "كينشاسا" },
            { "timezone.excity.Africa/Monrovia", "مونروفيا" },
            { "timezone.excity.Africa/Ndjamena", "نجامينا" },
            { "timezone.excity.Africa/Sao_Tome", "ساو تومي" },
            { "timezone.excity.Africa/Windhoek", "ويندهوك" },
            { "timezone.excity.America/Antigua", "أنتيغوا" },
            { "timezone.excity.America/Caracas", "كاراكاس" },
            { "timezone.excity.America/Cayenne", "كايين" },
            { "timezone.excity.America/Chicago", "شيكاغو" },
            { "timezone.excity.America/Cordoba", "كوردوبا" },
            { "timezone.excity.America/Creston", "كريستون" },
            { "timezone.excity.America/Curacao", "كوراساو" },
            { "timezone.excity.America/Detroit", "ديترويت" },
            { "timezone.excity.America/Godthab", "غودثاب" },
            { "timezone.excity.America/Grenada", "غرينادا" },
            { "timezone.excity.America/Halifax", "هاليفاكس" },
            { "timezone.excity.America/Iqaluit", "اكويلت" },
            { "timezone.excity.America/Jamaica", "جامايكا" },
            { "timezone.excity.America/Managua", "ماناغوا" },
            { "timezone.excity.America/Marigot", "ماريغوت" },
            { "timezone.excity.America/Mendoza", "ميندوزا" },
            { "timezone.excity.America/Moncton", "وينكتون" },
            { "timezone.excity.America/Noronha", "نوروناه" },
            { "timezone.excity.America/Ojinaga", "أوجيناجا" },
            { "timezone.excity.America/Phoenix", "فينكس" },
            { "timezone.excity.America/Tijuana", "تيخوانا" },
            { "timezone.excity.America/Toronto", "تورونتو" },
            { "timezone.excity.America/Tortola", "تورتولا" },
            { "timezone.excity.America/Yakutat", "ياكوتات" },
            { "timezone.excity.Asia/Phnom_Penh", "بنوم بنه" },
            { "timezone.excity.Atlantic/Azores", "أزورس" },
            { "timezone.excity.Atlantic/Canary", "كناري" },
            { "timezone.excity.Atlantic/Faeroe", "فارو" },
            { "timezone.excity.Australia/Eucla", "أوكلا" },
            { "timezone.excity.Australia/Perth", "برثا" },
            { "timezone.excity.Europe/Belgrade", "بلغراد" },
            { "timezone.excity.Europe/Brussels", "بروكسل" },
            { "timezone.excity.Europe/Budapest", "بودابست" },
            { "timezone.excity.Europe/Busingen", "بوسنغن" },
            { "timezone.excity.Europe/Chisinau", "تشيسيناو" },
            { "timezone.excity.Europe/Guernsey", "غيرنزي" },
            { "timezone.excity.Europe/Helsinki", "هلسنكي" },
            { "timezone.excity.Europe/Istanbul", "إسطنبول" },
            { "timezone.excity.Europe/Sarajevo", "سراييفو" },
            { "timezone.excity.Indian/Maldives", "المالديف" },
            { "timezone.excity.Pacific/Chatham", "تشاثام" },
            { "timezone.excity.Pacific/Fakaofo", "فاكاوفو" },
            { "timezone.excity.Pacific/Gambier", "جامبير" },
            { "timezone.excity.Pacific/Norfolk", "نورفولك" },
            { "timezone.excity.Africa/Bujumbura", "بوجومبورا" },
            { "timezone.excity.Africa/Mogadishu", "مقديشيو" },
            { "timezone.excity.America/Anguilla", "أنغويلا" },
            { "timezone.excity.America/Asuncion", "أسونسيون" },
            { "timezone.excity.America/Barbados", "بربادوس" },
            { "timezone.excity.America/Dominica", "دومينيكا" },
            { "timezone.excity.America/Edmonton", "ايدمونتون" },
            { "timezone.excity.America/Eirunepe", "ايرونبي" },
            { "timezone.excity.America/Mazatlan", "مازاتلان" },
            { "timezone.excity.America/Miquelon", "مكويلون" },
            { "timezone.excity.America/New_York", "نيويورك" },
            { "timezone.excity.America/Resolute", "ريزولوت" },
            { "timezone.excity.America/Santarem", "سانتاريم" },
            { "timezone.excity.America/Santiago", "سانتياغو" },
            { "timezone.excity.America/St_Johns", "سانت جونس" },
            { "timezone.excity.America/St_Kitts", "سانت كيتس" },
            { "timezone.excity.America/St_Lucia", "سانت لوشيا" },
            { "timezone.excity.America/Winnipeg", "وينيبيج" },
            { "timezone.excity.Antarctica/Casey", "كاساي" },
            { "timezone.excity.Antarctica/Davis", "دافيز" },
            { "timezone.excity.Antarctica/Syowa", "سايووا" },
            { "timezone.excity.Antarctica/Troll", "ترول" },
            { "timezone.excity.Asia/Krasnoyarsk", "كراسنويارسك" },
            { "timezone.excity.Asia/Novosibirsk", "نوفوسبيرسك" },
            { "timezone.excity.Asia/Ulaanbaatar", "آلانباتار" },
            { "timezone.excity.Asia/Vladivostok", "فلاديفوستك" },
            { "timezone.excity.Atlantic/Bermuda", "برمودا" },
            { "timezone.excity.Atlantic/Madeira", "ماديرا" },
            { "timezone.excity.Atlantic/Stanley", "استانلي" },
            { "timezone.excity.Australia/Darwin", "دارون" },
            { "timezone.excity.Australia/Hobart", "هوبارت" },
            { "timezone.excity.Australia/Sydney", "سيدني" },
            { "timezone.excity.Europe/Amsterdam", "أمستردام" },
            { "timezone.excity.Europe/Astrakhan", "أستراخان" },
            { "timezone.excity.Europe/Bucharest", "بوخارست" },
            { "timezone.excity.Europe/Gibraltar", "جبل طارق" },
            { "timezone.excity.Europe/Ljubljana", "ليوبليانا" },
            { "timezone.excity.Europe/Mariehamn", "ماريهامن" },
            { "timezone.excity.Europe/Podgorica", "بودغوريكا" },
            { "timezone.excity.Europe/Stockholm", "ستوكهولم" },
            { "timezone.excity.Europe/Ulyanovsk", "أوليانوفسك" },
            { "timezone.excity.Europe/Volgograd", "فولوجراد" },
            { "timezone.excity.Indian/Christmas", "كريسماس" },
            { "timezone.excity.Indian/Kerguelen", "كيرغويلين" },
            { "timezone.excity.Indian/Mauritius", "موريشيوس" },
            { "timezone.excity.Pacific/Auckland", "أوكلاند" },
            { "timezone.excity.Pacific/Funafuti", "فونافوتي" },
            { "timezone.excity.Pacific/Honolulu", "هونولولو" },
            { "timezone.excity.Pacific/Pitcairn", "بيتكيرن" },
            { "timezone.excity.Africa/Casablanca", "الدار البيضاء" },
            { "timezone.excity.Africa/Libreville", "ليبرفيل" },
            { "timezone.excity.Africa/Lubumbashi", "لومبباشا" },
            { "timezone.excity.Africa/Nouakchott", "نواكشوط" },
            { "timezone.excity.Africa/Porto-Novo", "بورتو نوفو" },
            { "timezone.excity.America/Anchorage", "أنشوراج" },
            { "timezone.excity.America/Araguaina", "أروجوانيا" },
            { "timezone.excity.America/Boa_Vista", "باو فيستا" },
            { "timezone.excity.America/Catamarca", "كاتاماركا" },
            { "timezone.excity.America/Chihuahua", "تشيواوا" },
            { "timezone.excity.America/Fortaleza", "فورتاليزا" },
            { "timezone.excity.America/Glace_Bay", "جلاس باي" },
            { "timezone.excity.America/Goose_Bay", "جوس باي" },
            { "timezone.excity.America/Guatemala", "غواتيمالا" },
            { "timezone.excity.America/Guayaquil", "غواياكويل" },
            { "timezone.excity.America/Matamoros", "ماتاموروس" },
            { "timezone.excity.America/Menominee", "مينوميني" },
            { "timezone.excity.America/Monterrey", "مونتيري" },
            { "timezone.excity.America/Sao_Paulo", "ساو باولو" },
            { "timezone.excity.America/St_Thomas", "سانت توماس" },
            { "timezone.excity.America/Vancouver", "فانكوفر" },
            { "timezone.excity.Antarctica/Mawson", "ماوسون" },
            { "timezone.excity.Antarctica/Palmer", "بالمير" },
            { "timezone.excity.Antarctica/Vostok", "فوستوك" },
            { "timezone.excity.Asia/Kuala_Lumpur", "كوالا لامبور" },
            { "timezone.excity.Asia/Novokuznetsk", "نوفوكوزنتسك" },
            { "timezone.excity.Europe/Bratislava", "براتيسلافا" },
            { "timezone.excity.Europe/Copenhagen", "كوبنهاغن" },
            { "timezone.excity.Europe/Luxembourg", "لوكسمبورغ" },
            { "timezone.excity.Europe/San_Marino", "سان مارينو" },
            { "timezone.excity.Europe/Simferopol", "سيمفروبول" },
            { "timezone.excity.Pacific/Enderbury", "اندربيرج" },
            { "timezone.excity.Pacific/Galapagos", "جلاباجوس" },
            { "timezone.excity.Pacific/Kwajalein", "كواجالين" },
            { "timezone.excity.Pacific/Marquesas", "ماركيساس" },
            { "timezone.excity.Pacific/Pago_Pago", "باغو باغو" },
            { "timezone.excity.Pacific/Rarotonga", "راروتونغا" },
            { "timezone.excity.Pacific/Tongatapu", "تونغاتابو" },
            { "timezone.excity.Africa/Addis_Ababa", "أديس أبابا" },
            { "timezone.excity.Africa/Brazzaville", "برازافيل" },
            { "timezone.excity.Africa/Ouagadougou", "واغادوغو" },
            { "timezone.excity.America/Costa_Rica", "كوستاريكا" },
            { "timezone.excity.America/Grand_Turk", "غراند ترك" },
            { "timezone.excity.America/Guadeloupe", "غوادلوب" },
            { "timezone.excity.America/Hermosillo", "هيرموسيلو" },
            { "timezone.excity.America/Kralendijk", "كرالنديك" },
            { "timezone.excity.America/Louisville", "لويس فيل" },
            { "timezone.excity.America/Martinique", "المارتينيك" },
            { "timezone.excity.America/Metlakatla", "ميتلاكاتلا" },
            { "timezone.excity.America/Montevideo", "مونتفيديو" },
            { "timezone.excity.America/Montserrat", "مونتسيرات" },
            { "timezone.excity.America/Paramaribo", "باراماريبو" },
            { "timezone.excity.America/Rio_Branco", "ريوبرانكو" },
            { "timezone.excity.America/St_Vincent", "سانت فنسنت" },
            { "timezone.excity.America/Whitehorse", "وايت هورس" },
            { "timezone.excity.Antarctica/McMurdo", "ماك موردو" },
            { "timezone.excity.Antarctica/Rothera", "روثيرا" },
            { "timezone.excity.Asia/Srednekolymsk", "سريدنكوليمسك" },
            { "timezone.excity.Asia/Yekaterinburg", "يكاترنبيرج" },
            { "timezone.excity.Atlantic/Reykjavik", "ريكيافيك" },
            { "timezone.excity.Atlantic/St_Helena", "سانت هيلينا" },
            { "timezone.excity.Australia/Adelaide", "أديليد" },
            { "timezone.excity.Australia/Brisbane", "برسيبان" },
            { "timezone.excity.Australia/Lindeman", "ليندمان" },
            { "timezone.excity.Europe/Isle_of_Man", "جزيرة مان" },
            { "timezone.excity.Europe/Kaliningrad", "كالينجراد" },
            { "timezone.excity.Pacific/Kiritimati", "كيريتي ماتي" },
            { "timezone.excity.Africa/Johannesburg", "جوهانسبرغ" },
            { "timezone.excity.America/El_Salvador", "السلفادور" },
            { "timezone.excity.America/Fort_Nelson", "فورت نيلسون" },
            { "timezone.excity.America/Los_Angeles", "لوس انجلوس" },
            { "timezone.excity.America/Mexico_City", "مكسيكو سيتي" },
            { "timezone.excity.America/Porto_Velho", "بورتو فيلو" },
            { "timezone.excity.America/Puerto_Rico", "بورتوريكو" },
            { "timezone.excity.America/Tegucigalpa", "تيغوسيغالبا" },
            { "timezone.excity.Arctic/Longyearbyen", "لونجيربين" },
            { "timezone.excity.Atlantic/Cape_Verde", "الرأس الأخضر" },
            { "timezone.excity.Australia/Lord_Howe", "لورد هاو" },
            { "timezone.excity.Australia/Melbourne", "ميلبورن" },
            { "timezone.excity.Indian/Antananarivo", "أنتاناناريفو" },
            { "timezone.excity.Pacific/Guadalcanal", "غوادالكانال" },
            { "timezone.excity.Africa/Dar_es_Salaam", "دار السلام" },
            { "timezone.excity.America/Blanc-Sablon", "بلانك-سابلون" },
            { "timezone.excity.America/Buenos_Aires", "بوينوس أيرس" },
            { "timezone.excity.America/Campo_Grande", "كومبو جراند" },
            { "timezone.excity.America/Danmarkshavn", "دانمرك شافن" },
            { "timezone.excity.America/Dawson_Creek", "داوسن كريك" },
            { "timezone.excity.America/Indiana/Knox", "كونكس" },
            { "timezone.excity.America/Indianapolis", "إنديانابوليس" },
            { "timezone.excity.America/Punta_Arenas", "بونتا أريناز" },
            { "timezone.excity.America/Rankin_Inlet", "رانكن انلت" },
            { "timezone.excity.America/Scoresbysund", "سكورسبيسند" },
            { "timezone.excity.Antarctica/Macquarie", "ماكواري" },
            { "timezone.excity.Pacific/Bougainville", "بوغانفيل" },
            { "timezone.excity.Pacific/Port_Moresby", "بور مورسبي" },
            { "timezone.excity.America/Cambridge_Bay", "كامبرديج باي" },
            { "timezone.excity.America/Ciudad_Juarez", "سيوداد خواريز" },
            { "timezone.excity.America/Coral_Harbour", "كورال هاربر" },
            { "timezone.excity.America/Indiana/Vevay", "فيفاي" },
            { "timezone.excity.America/Lower_Princes", "حي الأمير السفلي" },
            { "timezone.excity.America/Port_of_Spain", "بورت أوف سبين" },
            { "timezone.excity.America/Santo_Domingo", "سانتو دومينغو" },
            { "timezone.excity.America/St_Barthelemy", "سانت بارتيليمي" },
            { "timezone.excity.America/Swift_Current", "سوفت كارنت" },
            { "timezone.excity.Australia/Broken_Hill", "بروكن هيل" },
            { "timezone.excity.America/Bahia_Banderas", "باهيا بانديراس" },
            { "timezone.excity.America/Port-au-Prince", "بورت أو برنس" },
            { "timezone.excity.Atlantic/South_Georgia", "جورجيا الجنوبية" },
            { "timezone.excity.America/Argentina/Salta", "سالطا" },
            { "timezone.excity.America/Indiana/Marengo", "مارنجو" },
            { "timezone.excity.America/Indiana/Winamac", "ويناماك" },
            { "timezone.excity.America/Argentina/Tucuman", "تاكمان" },
            { "timezone.excity.America/Argentina/Ushuaia", "أشوا" },
            { "timezone.excity.America/Indiana/Tell_City", "مدينة تل، إنديانا" },
            { "timezone.excity.America/Indiana/Vincennes", "فينسينس" },
            { "timezone.excity.Antarctica/DumontDUrville", "دي مونت دو روفيل" },
            { "timezone.excity.America/Argentina/La_Rioja", "لا ريوجا" },
            { "timezone.excity.America/Argentina/San_Juan", "سان خوان" },
            { "timezone.excity.America/Argentina/San_Luis", "سان لويس" },
            { "timezone.excity.America/Indiana/Petersburg", "بيترسبرغ" },
            { "timezone.excity.America/Kentucky/Monticello", "مونتيسيلو" },
            { "timezone.excity.America/North_Dakota/Beulah", "بيولا، داكوتا الشمالية" },
            { "timezone.excity.America/North_Dakota/Center", "سنتر" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ريو جالييوس" },
            { "timezone.excity.America/North_Dakota/New_Salem", "نيو ساليم" },
        };
        return data;
    }
}
