/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputUtil;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011\u001a,\u0010\u0015\u001a\u00020\u000f*\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\",\u0010\u0007\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0018"}, d2={"hasFileMetadata", "", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "getHasFileMetadata", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;)Z", "value", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputCellMetadata;", "dataInputMetadata", "getDataInputMetadata", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;)Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputCellMetadata;", "setDataInputMetadata", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputCellMetadata;)V", "importFileMetadataOrDefault", "getImportFileMetadataOrDefault", "setFileInfo", "", "filePath", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "notebookPath", "setFileInfoUndoable", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.jupyter.core"})
public final class JupyterDataInputCellMetadataKt {
    public static final boolean getHasFileMetadata(@NotNull JupyterCell $this$hasFileMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFileMetadata, (String)"<this>");
        JupyterDataInputCellMetadata jupyterDataInputCellMetadata = JupyterDataInputCellMetadataKt.getDataInputMetadata($this$hasFileMetadata);
        return jupyterDataInputCellMetadata != null ? jupyterDataInputCellMetadata.hasFileMetadata() : false;
    }

    @Nullable
    public static final JupyterDataInputCellMetadata getDataInputMetadata(@NotNull JupyterCell $this$dataInputMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$dataInputMetadata, (String)"<this>");
        return (JupyterDataInputCellMetadata)JupyterJsonKt.getJackson().treeToValue((TreeNode)$this$dataInputMetadata.getMetadata("import_data_from_file"), JupyterDataInputCellMetadata.class);
    }

    public static final void setDataInputMetadata(@NotNull JupyterCell $this$dataInputMetadata, @Nullable JupyterDataInputCellMetadata value) {
        Intrinsics.checkNotNullParameter((Object)$this$dataInputMetadata, (String)"<this>");
        if (value == null) {
            $this$dataInputMetadata.removeMetadata("import_data_from_file");
        } else {
            JsonNode jsonNode = JupyterJsonKt.getJackson().valueToTree((Object)value);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"valueToTree(...)");
            $this$dataInputMetadata.setMetadata("import_data_from_file", jsonNode);
        }
    }

    @NotNull
    public static final JupyterDataInputCellMetadata getImportFileMetadataOrDefault(@NotNull JupyterCell $this$importFileMetadataOrDefault) {
        Intrinsics.checkNotNullParameter((Object)$this$importFileMetadataOrDefault, (String)"<this>");
        JupyterDataInputCellMetadata jupyterDataInputCellMetadata = JupyterDataInputCellMetadataKt.getDataInputMetadata($this$importFileMetadataOrDefault);
        if (jupyterDataInputCellMetadata == null) {
            jupyterDataInputCellMetadata = JupyterDataInputCellMetadata.Companion.getDefault();
        }
        return jupyterDataInputCellMetadata;
    }

    public static final void setFileInfo(@NotNull JupyterCell $this$setFileInfo, @Nullable Path filePath, @NotNull Project project, @NotNull Path notebookPath) {
        Intrinsics.checkNotNullParameter((Object)$this$setFileInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookPath, (String)"notebookPath");
        Object object = JupyterDataInputCellMetadataKt.getDataInputMetadata($this$setFileInfo);
        if (object == null || (object = ((JupyterDataInputCellMetadata)object).getVariableName()) == null) {
            JupyterDataInputCellTableMetadata jupyterDataInputCellTableMetadata = JupyterDataInputCellTableMetadataKt.getDataInputTableMetadata($this$setFileInfo);
            object = jupyterDataInputCellTableMetadata != null ? jupyterDataInputCellTableMetadata.getVariableName() : null;
        }
        Object varName = object;
        JupyterDataInputCellMetadataKt.setDataInputMetadata($this$setFileInfo, JupyterDataInputCellMetadata.Companion.create(filePath, (String)varName, project, notebookPath));
        JupyterDataInputCellTableMetadataKt.setDataInputTableMetadata($this$setFileInfo, null);
    }

    public static final void setFileInfoUndoable(@NotNull JupyterCell $this$setFileInfoUndoable, @Nullable Path filePath, @NotNull Project project, @NotNull Path notebookPath, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$setFileInfoUndoable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookPath, (String)"notebookPath");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        CommandProcessor.getInstance().executeCommand(project, () -> JupyterDataInputCellMetadataKt.setFileInfoUndoable$lambda$1($this$setFileInfoUndoable, project, document, filePath, notebookPath), null, null, document);
    }

    private static final Unit setFileInfoUndoable$lambda$1$lambda$0(JupyterCell $this_setFileInfoUndoable, Path $filePath, Project $project, Path $notebookPath) {
        JupyterDataInputCellMetadataKt.setFileInfo($this_setFileInfoUndoable, $filePath, $project, $notebookPath);
        return Unit.INSTANCE;
    }

    private static final void setFileInfoUndoable$lambda$1(JupyterCell $this_setFileInfoUndoable, Project $project, Document $document, Path $filePath, Path $notebookPath) {
        JupyterDataInputUtil.INSTANCE.setDataInfoUndoable($this_setFileInfoUndoable, $project, $document, (Function0<Unit>)((Function0)() -> JupyterDataInputCellMetadataKt.setFileInfoUndoable$lambda$1$lambda$0($this_setFileInfoUndoable, $filePath, $project, $notebookPath)));
    }
}

