/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.jupyter.core.editor.handlers.DataInputCodeGenerationContext;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandler;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandlerContext;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadataKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookConverter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputNotebookConverter;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookConverter;", "<init>", "()V", "convertAfterLoading", "", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "convertBeforeSave", "notebookCopy", "generateSourceByMetadata", "", "metadata", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputCellMetadata;", "generationContext", "Lcom/intellij/jupyter/core/editor/handlers/DataInputCodeGenerationContext;", "Companion", "intellij.jupyter.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJupyterDataInputNotebookConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDataInputNotebookConverter.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputNotebookConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class JupyterDataInputNotebookConverter
implements JupyterNotebookConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SQL_SOURCE_PREFIX = "%%sql";

    @Override
    public void convertAfterLoading(@NotNull JupyterNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        for (JupyterCell cell : notebook.computeCells()) {
            boolean shouldConvert;
            JupyterDataInputCellMetadata metadata;
            if (cell.getCellType() != JupyterCellType.CODE) continue;
            if (JupyterDataInputCellTableMetadataKt.getHasTableMetadata(cell) && StringsKt.startsWith$default((String)cell.getSource(), (String)SQL_SOURCE_PREFIX, (boolean)false, (int)2, null)) {
                cell.setCellType(JupyterCellType.DATA_INPUT);
                String[] stringArray = new String[]{"\n"};
                cell.setSource(CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)cell.getSource(), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                continue;
            }
            if (JupyterDataInputCellMetadataKt.getDataInputMetadata(cell) == null) continue;
            String expectedSource = this.generateSourceByMetadata(notebook, metadata, DataInputCodeGenerationContext.AFTER_LOADING);
            boolean bl = expectedSource == null ? Intrinsics.areEqual((Object)cell.getSource(), (Object)"") : (shouldConvert = Intrinsics.areEqual((Object)expectedSource, (Object)cell.getSource()));
            if (shouldConvert) {
                cell.setCellType(JupyterCellType.DATA_INPUT);
                cell.setSource("");
                continue;
            }
            JupyterDataInputCellMetadataKt.setDataInputMetadata(cell, null);
        }
    }

    @Override
    public void convertBeforeSave(@NotNull JupyterNotebook notebookCopy) {
        Intrinsics.checkNotNullParameter((Object)notebookCopy, (String)"notebookCopy");
        for (JupyterCell cell : notebookCopy.computeCells()) {
            JupyterDataInputCellMetadata metadata;
            String string;
            if (cell.getCellType() != JupyterCellType.DATA_INPUT) continue;
            cell.setCellType(JupyterCellType.CODE);
            if (JupyterDataInputCellTableMetadataKt.getHasTableMetadata(cell)) {
                String tableName;
                JupyterDataInputCellTableMetadata jupyterDataInputCellTableMetadata = JupyterDataInputCellTableMetadataKt.getDataInputTableMetadata(cell);
                String string2 = tableName = jupyterDataInputCellTableMetadata != null ? jupyterDataInputCellTableMetadata.getTableName() : null;
                if (tableName != null) {
                    String query = "# SELECT * FROM " + tableName;
                    cell.setSource("%%sql\n" + query);
                    continue;
                }
                cell.setSource("%%sql\n" + cell.getSource());
                continue;
            }
            JupyterDataInputCellMetadata jupyterDataInputCellMetadata = JupyterDataInputCellMetadataKt.getDataInputMetadata(cell);
            if (jupyterDataInputCellMetadata == null) {
                JupyterDataInputCellMetadata jupyterDataInputCellMetadata2;
                JupyterDataInputCellMetadata it = jupyterDataInputCellMetadata2 = JupyterDataInputCellMetadata.Companion.getDefault();
                boolean bl = false;
                JupyterDataInputCellMetadataKt.setDataInputMetadata(cell, it);
                jupyterDataInputCellMetadata = jupyterDataInputCellMetadata2;
            }
            if ((string = this.generateSourceByMetadata(notebookCopy, metadata = jupyterDataInputCellMetadata, DataInputCodeGenerationContext.BEFORE_SAVE)) == null) {
                string = "";
            }
            cell.setSource(string);
        }
    }

    private final String generateSourceByMetadata(JupyterNotebook notebook, JupyterDataInputCellMetadata metadata, DataInputCodeGenerationContext generationContext) {
        if (metadata.getVariableName() == null) {
            return null;
        }
        if (metadata.getNotebookRelativedFilePath() == null) {
            return null;
        }
        String extension = StringsKt.substringAfterLast((String)metadata.getNotebookRelativedFilePath(), (char)'.', (String)"");
        TableDataFileDropHandler tableDataFileDropHandler = TableDataFileDropHandler.Companion.findApplicable(notebook, extension);
        if (tableDataFileDropHandler == null) {
            return null;
        }
        TableDataFileDropHandler tableDataFileDropHandler2 = tableDataFileDropHandler;
        String string = metadata.getNotebookRelativedFilePath();
        String string2 = metadata.getVariableName();
        return tableDataFileDropHandler2.generateCellCode(new TableDataFileDropHandlerContext(string, extension, null, generationContext, 0, string2));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputNotebookConverter$Companion;", "", "<init>", "()V", "SQL_SOURCE_PREFIX", "", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

