---
title: pixi tree
---
<!--- This file is autogenerated. Do not edit manually! -->
# [pixi](../pixi.md) tree

Show a tree of workspace dependencies

--8<-- "docs/reference/cli/pixi/tree_extender:description"

## Usage
```
pixi tree [OPTIONS] [REGEX]
```

## Arguments
- <a id="arg-<REGEX>" href="#arg-<REGEX>">`<REGEX>`</a>
:  List only packages matching a regular expression

## Options
- <a id="arg---platform" href="#arg---platform">`--platform (-p) <PLATFORM>`</a>
:  The platform to list packages for. Defaults to the current platform
- <a id="arg---environment" href="#arg---environment">`--environment (-e) <ENVIRONMENT>`</a>
:  The environment to list packages for. Defaults to the default environment
- <a id="arg---invert" href="#arg---invert">`--invert (-i)`</a>
:  Invert tree and show what depends on given package in the regex argument

## Update Options
- <a id="arg---frozen" href="#arg---frozen">`--frozen`</a>
:  Install the environment as defined in the lockfile, doesn't update lockfile if it isn't up-to-date with the manifest file
<br>**env**: `PIXI_FROZEN`
- <a id="arg---locked" href="#arg---locked">`--locked`</a>
:  Check if lockfile is up-to-date before installing the environment, aborts when lockfile isn't up-to-date with the manifest file
<br>**env**: `PIXI_LOCKED`
- <a id="arg---no-install" href="#arg---no-install">`--no-install`</a>
:  Don't modify the environment, only modify the lock-file

## Global Options
- <a id="arg---manifest-path" href="#arg---manifest-path">`--manifest-path (-m) <MANIFEST_PATH>`</a>
:  The path to `pixi.toml`, `pyproject.toml`, or the workspace directory

## Description
Show a tree of workspace dependencies

Dependency names highlighted in green are directly specified in the manifest. Yellow version numbers are conda packages, PyPI version numbers are blue.


--8<-- "docs/reference/cli/pixi/tree_extender:example"
