#![allow(dead_code)]
#![allow(unused_imports)]
/*
Copyright © 2013 Free Software Foundation, Inc
See licensing in LICENSE file

File: ll.rs
Author: Jesse 'Jeaye' Wilkerson
Description:
Low-level interface to foreign
ncurses functions.
 */

use libc::{ c_char, c_int, c_short, c_uint, c_ulong, c_void, FILE };

pub type c_bool = ::libc::c_uchar;

/* Intrinsic types. */
#[cfg(feature="wide_chtype")]
pub type chtype = u64;
#[cfg(not(feature="wide_chtype"))]
pub type chtype = u32;
pub type winttype = c_uint;

pub type mmask_t = chtype;
pub type attr_t = chtype;
pub type NCURSES_ATTR_T = attr_t;

/* Pointer types. */
pub type attr_t_p = *mut attr_t;
pub type short_p = *mut c_short;
pub type int_p = *mut c_int;
pub type void_p = *const c_void;
pub type char_p = *const c_char;
pub type chtype_p = *const chtype;
pub type WINDOW = *mut i8;
pub type SCREEN = *mut i8;
pub type FILE_p = *mut FILE;
pub type va_list = *mut u8;

/* Custom Types. */
#[repr(C)]
#[derive(Debug, Clone, Copy)]
pub struct MEVENT { pub id: c_short, pub x: c_int, pub y: c_int, pub z: c_int, pub bstate: mmask_t}

extern {
    pub fn addch(_:chtype) -> c_int;
    pub fn addchnstr(_:*const chtype, _:c_int) -> c_int;
    pub fn addchstr(_:*const chtype) -> c_int;
    pub fn addnstr(_:*const c_char, _:c_int) -> c_int;
    pub fn addstr(_:*const c_char) -> c_int;
    pub fn assume_default_colors(_:c_int, _:c_int) -> c_int;
    pub fn attroff(_:NCURSES_ATTR_T) -> c_int;
    pub fn attron(_:NCURSES_ATTR_T) -> c_int;
    pub fn attrset(_:NCURSES_ATTR_T) -> c_int;
    pub fn attr_get(_:attr_t_p, _:short_p, _:void_p) -> c_int;
    pub fn attr_off(_:attr_t, _:void_p) -> c_int;
    pub fn attr_on(_:attr_t, _:void_p) -> c_int;
    pub fn attr_set(_:attr_t, _:c_short, _:void_p) -> c_int;
    pub fn baudrate() -> c_int;
    pub fn beep() -> c_int;
    pub fn bkgd(_:chtype) -> c_int;
    pub fn bkgdset(_:chtype);
    pub fn border(_:chtype,_:chtype,_:chtype,_:chtype,_:chtype,_:chtype,_:chtype,_:chtype) -> c_int;
    pub fn box_(_:WINDOW, _:chtype, _:chtype) -> c_int;
    pub fn can_change_color() -> c_bool;
    pub fn cbreak() -> c_int;
    pub fn chgat(_:c_int, _:attr_t, _:c_short, _:void_p) -> c_int;
    pub fn clear() -> c_int;
    pub fn clearok(_:WINDOW,_:c_bool) -> c_int;
    pub fn clrtobot() -> c_int;
    pub fn clrtoeol() -> c_int;
    pub fn color_content(_:c_short,_:short_p,_:short_p,_:short_p) -> c_int;
    pub fn color_set(_:c_short,_:void_p) -> c_int;
    pub fn COLOR_PAIR(_:c_int) -> c_int;
    pub fn copywin(_:WINDOW,_:WINDOW,_:c_int,_:c_int,_:c_int,_:c_int,_:c_int,_:c_int,_:c_int) -> c_int;
    pub fn curs_set(_:c_int) -> c_int;
    pub fn def_prog_mode() -> c_int;
    pub fn def_shell_mode() -> c_int;
    pub fn delay_output(_:c_int) -> c_int;
    pub fn delch() -> c_int;
    pub fn delscreen(_:SCREEN);
    pub fn delwin(_:WINDOW) -> c_int;
    pub fn deleteln() -> c_int;
    pub fn derwin(_:WINDOW,_:c_int,_:c_int,_:c_int,_:c_int) -> WINDOW;
    pub fn doupdate() -> c_int;
    pub fn dupwin(_:WINDOW) -> WINDOW;
    pub fn echo() -> c_int;
    pub fn echochar(_:chtype) -> c_int;
    pub fn erase() -> c_int;
    pub fn endwin() -> c_int;
    pub fn erasechar() -> c_char;
    pub fn filter();
    pub fn flash() -> c_int;
    pub fn flushinp() -> c_int;
    pub fn getbkgd(_:WINDOW) -> chtype;
    pub fn getch() -> c_int;
    pub fn getnstr(_:*mut c_char, _:c_int) -> c_int;
    pub fn getstr(_:char_p) -> c_int;
    pub fn getwin(_:FILE_p) -> WINDOW;
    pub fn halfdelay(_:c_int) -> c_int;
    pub fn has_colors() -> c_bool;
    pub fn has_ic() -> c_bool;
    pub fn has_il() -> c_bool;
    pub fn hline(_:chtype, _:c_int) -> c_int;
    pub fn idcok(_:WINDOW, _:c_bool);
    pub fn idlok(_:WINDOW, _:c_bool) -> c_int;
    pub fn immedok(_:WINDOW, _:c_bool);
    pub fn inch() -> chtype;
    pub fn inchnstr(_:chtype_p, _:c_int) -> c_int;
    pub fn inchstr(_:chtype_p) -> c_int;
    pub fn initscr() -> WINDOW;
    pub fn init_color(_:c_short,_:c_short,_:c_short,_:c_short) -> c_int;
    pub fn init_pair(_:c_short,_:c_short,_:c_short) -> c_int;
    pub fn innstr(_:char_p, _:c_int) -> c_int;
    pub fn insch(_:chtype) -> c_int;
    pub fn insdelln(_:c_int) -> c_int;
    pub fn insertln() -> c_int;
    pub fn insnstr(_:char_p, _:c_int) -> c_int;
    pub fn insstr(_:char_p) -> c_int;
    pub fn instr(_:char_p) -> c_int;
    pub fn intrflush(_:WINDOW,_:c_bool) -> c_int;
    pub fn isendwin() -> c_bool;
    pub fn is_linetouched(_:WINDOW,_:c_int) -> c_bool;
    pub fn is_term_resized(_:c_int, _:c_int) -> c_bool;
    pub fn is_wintouched(_:WINDOW) -> c_bool;
    pub fn keyname(_:c_int) -> *const c_char;
    pub fn keypad(_:WINDOW, _:c_bool) -> c_int;
    pub fn killchar() -> c_char;
    pub fn leaveok(_:WINDOW,_:c_bool) -> c_int;
    pub fn longname() -> *mut c_char;
    pub fn meta(_:WINDOW,_:c_bool) -> c_int;
    #[link_name = "move"]
    pub fn mv(_:c_int, _:c_int) -> c_int;
    pub fn mvaddch(_:c_int, _:c_int, _:chtype) -> c_int;
    pub fn mvaddchnstr(_:c_int, _:c_int, _:chtype_p, _:c_int) -> c_int;
    pub fn mvaddchstr(_:c_int, _:c_int, _:chtype_p) -> c_int;
    pub fn mvaddnstr(_:c_int, _:c_int, _:char_p, _:c_int) -> c_int;
    pub fn mvaddstr(_:c_int, _:c_int, _:char_p) -> c_int;
    pub fn mvchgat(_:c_int, _:c_int, _:c_int, _:attr_t, _:c_short, _:void_p) -> c_int;
    pub fn mvcur(_:c_int,_:c_int,_:c_int,_:c_int) -> c_int;
    pub fn mvdelch(_:c_int, _:c_int) -> c_int;
    pub fn mvderwin(_:WINDOW, _:c_int, _:c_int) -> c_int;
    pub fn mvgetch(_:c_int, _:c_int) -> c_int;
    pub fn mvgetnstr(_:c_int, _:c_int, _:char_p, _:c_int) -> c_int;
    pub fn mvgetstr(_:c_int, _:c_int, _:char_p) -> c_int;
    pub fn mvhline(_:c_int, _:c_int, _:chtype, _:c_int) -> c_int;
    pub fn mvinch(_:c_int, _:c_int) -> chtype;
    pub fn mvinchnstr(_:c_int, _:c_int, _:chtype_p, _:c_int) -> c_int;
    pub fn mvinchstr(_:c_int, _:c_int, _:chtype_p) -> c_int;
    pub fn mvinnstr(_:c_int, _:c_int, _:char_p, _:c_int) -> c_int;
    pub fn mvinsch(_:c_int, _:c_int, _:chtype) -> c_int;
    pub fn mvinsnstr(_:c_int, _:c_int, _:char_p, _:c_int) -> c_int;
    pub fn mvinsstr(_:c_int, _:c_int, _:char_p) -> c_int;
    pub fn mvinstr(_:c_int, _:c_int, _:char_p) -> c_int;
    pub fn mvprintw(_:c_int, _:c_int, fmt: char_p, _:char_p) -> c_int;
    //  fn mvscanw(_:c_int,_:c_int, _:char_p) -> c_int;
    pub fn mvvline(_:c_int, _:c_int, _:chtype, _:c_int) -> c_int;
    pub fn mvwaddch(_:WINDOW, _:c_int, _:c_int, _:chtype) -> c_int;
    pub fn mvwaddchnstr(_:WINDOW, _:c_int, _:c_int, _:chtype_p, _:c_int) -> c_int;
    pub fn mvwaddchstr(_:WINDOW, _:c_int, _:c_int, _:chtype_p) -> c_int;
    pub fn mvwaddnstr(_:WINDOW, _:c_int, _:c_int, _:char_p, _:c_int) -> c_int;
    pub fn mvwaddstr(_:WINDOW, _:c_int, _:c_int, _:char_p) -> c_int;
    pub fn mvwchgat(_:WINDOW, _:c_int, _:c_int, _:c_int, _:attr_t, _:c_short, _:void_p) -> c_int;
    pub fn mvwdelch(_:WINDOW, _:c_int, _:c_int) -> c_int;
    pub fn mvwgetch(_:WINDOW, _:c_int, _:c_int) -> c_int;
    pub fn mvwgetnstr(_:WINDOW, _:c_int, _:c_int, _:char_p, _:c_int) -> c_int;
    pub fn mvwgetstr(_:WINDOW, _:c_int, _:c_int, _:char_p) -> c_int;
    pub fn mvwhline(_:WINDOW, _:c_int, _:c_int, _:chtype, _:c_int) -> c_int;
    pub fn mvwin(_:WINDOW,_:c_int,_:c_int) -> c_int;
    pub fn mvwinch(_:WINDOW, _:c_int, _:c_int) -> chtype;
    pub fn mvwinchnstr(_:WINDOW, _:c_int, _:c_int, _:chtype_p, _:c_int) -> c_int;
    pub fn mvwinchstr(_:WINDOW, _:c_int, _:c_int, _:chtype_p) -> c_int;
    pub fn mvwinnstr(_:WINDOW, _:c_int, _:c_int, _:char_p, _:c_int) -> c_int;
    pub fn mvwinsch(_:WINDOW, _:c_int, _:c_int, _:chtype) -> c_int;
    pub fn mvwinsnstr(_:WINDOW, _:c_int, _:c_int, _:char_p, _:c_int) -> c_int;
    pub fn mvwinsstr(_:WINDOW, _:c_int, _:c_int, _:char_p) -> c_int;
    pub fn mvwinstr(_:WINDOW, _:c_int, _:c_int, _:char_p) -> c_int;
    pub fn mvwprintw(_:WINDOW, _:c_int, _:c_int, fmt: char_p, _:char_p) -> c_int;

    //  fn mvwscanw(_:WINDOW, _:c_int, _:c_int, _:char_p) -> c_int;
    pub fn mvwvline(_:WINDOW, _:c_int, _:c_int, _:chtype, _:c_int) -> c_int;
    pub fn napms(_:c_int) -> c_int;
    pub fn newpad(_:c_int,_:c_int) -> WINDOW;
    pub fn newterm(_:char_p,_:FILE_p,_:FILE_p) -> SCREEN;
    pub fn newwin(_:c_int,_:c_int,_:c_int,_:c_int) -> WINDOW;
    pub fn nl() -> c_int;
    pub fn nocbreak() -> c_int;
    pub fn nodelay(_:WINDOW,_:c_bool) -> c_int;
    pub fn noecho() -> c_int;
    pub fn nonl() -> c_int;
    pub fn noqiflush();
    pub fn noraw() -> c_int;
    pub fn notimeout(_:WINDOW,_:c_bool) -> c_int;
    pub fn overlay(_:WINDOW,_:WINDOW) -> c_int;
    pub fn overwrite(_:WINDOW,_:WINDOW) -> c_int;
    pub fn pair_content(_:c_short,_:short_p,_:short_p) -> c_int;
    pub fn PAIR_NUMBER(_:c_int) -> c_int;
    pub fn pechochar(_:WINDOW, _:chtype) -> c_int;
    pub fn pnoutrefresh(_:WINDOW,_:c_int,_:c_int,_:c_int,_:c_int,_:c_int,_:c_int) -> c_int;
    pub fn prefresh(_:WINDOW,_:c_int,_:c_int,_:c_int,_:c_int,_:c_int,_:c_int) -> c_int;

    pub fn printw(fmt: char_p, _:char_p) -> c_int;
    pub fn putwin(_:WINDOW, _:FILE_p) -> c_int;
    pub fn qiflush();
    pub fn raw() -> c_int;
    pub fn redrawwin(_:WINDOW) -> c_int;
    pub fn refresh() -> c_int;
    pub fn resizeterm(_:c_int, _:c_int) -> c_int;
    pub fn resize_term(_:c_int, _:c_int) -> c_int;
    pub fn resetty() -> c_int;
    pub fn reset_prog_mode() -> c_int;
    pub fn reset_shell_mode() -> c_int;
    // fn ripoffline(_:c_int, extern  fn f(WINDOW, c_int) -> c_int) -> c_int;
    pub fn savetty() -> c_int;
    // fn scanw(_:NCURSES_CONST char_p,...) -> c_int;
    pub fn scr_dump(_:char_p) -> c_int;
    pub fn scr_init(_:char_p) -> c_int;
    pub fn scrl(_:c_int) -> c_int;
    pub fn scroll(_:WINDOW) -> c_int;
    pub fn scrollok(_:WINDOW,_:c_bool) -> c_int;
    pub fn scr_restore(_:char_p) -> c_int;
    pub fn scr_set(_:char_p) -> c_int;
    pub fn setscrreg(_:c_int,_:c_int) -> c_int;
    pub fn set_term(_:SCREEN) -> SCREEN;
    pub fn set_escdelay(_:c_int) -> c_int;
    pub fn set_tabsize(_:c_int) -> c_int;
    pub fn slk_attroff(_:chtype) -> c_int;
    pub fn slk_attr_off(_:attr_t, _:void_p) -> c_int;
    pub fn slk_attron(_:chtype) -> c_int;
    pub fn slk_attr_on(_:attr_t,_:void_p) -> c_int;
    pub fn slk_attrset(_:chtype) -> c_int;
    pub fn slk_attr() -> attr_t;
    pub fn slk_attr_set(_:attr_t,_:c_short,_:void_p) -> c_int;
    pub fn slk_clear() -> c_int;
    pub fn slk_color(_:c_short) -> c_int;
    pub fn slk_init(_:c_int) -> c_int;
    pub fn slk_label(_:c_int) -> char_p;
    pub fn slk_noutrefresh() -> c_int;
    pub fn slk_refresh() -> c_int;
    pub fn slk_restore() -> c_int;
    pub fn slk_set(_:c_int,_:char_p,_:c_int) -> c_int;
    pub fn slk_touch() -> c_int;
    pub fn standout() -> c_int;
    pub fn standend() -> c_int;
    pub fn start_color() -> c_int;
    pub fn subpad(_:WINDOW, _:c_int, _:c_int, _:c_int, _:c_int) -> WINDOW;
    pub fn subwin(_:WINDOW, _:c_int, _:c_int, _:c_int, _:c_int) -> WINDOW;
    pub fn syncok(_:WINDOW, _:c_bool) -> c_int;
    pub fn termattrs() -> chtype;
    pub fn termname() -> char_p;
    pub fn timeout(_:c_int);
    pub fn touchline(_:WINDOW, _:c_int, _:c_int) -> c_int;
    pub fn touchwin(_:WINDOW) -> c_int;
    pub fn typeahead(_:c_int) -> c_int;
    pub fn ungetch(_:c_int) -> c_int;
    pub fn untouchwin(_:WINDOW) -> c_int;
    pub fn use_env(_:c_bool);
    pub fn use_default_colors() -> c_int;
    pub fn vidattr(_:chtype) -> c_int;
    //  fn vidputs(_:chtype, extern  fn f(c_int) -> c_int) -> c_int;
    //pub fn vidputs(_:chtype, f:*mut c_char) -> c_int;
    pub fn vline(_:chtype, _:c_int) -> c_int;
    pub fn vwprintw(_:WINDOW, _:char_p, _:va_list) -> c_int;
    pub fn vw_printw(_:WINDOW, _:char_p,_:va_list) -> c_int;
    //  fn vwscanw(_:WINDOW, _:char_p, _:va_list) -> c_int;
    //  fn vw_scanw(_:WINDOW, _:char_p, _:va_list) -> c_int;
    pub fn waddch(_:WINDOW, _:chtype) -> c_int;
    pub fn waddchnstr(_:WINDOW,_:chtype_p,_:c_int) -> c_int;
    pub fn waddchstr(_:WINDOW,_:chtype_p) -> c_int;
    pub fn waddnstr(_:WINDOW,_:char_p,_:c_int) -> c_int;
    pub fn waddstr(_:WINDOW,_:char_p) -> c_int;
    pub fn wattron(_:WINDOW, _:NCURSES_ATTR_T) -> c_int;
    pub fn wattroff(_:WINDOW, _:NCURSES_ATTR_T) -> c_int;
    pub fn wattrset(_:WINDOW, _:NCURSES_ATTR_T) -> c_int;
    pub fn wattr_get(_:WINDOW, _:attr_t_p, _:short_p, _:void_p) -> c_int;
    pub fn wattr_on(_:WINDOW, _:attr_t, _:void_p) -> c_int;
    pub fn wattr_off(_:WINDOW, _:attr_t, _:void_p) -> c_int;
    pub fn wattr_set(_:WINDOW, _:attr_t, _:c_short, _:void_p) -> c_int;
    pub fn wbkgd(_:WINDOW, _:chtype) -> c_int;
    pub fn wbkgdset(_:WINDOW,_:chtype);
    pub fn wborder(_:WINDOW,_:chtype,_:chtype,_:chtype,_:chtype,_:chtype,_:chtype,_:chtype,_:chtype) -> c_int;
    pub fn wchgat(_:WINDOW, _:c_int, _:attr_t, _:c_short, _:void_p) -> c_int;
    pub fn wclear(_:WINDOW) -> c_int;
    pub fn wclrtobot(_:WINDOW) -> c_int;
    pub fn wclrtoeol(_:WINDOW) -> c_int;
    pub fn wcolor_set(_:WINDOW,_:c_short,_:void_p) -> c_int;
    pub fn wcursyncup(_:WINDOW);
    pub fn wdelch(_:WINDOW) -> c_int;
    pub fn wdeleteln(_:WINDOW) -> c_int;
    pub fn wechochar(_:WINDOW, _:chtype) -> c_int;
    pub fn werase(_:WINDOW) -> c_int;
    pub fn wgetch(_:WINDOW) -> c_int;
    pub fn wget_wch(_:WINDOW, _:*mut winttype) -> c_int;
    pub fn mvwget_wch(_:WINDOW, _:c_int, _:c_int, _:*mut winttype) -> c_int;
    pub fn mvget_wch(_:c_int, _: c_int, _:*mut winttype) -> c_int;
    pub fn get_wch(_:*mut winttype) -> c_int;
    pub fn unget_wch(_:winttype) -> c_int;
    pub fn wgetnstr(_:WINDOW,_:*const u8,_:c_int) -> c_int;
    pub fn wgetstr(_:WINDOW, _:char_p) -> c_int;
    pub fn whline(_:WINDOW, _:chtype, _:c_int) -> c_int;
    pub fn winch(_:WINDOW) -> chtype;
    pub fn winchnstr(_:WINDOW, _:chtype_p, _:c_int) -> c_int;
    pub fn winchstr(_:WINDOW, _:chtype_p) -> c_int;
    pub fn winnstr(_:WINDOW, _:char_p, _:c_int) -> c_int;
    pub fn winsch(_:WINDOW, _:chtype) -> c_int;
    pub fn winsdelln(_:WINDOW,_:c_int) -> c_int;
    pub fn winsertln(_:WINDOW) -> c_int;
    pub fn winsnstr(_:WINDOW, _:char_p,_:c_int) -> c_int;
    pub fn winsstr(_:WINDOW, _:char_p) -> c_int;
    pub fn winstr(_:WINDOW, _:char_p) -> c_int;
    pub fn wmove(_:WINDOW,_:c_int,_:c_int) -> c_int;
    pub fn wnoutrefresh(_:WINDOW) -> c_int;
    pub fn wprintw(_:WINDOW, fmt: char_p, _:char_p) -> c_int;
    pub fn wredrawln(_:WINDOW,_:c_int,_:c_int) -> c_int;
    pub fn wrefresh(_:WINDOW) -> c_int;
    pub fn wresize(_:WINDOW, _:c_int, _:c_int) -> c_int;
    //  fn wscanw(_:WINDOW, _:NCURSES_CONST char_p) -> c_int;
    pub fn wscrl(_:WINDOW,_:c_int) -> c_int;
    pub fn wsetscrreg(_:WINDOW,_:c_int,_:c_int) -> c_int;
    pub fn wstandout(_:WINDOW) -> c_int;
    pub fn wstandend(_:WINDOW) -> c_int;
    pub fn wsyncdown(_:WINDOW);
    pub fn wsyncup(_:WINDOW);
    pub fn wtimeout(_:WINDOW,_:c_int);
    pub fn wtouchln(_:WINDOW,_:c_int,_:c_int,_:c_int) -> c_int;
    pub fn wvline(_:WINDOW,_:chtype,_:c_int) -> c_int;

    /*
     * These are also declared in <term.h>:
     */
    pub fn tigetflag(_:char_p) -> c_int;
    pub fn tigetnum(_:char_p) -> c_int;
    pub fn tigetstr(_:char_p) -> *mut c_char;
    pub fn putp(_:char_p) -> c_int;

    pub fn tparm(_:char_p) -> *mut c_char;

    /*
     * These functions are not in X/Open, but we use them in macro definitions:
     */
    pub fn getattrs(_:WINDOW) -> c_int;
    pub fn getcurx(_:WINDOW) -> c_int;
    pub fn getcury(_:WINDOW) -> c_int;
    pub fn getbegx(_:WINDOW) -> c_int;
    pub fn getbegy(_:WINDOW) -> c_int;
    pub fn getmaxx(_:WINDOW) -> c_int;
    pub fn getmaxy(_:WINDOW) -> c_int;
    pub fn getparx(_:WINDOW) -> c_int;
    pub fn getpary(_:WINDOW) -> c_int;

    /*
     * These extensions provide access to information stored in the WINDOW even
     * when NCURSES_OPAQUE is set:
     */
    pub fn wgetparent(_:WINDOW) -> WINDOW;
    pub fn is_cleared(_:WINDOW) -> c_bool;
    pub fn is_idcok(_:WINDOW) -> c_bool;
    pub fn is_idlok(_:WINDOW) -> c_bool;
    pub fn is_immedok(_:WINDOW) -> c_bool;
    pub fn is_keypad(_:WINDOW) -> c_bool;
    pub fn is_leaveok(_:WINDOW) -> c_bool;
    pub fn is_nodelay(_:WINDOW) -> c_bool;
    pub fn is_notimeout(_:WINDOW) -> c_bool;
    pub fn is_scrollok(_:WINDOW) -> c_bool;
    pub fn is_syncok(_:WINDOW) -> c_bool;
    pub fn wgetscrreg(_:WINDOW, _:*mut c_int, _:*mut c_int) -> c_int;
    /*
     * Added mouse support
     */
    pub fn has_mouse() -> c_bool;
    pub fn getmouse(_:*mut MEVENT) -> c_int;
    pub fn ungetmouse(_:*mut MEVENT) -> c_int;
    pub fn mousemask(_:mmask_t,_:*mut mmask_t) -> mmask_t;
    pub fn wenclose(_:WINDOW,_:c_int,_:c_int) -> c_bool;
    pub fn mouseinterval(_:c_int) -> c_int;
    pub fn wmouse_trafo(_:WINDOW,_:*mut c_int,_:*mut c_int,_:c_bool) -> c_bool;
    pub fn mouse_trafo(_:*mut c_int,_:*mut c_int,_:c_bool) -> c_bool;

    pub fn impl_ACS_ULCORNER() -> chtype;
    pub fn impl_ACS_LLCORNER() -> chtype;
    pub fn impl_ACS_URCORNER() -> chtype;
    pub fn impl_ACS_LRCORNER() -> chtype;
    pub fn impl_ACS_LTEE() -> chtype;
    pub fn impl_ACS_RTEE() -> chtype;
    pub fn impl_ACS_BTEE() -> chtype;
    pub fn impl_ACS_TTEE() -> chtype;
    pub fn impl_ACS_HLINE() -> chtype;
    pub fn impl_ACS_VLINE() -> chtype;
    pub fn impl_ACS_PLUS() -> chtype;
    pub fn impl_ACS_S1() -> chtype;
    pub fn impl_ACS_S9() -> chtype;
    pub fn impl_ACS_DIAMOND() -> chtype;
    pub fn impl_ACS_CKBOARD() -> chtype;
    pub fn impl_ACS_DEGREE() -> chtype;
    pub fn impl_ACS_PLMINUS() -> chtype;
    pub fn impl_ACS_BULLET() -> chtype;
    pub fn impl_ACS_LARROW() -> chtype;
    pub fn impl_ACS_RARROW() -> chtype;
    pub fn impl_ACS_DARROW() -> chtype;
    pub fn impl_ACS_UARROW() -> chtype;
    pub fn impl_ACS_BOARD() -> chtype;
    pub fn impl_ACS_LANTERN() -> chtype;
    pub fn impl_ACS_BLOCK() -> chtype;
    pub fn impl_ACS_S3() -> chtype;
    pub fn impl_ACS_S7() -> chtype;
    pub fn impl_ACS_LEQUAL() -> chtype;
    pub fn impl_ACS_GEQUAL() -> chtype;
    pub fn impl_ACS_PI() -> chtype;
    pub fn impl_ACS_NEQUAL() -> chtype;
    pub fn impl_ACS_STERLING() -> chtype;
    pub fn impl_ACS_BSSB() -> chtype;
    pub fn impl_ACS_SSBB() -> chtype;
    pub fn impl_ACS_BBSS() -> chtype;
    pub fn impl_ACS_SBBS() -> chtype;
    pub fn impl_ACS_SBSS() -> chtype;
    pub fn impl_ACS_SSSB() -> chtype;
    pub fn impl_ACS_SSBS() -> chtype;
    pub fn impl_ACS_BSSS() -> chtype;
    pub fn impl_ACS_BSBS() -> chtype;
    pub fn impl_ACS_SBSB() -> chtype;
    pub fn impl_ACS_SSSS() -> chtype;
    
}

/// Extended color support. Requires ncurses6.
#[cfg(feature = "extended_colors")]
extern {
    pub fn init_extended_color(_: c_int, _: c_int, _: c_int, _: c_int) -> c_int;
    pub fn init_extended_pair(_: c_int, _: c_int, _: c_int) -> c_int;
    pub fn extended_color_content(_: c_int, _: int_p, _: int_p, _: int_p) -> c_int;
    pub fn extended_pair_content(_: c_int, _: int_p, _: int_p) -> c_int;
}
