//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

mod private_NSObjectNSAccessibility {
    pub trait Sealed {}
}

/// Category "NSAccessibility" on [`NSObject`].
///
/// * Accessibility Informal Protocol **
#[doc(alias = "NSAccessibility")]
pub unsafe trait NSObjectNSAccessibility:
    ClassType + Sized + private_NSObjectNSAccessibility::Sealed
{
    extern_methods!(
        #[cfg(feature = "NSAccessibilityConstants")]
        #[deprecated = "Use the NSAccessibility protocol methods instead (see NSAccessibilityProtocols.h)"]
        #[unsafe(method(accessibilityAttributeNames))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributeNames(&self) -> Retained<NSArray<NSAccessibilityAttributeName>>;

        #[cfg(feature = "NSAccessibilityConstants")]
        #[deprecated = "Use the NSAccessibility protocol methods instead (see NSAccessibilityProtocols.h)"]
        #[unsafe(method(accessibilityAttributeValue:))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributeValue(
            &self,
            attribute: &NSAccessibilityAttributeName,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSAccessibilityConstants")]
        #[deprecated = "Use the NSAccessibility protocol methods instead (see NSAccessibilityProtocols.h)"]
        #[unsafe(method(accessibilityIsAttributeSettable:))]
        #[unsafe(method_family = none)]
        fn accessibilityIsAttributeSettable(
            &self,
            attribute: &NSAccessibilityAttributeName,
        ) -> bool;

        #[cfg(feature = "NSAccessibilityConstants")]
        /// # Safety
        ///
        /// `value` should be of the correct type.
        #[deprecated = "Use the NSAccessibility protocol methods instead (see NSAccessibilityProtocols.h)"]
        #[unsafe(method(accessibilitySetValue:forAttribute:))]
        #[unsafe(method_family = none)]
        unsafe fn accessibilitySetValue_forAttribute(
            &self,
            value: Option<&AnyObject>,
            attribute: &NSAccessibilityAttributeName,
        );

        #[cfg(feature = "NSAccessibilityConstants")]
        #[deprecated = "Use the NSAccessibility protocol methods instead (see NSAccessibilityProtocols.h)"]
        #[unsafe(method(accessibilityParameterizedAttributeNames))]
        #[unsafe(method_family = none)]
        fn accessibilityParameterizedAttributeNames(
            &self,
        ) -> Retained<NSArray<NSAccessibilityParameterizedAttributeName>>;

        #[cfg(feature = "NSAccessibilityConstants")]
        /// # Safety
        ///
        /// `parameter` should be of the correct type.
        #[deprecated = "Use the NSAccessibility protocol methods instead (see NSAccessibilityProtocols.h)"]
        #[unsafe(method(accessibilityAttributeValue:forParameter:))]
        #[unsafe(method_family = none)]
        unsafe fn accessibilityAttributeValue_forParameter(
            &self,
            attribute: &NSAccessibilityParameterizedAttributeName,
            parameter: Option<&AnyObject>,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSAccessibilityConstants")]
        #[deprecated = "Use the NSAccessibility protocol methods instead (see NSAccessibilityProtocols.h)"]
        #[unsafe(method(accessibilityActionNames))]
        #[unsafe(method_family = none)]
        fn accessibilityActionNames(&self) -> Retained<NSArray<NSAccessibilityActionName>>;

        #[cfg(feature = "NSAccessibilityConstants")]
        #[deprecated = "Use the NSAccessibility protocol methods instead (see NSAccessibilityProtocols.h)"]
        #[unsafe(method(accessibilityActionDescription:))]
        #[unsafe(method_family = none)]
        fn accessibilityActionDescription(
            &self,
            action: &NSAccessibilityActionName,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSAccessibilityConstants")]
        #[deprecated = "Use the NSAccessibility protocol methods instead (see NSAccessibilityProtocols.h)"]
        #[unsafe(method(accessibilityPerformAction:))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformAction(&self, action: &NSAccessibilityActionName);

        #[deprecated = "Use isAccessibilityElement instead"]
        #[unsafe(method(accessibilityIsIgnored))]
        #[unsafe(method_family = none)]
        fn accessibilityIsIgnored(&self) -> bool;

        #[unsafe(method(accessibilityHitTest:))]
        #[unsafe(method_family = none)]
        fn accessibilityHitTest(&self, point: NSPoint) -> Option<Retained<AnyObject>>;

        #[unsafe(method(accessibilityFocusedUIElement))]
        #[unsafe(method_family = none)]
        fn accessibilityFocusedUIElement(&self) -> Option<Retained<AnyObject>>;

        /// # Safety
        ///
        /// `child` should be of the correct type.
        #[unsafe(method(accessibilityIndexOfChild:))]
        #[unsafe(method_family = none)]
        unsafe fn accessibilityIndexOfChild(&self, child: &AnyObject) -> NSUInteger;

        #[cfg(feature = "NSAccessibilityConstants")]
        #[unsafe(method(accessibilityArrayAttributeCount:))]
        #[unsafe(method_family = none)]
        fn accessibilityArrayAttributeCount(
            &self,
            attribute: &NSAccessibilityAttributeName,
        ) -> NSUInteger;

        #[cfg(feature = "NSAccessibilityConstants")]
        #[unsafe(method(accessibilityArrayAttributeValues:index:maxCount:))]
        #[unsafe(method_family = none)]
        fn accessibilityArrayAttributeValues_index_maxCount(
            &self,
            attribute: &NSAccessibilityAttributeName,
            index: NSUInteger,
            max_count: NSUInteger,
        ) -> Retained<NSArray>;

        #[unsafe(method(accessibilityNotifiesWhenDestroyed))]
        #[unsafe(method_family = none)]
        fn accessibilityNotifiesWhenDestroyed(&self) -> bool;
    );
}

impl private_NSObjectNSAccessibility::Sealed for NSObject {}
unsafe impl NSObjectNSAccessibility for NSObject {}

/// NSWorkspaceAccessibilityDisplay.
#[cfg(feature = "NSWorkspace")]
impl NSWorkspace {
    extern_methods!(
        #[unsafe(method(accessibilityDisplayShouldIncreaseContrast))]
        #[unsafe(method_family = none)]
        pub fn accessibilityDisplayShouldIncreaseContrast(&self) -> bool;

        #[unsafe(method(accessibilityDisplayShouldDifferentiateWithoutColor))]
        #[unsafe(method_family = none)]
        pub fn accessibilityDisplayShouldDifferentiateWithoutColor(&self) -> bool;

        #[unsafe(method(accessibilityDisplayShouldReduceTransparency))]
        #[unsafe(method_family = none)]
        pub fn accessibilityDisplayShouldReduceTransparency(&self) -> bool;

        #[unsafe(method(accessibilityDisplayShouldReduceMotion))]
        #[unsafe(method_family = none)]
        pub fn accessibilityDisplayShouldReduceMotion(&self) -> bool;

        #[unsafe(method(accessibilityDisplayShouldInvertColors))]
        #[unsafe(method_family = none)]
        pub fn accessibilityDisplayShouldInvertColors(&self) -> bool;
    );
}

/// NSWorkspaceAccessibility.
#[cfg(feature = "NSWorkspace")]
impl NSWorkspace {
    extern_methods!(
        #[unsafe(method(isVoiceOverEnabled))]
        #[unsafe(method_family = none)]
        pub fn isVoiceOverEnabled(&self) -> bool;

        #[unsafe(method(isSwitchControlEnabled))]
        #[unsafe(method_family = none)]
        pub fn isSwitchControlEnabled(&self) -> bool;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspaceaccessibilitydisplayoptionsdidchangenotification?language=objc)
    pub static NSWorkspaceAccessibilityDisplayOptionsDidChangeNotification:
        &'static NSNotificationName;
}

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
#[inline]
pub extern "C-unwind" fn NSAccessibilityFrameInView(parent_view: &NSView, frame: NSRect) -> NSRect {
    extern "C-unwind" {
        fn NSAccessibilityFrameInView(parent_view: &NSView, frame: NSRect) -> NSRect;
    }
    unsafe { NSAccessibilityFrameInView(parent_view, frame) }
}

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
#[inline]
pub extern "C-unwind" fn NSAccessibilityPointInView(
    parent_view: &NSView,
    point: NSPoint,
) -> NSPoint {
    extern "C-unwind" {
        fn NSAccessibilityPointInView(parent_view: &NSView, point: NSPoint) -> NSPoint;
    }
    unsafe { NSAccessibilityPointInView(parent_view, point) }
}

#[inline]
pub extern "C-unwind" fn NSAccessibilitySetMayContainProtectedContent(flag: bool) -> bool {
    extern "C-unwind" {
        fn NSAccessibilitySetMayContainProtectedContent(flag: Bool) -> Bool;
    }
    unsafe { NSAccessibilitySetMayContainProtectedContent(Bool::new(flag)) }.as_bool()
}

#[cfg(feature = "NSAccessibilityConstants")]
#[inline]
pub extern "C-unwind" fn NSAccessibilityRoleDescription(
    role: &NSAccessibilityRole,
    subrole: Option<&NSAccessibilitySubrole>,
) -> Option<Retained<NSString>> {
    extern "C-unwind" {
        fn NSAccessibilityRoleDescription(
            role: &NSAccessibilityRole,
            subrole: Option<&NSAccessibilitySubrole>,
        ) -> *mut NSString;
    }
    let ret = unsafe { NSAccessibilityRoleDescription(role, subrole) };
    unsafe { Retained::retain_autoreleased(ret) }
}

/// # Safety
///
/// `element` should be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn NSAccessibilityRoleDescriptionForUIElement(
    element: &AnyObject,
) -> Option<Retained<NSString>> {
    extern "C-unwind" {
        fn NSAccessibilityRoleDescriptionForUIElement(element: &AnyObject) -> *mut NSString;
    }
    let ret = unsafe { NSAccessibilityRoleDescriptionForUIElement(element) };
    unsafe { Retained::retain_autoreleased(ret) }
}

#[cfg(feature = "NSAccessibilityConstants")]
#[inline]
pub extern "C-unwind" fn NSAccessibilityActionDescription(
    action: &NSAccessibilityActionName,
) -> Option<Retained<NSString>> {
    extern "C-unwind" {
        fn NSAccessibilityActionDescription(action: &NSAccessibilityActionName) -> *mut NSString;
    }
    let ret = unsafe { NSAccessibilityActionDescription(action) };
    unsafe { Retained::retain_autoreleased(ret) }
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `element` should be of the correct type.
    /// - `element` might not allow `None`.
    /// - `attribute` might not allow `None`.
    /// - `value` should be of the correct type.
    /// - `value` might not allow `None`.
    #[cfg(feature = "NSAccessibilityConstants")]
    #[deprecated = "Exceptions are no longer appropriate for indicating errors in accessibility API. Unexpected values should be handled through appropriate type checking."]
    pub fn NSAccessibilityRaiseBadArgumentException(
        element: Option<&AnyObject>,
        attribute: Option<&NSAccessibilityAttributeName>,
        value: Option<&AnyObject>,
    );
}

/// * Ignored UIElements Utilities **
///
/// # Safety
///
/// `element` should be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn NSAccessibilityUnignoredAncestor(
    element: &AnyObject,
) -> Option<Retained<AnyObject>> {
    extern "C-unwind" {
        fn NSAccessibilityUnignoredAncestor(element: &AnyObject) -> *mut AnyObject;
    }
    let ret = unsafe { NSAccessibilityUnignoredAncestor(element) };
    unsafe { Retained::retain_autoreleased(ret) }
}

/// # Safety
///
/// `element` should be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn NSAccessibilityUnignoredDescendant(
    element: &AnyObject,
) -> Option<Retained<AnyObject>> {
    extern "C-unwind" {
        fn NSAccessibilityUnignoredDescendant(element: &AnyObject) -> *mut AnyObject;
    }
    let ret = unsafe { NSAccessibilityUnignoredDescendant(element) };
    unsafe { Retained::retain_autoreleased(ret) }
}

/// # Safety
///
/// `original_children` generic should be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn NSAccessibilityUnignoredChildren(
    original_children: &NSArray,
) -> Retained<NSArray> {
    extern "C-unwind" {
        fn NSAccessibilityUnignoredChildren(original_children: &NSArray) -> *mut NSArray;
    }
    let ret = unsafe { NSAccessibilityUnignoredChildren(original_children) };
    unsafe { Retained::retain_autoreleased(ret) }
        .expect("function was marked as returning non-null, but actually returned NULL")
}

/// # Safety
///
/// `original_child` should be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn NSAccessibilityUnignoredChildrenForOnlyChild(
    original_child: &AnyObject,
) -> Retained<NSArray> {
    extern "C-unwind" {
        fn NSAccessibilityUnignoredChildrenForOnlyChild(original_child: &AnyObject)
            -> *mut NSArray;
    }
    let ret = unsafe { NSAccessibilityUnignoredChildrenForOnlyChild(original_child) };
    unsafe { Retained::retain_autoreleased(ret) }
        .expect("function was marked as returning non-null, but actually returned NULL")
}

extern "C-unwind" {
    /// * Posting Notifications **
    ///
    /// # Safety
    ///
    /// `element` should be of the correct type.
    #[cfg(feature = "NSAccessibilityConstants")]
    pub fn NSAccessibilityPostNotification(
        element: &AnyObject,
        notification: &NSAccessibilityNotificationName,
    );
}
