/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AZ = "Atepaihānia";
        final String metaValue_DE = "Tiamana";
        final String metaValue_FR = "Wīwī";
        final String metaValue_HU = "Hanekari";
        final String metaValue_IS = "Tiorangi";
        final String metaValue_GG = "Kōnihi";
        final String metaValue_LU = "Rakapuō";
        final String metaValue_CA = "Kānata";
        final String metaValue_LT = "Rituānia";
        final String metaValue_LV = "Rāwhia";
        final String metaValue_MN = "Mongōria";
        final String metaValue_MT = "Mārata";
        final String metaValue_NR = "Nauru";
        final String metaValue_NO = "Nōwei";
        final String metaValue_RO = "Romeinia";
        final String metaValue_SK = "Horowākia";
        final String metaValue_SI = "Horowinia";
        final String metaValue_WS = "Hāmoa";
        final String metaValue_RS = "Hirupia";
        final String metaValue_SE = "Huitene";
        final String metaValue_TO = "Tonga";
        final String metaValue_TR = "Tākei";
        final String metaValue_UA = "Ukareinga";
        final String metaValue_VN = "Whitināmu";
        final String metaValue_PW = "Pārau";
        final String metaValue_hy = "Āmeniana";
        final String metaValue_ccp = "Tiakamā";
        final String metaValue_ka = "Hōriana";
        final String metaValue_el = "Kariki";
        final String metaValue_gu = "Kutarāti";
        final String metaValue_he = "Hīperu";
        final String metaValue_ja = "Hapanihi";
        final String metaValue_km = "Kimēra";
        final String metaValue_ko = "Kōreana";
        final String metaValue_lo = "Rao";
        final String metaValue_la = "Rātini";
        final String metaValue_nqo = "Unukō";
        final String metaValue_syr = "Hīriaka";
        final String metaValue_te = "Teruku";
        final String metaValue_th = "Tai";
        final String metaValue_bo = "Tipete";
        final String metaValue_vai = "Wai";
        final Object[][] data = new Object[][] {
            { "001", "te ao" },
            { "002", "Āwherika" },
            { "003", "Amerika ki te Raki" },
            { "005", "Amerika ki te Tonga" },
            { "009", "Ngā Moutere-a-Kiwa" },
            { "011", "Āwherika ki te Uru" },
            { "013", "Te Puku o Amerika" },
            { "014", "Āwherika ki te Rāwhiti" },
            { "015", "Āwherika ki te Raki" },
            { "017", "Te Pokapū o Āwherika" },
            { "018", "Āwherika Whakatetonga" },
            { "019", "Ngā Amerika" },
            { "021", "Te Raki o Amerika" },
            { "029", "Karapīana" },
            { "030", "Āhia ki te Rāwhiti" },
            { "034", "Āhia ki te Tonga" },
            { "035", "Āhia ki te Tonga-mā-rāwhiti" },
            { "039", "Ūropi ki te Tonga" },
            { "053", "Atareiria" },
            { "054", "Meranīhia" },
            { "057", "Te Rohe o Mekanēhia" },
            { "061", "Te Moana-nui-a-Kiwa" },
            { "142", "Āhia" },
            { "143", "Te Puku o Āhia" },
            { "145", "Āhia ki te Uru" },
            { "150", "Ūropi" },
            { "151", "Ūropi ki te Rāwhiti" },
            { "154", "Ūropi ki te Raki" },
            { "155", "Ūropi ki te Uru" },
            { "202", "Āwherika ki te Tonga o Te Hahāra" },
            { "419", "Amerika Rātini" },
            { "AC", "Te Moutere Aupikinga" },
            { "AD", "Anatōra" },
            { "AE", "Kotahitanga o ngā Whenua o Ārapi" },
            { "AF", "Awhekenetāna" },
            { "AG", "Motu Nehe me Pāputa" },
            { "AI", "Anguira" },
            { "AL", "Arapeinia" },
            { "AM", "Āmenia" },
            { "AO", "Anakora" },
            { "AQ", "Te Kōpakatanga ki te Tonga" },
            { "AR", "Āketina" },
            { "AS", "Hāmoa-Amerika" },
            { "AT", "Ataria" },
            { "AU", "Ahitereiria" },
            { "AW", "Arūpa" },
            { "AX", "Motu Ōrana" },
            { "AZ", metaValue_AZ },
            { "BA", "Pōngia-Herekōwini" },
            { "BB", "Papatohe" },
            { "BD", "Pākaratēhi" },
            { "BE", "Peretiama" },
            { "BF", "Pākina Wharo" },
            { "BG", "Purukāria" },
            { "BH", "Pāreina" },
            { "BI", "Puruniti" },
            { "BJ", "Penīna" },
            { "BL", "Hato Pāteremi" },
            { "BM", "Pāmura" },
            { "BN", "Poronai" },
            { "BO", "Poriwia" },
            { "BQ", "Karapīana Hōrana" },
            { "BR", "Parīhi" },
            { "BS", "Pahama" },
            { "BT", "Pūtana" },
            { "BV", "Motu Pūwei" },
            { "BW", "Poriwana" },
            { "BY", "Pērara" },
            { "BZ", "Perīhi" },
            { "CA", metaValue_CA },
            { "CC", "Ngā Moutere Kokoko (Kirini)" },
            { "CD", "Kōngo - Kinihāha" },
            { "CF", "Te Whenua Tūhake o Āwherika Waenga" },
            { "CG", "Kōngo - Pārawhe" },
            { "CH", "Huiterangi" },
            { "CI", "Te Tai Rei" },
            { "CK", "Kuki Airani" },
            { "CL", "Hiri" },
            { "CM", "Kamarūna" },
            { "CN", "Haina" },
            { "CO", "Koromōpia" },
            { "CP", "Te Moutere Kiripetone" },
            { "CR", "Koto Rīka" },
            { "CU", "Kiupa" },
            { "CV", "Te Kūrae Matomato" },
            { "CW", "Kurahao" },
            { "CX", "Te Moutere Kirihimete" },
            { "CY", "Haipara" },
            { "CZ", "Tiekia" },
            { "DE", metaValue_DE },
            { "DG", "Tieko Kāhia" },
            { "DJ", "Tipūti" },
            { "DK", "Tenemāka" },
            { "DM", "Tominika" },
            { "DO", "Te Whenua Tūhake o Tominika" },
            { "DZ", "Aratiria" },
            { "EA", "Hūta me Merera" },
            { "EC", "Ekuatoa" },
            { "EE", "Etōnia" },
            { "EG", "Īhipa" },
            { "EH", "Hahāra ki te Tonga" },
            { "ER", "Eritēria" },
            { "ES", "Peina" },
            { "ET", "Etiopia" },
            { "EU", "Te Uniana o Ūropi" },
            { "EZ", "Te Rohe o Ūropi" },
            { "FI", "Whinarana" },
            { "FJ", "Whītī" },
            { "FK", "Motu Whākarangi" },
            { "FM", "Mekanēhia" },
            { "FO", "Motu Wharau" },
            { "FR", metaValue_FR },
            { "GA", "Kāpona" },
            { "GB", "Te Hononga o Piritene" },
            { "GD", "Kerenāta" },
            { "GE", "Hōria" },
            { "GF", "Kiāna Wīwī" },
            { "GG", metaValue_GG },
            { "GH", "Kāna" },
            { "GI", "Kāmaka" },
            { "GL", "Whenuakāriki" },
            { "GM", "Kamopia" },
            { "GN", "Kini" },
            { "GP", "Kuatarupa" },
            { "GQ", "Kini Ekuatoria" },
            { "GR", "Kirihi" },
            { "GS", "Hōria ki te Tonga me ngā Motu Hanawiti ki te Tonga" },
            { "GT", "Kuatamāra" },
            { "GU", "Kuama" },
            { "GW", "Kini-Pihao" },
            { "GY", "Kaiana" },
            { "HK", "Hongipua Haina" },
            { "HM", "Ngā Moutere Heriti me Makitānara" },
            { "HN", "Honotura" },
            { "HR", "Koroātia" },
            { "HT", "Haiti" },
            { "HU", metaValue_HU },
            { "IC", "Motu Kanēre" },
            { "ID", "Initonīhia" },
            { "IE", "Airani" },
            { "IL", "Iharaira" },
            { "IM", "Te Moutere Mana" },
            { "IN", "Inia" },
            { "IO", "Te Rohe o te Moana Īniana Piritihi" },
            { "IQ", "Irāka" },
            { "IR", "Irāna" },
            { "IS", metaValue_IS },
            { "IT", "Itāria" },
            { "JE", "Tōrehe" },
            { "JM", "Hemeika" },
            { "JO", "Hōrano" },
            { "JP", "Hapani" },
            { "KE", "Kenia" },
            { "KG", "Kikitānga" },
            { "KH", "Kamapōtia" },
            { "KI", "Kiripati" },
            { "KM", "Komoro" },
            { "KN", "Hato Kiti me Newhi" },
            { "KP", "Kōrea ki te Raki" },
            { "KR", "Kōrea ki te Tonga" },
            { "KW", "Kūweiti" },
            { "KY", "Ngā Motu Keimana" },
            { "KZ", "Katatānga" },
            { "LA", "Rāoho" },
            { "LB", "Repanona" },
            { "LC", "Hato Ruhia" },
            { "LI", "Rīkenetaina" },
            { "LK", "Hiri Rānaka" },
            { "LR", "Raipiria" },
            { "LS", "Teroto" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "LY", "Ripia" },
            { "MA", "Moroko" },
            { "MC", "Monāko" },
            { "MD", "Morotawa" },
            { "ME", "Maungakororiko" },
            { "MF", "Hato Mātene" },
            { "MG", "Matakāhika" },
            { "MH", "Ngā Motu Māhara" },
            { "MK", "Makerōnia ki te Raki" },
            { "ML", "Māri" },
            { "MM", "Pēma" },
            { "MN", metaValue_MN },
            { "MO", "Makau Haina" },
            { "MP", "Ngā Motu Mariana ki te Raki" },
            { "MQ", "Mātiniki" },
            { "MR", "Mauritānia" },
            { "MS", "Monoterā" },
            { "MT", metaValue_MT },
            { "MU", "Marihi" },
            { "MV", "Māratiri" },
            { "MW", "Marāwi" },
            { "MX", "Mēhiko" },
            { "MY", "Mareia" },
            { "MZ", "Mohapiki" },
            { "NA", "Namipia" },
            { "NC", "Whenua Kanaki" },
            { "NE", "Ngāika" },
            { "NF", "Te Moutere Nōpoke" },
            { "NG", "Ngāitiria" },
            { "NI", "Nikarāhua" },
            { "NL", "Hōrana" },
            { "NO", metaValue_NO },
            { "NP", "Nepōra" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "Aotearoa" },
            { "OM", "Ōmana" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Poronēhia Wīwī" },
            { "PG", "Papua Nūkini" },
            { "PH", "Piripīni" },
            { "PK", "Pakitāne" },
            { "PL", "Pōrana" },
            { "PM", "Hato Piere & Mikerona" },
            { "PN", "Pitikeina" },
            { "PR", "Peta Riko" },
            { "PS", "Ngā Rohe o Parihitini" },
            { "PT", "Potukara" },
            { "PW", metaValue_PW },
            { "PY", "Parakai" },
            { "QA", "Katā" },
            { "QO", "Ngā Moutere-a-Kiwa o Waho atu" },
            { "RE", "Reūnio" },
            { "RO", metaValue_RO },
            { "RS", metaValue_RS },
            { "RU", "Rūhia" },
            { "RW", "Rāwana" },
            { "SA", "Hauri Arāpia" },
            { "SB", "Ngā Motu Horomona" },
            { "SC", "Heikere" },
            { "SD", "Hūtāne" },
            { "SE", metaValue_SE },
            { "SG", "Hingapoa" },
            { "SH", "Hato Hērena" },
            { "SI", metaValue_SI },
            { "SJ", "Heopara me Iana Maiana" },
            { "SK", metaValue_SK },
            { "SL", "Te Araone" },
            { "SM", "Hana Marino" },
            { "SN", "Henekara" },
            { "SO", "Hūmārie" },
            { "SR", "Huriname" },
            { "SS", "Hūtāne ki te Tonga" },
            { "ST", "Hato Tomei me Pirinipei" },
            { "SV", "Whakaora" },
            { "SX", "Hiti Mātene" },
            { "SY", "Hiria" },
            { "SZ", "Ehiwatini" },
            { "TA", "Tiritana da Kunia" },
            { "TC", "Koru-Kākoa" },
            { "TD", "Kāta" },
            { "TF", "Ngā Rohe o Wīwī ki te Tonga" },
            { "TG", "Toko" },
            { "TH", "Tairanga" },
            { "TJ", "Takiritānga" },
            { "TK", "Tokerau" },
            { "TL", "Tīmoa ki te Rāwhiti" },
            { "TM", "Tukumanatānga" },
            { "TN", "Tūnihia" },
            { "TO", metaValue_TO },
            { "TR", metaValue_TR },
            { "TT", "Tirinaki Tōpako" },
            { "TV", "Tūwaru" },
            { "TW", "Taiwana" },
            { "TZ", "Tānahia" },
            { "UA", metaValue_UA },
            { "UG", "Ukānga" },
            { "UM", "Ngā Moutere Amerika o Waho" },
            { "UN", "Te Rūnanga Whakakotahi i ngā Iwi o te Ao" },
            { "US", "Hononga o Amerika" },
            { "UY", "Urukoi" },
            { "UZ", "Uhipeketāne" },
            { "VA", "Te Poho-o-Pita" },
            { "VC", "Hato Wēneti me Keretīni" },
            { "VE", "Penehūera" },
            { "VG", "Ngā Moutere Puhi Piritene" },
            { "VI", "Ngā Moutere Puhi Amerika" },
            { "VN", metaValue_VN },
            { "VU", "Whenuatū" },
            { "WF", "Warihi me Whutuna" },
            { "WS", metaValue_WS },
            { "XA", "Mita kikoika" },
            { "XB", "Piri Kikoika" },
            { "XK", "Kōhoro" },
            { "YE", "Īmene" },
            { "YT", "Māiota" },
            { "ZA", "Āwherika ki te Tonga" },
            { "ZM", "Tāmipia" },
            { "ZW", "Timuwawe" },
            { "ZZ", "Rohe Tē Mōhiotia" },
            { "ab", "Apakāhiana" },
            { "af", "Awherikāna" },
            { "ak", "Ākana" },
            { "am", "Amahereka" },
            { "an", "Arakonihi" },
            { "ar", "Ārapi" },
            { "as", "Āhamēhi" },
            { "av", "Āwhāriki" },
            { "ay", "Aimāra" },
            { "az", metaValue_AZ },
            { "ba", "Pākīra" },
            { "be", "Perarūhiana" },
            { "bg", "Purukāriana" },
            { "bi", "Pihirāma" },
            { "bm", "Pāpara" },
            { "bn", "Pākara" },
            { "bo", metaValue_bo },
            { "br", "Peretana" },
            { "bs", "Pōngiana" },
            { "ca", "Katarana" },
            { "ce", "Tietiene" },
            { "ch", "Tiamoro" },
            { "co", "Kōhikana" },
            { "cs", "Tieke" },
            { "cv", "Tiuwhāhi" },
            { "cy", "Werehi" },
            { "da", "Teina" },
            { "de", metaValue_DE },
            { "dv", "Tīwhehi" },
            { "dz", "Tonoka" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Ingarihi" },
            { "eo", "Eheperāto" },
            { "es", "Pāniora" },
            { "et", "Etōniana" },
            { "eu", "Pākihi" },
            { "fa", "Pāhiana" },
            { "ff", "Whūra" },
            { "fi", "Whinirānia" },
            { "fj", "Whītīana" },
            { "fo", "Wharoīhi" },
            { "fr", metaValue_FR },
            { "fy", "Whirīhiana ki te Uru" },
            { "ga", "Airihi" },
            { "gd", "Keiriki Kotimana" },
            { "gl", "Karīhia" },
            { "gn", "Kuaranī" },
            { "gu", metaValue_gu },
            { "gv", "Manaki" },
            { "ha", "Hauha" },
            { "he", metaValue_he },
            { "hi", "Hīni" },
            { "hr", "Koroātiana" },
            { "ht", "Kereō Haiti" },
            { "hu", metaValue_HU },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Inarīngua" },
            { "id", "Initonīhiana" },
            { "ig", "Ikapo" },
            { "ii", "Hīhuana Eī" },
            { "io", "Īto" },
            { "is", metaValue_IS },
            { "it", "Itāriana" },
            { "iu", "Inukitetūta" },
            { "ja", metaValue_ja },
            { "jv", "Hāwhanihi" },
            { "ka", metaValue_ka },
            { "ki", "Kikūiu" },
            { "kj", "Kuoniāma" },
            { "kk", "Kahāka" },
            { "kl", "Kararīhutu" },
            { "km", metaValue_km },
            { "kn", "Kanara" },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kahimiri" },
            { "ku", "Kūrihi" },
            { "kv", "Komi" },
            { "kw", metaValue_GG },
            { "ky", "Kiakihi" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "lg", metaValue_CA },
            { "li", "Ripūkuihi" },
            { "ln", "Ringāra" },
            { "lo", metaValue_lo },
            { "lt", metaValue_LT },
            { "lu", "Rupa Katanga" },
            { "lv", metaValue_LV },
            { "mg", "Marakāhi" },
            { "mh", "Mararīhi" },
            { "mi", "Māori" },
            { "mk", "Makerōnia" },
            { "ml", "Mareiārama" },
            { "mn", metaValue_MN },
            { "mr", "Marati" },
            { "ms", "Marei" },
            { "mt", metaValue_MT },
            { "my", "Pēmīhi" },
            { "na", metaValue_NR },
            { "nb", "Pakamō Nōwei" },
            { "nd", "Enetepēra ki te Raki" },
            { "ne", "Nepari" },
            { "ng", "Natōka" },
            { "nl", "Tati" },
            { "nn", "Nīnōka Nōwei" },
            { "no", metaValue_NO },
            { "nr", "Enetepēra ki te Tonga" },
            { "nv", "Nawahō" },
            { "ny", "Niānia" },
            { "oc", "Ōkitana" },
            { "om", "Ōromo" },
            { "or", "Ōtia" },
            { "os", "Ōtītiki" },
            { "pa", "Punutapi" },
            { "pl", "Pōrihi" },
            { "ps", "Pāhitō" },
            { "pt", "Pōtukīhi" },
            { "qu", "Kētua" },
            { "rm", "Romānihi" },
            { "rn", "Rūniti" },
            { "ro", metaValue_RO },
            { "ru", "Ruhiana" },
            { "rw", "Kiniawāna" },
            { "sa", "Hanahiti" },
            { "sc", "Hārinia" },
            { "sd", "Hiniti" },
            { "se", "Hami ki te Raki" },
            { "sg", "Hāngo" },
            { "si", "Hinihāra" },
            { "sk", metaValue_SK },
            { "sl", metaValue_SI },
            { "sm", metaValue_WS },
            { "sn", "Hōna" },
            { "so", "Hamāri" },
            { "sq", "Arapeiniana" },
            { "sr", metaValue_RS },
            { "ss", "Wāti" },
            { "st", "Hōto ki te Tonga" },
            { "su", "Hunanīhi" },
            { "sv", metaValue_SE },
            { "sw", "Wāhīri" },
            { "ta", "Tamira" },
            { "te", metaValue_te },
            { "tg", "Tāhiki" },
            { "th", metaValue_th },
            { "ti", "Tekirinia" },
            { "tk", "Tākamana" },
            { "tn", "Hawāna" },
            { "to", metaValue_TO },
            { "tr", metaValue_TR },
            { "ts", "Honga" },
            { "tt", "Tatā" },
            { "ty", "Tahiti" },
            { "ug", "Wīkura" },
            { "uk", metaValue_UA },
            { "ur", "Ūrutu" },
            { "uz", "Ūpeke" },
            { "ve", "Wēnera" },
            { "vi", metaValue_VN },
            { "wa", "Warūna" },
            { "wo", "Warawhe" },
            { "xh", "Tōha" },
            { "yi", "Irihi" },
            { "yo", "Ōrūpa" },
            { "zh", "Hainamana" },
            { "zu", "Tūru" },
            { "ace", "Akanīhi" },
            { "ada", "Atāngami" },
            { "ady", "Āteke" },
            { "agq", "Ākeme" },
            { "ain", "Ainu" },
            { "ale", "Ariuta" },
            { "alt", "Ātai ki te Tonga" },
            { "ann", "Ōporo" },
            { "anp", "Anahika" },
            { "arn", "Mapūte" },
            { "arp", "Arapaho" },
            { "ars", "Arapika Nahāri" },
            { "asa", "Ahu" },
            { "ast", "Ahitūriana" },
            { "atj", "Atikameke" },
            { "awa", "Awāti" },
            { "ban", "Pārinīhi" },
            { "bas", "Pahā" },
            { "bem", "Pema" },
            { "bez", "Pena" },
            { "bgc", "Herianawhi" },
            { "bho", "Pōhipuri" },
            { "bin", "Pini" },
            { "bla", "Hihika" },
            { "brx", "Pōto" },
            { "bug", "Pukenīhi" },
            { "byn", "Pirina" },
            { "cay", "Keiūka" },
            { "ccp", metaValue_ccp },
            { "ceb", "Hepuano" },
            { "cgg", "Tieka" },
            { "chk", "Tiukīhi" },
            { "chm", "Mari" },
            { "cho", "Tiokatō" },
            { "chp", "Tiepewaiana" },
            { "chr", "Tierokī" },
            { "chy", "Haiene" },
            { "ckb", "Kūrihi Waenga" },
            { "clc", "Tiekautini" },
            { "crg", "Mītiwhi" },
            { "crj", "Kirī Tonga-mā-Rāwhiti" },
            { "crk", "Pareina Kirī" },
            { "crl", "Kirī Raki-mā-Rāwhiti" },
            { "crm", "Mūhi Kirī" },
            { "crr", "Arakōkiana Kararaina" },
            { "csw", "Wāpi Kirī" },
            { "dak", "Takōta" },
            { "dar", "Tākawa" },
            { "dav", "Taita" },
            { "dgr", "Tōkiripi" },
            { "dje", "Tāma" },
            { "doi", "Tōkiri" },
            { "dsb", "Hōpiana Hakahaka" },
            { "dua", "Tuāra" },
            { "dyo", "Hora-Whōni" },
            { "dzg", "Tahāka" },
            { "ebu", "Emepū" },
            { "efi", "Ewhiki" },
            { "eka", "Ekatika" },
            { "ewo", "Ewāto" },
            { "fil", "Piripīno" },
            { "fon", "Whāna" },
            { "frc", "Wīwī Keihana" },
            { "frr", "Whirīhiana ki te Raki" },
            { "fur", "Whiriūriana" },
            { "gaa", "Kā" },
            { "gez", "Kīhi" },
            { "gil", "Kiripatīhi" },
            { "gor", "Korōtaro" },
            { "gsw", "Tiamana Huiterangi" },
            { "guz", "Kūhī" },
            { "gwi", "Kuitīna" },
            { "hai", "Heira" },
            { "haw", "Wāhu" },
            { "hax", "Haira ki te Tonga" },
            { "hil", "Hirikaina" },
            { "hmn", "Mōnga" },
            { "hsb", "Hōpiana Maunga" },
            { "hup", "Hupa" },
            { "hur", "Hākomerema" },
            { "iba", "Īpana" },
            { "ibb", "Ipīpio" },
            { "ikt", "Inukitetūta Kānata ki te Uru" },
            { "ilo", "Iroko" },
            { "inh", "Inguihi" },
            { "jbo", "Rōpāna" },
            { "jgo", "Nakōma" },
            { "jmc", "Mākame" },
            { "kab", "Kapāiro" },
            { "kac", "Katīana" },
            { "kaj", "Heiho" },
            { "kam", "Kāmapa" },
            { "kbd", "Kapāriana" },
            { "kcg", "Tiapa" },
            { "kde", "Makonote" },
            { "kea", "Kapuwētianu" },
            { "kfo", "Koro" },
            { "kgp", "Keinganga" },
            { "kha", "Kahi" },
            { "khq", "Kōira Tīni" },
            { "kkj", "Kako" },
            { "kln", "Karenini" },
            { "kmb", "Kimipunu" },
            { "kok", "Kōkani" },
            { "kpe", "Kepēre" },
            { "krc", "Karatai-Pāka" },
            { "krl", "Kareriana" },
            { "kru", "Kuruka" },
            { "ksb", "Hapāra" },
            { "ksf", "Pāwhia" },
            { "ksh", "Korōniana" },
            { "kum", "Kumiki" },
            { "kwk", "Kuakawara" },
            { "lad", "Ratino" },
            { "lag", "Rangi" },
            { "lez", "Rēhiana" },
            { "lil", "Riruete" },
            { "lkt", "Rakōta" },
            { "lou", "Kreōro Ruihiana" },
            { "loz", "Rohi" },
            { "lrc", "Ruri ki te Raki" },
            { "lsm", "Hāmia" },
            { "lua", "Rupa Rurua" },
            { "lun", "Runa" },
            { "luo", "Ruo" },
            { "lus", "Mīho" },
            { "luy", "Rūia" },
            { "mad", "Maturīhi" },
            { "mag", "Makāhi" },
            { "mai", "Maitiri" },
            { "mak", "Makahā" },
            { "mas", "Māhai" },
            { "mdf", "Mōkaha" },
            { "men", "Menēte" },
            { "mer", "Meru" },
            { "mfe", "Morihiene" },
            { "mgh", "Makuwa-Mēto" },
            { "mgo", "Meta" },
            { "mic", "Mīkamā" },
            { "min", "Minākapao" },
            { "mni", "Manipuri" },
            { "moe", "Inu-aimuna" },
            { "moh", "Mauhōka" },
            { "mos", "Mohi" },
            { "mua", "Mūnatanga" },
            { "mul", "Ngā reo maha" },
            { "mus", "Mukōki" },
            { "mwl", "Miranatīhi" },
            { "myv", "Erehīa" },
            { "mzn", "Mahaterani" },
            { "nap", "Neaporitana" },
            { "naq", "Nama" },
            { "nds", "Tiamana Hakahaka" },
            { "new", "Newari" },
            { "nia", "Niāhi" },
            { "niu", "Niueana" },
            { "nmg", "Kuahio" },
            { "nnh", "Nekiepūna" },
            { "nog", "Nōkai" },
            { "nqo", metaValue_nqo },
            { "nso", "Hoto ki te Raki" },
            { "nus", "Nua" },
            { "nyn", "Niānakore" },
            { "ojb", "Ōtīpia Raki-mā-Uru" },
            { "ojc", "Ohīpawe Waenga" },
            { "ojs", "Ōti-Kirī" },
            { "ojw", "Ōhīpiwa ki te Uru" },
            { "oka", "Ōkanakana" },
            { "pag", "Pāngahina" },
            { "pam", "Pamapaka" },
            { "pap", "Papiamēto" },
            { "pau", metaValue_PW },
            { "pcm", "Ngāitiriana Kōrapurapu" },
            { "pis", "Pītini" },
            { "pqm", "Marahiti-Pehamakoare" },
            { "raj", "Ratiahitani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotonga" },
            { "rhg", "Rohingia" },
            { "rof", "Romopo" },
            { "rup", "Aromeiniana" },
            { "rwk", "Rawa" },
            { "sad", "Hātawe" },
            { "sah", "Hakūta" },
            { "saq", "Hāmapuru" },
            { "sat", "Hatāri" },
            { "sba", "Nekāpei" },
            { "sbp", "Hāngu" },
            { "scn", "Hihiriana" },
            { "sco", "Kotimana" },
            { "seh", "Hena" },
            { "ses", "Kōiraporo Heni" },
            { "shi", "Tāhehita" },
            { "shn", "Hāna" },
            { "slh", "Ratūti ki te Tonga" },
            { "smn", "Inari Hami" },
            { "sms", "Hakoto Hāmi" },
            { "snk", "Honīke" },
            { "srn", "Harāna Tongo" },
            { "str", "Hārihi Kuititanga" },
            { "suk", "Hukuma" },
            { "swb", "Komōriana" },
            { "syr", metaValue_syr },
            { "tce", "Tatōne ki te Tonga" },
            { "tem", "Tīmene" },
            { "teo", "Teho" },
            { "tet", "Tetumu" },
            { "tgx", "Tākihi" },
            { "tht", "Tātana" },
            { "tig", "Tīkara" },
            { "tlh", "Kirīngona" },
            { "tli", "Tirīkiti" },
            { "tok", "Toki Pona" },
            { "tpi", "Toko Pīhini" },
            { "trv", "Taroko" },
            { "ttm", "Tūtone ki te Raki" },
            { "tum", "Tumūka" },
            { "tvl", "Tuwaru" },
            { "twq", "Tahawaka" },
            { "tyv", "Tuwīniana" },
            { "tzm", "Tamahīta Te Puku o Atarihi" },
            { "udm", "Ūmutu" },
            { "umb", "Ūpunu" },
            { "und", "Reo Tē Mōhiotia" },
            { "vai", metaValue_vai },
            { "vun", "Whunio" },
            { "wae", "Wāhere" },
            { "wal", "Wareita" },
            { "war", "Warei" },
            { "wuu", "Hainamana Wū" },
            { "xal", "Karamiki" },
            { "xog", "Hoka" },
            { "yav", "Angapene" },
            { "ybb", "Emapa" },
            { "yrl", "Nīkātū" },
            { "yue", "Katonīhi" },
            { "zgh", "Moroko Tamatai" },
            { "zun", "Tuni" },
            { "zxx", "Wetereo kiko kore" },
            { "zza", "Tātā" },
            { "Adlm", "Atarama" },
            { "Arab", "Arapika" },
            { "Aran", "Nātarika" },
            { "Armn", metaValue_hy },
            { "Beng", "Pāngara" },
            { "Bopo", "Papamawha" },
            { "Brai", "Tuhi Matapō" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Ngā Kūoro o ngā Iwi Taketake o Kānata kua paiheretia" },
            { "Cher", "Terokī" },
            { "Cyrl", "Hīririki" },
            { "Deva", "Tewhangāngari" },
            { "Ethi", "Etiopika" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "Kūmuki" },
            { "Hanb", "Hana me te Papamawha" },
            { "Hang", "Hāngū" },
            { "Hani", "Hana" },
            { "Hans", "Māmā" },
            { "Hant", "Tuku iho" },
            { "Hebr", metaValue_he },
            { "Hira", "Hirakana" },
            { "Hrkt", "Kūoro Hapanihi" },
            { "Jamo", "Hamo" },
            { "Jpan", metaValue_ja },
            { "Kana", "Katakana" },
            { "Khmr", metaValue_km },
            { "Knda", "Kanāra" },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", "Maraiārama" },
            { "Mong", metaValue_MN },
            { "Mtei", "Meitei Maeke" },
            { "Mymr", "Mienemā" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "Ōtiki" },
            { "Orya", "Otia" },
            { "Rohg", "Hāniwhi" },
            { "Sinh", "Hināra" },
            { "Sund", "Hunanihi" },
            { "Syrc", metaValue_syr },
            { "Taml", "Tamiera" },
            { "Telu", metaValue_te },
            { "Tfng", "Tiwhinā" },
            { "Thaa", "Tāna" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "Eī" },
            { "Zmth", "Reo Tohu Pāngarau" },
            { "Zsye", "Emohi" },
            { "Zsym", "Tohu" },
            { "Zxxx", "Tuhikore" },
            { "Zyyy", "Komona" },
            { "Zzzz", "Momotuhi Tē Mōhiotia" },
            { "de_AT", "Tiamana Ateriana" },
            { "de_CH", "Tiamana Ōkawa Huiterangi" },
            { "en_AU", "Ingarihi Ahitereiriana" },
            { "en_CA", "Ingarihi Kānata" },
            { "en_GB", "Ingarihi Piritene" },
            { "en_US", "Ingarihi Amerikana" },
            { "es_ES", "Pāniora Ūropi" },
            { "es_MX", "Pāniora Mehikana" },
            { "fa_AF", "Tāri" },
            { "fr_CA", "Wīwī Kānata" },
            { "fr_CH", "Wīwī Huiterangi" },
            { "nl_BE", "Tati Whēmirihi" },
            { "pt_BR", "Pōtukīhi Parahi" },
            { "pt_PT", "Pōtukīhi Uropi" },
            { "ar_001", "Ārapi Moroki" },
            { "es_419", "Pāniora Amerikana ki te Tonga" },
            { "key.ca", "Maramataka" },
            { "key.cf", "Hōputu Moni" },
            { "key.co", "Raupapa Kōmaka" },
            { "key.cu", "Momo Moni" },
            { "key.hc", "Hurihanga Haora (12, 24 rānei)" },
            { "key.lb", "Hātuhi Whati Rārangi" },
            { "key.ms", "Pūnaha Inenga" },
            { "key.nu", "Tau" },
            { "zh_Hans", "Hainamana Māmā" },
            { "zh_Hant", "Hainamana Tukuiho" },
            { "type.ca.roc", "Maramataka Minguo" },
            { "type.hc.h11", "Pūnaha Haora 12 (0–11)" },
            { "type.hc.h12", "Pūnaha Haora 12 (1–12)" },
            { "type.hc.h23", "Pūnaha Haora 24 (0–23)" },
            { "type.hc.h24", "Pūnaha Haora 24 (1–24)" },
            { "type.nu.arab", "Mati Arapī-Īnia" },
            { "type.nu.armn", "Tohutau Āmenia" },
            { "type.nu.beng", "Mati Pākara" },
            { "type.nu.cakm", "Mati Tiakama" },
            { "type.nu.deva", "Mati Tewanakari" },
            { "type.nu.ethi", "Tohutau Etiopia" },
            { "type.nu.geor", "Tohutau Hōriana" },
            { "type.nu.grek", "Tohutau Kariki" },
            { "type.nu.gujr", "Mati Kuharati" },
            { "type.nu.guru", "Mati Kuramuki" },
            { "type.nu.hans", "Tohutau Haina Māmā" },
            { "type.nu.hant", "Tohutau Haina Tukuiho" },
            { "type.nu.hebr", "Tohutau Hīperu" },
            { "type.nu.java", "Mati Tiawha" },
            { "type.nu.jpan", "Tohutau Hapanihi" },
            { "type.nu.khmr", "Mati Kimēra" },
            { "type.nu.knda", "Mati Kanāta" },
            { "type.nu.laoo", "Mati Rao" },
            { "type.nu.latn", "Ngā Mati Pākehā" },
            { "type.nu.mlym", "Mati Maraiarama" },
            { "type.nu.mtei", "Mati Mētei Maieka" },
            { "type.nu.mymr", "Mati Pēma" },
            { "type.nu.olck", "Mati Oro Tieki" },
            { "type.nu.orya", "Mati Oria" },
            { "type.nu.taml", "Tohutau Tamira Tukuiho" },
            { "type.nu.telu", "Mati Teruku" },
            { "type.nu.thai", "Mati Tai" },
            { "type.nu.tibt", "Mati Tīpete" },
            { "type.nu.vaii", "Mati Wai" },
            { "type.ca.dangi", "Maramataka Tangi" },
            { "type.co.ducet", "Raupapa Kōmaka Unicode Taunoa" },
            { "type.lb.loose", "Hātuhi Whati Rārangi Tangatanga" },
            { "type.nu.roman", "Tohutau Rōmana" },
            { "type.ca.coptic", "Maramataka Kopitika" },
            { "type.ca.hebrew", "Maramataka Hīperu" },
            { "type.co.search", "Rapunga Arowhānui" },
            { "type.lb.normal", "Hātuhi Whati Rārangi Taunoa" },
            { "type.lb.strict", "Hātuhi Whati Rārangi Pākaha" },
            { "type.ms.metric", "Pūnaha Ngahuru" },
            { "type.ca.chinese", "Maramataka Haina" },
            { "type.ca.islamic", "Maramataka Hitiuri" },
            { "type.ca.iso8601", "Maramataka ISO-8601" },
            { "type.ca.persian", "Maramataka Pāhia" },
            { "type.cf.account", "Hōputu Moni Mahi Kaute" },
            { "type.nu.arabext", "Mati Arapī-Īnia Whakaroa" },
            { "type.nu.armnlow", "Tohutau Āmenia Pūriki" },
            { "type.nu.greklow", "Tohutau Kariki Pūriki" },
            { "type.nu.hanidec", "Tohutau Haina ā-ira" },
            { "type.nu.hansfin", "Tohutau Ahumoni Haina Māmā" },
            { "type.nu.hantfin", "Tohutau Ahumoni Haina Tukuiho" },
            { "type.nu.jpanfin", "Tohutau Ahumoni Hapanihi" },
            { "type.nu.tamldec", "Mati Tamira" },
            { "type.ca.buddhist", "Maramataka Puta" },
            { "type.ca.ethiopic", "Maramataka Etiopia" },
            { "type.ca.japanese", "Maramataka Hapanihi" },
            { "type.cf.standard", "Hōputu Moni Arowhānui" },
            { "type.co.standard", "Raupapa Kōmaka Arowhānui" },
            { "type.ms.uksystem", "Pūnaha Inenga Emepaea" },
            { "type.ms.ussystem", "Pūnenga Inenga Amerika" },
            { "type.nu.fullwide", "Mati Whānui Rawa" },
            { "type.nu.romanlow", "Tohutau Rōmana Pūriki" },
            { "type.ca.gregorian", "Maramataka Pākehā" },
            { "type.ca.islamic-civil", "Maramataka Hitiuri (tūtohi, wā o naiānei)" },
            { "type.ca.islamic-umalqura", "Maramataka Hitiuri (Uma ara Kura)" },
            { "type.ca.ethiopic-amete-alem", "Maramataka Etiopia Amete Arema" },
        };
        return data;
    }
}
