# Unicode normalization tests, generated from NormalizationTests.txt in the
# Unicode database by S15-normalization/test-gen.raku.
# Generated from Unicode version 15.0.0.

use Test;

plan 2000;

ok Uni.new(0xFAD4).NFKC.list ~~ (0x4039,), 'FAD4 -> 4039';
ok Uni.new(0xFAD5).NFKC.list ~~ (0x25249,), 'FAD5 -> 25249';
ok Uni.new(0xFAD6).NFKC.list ~~ (0x25CD0,), 'FAD6 -> 25CD0';
ok Uni.new(0xFAD7).NFKC.list ~~ (0x27ED3,), 'FAD7 -> 27ED3';
ok Uni.new(0xFAD8).NFKC.list ~~ (0x9F43,), 'FAD8 -> 9F43';
ok Uni.new(0xFAD9).NFKC.list ~~ (0x9F8E,), 'FAD9 -> 9F8E';
ok Uni.new(0xFB00).NFKC.list ~~ (0x0066, 0x0066,), 'FB00 -> 0066 0066';
ok Uni.new(0xFB01).NFKC.list ~~ (0x0066, 0x0069,), 'FB01 -> 0066 0069';
ok Uni.new(0xFB02).NFKC.list ~~ (0x0066, 0x006C,), 'FB02 -> 0066 006C';
ok Uni.new(0xFB03).NFKC.list ~~ (0x0066, 0x0066, 0x0069,), 'FB03 -> 0066 0066 0069';
ok Uni.new(0xFB04).NFKC.list ~~ (0x0066, 0x0066, 0x006C,), 'FB04 -> 0066 0066 006C';
ok Uni.new(0xFB05).NFKC.list ~~ (0x0073, 0x0074,), 'FB05 -> 0073 0074';
ok Uni.new(0xFB06).NFKC.list ~~ (0x0073, 0x0074,), 'FB06 -> 0073 0074';
ok Uni.new(0xFB13).NFKC.list ~~ (0x0574, 0x0576,), 'FB13 -> 0574 0576';
ok Uni.new(0xFB14).NFKC.list ~~ (0x0574, 0x0565,), 'FB14 -> 0574 0565';
ok Uni.new(0xFB15).NFKC.list ~~ (0x0574, 0x056B,), 'FB15 -> 0574 056B';
ok Uni.new(0xFB16).NFKC.list ~~ (0x057E, 0x0576,), 'FB16 -> 057E 0576';
ok Uni.new(0xFB17).NFKC.list ~~ (0x0574, 0x056D,), 'FB17 -> 0574 056D';
ok Uni.new(0xFB1D).NFKC.list ~~ (0x05D9, 0x05B4,), 'FB1D -> 05D9 05B4';
ok Uni.new(0xFB1F).NFKC.list ~~ (0x05F2, 0x05B7,), 'FB1F -> 05F2 05B7';
ok Uni.new(0xFB20).NFKC.list ~~ (0x05E2,), 'FB20 -> 05E2';
ok Uni.new(0xFB21).NFKC.list ~~ (0x05D0,), 'FB21 -> 05D0';
ok Uni.new(0xFB22).NFKC.list ~~ (0x05D3,), 'FB22 -> 05D3';
ok Uni.new(0xFB23).NFKC.list ~~ (0x05D4,), 'FB23 -> 05D4';
ok Uni.new(0xFB24).NFKC.list ~~ (0x05DB,), 'FB24 -> 05DB';
ok Uni.new(0xFB25).NFKC.list ~~ (0x05DC,), 'FB25 -> 05DC';
ok Uni.new(0xFB26).NFKC.list ~~ (0x05DD,), 'FB26 -> 05DD';
ok Uni.new(0xFB27).NFKC.list ~~ (0x05E8,), 'FB27 -> 05E8';
ok Uni.new(0xFB28).NFKC.list ~~ (0x05EA,), 'FB28 -> 05EA';
ok Uni.new(0xFB29).NFKC.list ~~ (0x002B,), 'FB29 -> 002B';
ok Uni.new(0xFB2A).NFKC.list ~~ (0x05E9, 0x05C1,), 'FB2A -> 05E9 05C1';
ok Uni.new(0xFB2B).NFKC.list ~~ (0x05E9, 0x05C2,), 'FB2B -> 05E9 05C2';
ok Uni.new(0xFB2C).NFKC.list ~~ (0x05E9, 0x05BC, 0x05C1,), 'FB2C -> 05E9 05BC 05C1';
ok Uni.new(0xFB2D).NFKC.list ~~ (0x05E9, 0x05BC, 0x05C2,), 'FB2D -> 05E9 05BC 05C2';
ok Uni.new(0xFB2E).NFKC.list ~~ (0x05D0, 0x05B7,), 'FB2E -> 05D0 05B7';
ok Uni.new(0xFB2F).NFKC.list ~~ (0x05D0, 0x05B8,), 'FB2F -> 05D0 05B8';
ok Uni.new(0xFB30).NFKC.list ~~ (0x05D0, 0x05BC,), 'FB30 -> 05D0 05BC';
ok Uni.new(0xFB31).NFKC.list ~~ (0x05D1, 0x05BC,), 'FB31 -> 05D1 05BC';
ok Uni.new(0xFB32).NFKC.list ~~ (0x05D2, 0x05BC,), 'FB32 -> 05D2 05BC';
ok Uni.new(0xFB33).NFKC.list ~~ (0x05D3, 0x05BC,), 'FB33 -> 05D3 05BC';
ok Uni.new(0xFB34).NFKC.list ~~ (0x05D4, 0x05BC,), 'FB34 -> 05D4 05BC';
ok Uni.new(0xFB35).NFKC.list ~~ (0x05D5, 0x05BC,), 'FB35 -> 05D5 05BC';
ok Uni.new(0xFB36).NFKC.list ~~ (0x05D6, 0x05BC,), 'FB36 -> 05D6 05BC';
ok Uni.new(0xFB38).NFKC.list ~~ (0x05D8, 0x05BC,), 'FB38 -> 05D8 05BC';
ok Uni.new(0xFB39).NFKC.list ~~ (0x05D9, 0x05BC,), 'FB39 -> 05D9 05BC';
ok Uni.new(0xFB3A).NFKC.list ~~ (0x05DA, 0x05BC,), 'FB3A -> 05DA 05BC';
ok Uni.new(0xFB3B).NFKC.list ~~ (0x05DB, 0x05BC,), 'FB3B -> 05DB 05BC';
ok Uni.new(0xFB3C).NFKC.list ~~ (0x05DC, 0x05BC,), 'FB3C -> 05DC 05BC';
ok Uni.new(0xFB3E).NFKC.list ~~ (0x05DE, 0x05BC,), 'FB3E -> 05DE 05BC';
ok Uni.new(0xFB40).NFKC.list ~~ (0x05E0, 0x05BC,), 'FB40 -> 05E0 05BC';
ok Uni.new(0xFB41).NFKC.list ~~ (0x05E1, 0x05BC,), 'FB41 -> 05E1 05BC';
ok Uni.new(0xFB43).NFKC.list ~~ (0x05E3, 0x05BC,), 'FB43 -> 05E3 05BC';
ok Uni.new(0xFB44).NFKC.list ~~ (0x05E4, 0x05BC,), 'FB44 -> 05E4 05BC';
ok Uni.new(0xFB46).NFKC.list ~~ (0x05E6, 0x05BC,), 'FB46 -> 05E6 05BC';
ok Uni.new(0xFB47).NFKC.list ~~ (0x05E7, 0x05BC,), 'FB47 -> 05E7 05BC';
ok Uni.new(0xFB48).NFKC.list ~~ (0x05E8, 0x05BC,), 'FB48 -> 05E8 05BC';
ok Uni.new(0xFB49).NFKC.list ~~ (0x05E9, 0x05BC,), 'FB49 -> 05E9 05BC';
ok Uni.new(0xFB4A).NFKC.list ~~ (0x05EA, 0x05BC,), 'FB4A -> 05EA 05BC';
ok Uni.new(0xFB4B).NFKC.list ~~ (0x05D5, 0x05B9,), 'FB4B -> 05D5 05B9';
ok Uni.new(0xFB4C).NFKC.list ~~ (0x05D1, 0x05BF,), 'FB4C -> 05D1 05BF';
ok Uni.new(0xFB4D).NFKC.list ~~ (0x05DB, 0x05BF,), 'FB4D -> 05DB 05BF';
ok Uni.new(0xFB4E).NFKC.list ~~ (0x05E4, 0x05BF,), 'FB4E -> 05E4 05BF';
ok Uni.new(0xFB4F).NFKC.list ~~ (0x05D0, 0x05DC,), 'FB4F -> 05D0 05DC';
ok Uni.new(0xFB50).NFKC.list ~~ (0x0671,), 'FB50 -> 0671';
ok Uni.new(0xFB51).NFKC.list ~~ (0x0671,), 'FB51 -> 0671';
ok Uni.new(0xFB52).NFKC.list ~~ (0x067B,), 'FB52 -> 067B';
ok Uni.new(0xFB53).NFKC.list ~~ (0x067B,), 'FB53 -> 067B';
ok Uni.new(0xFB54).NFKC.list ~~ (0x067B,), 'FB54 -> 067B';
ok Uni.new(0xFB55).NFKC.list ~~ (0x067B,), 'FB55 -> 067B';
ok Uni.new(0xFB56).NFKC.list ~~ (0x067E,), 'FB56 -> 067E';
ok Uni.new(0xFB57).NFKC.list ~~ (0x067E,), 'FB57 -> 067E';
ok Uni.new(0xFB58).NFKC.list ~~ (0x067E,), 'FB58 -> 067E';
ok Uni.new(0xFB59).NFKC.list ~~ (0x067E,), 'FB59 -> 067E';
ok Uni.new(0xFB5A).NFKC.list ~~ (0x0680,), 'FB5A -> 0680';
ok Uni.new(0xFB5B).NFKC.list ~~ (0x0680,), 'FB5B -> 0680';
ok Uni.new(0xFB5C).NFKC.list ~~ (0x0680,), 'FB5C -> 0680';
ok Uni.new(0xFB5D).NFKC.list ~~ (0x0680,), 'FB5D -> 0680';
ok Uni.new(0xFB5E).NFKC.list ~~ (0x067A,), 'FB5E -> 067A';
ok Uni.new(0xFB5F).NFKC.list ~~ (0x067A,), 'FB5F -> 067A';
ok Uni.new(0xFB60).NFKC.list ~~ (0x067A,), 'FB60 -> 067A';
ok Uni.new(0xFB61).NFKC.list ~~ (0x067A,), 'FB61 -> 067A';
ok Uni.new(0xFB62).NFKC.list ~~ (0x067F,), 'FB62 -> 067F';
ok Uni.new(0xFB63).NFKC.list ~~ (0x067F,), 'FB63 -> 067F';
ok Uni.new(0xFB64).NFKC.list ~~ (0x067F,), 'FB64 -> 067F';
ok Uni.new(0xFB65).NFKC.list ~~ (0x067F,), 'FB65 -> 067F';
ok Uni.new(0xFB66).NFKC.list ~~ (0x0679,), 'FB66 -> 0679';
ok Uni.new(0xFB67).NFKC.list ~~ (0x0679,), 'FB67 -> 0679';
ok Uni.new(0xFB68).NFKC.list ~~ (0x0679,), 'FB68 -> 0679';
ok Uni.new(0xFB69).NFKC.list ~~ (0x0679,), 'FB69 -> 0679';
ok Uni.new(0xFB6A).NFKC.list ~~ (0x06A4,), 'FB6A -> 06A4';
ok Uni.new(0xFB6B).NFKC.list ~~ (0x06A4,), 'FB6B -> 06A4';
ok Uni.new(0xFB6C).NFKC.list ~~ (0x06A4,), 'FB6C -> 06A4';
ok Uni.new(0xFB6D).NFKC.list ~~ (0x06A4,), 'FB6D -> 06A4';
ok Uni.new(0xFB6E).NFKC.list ~~ (0x06A6,), 'FB6E -> 06A6';
ok Uni.new(0xFB6F).NFKC.list ~~ (0x06A6,), 'FB6F -> 06A6';
ok Uni.new(0xFB70).NFKC.list ~~ (0x06A6,), 'FB70 -> 06A6';
ok Uni.new(0xFB71).NFKC.list ~~ (0x06A6,), 'FB71 -> 06A6';
ok Uni.new(0xFB72).NFKC.list ~~ (0x0684,), 'FB72 -> 0684';
ok Uni.new(0xFB73).NFKC.list ~~ (0x0684,), 'FB73 -> 0684';
ok Uni.new(0xFB74).NFKC.list ~~ (0x0684,), 'FB74 -> 0684';
ok Uni.new(0xFB75).NFKC.list ~~ (0x0684,), 'FB75 -> 0684';
ok Uni.new(0xFB76).NFKC.list ~~ (0x0683,), 'FB76 -> 0683';
ok Uni.new(0xFB77).NFKC.list ~~ (0x0683,), 'FB77 -> 0683';
ok Uni.new(0xFB78).NFKC.list ~~ (0x0683,), 'FB78 -> 0683';
ok Uni.new(0xFB79).NFKC.list ~~ (0x0683,), 'FB79 -> 0683';
ok Uni.new(0xFB7A).NFKC.list ~~ (0x0686,), 'FB7A -> 0686';
ok Uni.new(0xFB7B).NFKC.list ~~ (0x0686,), 'FB7B -> 0686';
ok Uni.new(0xFB7C).NFKC.list ~~ (0x0686,), 'FB7C -> 0686';
ok Uni.new(0xFB7D).NFKC.list ~~ (0x0686,), 'FB7D -> 0686';
ok Uni.new(0xFB7E).NFKC.list ~~ (0x0687,), 'FB7E -> 0687';
ok Uni.new(0xFB7F).NFKC.list ~~ (0x0687,), 'FB7F -> 0687';
ok Uni.new(0xFB80).NFKC.list ~~ (0x0687,), 'FB80 -> 0687';
ok Uni.new(0xFB81).NFKC.list ~~ (0x0687,), 'FB81 -> 0687';
ok Uni.new(0xFB82).NFKC.list ~~ (0x068D,), 'FB82 -> 068D';
ok Uni.new(0xFB83).NFKC.list ~~ (0x068D,), 'FB83 -> 068D';
ok Uni.new(0xFB84).NFKC.list ~~ (0x068C,), 'FB84 -> 068C';
ok Uni.new(0xFB85).NFKC.list ~~ (0x068C,), 'FB85 -> 068C';
ok Uni.new(0xFB86).NFKC.list ~~ (0x068E,), 'FB86 -> 068E';
ok Uni.new(0xFB87).NFKC.list ~~ (0x068E,), 'FB87 -> 068E';
ok Uni.new(0xFB88).NFKC.list ~~ (0x0688,), 'FB88 -> 0688';
ok Uni.new(0xFB89).NFKC.list ~~ (0x0688,), 'FB89 -> 0688';
ok Uni.new(0xFB8A).NFKC.list ~~ (0x0698,), 'FB8A -> 0698';
ok Uni.new(0xFB8B).NFKC.list ~~ (0x0698,), 'FB8B -> 0698';
ok Uni.new(0xFB8C).NFKC.list ~~ (0x0691,), 'FB8C -> 0691';
ok Uni.new(0xFB8D).NFKC.list ~~ (0x0691,), 'FB8D -> 0691';
ok Uni.new(0xFB8E).NFKC.list ~~ (0x06A9,), 'FB8E -> 06A9';
ok Uni.new(0xFB8F).NFKC.list ~~ (0x06A9,), 'FB8F -> 06A9';
ok Uni.new(0xFB90).NFKC.list ~~ (0x06A9,), 'FB90 -> 06A9';
ok Uni.new(0xFB91).NFKC.list ~~ (0x06A9,), 'FB91 -> 06A9';
ok Uni.new(0xFB92).NFKC.list ~~ (0x06AF,), 'FB92 -> 06AF';
ok Uni.new(0xFB93).NFKC.list ~~ (0x06AF,), 'FB93 -> 06AF';
ok Uni.new(0xFB94).NFKC.list ~~ (0x06AF,), 'FB94 -> 06AF';
ok Uni.new(0xFB95).NFKC.list ~~ (0x06AF,), 'FB95 -> 06AF';
ok Uni.new(0xFB96).NFKC.list ~~ (0x06B3,), 'FB96 -> 06B3';
ok Uni.new(0xFB97).NFKC.list ~~ (0x06B3,), 'FB97 -> 06B3';
ok Uni.new(0xFB98).NFKC.list ~~ (0x06B3,), 'FB98 -> 06B3';
ok Uni.new(0xFB99).NFKC.list ~~ (0x06B3,), 'FB99 -> 06B3';
ok Uni.new(0xFB9A).NFKC.list ~~ (0x06B1,), 'FB9A -> 06B1';
ok Uni.new(0xFB9B).NFKC.list ~~ (0x06B1,), 'FB9B -> 06B1';
ok Uni.new(0xFB9C).NFKC.list ~~ (0x06B1,), 'FB9C -> 06B1';
ok Uni.new(0xFB9D).NFKC.list ~~ (0x06B1,), 'FB9D -> 06B1';
ok Uni.new(0xFB9E).NFKC.list ~~ (0x06BA,), 'FB9E -> 06BA';
ok Uni.new(0xFB9F).NFKC.list ~~ (0x06BA,), 'FB9F -> 06BA';
ok Uni.new(0xFBA0).NFKC.list ~~ (0x06BB,), 'FBA0 -> 06BB';
ok Uni.new(0xFBA1).NFKC.list ~~ (0x06BB,), 'FBA1 -> 06BB';
ok Uni.new(0xFBA2).NFKC.list ~~ (0x06BB,), 'FBA2 -> 06BB';
ok Uni.new(0xFBA3).NFKC.list ~~ (0x06BB,), 'FBA3 -> 06BB';
ok Uni.new(0xFBA4).NFKC.list ~~ (0x06C0,), 'FBA4 -> 06C0';
ok Uni.new(0xFBA5).NFKC.list ~~ (0x06C0,), 'FBA5 -> 06C0';
ok Uni.new(0xFBA6).NFKC.list ~~ (0x06C1,), 'FBA6 -> 06C1';
ok Uni.new(0xFBA7).NFKC.list ~~ (0x06C1,), 'FBA7 -> 06C1';
ok Uni.new(0xFBA8).NFKC.list ~~ (0x06C1,), 'FBA8 -> 06C1';
ok Uni.new(0xFBA9).NFKC.list ~~ (0x06C1,), 'FBA9 -> 06C1';
ok Uni.new(0xFBAA).NFKC.list ~~ (0x06BE,), 'FBAA -> 06BE';
ok Uni.new(0xFBAB).NFKC.list ~~ (0x06BE,), 'FBAB -> 06BE';
ok Uni.new(0xFBAC).NFKC.list ~~ (0x06BE,), 'FBAC -> 06BE';
ok Uni.new(0xFBAD).NFKC.list ~~ (0x06BE,), 'FBAD -> 06BE';
ok Uni.new(0xFBAE).NFKC.list ~~ (0x06D2,), 'FBAE -> 06D2';
ok Uni.new(0xFBAF).NFKC.list ~~ (0x06D2,), 'FBAF -> 06D2';
ok Uni.new(0xFBB0).NFKC.list ~~ (0x06D3,), 'FBB0 -> 06D3';
ok Uni.new(0xFBB1).NFKC.list ~~ (0x06D3,), 'FBB1 -> 06D3';
ok Uni.new(0xFBD3).NFKC.list ~~ (0x06AD,), 'FBD3 -> 06AD';
ok Uni.new(0xFBD4).NFKC.list ~~ (0x06AD,), 'FBD4 -> 06AD';
ok Uni.new(0xFBD5).NFKC.list ~~ (0x06AD,), 'FBD5 -> 06AD';
ok Uni.new(0xFBD6).NFKC.list ~~ (0x06AD,), 'FBD6 -> 06AD';
ok Uni.new(0xFBD7).NFKC.list ~~ (0x06C7,), 'FBD7 -> 06C7';
ok Uni.new(0xFBD8).NFKC.list ~~ (0x06C7,), 'FBD8 -> 06C7';
ok Uni.new(0xFBD9).NFKC.list ~~ (0x06C6,), 'FBD9 -> 06C6';
ok Uni.new(0xFBDA).NFKC.list ~~ (0x06C6,), 'FBDA -> 06C6';
ok Uni.new(0xFBDB).NFKC.list ~~ (0x06C8,), 'FBDB -> 06C8';
ok Uni.new(0xFBDC).NFKC.list ~~ (0x06C8,), 'FBDC -> 06C8';
ok Uni.new(0xFBDD).NFKC.list ~~ (0x06C7, 0x0674,), 'FBDD -> 06C7 0674';
ok Uni.new(0xFBDE).NFKC.list ~~ (0x06CB,), 'FBDE -> 06CB';
ok Uni.new(0xFBDF).NFKC.list ~~ (0x06CB,), 'FBDF -> 06CB';
ok Uni.new(0xFBE0).NFKC.list ~~ (0x06C5,), 'FBE0 -> 06C5';
ok Uni.new(0xFBE1).NFKC.list ~~ (0x06C5,), 'FBE1 -> 06C5';
ok Uni.new(0xFBE2).NFKC.list ~~ (0x06C9,), 'FBE2 -> 06C9';
ok Uni.new(0xFBE3).NFKC.list ~~ (0x06C9,), 'FBE3 -> 06C9';
ok Uni.new(0xFBE4).NFKC.list ~~ (0x06D0,), 'FBE4 -> 06D0';
ok Uni.new(0xFBE5).NFKC.list ~~ (0x06D0,), 'FBE5 -> 06D0';
ok Uni.new(0xFBE6).NFKC.list ~~ (0x06D0,), 'FBE6 -> 06D0';
ok Uni.new(0xFBE7).NFKC.list ~~ (0x06D0,), 'FBE7 -> 06D0';
ok Uni.new(0xFBE8).NFKC.list ~~ (0x0649,), 'FBE8 -> 0649';
ok Uni.new(0xFBE9).NFKC.list ~~ (0x0649,), 'FBE9 -> 0649';
ok Uni.new(0xFBEA).NFKC.list ~~ (0x0626, 0x0627,), 'FBEA -> 0626 0627';
ok Uni.new(0xFBEB).NFKC.list ~~ (0x0626, 0x0627,), 'FBEB -> 0626 0627';
ok Uni.new(0xFBEC).NFKC.list ~~ (0x0626, 0x06D5,), 'FBEC -> 0626 06D5';
ok Uni.new(0xFBED).NFKC.list ~~ (0x0626, 0x06D5,), 'FBED -> 0626 06D5';
ok Uni.new(0xFBEE).NFKC.list ~~ (0x0626, 0x0648,), 'FBEE -> 0626 0648';
ok Uni.new(0xFBEF).NFKC.list ~~ (0x0626, 0x0648,), 'FBEF -> 0626 0648';
ok Uni.new(0xFBF0).NFKC.list ~~ (0x0626, 0x06C7,), 'FBF0 -> 0626 06C7';
ok Uni.new(0xFBF1).NFKC.list ~~ (0x0626, 0x06C7,), 'FBF1 -> 0626 06C7';
ok Uni.new(0xFBF2).NFKC.list ~~ (0x0626, 0x06C6,), 'FBF2 -> 0626 06C6';
ok Uni.new(0xFBF3).NFKC.list ~~ (0x0626, 0x06C6,), 'FBF3 -> 0626 06C6';
ok Uni.new(0xFBF4).NFKC.list ~~ (0x0626, 0x06C8,), 'FBF4 -> 0626 06C8';
ok Uni.new(0xFBF5).NFKC.list ~~ (0x0626, 0x06C8,), 'FBF5 -> 0626 06C8';
ok Uni.new(0xFBF6).NFKC.list ~~ (0x0626, 0x06D0,), 'FBF6 -> 0626 06D0';
ok Uni.new(0xFBF7).NFKC.list ~~ (0x0626, 0x06D0,), 'FBF7 -> 0626 06D0';
ok Uni.new(0xFBF8).NFKC.list ~~ (0x0626, 0x06D0,), 'FBF8 -> 0626 06D0';
ok Uni.new(0xFBF9).NFKC.list ~~ (0x0626, 0x0649,), 'FBF9 -> 0626 0649';
ok Uni.new(0xFBFA).NFKC.list ~~ (0x0626, 0x0649,), 'FBFA -> 0626 0649';
ok Uni.new(0xFBFB).NFKC.list ~~ (0x0626, 0x0649,), 'FBFB -> 0626 0649';
ok Uni.new(0xFBFC).NFKC.list ~~ (0x06CC,), 'FBFC -> 06CC';
ok Uni.new(0xFBFD).NFKC.list ~~ (0x06CC,), 'FBFD -> 06CC';
ok Uni.new(0xFBFE).NFKC.list ~~ (0x06CC,), 'FBFE -> 06CC';
ok Uni.new(0xFBFF).NFKC.list ~~ (0x06CC,), 'FBFF -> 06CC';
ok Uni.new(0xFC00).NFKC.list ~~ (0x0626, 0x062C,), 'FC00 -> 0626 062C';
ok Uni.new(0xFC01).NFKC.list ~~ (0x0626, 0x062D,), 'FC01 -> 0626 062D';
ok Uni.new(0xFC02).NFKC.list ~~ (0x0626, 0x0645,), 'FC02 -> 0626 0645';
ok Uni.new(0xFC03).NFKC.list ~~ (0x0626, 0x0649,), 'FC03 -> 0626 0649';
ok Uni.new(0xFC04).NFKC.list ~~ (0x0626, 0x064A,), 'FC04 -> 0626 064A';
ok Uni.new(0xFC05).NFKC.list ~~ (0x0628, 0x062C,), 'FC05 -> 0628 062C';
ok Uni.new(0xFC06).NFKC.list ~~ (0x0628, 0x062D,), 'FC06 -> 0628 062D';
ok Uni.new(0xFC07).NFKC.list ~~ (0x0628, 0x062E,), 'FC07 -> 0628 062E';
ok Uni.new(0xFC08).NFKC.list ~~ (0x0628, 0x0645,), 'FC08 -> 0628 0645';
ok Uni.new(0xFC09).NFKC.list ~~ (0x0628, 0x0649,), 'FC09 -> 0628 0649';
ok Uni.new(0xFC0A).NFKC.list ~~ (0x0628, 0x064A,), 'FC0A -> 0628 064A';
ok Uni.new(0xFC0B).NFKC.list ~~ (0x062A, 0x062C,), 'FC0B -> 062A 062C';
ok Uni.new(0xFC0C).NFKC.list ~~ (0x062A, 0x062D,), 'FC0C -> 062A 062D';
ok Uni.new(0xFC0D).NFKC.list ~~ (0x062A, 0x062E,), 'FC0D -> 062A 062E';
ok Uni.new(0xFC0E).NFKC.list ~~ (0x062A, 0x0645,), 'FC0E -> 062A 0645';
ok Uni.new(0xFC0F).NFKC.list ~~ (0x062A, 0x0649,), 'FC0F -> 062A 0649';
ok Uni.new(0xFC10).NFKC.list ~~ (0x062A, 0x064A,), 'FC10 -> 062A 064A';
ok Uni.new(0xFC11).NFKC.list ~~ (0x062B, 0x062C,), 'FC11 -> 062B 062C';
ok Uni.new(0xFC12).NFKC.list ~~ (0x062B, 0x0645,), 'FC12 -> 062B 0645';
ok Uni.new(0xFC13).NFKC.list ~~ (0x062B, 0x0649,), 'FC13 -> 062B 0649';
ok Uni.new(0xFC14).NFKC.list ~~ (0x062B, 0x064A,), 'FC14 -> 062B 064A';
ok Uni.new(0xFC15).NFKC.list ~~ (0x062C, 0x062D,), 'FC15 -> 062C 062D';
ok Uni.new(0xFC16).NFKC.list ~~ (0x062C, 0x0645,), 'FC16 -> 062C 0645';
ok Uni.new(0xFC17).NFKC.list ~~ (0x062D, 0x062C,), 'FC17 -> 062D 062C';
ok Uni.new(0xFC18).NFKC.list ~~ (0x062D, 0x0645,), 'FC18 -> 062D 0645';
ok Uni.new(0xFC19).NFKC.list ~~ (0x062E, 0x062C,), 'FC19 -> 062E 062C';
ok Uni.new(0xFC1A).NFKC.list ~~ (0x062E, 0x062D,), 'FC1A -> 062E 062D';
ok Uni.new(0xFC1B).NFKC.list ~~ (0x062E, 0x0645,), 'FC1B -> 062E 0645';
ok Uni.new(0xFC1C).NFKC.list ~~ (0x0633, 0x062C,), 'FC1C -> 0633 062C';
ok Uni.new(0xFC1D).NFKC.list ~~ (0x0633, 0x062D,), 'FC1D -> 0633 062D';
ok Uni.new(0xFC1E).NFKC.list ~~ (0x0633, 0x062E,), 'FC1E -> 0633 062E';
ok Uni.new(0xFC1F).NFKC.list ~~ (0x0633, 0x0645,), 'FC1F -> 0633 0645';
ok Uni.new(0xFC20).NFKC.list ~~ (0x0635, 0x062D,), 'FC20 -> 0635 062D';
ok Uni.new(0xFC21).NFKC.list ~~ (0x0635, 0x0645,), 'FC21 -> 0635 0645';
ok Uni.new(0xFC22).NFKC.list ~~ (0x0636, 0x062C,), 'FC22 -> 0636 062C';
ok Uni.new(0xFC23).NFKC.list ~~ (0x0636, 0x062D,), 'FC23 -> 0636 062D';
ok Uni.new(0xFC24).NFKC.list ~~ (0x0636, 0x062E,), 'FC24 -> 0636 062E';
ok Uni.new(0xFC25).NFKC.list ~~ (0x0636, 0x0645,), 'FC25 -> 0636 0645';
ok Uni.new(0xFC26).NFKC.list ~~ (0x0637, 0x062D,), 'FC26 -> 0637 062D';
ok Uni.new(0xFC27).NFKC.list ~~ (0x0637, 0x0645,), 'FC27 -> 0637 0645';
ok Uni.new(0xFC28).NFKC.list ~~ (0x0638, 0x0645,), 'FC28 -> 0638 0645';
ok Uni.new(0xFC29).NFKC.list ~~ (0x0639, 0x062C,), 'FC29 -> 0639 062C';
ok Uni.new(0xFC2A).NFKC.list ~~ (0x0639, 0x0645,), 'FC2A -> 0639 0645';
ok Uni.new(0xFC2B).NFKC.list ~~ (0x063A, 0x062C,), 'FC2B -> 063A 062C';
ok Uni.new(0xFC2C).NFKC.list ~~ (0x063A, 0x0645,), 'FC2C -> 063A 0645';
ok Uni.new(0xFC2D).NFKC.list ~~ (0x0641, 0x062C,), 'FC2D -> 0641 062C';
ok Uni.new(0xFC2E).NFKC.list ~~ (0x0641, 0x062D,), 'FC2E -> 0641 062D';
ok Uni.new(0xFC2F).NFKC.list ~~ (0x0641, 0x062E,), 'FC2F -> 0641 062E';
ok Uni.new(0xFC30).NFKC.list ~~ (0x0641, 0x0645,), 'FC30 -> 0641 0645';
ok Uni.new(0xFC31).NFKC.list ~~ (0x0641, 0x0649,), 'FC31 -> 0641 0649';
ok Uni.new(0xFC32).NFKC.list ~~ (0x0641, 0x064A,), 'FC32 -> 0641 064A';
ok Uni.new(0xFC33).NFKC.list ~~ (0x0642, 0x062D,), 'FC33 -> 0642 062D';
ok Uni.new(0xFC34).NFKC.list ~~ (0x0642, 0x0645,), 'FC34 -> 0642 0645';
ok Uni.new(0xFC35).NFKC.list ~~ (0x0642, 0x0649,), 'FC35 -> 0642 0649';
ok Uni.new(0xFC36).NFKC.list ~~ (0x0642, 0x064A,), 'FC36 -> 0642 064A';
ok Uni.new(0xFC37).NFKC.list ~~ (0x0643, 0x0627,), 'FC37 -> 0643 0627';
ok Uni.new(0xFC38).NFKC.list ~~ (0x0643, 0x062C,), 'FC38 -> 0643 062C';
ok Uni.new(0xFC39).NFKC.list ~~ (0x0643, 0x062D,), 'FC39 -> 0643 062D';
ok Uni.new(0xFC3A).NFKC.list ~~ (0x0643, 0x062E,), 'FC3A -> 0643 062E';
ok Uni.new(0xFC3B).NFKC.list ~~ (0x0643, 0x0644,), 'FC3B -> 0643 0644';
ok Uni.new(0xFC3C).NFKC.list ~~ (0x0643, 0x0645,), 'FC3C -> 0643 0645';
ok Uni.new(0xFC3D).NFKC.list ~~ (0x0643, 0x0649,), 'FC3D -> 0643 0649';
ok Uni.new(0xFC3E).NFKC.list ~~ (0x0643, 0x064A,), 'FC3E -> 0643 064A';
ok Uni.new(0xFC3F).NFKC.list ~~ (0x0644, 0x062C,), 'FC3F -> 0644 062C';
ok Uni.new(0xFC40).NFKC.list ~~ (0x0644, 0x062D,), 'FC40 -> 0644 062D';
ok Uni.new(0xFC41).NFKC.list ~~ (0x0644, 0x062E,), 'FC41 -> 0644 062E';
ok Uni.new(0xFC42).NFKC.list ~~ (0x0644, 0x0645,), 'FC42 -> 0644 0645';
ok Uni.new(0xFC43).NFKC.list ~~ (0x0644, 0x0649,), 'FC43 -> 0644 0649';
ok Uni.new(0xFC44).NFKC.list ~~ (0x0644, 0x064A,), 'FC44 -> 0644 064A';
ok Uni.new(0xFC45).NFKC.list ~~ (0x0645, 0x062C,), 'FC45 -> 0645 062C';
ok Uni.new(0xFC46).NFKC.list ~~ (0x0645, 0x062D,), 'FC46 -> 0645 062D';
ok Uni.new(0xFC47).NFKC.list ~~ (0x0645, 0x062E,), 'FC47 -> 0645 062E';
ok Uni.new(0xFC48).NFKC.list ~~ (0x0645, 0x0645,), 'FC48 -> 0645 0645';
ok Uni.new(0xFC49).NFKC.list ~~ (0x0645, 0x0649,), 'FC49 -> 0645 0649';
ok Uni.new(0xFC4A).NFKC.list ~~ (0x0645, 0x064A,), 'FC4A -> 0645 064A';
ok Uni.new(0xFC4B).NFKC.list ~~ (0x0646, 0x062C,), 'FC4B -> 0646 062C';
ok Uni.new(0xFC4C).NFKC.list ~~ (0x0646, 0x062D,), 'FC4C -> 0646 062D';
ok Uni.new(0xFC4D).NFKC.list ~~ (0x0646, 0x062E,), 'FC4D -> 0646 062E';
ok Uni.new(0xFC4E).NFKC.list ~~ (0x0646, 0x0645,), 'FC4E -> 0646 0645';
ok Uni.new(0xFC4F).NFKC.list ~~ (0x0646, 0x0649,), 'FC4F -> 0646 0649';
ok Uni.new(0xFC50).NFKC.list ~~ (0x0646, 0x064A,), 'FC50 -> 0646 064A';
ok Uni.new(0xFC51).NFKC.list ~~ (0x0647, 0x062C,), 'FC51 -> 0647 062C';
ok Uni.new(0xFC52).NFKC.list ~~ (0x0647, 0x0645,), 'FC52 -> 0647 0645';
ok Uni.new(0xFC53).NFKC.list ~~ (0x0647, 0x0649,), 'FC53 -> 0647 0649';
ok Uni.new(0xFC54).NFKC.list ~~ (0x0647, 0x064A,), 'FC54 -> 0647 064A';
ok Uni.new(0xFC55).NFKC.list ~~ (0x064A, 0x062C,), 'FC55 -> 064A 062C';
ok Uni.new(0xFC56).NFKC.list ~~ (0x064A, 0x062D,), 'FC56 -> 064A 062D';
ok Uni.new(0xFC57).NFKC.list ~~ (0x064A, 0x062E,), 'FC57 -> 064A 062E';
ok Uni.new(0xFC58).NFKC.list ~~ (0x064A, 0x0645,), 'FC58 -> 064A 0645';
ok Uni.new(0xFC59).NFKC.list ~~ (0x064A, 0x0649,), 'FC59 -> 064A 0649';
ok Uni.new(0xFC5A).NFKC.list ~~ (0x064A, 0x064A,), 'FC5A -> 064A 064A';
ok Uni.new(0xFC5B).NFKC.list ~~ (0x0630, 0x0670,), 'FC5B -> 0630 0670';
ok Uni.new(0xFC5C).NFKC.list ~~ (0x0631, 0x0670,), 'FC5C -> 0631 0670';
ok Uni.new(0xFC5D).NFKC.list ~~ (0x0649, 0x0670,), 'FC5D -> 0649 0670';
ok Uni.new(0xFC5E).NFKC.list ~~ (0x0020, 0x064C, 0x0651,), 'FC5E -> 0020 064C 0651';
ok Uni.new(0xFC5F).NFKC.list ~~ (0x0020, 0x064D, 0x0651,), 'FC5F -> 0020 064D 0651';
ok Uni.new(0xFC60).NFKC.list ~~ (0x0020, 0x064E, 0x0651,), 'FC60 -> 0020 064E 0651';
ok Uni.new(0xFC61).NFKC.list ~~ (0x0020, 0x064F, 0x0651,), 'FC61 -> 0020 064F 0651';
ok Uni.new(0xFC62).NFKC.list ~~ (0x0020, 0x0650, 0x0651,), 'FC62 -> 0020 0650 0651';
ok Uni.new(0xFC63).NFKC.list ~~ (0x0020, 0x0651, 0x0670,), 'FC63 -> 0020 0651 0670';
ok Uni.new(0xFC64).NFKC.list ~~ (0x0626, 0x0631,), 'FC64 -> 0626 0631';
ok Uni.new(0xFC65).NFKC.list ~~ (0x0626, 0x0632,), 'FC65 -> 0626 0632';
ok Uni.new(0xFC66).NFKC.list ~~ (0x0626, 0x0645,), 'FC66 -> 0626 0645';
ok Uni.new(0xFC67).NFKC.list ~~ (0x0626, 0x0646,), 'FC67 -> 0626 0646';
ok Uni.new(0xFC68).NFKC.list ~~ (0x0626, 0x0649,), 'FC68 -> 0626 0649';
ok Uni.new(0xFC69).NFKC.list ~~ (0x0626, 0x064A,), 'FC69 -> 0626 064A';
ok Uni.new(0xFC6A).NFKC.list ~~ (0x0628, 0x0631,), 'FC6A -> 0628 0631';
ok Uni.new(0xFC6B).NFKC.list ~~ (0x0628, 0x0632,), 'FC6B -> 0628 0632';
ok Uni.new(0xFC6C).NFKC.list ~~ (0x0628, 0x0645,), 'FC6C -> 0628 0645';
ok Uni.new(0xFC6D).NFKC.list ~~ (0x0628, 0x0646,), 'FC6D -> 0628 0646';
ok Uni.new(0xFC6E).NFKC.list ~~ (0x0628, 0x0649,), 'FC6E -> 0628 0649';
ok Uni.new(0xFC6F).NFKC.list ~~ (0x0628, 0x064A,), 'FC6F -> 0628 064A';
ok Uni.new(0xFC70).NFKC.list ~~ (0x062A, 0x0631,), 'FC70 -> 062A 0631';
ok Uni.new(0xFC71).NFKC.list ~~ (0x062A, 0x0632,), 'FC71 -> 062A 0632';
ok Uni.new(0xFC72).NFKC.list ~~ (0x062A, 0x0645,), 'FC72 -> 062A 0645';
ok Uni.new(0xFC73).NFKC.list ~~ (0x062A, 0x0646,), 'FC73 -> 062A 0646';
ok Uni.new(0xFC74).NFKC.list ~~ (0x062A, 0x0649,), 'FC74 -> 062A 0649';
ok Uni.new(0xFC75).NFKC.list ~~ (0x062A, 0x064A,), 'FC75 -> 062A 064A';
ok Uni.new(0xFC76).NFKC.list ~~ (0x062B, 0x0631,), 'FC76 -> 062B 0631';
ok Uni.new(0xFC77).NFKC.list ~~ (0x062B, 0x0632,), 'FC77 -> 062B 0632';
ok Uni.new(0xFC78).NFKC.list ~~ (0x062B, 0x0645,), 'FC78 -> 062B 0645';
ok Uni.new(0xFC79).NFKC.list ~~ (0x062B, 0x0646,), 'FC79 -> 062B 0646';
ok Uni.new(0xFC7A).NFKC.list ~~ (0x062B, 0x0649,), 'FC7A -> 062B 0649';
ok Uni.new(0xFC7B).NFKC.list ~~ (0x062B, 0x064A,), 'FC7B -> 062B 064A';
ok Uni.new(0xFC7C).NFKC.list ~~ (0x0641, 0x0649,), 'FC7C -> 0641 0649';
ok Uni.new(0xFC7D).NFKC.list ~~ (0x0641, 0x064A,), 'FC7D -> 0641 064A';
ok Uni.new(0xFC7E).NFKC.list ~~ (0x0642, 0x0649,), 'FC7E -> 0642 0649';
ok Uni.new(0xFC7F).NFKC.list ~~ (0x0642, 0x064A,), 'FC7F -> 0642 064A';
ok Uni.new(0xFC80).NFKC.list ~~ (0x0643, 0x0627,), 'FC80 -> 0643 0627';
ok Uni.new(0xFC81).NFKC.list ~~ (0x0643, 0x0644,), 'FC81 -> 0643 0644';
ok Uni.new(0xFC82).NFKC.list ~~ (0x0643, 0x0645,), 'FC82 -> 0643 0645';
ok Uni.new(0xFC83).NFKC.list ~~ (0x0643, 0x0649,), 'FC83 -> 0643 0649';
ok Uni.new(0xFC84).NFKC.list ~~ (0x0643, 0x064A,), 'FC84 -> 0643 064A';
ok Uni.new(0xFC85).NFKC.list ~~ (0x0644, 0x0645,), 'FC85 -> 0644 0645';
ok Uni.new(0xFC86).NFKC.list ~~ (0x0644, 0x0649,), 'FC86 -> 0644 0649';
ok Uni.new(0xFC87).NFKC.list ~~ (0x0644, 0x064A,), 'FC87 -> 0644 064A';
ok Uni.new(0xFC88).NFKC.list ~~ (0x0645, 0x0627,), 'FC88 -> 0645 0627';
ok Uni.new(0xFC89).NFKC.list ~~ (0x0645, 0x0645,), 'FC89 -> 0645 0645';
ok Uni.new(0xFC8A).NFKC.list ~~ (0x0646, 0x0631,), 'FC8A -> 0646 0631';
ok Uni.new(0xFC8B).NFKC.list ~~ (0x0646, 0x0632,), 'FC8B -> 0646 0632';
ok Uni.new(0xFC8C).NFKC.list ~~ (0x0646, 0x0645,), 'FC8C -> 0646 0645';
ok Uni.new(0xFC8D).NFKC.list ~~ (0x0646, 0x0646,), 'FC8D -> 0646 0646';
ok Uni.new(0xFC8E).NFKC.list ~~ (0x0646, 0x0649,), 'FC8E -> 0646 0649';
ok Uni.new(0xFC8F).NFKC.list ~~ (0x0646, 0x064A,), 'FC8F -> 0646 064A';
ok Uni.new(0xFC90).NFKC.list ~~ (0x0649, 0x0670,), 'FC90 -> 0649 0670';
ok Uni.new(0xFC91).NFKC.list ~~ (0x064A, 0x0631,), 'FC91 -> 064A 0631';
ok Uni.new(0xFC92).NFKC.list ~~ (0x064A, 0x0632,), 'FC92 -> 064A 0632';
ok Uni.new(0xFC93).NFKC.list ~~ (0x064A, 0x0645,), 'FC93 -> 064A 0645';
ok Uni.new(0xFC94).NFKC.list ~~ (0x064A, 0x0646,), 'FC94 -> 064A 0646';
ok Uni.new(0xFC95).NFKC.list ~~ (0x064A, 0x0649,), 'FC95 -> 064A 0649';
ok Uni.new(0xFC96).NFKC.list ~~ (0x064A, 0x064A,), 'FC96 -> 064A 064A';
ok Uni.new(0xFC97).NFKC.list ~~ (0x0626, 0x062C,), 'FC97 -> 0626 062C';
ok Uni.new(0xFC98).NFKC.list ~~ (0x0626, 0x062D,), 'FC98 -> 0626 062D';
ok Uni.new(0xFC99).NFKC.list ~~ (0x0626, 0x062E,), 'FC99 -> 0626 062E';
ok Uni.new(0xFC9A).NFKC.list ~~ (0x0626, 0x0645,), 'FC9A -> 0626 0645';
ok Uni.new(0xFC9B).NFKC.list ~~ (0x0626, 0x0647,), 'FC9B -> 0626 0647';
ok Uni.new(0xFC9C).NFKC.list ~~ (0x0628, 0x062C,), 'FC9C -> 0628 062C';
ok Uni.new(0xFC9D).NFKC.list ~~ (0x0628, 0x062D,), 'FC9D -> 0628 062D';
ok Uni.new(0xFC9E).NFKC.list ~~ (0x0628, 0x062E,), 'FC9E -> 0628 062E';
ok Uni.new(0xFC9F).NFKC.list ~~ (0x0628, 0x0645,), 'FC9F -> 0628 0645';
ok Uni.new(0xFCA0).NFKC.list ~~ (0x0628, 0x0647,), 'FCA0 -> 0628 0647';
ok Uni.new(0xFCA1).NFKC.list ~~ (0x062A, 0x062C,), 'FCA1 -> 062A 062C';
ok Uni.new(0xFCA2).NFKC.list ~~ (0x062A, 0x062D,), 'FCA2 -> 062A 062D';
ok Uni.new(0xFCA3).NFKC.list ~~ (0x062A, 0x062E,), 'FCA3 -> 062A 062E';
ok Uni.new(0xFCA4).NFKC.list ~~ (0x062A, 0x0645,), 'FCA4 -> 062A 0645';
ok Uni.new(0xFCA5).NFKC.list ~~ (0x062A, 0x0647,), 'FCA5 -> 062A 0647';
ok Uni.new(0xFCA6).NFKC.list ~~ (0x062B, 0x0645,), 'FCA6 -> 062B 0645';
ok Uni.new(0xFCA7).NFKC.list ~~ (0x062C, 0x062D,), 'FCA7 -> 062C 062D';
ok Uni.new(0xFCA8).NFKC.list ~~ (0x062C, 0x0645,), 'FCA8 -> 062C 0645';
ok Uni.new(0xFCA9).NFKC.list ~~ (0x062D, 0x062C,), 'FCA9 -> 062D 062C';
ok Uni.new(0xFCAA).NFKC.list ~~ (0x062D, 0x0645,), 'FCAA -> 062D 0645';
ok Uni.new(0xFCAB).NFKC.list ~~ (0x062E, 0x062C,), 'FCAB -> 062E 062C';
ok Uni.new(0xFCAC).NFKC.list ~~ (0x062E, 0x0645,), 'FCAC -> 062E 0645';
ok Uni.new(0xFCAD).NFKC.list ~~ (0x0633, 0x062C,), 'FCAD -> 0633 062C';
ok Uni.new(0xFCAE).NFKC.list ~~ (0x0633, 0x062D,), 'FCAE -> 0633 062D';
ok Uni.new(0xFCAF).NFKC.list ~~ (0x0633, 0x062E,), 'FCAF -> 0633 062E';
ok Uni.new(0xFCB0).NFKC.list ~~ (0x0633, 0x0645,), 'FCB0 -> 0633 0645';
ok Uni.new(0xFCB1).NFKC.list ~~ (0x0635, 0x062D,), 'FCB1 -> 0635 062D';
ok Uni.new(0xFCB2).NFKC.list ~~ (0x0635, 0x062E,), 'FCB2 -> 0635 062E';
ok Uni.new(0xFCB3).NFKC.list ~~ (0x0635, 0x0645,), 'FCB3 -> 0635 0645';
ok Uni.new(0xFCB4).NFKC.list ~~ (0x0636, 0x062C,), 'FCB4 -> 0636 062C';
ok Uni.new(0xFCB5).NFKC.list ~~ (0x0636, 0x062D,), 'FCB5 -> 0636 062D';
ok Uni.new(0xFCB6).NFKC.list ~~ (0x0636, 0x062E,), 'FCB6 -> 0636 062E';
ok Uni.new(0xFCB7).NFKC.list ~~ (0x0636, 0x0645,), 'FCB7 -> 0636 0645';
ok Uni.new(0xFCB8).NFKC.list ~~ (0x0637, 0x062D,), 'FCB8 -> 0637 062D';
ok Uni.new(0xFCB9).NFKC.list ~~ (0x0638, 0x0645,), 'FCB9 -> 0638 0645';
ok Uni.new(0xFCBA).NFKC.list ~~ (0x0639, 0x062C,), 'FCBA -> 0639 062C';
ok Uni.new(0xFCBB).NFKC.list ~~ (0x0639, 0x0645,), 'FCBB -> 0639 0645';
ok Uni.new(0xFCBC).NFKC.list ~~ (0x063A, 0x062C,), 'FCBC -> 063A 062C';
ok Uni.new(0xFCBD).NFKC.list ~~ (0x063A, 0x0645,), 'FCBD -> 063A 0645';
ok Uni.new(0xFCBE).NFKC.list ~~ (0x0641, 0x062C,), 'FCBE -> 0641 062C';
ok Uni.new(0xFCBF).NFKC.list ~~ (0x0641, 0x062D,), 'FCBF -> 0641 062D';
ok Uni.new(0xFCC0).NFKC.list ~~ (0x0641, 0x062E,), 'FCC0 -> 0641 062E';
ok Uni.new(0xFCC1).NFKC.list ~~ (0x0641, 0x0645,), 'FCC1 -> 0641 0645';
ok Uni.new(0xFCC2).NFKC.list ~~ (0x0642, 0x062D,), 'FCC2 -> 0642 062D';
ok Uni.new(0xFCC3).NFKC.list ~~ (0x0642, 0x0645,), 'FCC3 -> 0642 0645';
ok Uni.new(0xFCC4).NFKC.list ~~ (0x0643, 0x062C,), 'FCC4 -> 0643 062C';
ok Uni.new(0xFCC5).NFKC.list ~~ (0x0643, 0x062D,), 'FCC5 -> 0643 062D';
ok Uni.new(0xFCC6).NFKC.list ~~ (0x0643, 0x062E,), 'FCC6 -> 0643 062E';
ok Uni.new(0xFCC7).NFKC.list ~~ (0x0643, 0x0644,), 'FCC7 -> 0643 0644';
ok Uni.new(0xFCC8).NFKC.list ~~ (0x0643, 0x0645,), 'FCC8 -> 0643 0645';
ok Uni.new(0xFCC9).NFKC.list ~~ (0x0644, 0x062C,), 'FCC9 -> 0644 062C';
ok Uni.new(0xFCCA).NFKC.list ~~ (0x0644, 0x062D,), 'FCCA -> 0644 062D';
ok Uni.new(0xFCCB).NFKC.list ~~ (0x0644, 0x062E,), 'FCCB -> 0644 062E';
ok Uni.new(0xFCCC).NFKC.list ~~ (0x0644, 0x0645,), 'FCCC -> 0644 0645';
ok Uni.new(0xFCCD).NFKC.list ~~ (0x0644, 0x0647,), 'FCCD -> 0644 0647';
ok Uni.new(0xFCCE).NFKC.list ~~ (0x0645, 0x062C,), 'FCCE -> 0645 062C';
ok Uni.new(0xFCCF).NFKC.list ~~ (0x0645, 0x062D,), 'FCCF -> 0645 062D';
ok Uni.new(0xFCD0).NFKC.list ~~ (0x0645, 0x062E,), 'FCD0 -> 0645 062E';
ok Uni.new(0xFCD1).NFKC.list ~~ (0x0645, 0x0645,), 'FCD1 -> 0645 0645';
ok Uni.new(0xFCD2).NFKC.list ~~ (0x0646, 0x062C,), 'FCD2 -> 0646 062C';
ok Uni.new(0xFCD3).NFKC.list ~~ (0x0646, 0x062D,), 'FCD3 -> 0646 062D';
ok Uni.new(0xFCD4).NFKC.list ~~ (0x0646, 0x062E,), 'FCD4 -> 0646 062E';
ok Uni.new(0xFCD5).NFKC.list ~~ (0x0646, 0x0645,), 'FCD5 -> 0646 0645';
ok Uni.new(0xFCD6).NFKC.list ~~ (0x0646, 0x0647,), 'FCD6 -> 0646 0647';
ok Uni.new(0xFCD7).NFKC.list ~~ (0x0647, 0x062C,), 'FCD7 -> 0647 062C';
ok Uni.new(0xFCD8).NFKC.list ~~ (0x0647, 0x0645,), 'FCD8 -> 0647 0645';
ok Uni.new(0xFCD9).NFKC.list ~~ (0x0647, 0x0670,), 'FCD9 -> 0647 0670';
ok Uni.new(0xFCDA).NFKC.list ~~ (0x064A, 0x062C,), 'FCDA -> 064A 062C';
ok Uni.new(0xFCDB).NFKC.list ~~ (0x064A, 0x062D,), 'FCDB -> 064A 062D';
ok Uni.new(0xFCDC).NFKC.list ~~ (0x064A, 0x062E,), 'FCDC -> 064A 062E';
ok Uni.new(0xFCDD).NFKC.list ~~ (0x064A, 0x0645,), 'FCDD -> 064A 0645';
ok Uni.new(0xFCDE).NFKC.list ~~ (0x064A, 0x0647,), 'FCDE -> 064A 0647';
ok Uni.new(0xFCDF).NFKC.list ~~ (0x0626, 0x0645,), 'FCDF -> 0626 0645';
ok Uni.new(0xFCE0).NFKC.list ~~ (0x0626, 0x0647,), 'FCE0 -> 0626 0647';
ok Uni.new(0xFCE1).NFKC.list ~~ (0x0628, 0x0645,), 'FCE1 -> 0628 0645';
ok Uni.new(0xFCE2).NFKC.list ~~ (0x0628, 0x0647,), 'FCE2 -> 0628 0647';
ok Uni.new(0xFCE3).NFKC.list ~~ (0x062A, 0x0645,), 'FCE3 -> 062A 0645';
ok Uni.new(0xFCE4).NFKC.list ~~ (0x062A, 0x0647,), 'FCE4 -> 062A 0647';
ok Uni.new(0xFCE5).NFKC.list ~~ (0x062B, 0x0645,), 'FCE5 -> 062B 0645';
ok Uni.new(0xFCE6).NFKC.list ~~ (0x062B, 0x0647,), 'FCE6 -> 062B 0647';
ok Uni.new(0xFCE7).NFKC.list ~~ (0x0633, 0x0645,), 'FCE7 -> 0633 0645';
ok Uni.new(0xFCE8).NFKC.list ~~ (0x0633, 0x0647,), 'FCE8 -> 0633 0647';
ok Uni.new(0xFCE9).NFKC.list ~~ (0x0634, 0x0645,), 'FCE9 -> 0634 0645';
ok Uni.new(0xFCEA).NFKC.list ~~ (0x0634, 0x0647,), 'FCEA -> 0634 0647';
ok Uni.new(0xFCEB).NFKC.list ~~ (0x0643, 0x0644,), 'FCEB -> 0643 0644';
ok Uni.new(0xFCEC).NFKC.list ~~ (0x0643, 0x0645,), 'FCEC -> 0643 0645';
ok Uni.new(0xFCED).NFKC.list ~~ (0x0644, 0x0645,), 'FCED -> 0644 0645';
ok Uni.new(0xFCEE).NFKC.list ~~ (0x0646, 0x0645,), 'FCEE -> 0646 0645';
ok Uni.new(0xFCEF).NFKC.list ~~ (0x0646, 0x0647,), 'FCEF -> 0646 0647';
ok Uni.new(0xFCF0).NFKC.list ~~ (0x064A, 0x0645,), 'FCF0 -> 064A 0645';
ok Uni.new(0xFCF1).NFKC.list ~~ (0x064A, 0x0647,), 'FCF1 -> 064A 0647';
ok Uni.new(0xFCF2).NFKC.list ~~ (0x0640, 0x064E, 0x0651,), 'FCF2 -> 0640 064E 0651';
ok Uni.new(0xFCF3).NFKC.list ~~ (0x0640, 0x064F, 0x0651,), 'FCF3 -> 0640 064F 0651';
ok Uni.new(0xFCF4).NFKC.list ~~ (0x0640, 0x0650, 0x0651,), 'FCF4 -> 0640 0650 0651';
ok Uni.new(0xFCF5).NFKC.list ~~ (0x0637, 0x0649,), 'FCF5 -> 0637 0649';
ok Uni.new(0xFCF6).NFKC.list ~~ (0x0637, 0x064A,), 'FCF6 -> 0637 064A';
ok Uni.new(0xFCF7).NFKC.list ~~ (0x0639, 0x0649,), 'FCF7 -> 0639 0649';
ok Uni.new(0xFCF8).NFKC.list ~~ (0x0639, 0x064A,), 'FCF8 -> 0639 064A';
ok Uni.new(0xFCF9).NFKC.list ~~ (0x063A, 0x0649,), 'FCF9 -> 063A 0649';
ok Uni.new(0xFCFA).NFKC.list ~~ (0x063A, 0x064A,), 'FCFA -> 063A 064A';
ok Uni.new(0xFCFB).NFKC.list ~~ (0x0633, 0x0649,), 'FCFB -> 0633 0649';
ok Uni.new(0xFCFC).NFKC.list ~~ (0x0633, 0x064A,), 'FCFC -> 0633 064A';
ok Uni.new(0xFCFD).NFKC.list ~~ (0x0634, 0x0649,), 'FCFD -> 0634 0649';
ok Uni.new(0xFCFE).NFKC.list ~~ (0x0634, 0x064A,), 'FCFE -> 0634 064A';
ok Uni.new(0xFCFF).NFKC.list ~~ (0x062D, 0x0649,), 'FCFF -> 062D 0649';
ok Uni.new(0xFD00).NFKC.list ~~ (0x062D, 0x064A,), 'FD00 -> 062D 064A';
ok Uni.new(0xFD01).NFKC.list ~~ (0x062C, 0x0649,), 'FD01 -> 062C 0649';
ok Uni.new(0xFD02).NFKC.list ~~ (0x062C, 0x064A,), 'FD02 -> 062C 064A';
ok Uni.new(0xFD03).NFKC.list ~~ (0x062E, 0x0649,), 'FD03 -> 062E 0649';
ok Uni.new(0xFD04).NFKC.list ~~ (0x062E, 0x064A,), 'FD04 -> 062E 064A';
ok Uni.new(0xFD05).NFKC.list ~~ (0x0635, 0x0649,), 'FD05 -> 0635 0649';
ok Uni.new(0xFD06).NFKC.list ~~ (0x0635, 0x064A,), 'FD06 -> 0635 064A';
ok Uni.new(0xFD07).NFKC.list ~~ (0x0636, 0x0649,), 'FD07 -> 0636 0649';
ok Uni.new(0xFD08).NFKC.list ~~ (0x0636, 0x064A,), 'FD08 -> 0636 064A';
ok Uni.new(0xFD09).NFKC.list ~~ (0x0634, 0x062C,), 'FD09 -> 0634 062C';
ok Uni.new(0xFD0A).NFKC.list ~~ (0x0634, 0x062D,), 'FD0A -> 0634 062D';
ok Uni.new(0xFD0B).NFKC.list ~~ (0x0634, 0x062E,), 'FD0B -> 0634 062E';
ok Uni.new(0xFD0C).NFKC.list ~~ (0x0634, 0x0645,), 'FD0C -> 0634 0645';
ok Uni.new(0xFD0D).NFKC.list ~~ (0x0634, 0x0631,), 'FD0D -> 0634 0631';
ok Uni.new(0xFD0E).NFKC.list ~~ (0x0633, 0x0631,), 'FD0E -> 0633 0631';
ok Uni.new(0xFD0F).NFKC.list ~~ (0x0635, 0x0631,), 'FD0F -> 0635 0631';
ok Uni.new(0xFD10).NFKC.list ~~ (0x0636, 0x0631,), 'FD10 -> 0636 0631';
ok Uni.new(0xFD11).NFKC.list ~~ (0x0637, 0x0649,), 'FD11 -> 0637 0649';
ok Uni.new(0xFD12).NFKC.list ~~ (0x0637, 0x064A,), 'FD12 -> 0637 064A';
ok Uni.new(0xFD13).NFKC.list ~~ (0x0639, 0x0649,), 'FD13 -> 0639 0649';
ok Uni.new(0xFD14).NFKC.list ~~ (0x0639, 0x064A,), 'FD14 -> 0639 064A';
ok Uni.new(0xFD15).NFKC.list ~~ (0x063A, 0x0649,), 'FD15 -> 063A 0649';
ok Uni.new(0xFD16).NFKC.list ~~ (0x063A, 0x064A,), 'FD16 -> 063A 064A';
ok Uni.new(0xFD17).NFKC.list ~~ (0x0633, 0x0649,), 'FD17 -> 0633 0649';
ok Uni.new(0xFD18).NFKC.list ~~ (0x0633, 0x064A,), 'FD18 -> 0633 064A';
ok Uni.new(0xFD19).NFKC.list ~~ (0x0634, 0x0649,), 'FD19 -> 0634 0649';
ok Uni.new(0xFD1A).NFKC.list ~~ (0x0634, 0x064A,), 'FD1A -> 0634 064A';
ok Uni.new(0xFD1B).NFKC.list ~~ (0x062D, 0x0649,), 'FD1B -> 062D 0649';
ok Uni.new(0xFD1C).NFKC.list ~~ (0x062D, 0x064A,), 'FD1C -> 062D 064A';
ok Uni.new(0xFD1D).NFKC.list ~~ (0x062C, 0x0649,), 'FD1D -> 062C 0649';
ok Uni.new(0xFD1E).NFKC.list ~~ (0x062C, 0x064A,), 'FD1E -> 062C 064A';
ok Uni.new(0xFD1F).NFKC.list ~~ (0x062E, 0x0649,), 'FD1F -> 062E 0649';
ok Uni.new(0xFD20).NFKC.list ~~ (0x062E, 0x064A,), 'FD20 -> 062E 064A';
ok Uni.new(0xFD21).NFKC.list ~~ (0x0635, 0x0649,), 'FD21 -> 0635 0649';
ok Uni.new(0xFD22).NFKC.list ~~ (0x0635, 0x064A,), 'FD22 -> 0635 064A';
ok Uni.new(0xFD23).NFKC.list ~~ (0x0636, 0x0649,), 'FD23 -> 0636 0649';
ok Uni.new(0xFD24).NFKC.list ~~ (0x0636, 0x064A,), 'FD24 -> 0636 064A';
ok Uni.new(0xFD25).NFKC.list ~~ (0x0634, 0x062C,), 'FD25 -> 0634 062C';
ok Uni.new(0xFD26).NFKC.list ~~ (0x0634, 0x062D,), 'FD26 -> 0634 062D';
ok Uni.new(0xFD27).NFKC.list ~~ (0x0634, 0x062E,), 'FD27 -> 0634 062E';
ok Uni.new(0xFD28).NFKC.list ~~ (0x0634, 0x0645,), 'FD28 -> 0634 0645';
ok Uni.new(0xFD29).NFKC.list ~~ (0x0634, 0x0631,), 'FD29 -> 0634 0631';
ok Uni.new(0xFD2A).NFKC.list ~~ (0x0633, 0x0631,), 'FD2A -> 0633 0631';
ok Uni.new(0xFD2B).NFKC.list ~~ (0x0635, 0x0631,), 'FD2B -> 0635 0631';
ok Uni.new(0xFD2C).NFKC.list ~~ (0x0636, 0x0631,), 'FD2C -> 0636 0631';
ok Uni.new(0xFD2D).NFKC.list ~~ (0x0634, 0x062C,), 'FD2D -> 0634 062C';
ok Uni.new(0xFD2E).NFKC.list ~~ (0x0634, 0x062D,), 'FD2E -> 0634 062D';
ok Uni.new(0xFD2F).NFKC.list ~~ (0x0634, 0x062E,), 'FD2F -> 0634 062E';
ok Uni.new(0xFD30).NFKC.list ~~ (0x0634, 0x0645,), 'FD30 -> 0634 0645';
ok Uni.new(0xFD31).NFKC.list ~~ (0x0633, 0x0647,), 'FD31 -> 0633 0647';
ok Uni.new(0xFD32).NFKC.list ~~ (0x0634, 0x0647,), 'FD32 -> 0634 0647';
ok Uni.new(0xFD33).NFKC.list ~~ (0x0637, 0x0645,), 'FD33 -> 0637 0645';
ok Uni.new(0xFD34).NFKC.list ~~ (0x0633, 0x062C,), 'FD34 -> 0633 062C';
ok Uni.new(0xFD35).NFKC.list ~~ (0x0633, 0x062D,), 'FD35 -> 0633 062D';
ok Uni.new(0xFD36).NFKC.list ~~ (0x0633, 0x062E,), 'FD36 -> 0633 062E';
ok Uni.new(0xFD37).NFKC.list ~~ (0x0634, 0x062C,), 'FD37 -> 0634 062C';
ok Uni.new(0xFD38).NFKC.list ~~ (0x0634, 0x062D,), 'FD38 -> 0634 062D';
ok Uni.new(0xFD39).NFKC.list ~~ (0x0634, 0x062E,), 'FD39 -> 0634 062E';
ok Uni.new(0xFD3A).NFKC.list ~~ (0x0637, 0x0645,), 'FD3A -> 0637 0645';
ok Uni.new(0xFD3B).NFKC.list ~~ (0x0638, 0x0645,), 'FD3B -> 0638 0645';
ok Uni.new(0xFD3C).NFKC.list ~~ (0x0627, 0x064B,), 'FD3C -> 0627 064B';
ok Uni.new(0xFD3D).NFKC.list ~~ (0x0627, 0x064B,), 'FD3D -> 0627 064B';
ok Uni.new(0xFD50).NFKC.list ~~ (0x062A, 0x062C, 0x0645,), 'FD50 -> 062A 062C 0645';
ok Uni.new(0xFD51).NFKC.list ~~ (0x062A, 0x062D, 0x062C,), 'FD51 -> 062A 062D 062C';
ok Uni.new(0xFD52).NFKC.list ~~ (0x062A, 0x062D, 0x062C,), 'FD52 -> 062A 062D 062C';
ok Uni.new(0xFD53).NFKC.list ~~ (0x062A, 0x062D, 0x0645,), 'FD53 -> 062A 062D 0645';
ok Uni.new(0xFD54).NFKC.list ~~ (0x062A, 0x062E, 0x0645,), 'FD54 -> 062A 062E 0645';
ok Uni.new(0xFD55).NFKC.list ~~ (0x062A, 0x0645, 0x062C,), 'FD55 -> 062A 0645 062C';
ok Uni.new(0xFD56).NFKC.list ~~ (0x062A, 0x0645, 0x062D,), 'FD56 -> 062A 0645 062D';
ok Uni.new(0xFD57).NFKC.list ~~ (0x062A, 0x0645, 0x062E,), 'FD57 -> 062A 0645 062E';
ok Uni.new(0xFD58).NFKC.list ~~ (0x062C, 0x0645, 0x062D,), 'FD58 -> 062C 0645 062D';
ok Uni.new(0xFD59).NFKC.list ~~ (0x062C, 0x0645, 0x062D,), 'FD59 -> 062C 0645 062D';
ok Uni.new(0xFD5A).NFKC.list ~~ (0x062D, 0x0645, 0x064A,), 'FD5A -> 062D 0645 064A';
ok Uni.new(0xFD5B).NFKC.list ~~ (0x062D, 0x0645, 0x0649,), 'FD5B -> 062D 0645 0649';
ok Uni.new(0xFD5C).NFKC.list ~~ (0x0633, 0x062D, 0x062C,), 'FD5C -> 0633 062D 062C';
ok Uni.new(0xFD5D).NFKC.list ~~ (0x0633, 0x062C, 0x062D,), 'FD5D -> 0633 062C 062D';
ok Uni.new(0xFD5E).NFKC.list ~~ (0x0633, 0x062C, 0x0649,), 'FD5E -> 0633 062C 0649';
ok Uni.new(0xFD5F).NFKC.list ~~ (0x0633, 0x0645, 0x062D,), 'FD5F -> 0633 0645 062D';
ok Uni.new(0xFD60).NFKC.list ~~ (0x0633, 0x0645, 0x062D,), 'FD60 -> 0633 0645 062D';
ok Uni.new(0xFD61).NFKC.list ~~ (0x0633, 0x0645, 0x062C,), 'FD61 -> 0633 0645 062C';
ok Uni.new(0xFD62).NFKC.list ~~ (0x0633, 0x0645, 0x0645,), 'FD62 -> 0633 0645 0645';
ok Uni.new(0xFD63).NFKC.list ~~ (0x0633, 0x0645, 0x0645,), 'FD63 -> 0633 0645 0645';
ok Uni.new(0xFD64).NFKC.list ~~ (0x0635, 0x062D, 0x062D,), 'FD64 -> 0635 062D 062D';
ok Uni.new(0xFD65).NFKC.list ~~ (0x0635, 0x062D, 0x062D,), 'FD65 -> 0635 062D 062D';
ok Uni.new(0xFD66).NFKC.list ~~ (0x0635, 0x0645, 0x0645,), 'FD66 -> 0635 0645 0645';
ok Uni.new(0xFD67).NFKC.list ~~ (0x0634, 0x062D, 0x0645,), 'FD67 -> 0634 062D 0645';
ok Uni.new(0xFD68).NFKC.list ~~ (0x0634, 0x062D, 0x0645,), 'FD68 -> 0634 062D 0645';
ok Uni.new(0xFD69).NFKC.list ~~ (0x0634, 0x062C, 0x064A,), 'FD69 -> 0634 062C 064A';
ok Uni.new(0xFD6A).NFKC.list ~~ (0x0634, 0x0645, 0x062E,), 'FD6A -> 0634 0645 062E';
ok Uni.new(0xFD6B).NFKC.list ~~ (0x0634, 0x0645, 0x062E,), 'FD6B -> 0634 0645 062E';
ok Uni.new(0xFD6C).NFKC.list ~~ (0x0634, 0x0645, 0x0645,), 'FD6C -> 0634 0645 0645';
ok Uni.new(0xFD6D).NFKC.list ~~ (0x0634, 0x0645, 0x0645,), 'FD6D -> 0634 0645 0645';
ok Uni.new(0xFD6E).NFKC.list ~~ (0x0636, 0x062D, 0x0649,), 'FD6E -> 0636 062D 0649';
ok Uni.new(0xFD6F).NFKC.list ~~ (0x0636, 0x062E, 0x0645,), 'FD6F -> 0636 062E 0645';
ok Uni.new(0xFD70).NFKC.list ~~ (0x0636, 0x062E, 0x0645,), 'FD70 -> 0636 062E 0645';
ok Uni.new(0xFD71).NFKC.list ~~ (0x0637, 0x0645, 0x062D,), 'FD71 -> 0637 0645 062D';
ok Uni.new(0xFD72).NFKC.list ~~ (0x0637, 0x0645, 0x062D,), 'FD72 -> 0637 0645 062D';
ok Uni.new(0xFD73).NFKC.list ~~ (0x0637, 0x0645, 0x0645,), 'FD73 -> 0637 0645 0645';
ok Uni.new(0xFD74).NFKC.list ~~ (0x0637, 0x0645, 0x064A,), 'FD74 -> 0637 0645 064A';
ok Uni.new(0xFD75).NFKC.list ~~ (0x0639, 0x062C, 0x0645,), 'FD75 -> 0639 062C 0645';
ok Uni.new(0xFD76).NFKC.list ~~ (0x0639, 0x0645, 0x0645,), 'FD76 -> 0639 0645 0645';
ok Uni.new(0xFD77).NFKC.list ~~ (0x0639, 0x0645, 0x0645,), 'FD77 -> 0639 0645 0645';
ok Uni.new(0xFD78).NFKC.list ~~ (0x0639, 0x0645, 0x0649,), 'FD78 -> 0639 0645 0649';
ok Uni.new(0xFD79).NFKC.list ~~ (0x063A, 0x0645, 0x0645,), 'FD79 -> 063A 0645 0645';
ok Uni.new(0xFD7A).NFKC.list ~~ (0x063A, 0x0645, 0x064A,), 'FD7A -> 063A 0645 064A';
ok Uni.new(0xFD7B).NFKC.list ~~ (0x063A, 0x0645, 0x0649,), 'FD7B -> 063A 0645 0649';
ok Uni.new(0xFD7C).NFKC.list ~~ (0x0641, 0x062E, 0x0645,), 'FD7C -> 0641 062E 0645';
ok Uni.new(0xFD7D).NFKC.list ~~ (0x0641, 0x062E, 0x0645,), 'FD7D -> 0641 062E 0645';
ok Uni.new(0xFD7E).NFKC.list ~~ (0x0642, 0x0645, 0x062D,), 'FD7E -> 0642 0645 062D';
ok Uni.new(0xFD7F).NFKC.list ~~ (0x0642, 0x0645, 0x0645,), 'FD7F -> 0642 0645 0645';
ok Uni.new(0xFD80).NFKC.list ~~ (0x0644, 0x062D, 0x0645,), 'FD80 -> 0644 062D 0645';
ok Uni.new(0xFD81).NFKC.list ~~ (0x0644, 0x062D, 0x064A,), 'FD81 -> 0644 062D 064A';
ok Uni.new(0xFD82).NFKC.list ~~ (0x0644, 0x062D, 0x0649,), 'FD82 -> 0644 062D 0649';
ok Uni.new(0xFD83).NFKC.list ~~ (0x0644, 0x062C, 0x062C,), 'FD83 -> 0644 062C 062C';
ok Uni.new(0xFD84).NFKC.list ~~ (0x0644, 0x062C, 0x062C,), 'FD84 -> 0644 062C 062C';
ok Uni.new(0xFD85).NFKC.list ~~ (0x0644, 0x062E, 0x0645,), 'FD85 -> 0644 062E 0645';
ok Uni.new(0xFD86).NFKC.list ~~ (0x0644, 0x062E, 0x0645,), 'FD86 -> 0644 062E 0645';
ok Uni.new(0xFD87).NFKC.list ~~ (0x0644, 0x0645, 0x062D,), 'FD87 -> 0644 0645 062D';
ok Uni.new(0xFD88).NFKC.list ~~ (0x0644, 0x0645, 0x062D,), 'FD88 -> 0644 0645 062D';
ok Uni.new(0xFD89).NFKC.list ~~ (0x0645, 0x062D, 0x062C,), 'FD89 -> 0645 062D 062C';
ok Uni.new(0xFD8A).NFKC.list ~~ (0x0645, 0x062D, 0x0645,), 'FD8A -> 0645 062D 0645';
ok Uni.new(0xFD8B).NFKC.list ~~ (0x0645, 0x062D, 0x064A,), 'FD8B -> 0645 062D 064A';
ok Uni.new(0xFD8C).NFKC.list ~~ (0x0645, 0x062C, 0x062D,), 'FD8C -> 0645 062C 062D';
ok Uni.new(0xFD8D).NFKC.list ~~ (0x0645, 0x062C, 0x0645,), 'FD8D -> 0645 062C 0645';
ok Uni.new(0xFD8E).NFKC.list ~~ (0x0645, 0x062E, 0x062C,), 'FD8E -> 0645 062E 062C';
ok Uni.new(0xFD8F).NFKC.list ~~ (0x0645, 0x062E, 0x0645,), 'FD8F -> 0645 062E 0645';
ok Uni.new(0xFD92).NFKC.list ~~ (0x0645, 0x062C, 0x062E,), 'FD92 -> 0645 062C 062E';
ok Uni.new(0xFD93).NFKC.list ~~ (0x0647, 0x0645, 0x062C,), 'FD93 -> 0647 0645 062C';
ok Uni.new(0xFD94).NFKC.list ~~ (0x0647, 0x0645, 0x0645,), 'FD94 -> 0647 0645 0645';
ok Uni.new(0xFD95).NFKC.list ~~ (0x0646, 0x062D, 0x0645,), 'FD95 -> 0646 062D 0645';
ok Uni.new(0xFD96).NFKC.list ~~ (0x0646, 0x062D, 0x0649,), 'FD96 -> 0646 062D 0649';
ok Uni.new(0xFD97).NFKC.list ~~ (0x0646, 0x062C, 0x0645,), 'FD97 -> 0646 062C 0645';
ok Uni.new(0xFD98).NFKC.list ~~ (0x0646, 0x062C, 0x0645,), 'FD98 -> 0646 062C 0645';
ok Uni.new(0xFD99).NFKC.list ~~ (0x0646, 0x062C, 0x0649,), 'FD99 -> 0646 062C 0649';
ok Uni.new(0xFD9A).NFKC.list ~~ (0x0646, 0x0645, 0x064A,), 'FD9A -> 0646 0645 064A';
ok Uni.new(0xFD9B).NFKC.list ~~ (0x0646, 0x0645, 0x0649,), 'FD9B -> 0646 0645 0649';
ok Uni.new(0xFD9C).NFKC.list ~~ (0x064A, 0x0645, 0x0645,), 'FD9C -> 064A 0645 0645';
ok Uni.new(0xFD9D).NFKC.list ~~ (0x064A, 0x0645, 0x0645,), 'FD9D -> 064A 0645 0645';
ok Uni.new(0xFD9E).NFKC.list ~~ (0x0628, 0x062E, 0x064A,), 'FD9E -> 0628 062E 064A';
ok Uni.new(0xFD9F).NFKC.list ~~ (0x062A, 0x062C, 0x064A,), 'FD9F -> 062A 062C 064A';
ok Uni.new(0xFDA0).NFKC.list ~~ (0x062A, 0x062C, 0x0649,), 'FDA0 -> 062A 062C 0649';
ok Uni.new(0xFDA1).NFKC.list ~~ (0x062A, 0x062E, 0x064A,), 'FDA1 -> 062A 062E 064A';
ok Uni.new(0xFDA2).NFKC.list ~~ (0x062A, 0x062E, 0x0649,), 'FDA2 -> 062A 062E 0649';
ok Uni.new(0xFDA3).NFKC.list ~~ (0x062A, 0x0645, 0x064A,), 'FDA3 -> 062A 0645 064A';
ok Uni.new(0xFDA4).NFKC.list ~~ (0x062A, 0x0645, 0x0649,), 'FDA4 -> 062A 0645 0649';
ok Uni.new(0xFDA5).NFKC.list ~~ (0x062C, 0x0645, 0x064A,), 'FDA5 -> 062C 0645 064A';
ok Uni.new(0xFDA6).NFKC.list ~~ (0x062C, 0x062D, 0x0649,), 'FDA6 -> 062C 062D 0649';
ok Uni.new(0xFDA7).NFKC.list ~~ (0x062C, 0x0645, 0x0649,), 'FDA7 -> 062C 0645 0649';
ok Uni.new(0xFDA8).NFKC.list ~~ (0x0633, 0x062E, 0x0649,), 'FDA8 -> 0633 062E 0649';
ok Uni.new(0xFDA9).NFKC.list ~~ (0x0635, 0x062D, 0x064A,), 'FDA9 -> 0635 062D 064A';
ok Uni.new(0xFDAA).NFKC.list ~~ (0x0634, 0x062D, 0x064A,), 'FDAA -> 0634 062D 064A';
ok Uni.new(0xFDAB).NFKC.list ~~ (0x0636, 0x062D, 0x064A,), 'FDAB -> 0636 062D 064A';
ok Uni.new(0xFDAC).NFKC.list ~~ (0x0644, 0x062C, 0x064A,), 'FDAC -> 0644 062C 064A';
ok Uni.new(0xFDAD).NFKC.list ~~ (0x0644, 0x0645, 0x064A,), 'FDAD -> 0644 0645 064A';
ok Uni.new(0xFDAE).NFKC.list ~~ (0x064A, 0x062D, 0x064A,), 'FDAE -> 064A 062D 064A';
ok Uni.new(0xFDAF).NFKC.list ~~ (0x064A, 0x062C, 0x064A,), 'FDAF -> 064A 062C 064A';
ok Uni.new(0xFDB0).NFKC.list ~~ (0x064A, 0x0645, 0x064A,), 'FDB0 -> 064A 0645 064A';
ok Uni.new(0xFDB1).NFKC.list ~~ (0x0645, 0x0645, 0x064A,), 'FDB1 -> 0645 0645 064A';
ok Uni.new(0xFDB2).NFKC.list ~~ (0x0642, 0x0645, 0x064A,), 'FDB2 -> 0642 0645 064A';
ok Uni.new(0xFDB3).NFKC.list ~~ (0x0646, 0x062D, 0x064A,), 'FDB3 -> 0646 062D 064A';
ok Uni.new(0xFDB4).NFKC.list ~~ (0x0642, 0x0645, 0x062D,), 'FDB4 -> 0642 0645 062D';
ok Uni.new(0xFDB5).NFKC.list ~~ (0x0644, 0x062D, 0x0645,), 'FDB5 -> 0644 062D 0645';
ok Uni.new(0xFDB6).NFKC.list ~~ (0x0639, 0x0645, 0x064A,), 'FDB6 -> 0639 0645 064A';
ok Uni.new(0xFDB7).NFKC.list ~~ (0x0643, 0x0645, 0x064A,), 'FDB7 -> 0643 0645 064A';
ok Uni.new(0xFDB8).NFKC.list ~~ (0x0646, 0x062C, 0x062D,), 'FDB8 -> 0646 062C 062D';
ok Uni.new(0xFDB9).NFKC.list ~~ (0x0645, 0x062E, 0x064A,), 'FDB9 -> 0645 062E 064A';
ok Uni.new(0xFDBA).NFKC.list ~~ (0x0644, 0x062C, 0x0645,), 'FDBA -> 0644 062C 0645';
ok Uni.new(0xFDBB).NFKC.list ~~ (0x0643, 0x0645, 0x0645,), 'FDBB -> 0643 0645 0645';
ok Uni.new(0xFDBC).NFKC.list ~~ (0x0644, 0x062C, 0x0645,), 'FDBC -> 0644 062C 0645';
ok Uni.new(0xFDBD).NFKC.list ~~ (0x0646, 0x062C, 0x062D,), 'FDBD -> 0646 062C 062D';
ok Uni.new(0xFDBE).NFKC.list ~~ (0x062C, 0x062D, 0x064A,), 'FDBE -> 062C 062D 064A';
ok Uni.new(0xFDBF).NFKC.list ~~ (0x062D, 0x062C, 0x064A,), 'FDBF -> 062D 062C 064A';
ok Uni.new(0xFDC0).NFKC.list ~~ (0x0645, 0x062C, 0x064A,), 'FDC0 -> 0645 062C 064A';
ok Uni.new(0xFDC1).NFKC.list ~~ (0x0641, 0x0645, 0x064A,), 'FDC1 -> 0641 0645 064A';
ok Uni.new(0xFDC2).NFKC.list ~~ (0x0628, 0x062D, 0x064A,), 'FDC2 -> 0628 062D 064A';
ok Uni.new(0xFDC3).NFKC.list ~~ (0x0643, 0x0645, 0x0645,), 'FDC3 -> 0643 0645 0645';
ok Uni.new(0xFDC4).NFKC.list ~~ (0x0639, 0x062C, 0x0645,), 'FDC4 -> 0639 062C 0645';
ok Uni.new(0xFDC5).NFKC.list ~~ (0x0635, 0x0645, 0x0645,), 'FDC5 -> 0635 0645 0645';
ok Uni.new(0xFDC6).NFKC.list ~~ (0x0633, 0x062E, 0x064A,), 'FDC6 -> 0633 062E 064A';
ok Uni.new(0xFDC7).NFKC.list ~~ (0x0646, 0x062C, 0x064A,), 'FDC7 -> 0646 062C 064A';
ok Uni.new(0xFDF0).NFKC.list ~~ (0x0635, 0x0644, 0x06D2,), 'FDF0 -> 0635 0644 06D2';
ok Uni.new(0xFDF1).NFKC.list ~~ (0x0642, 0x0644, 0x06D2,), 'FDF1 -> 0642 0644 06D2';
ok Uni.new(0xFDF2).NFKC.list ~~ (0x0627, 0x0644, 0x0644, 0x0647,), 'FDF2 -> 0627 0644 0644 0647';
ok Uni.new(0xFDF3).NFKC.list ~~ (0x0627, 0x0643, 0x0628, 0x0631,), 'FDF3 -> 0627 0643 0628 0631';
ok Uni.new(0xFDF4).NFKC.list ~~ (0x0645, 0x062D, 0x0645, 0x062F,), 'FDF4 -> 0645 062D 0645 062F';
ok Uni.new(0xFDF5).NFKC.list ~~ (0x0635, 0x0644, 0x0639, 0x0645,), 'FDF5 -> 0635 0644 0639 0645';
ok Uni.new(0xFDF6).NFKC.list ~~ (0x0631, 0x0633, 0x0648, 0x0644,), 'FDF6 -> 0631 0633 0648 0644';
ok Uni.new(0xFDF7).NFKC.list ~~ (0x0639, 0x0644, 0x064A, 0x0647,), 'FDF7 -> 0639 0644 064A 0647';
ok Uni.new(0xFDF8).NFKC.list ~~ (0x0648, 0x0633, 0x0644, 0x0645,), 'FDF8 -> 0648 0633 0644 0645';
ok Uni.new(0xFDF9).NFKC.list ~~ (0x0635, 0x0644, 0x0649,), 'FDF9 -> 0635 0644 0649';
ok Uni.new(0xFDFA).NFKC.list ~~ (0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645,), 'FDFA -> 0635 0644 0649 0020 0627 0644 0644 0647 0020 0639 0644 064A 0647 0020 0648 0633 0644 0645';
ok Uni.new(0xFDFB).NFKC.list ~~ (0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647,), 'FDFB -> 062C 0644 0020 062C 0644 0627 0644 0647';
ok Uni.new(0xFDFC).NFKC.list ~~ (0x0631, 0x06CC, 0x0627, 0x0644,), 'FDFC -> 0631 06CC 0627 0644';
ok Uni.new(0xFE10).NFKC.list ~~ (0x002C,), 'FE10 -> 002C';
ok Uni.new(0xFE11).NFKC.list ~~ (0x3001,), 'FE11 -> 3001';
ok Uni.new(0xFE12).NFKC.list ~~ (0x3002,), 'FE12 -> 3002';
ok Uni.new(0xFE13).NFKC.list ~~ (0x003A,), 'FE13 -> 003A';
ok Uni.new(0xFE14).NFKC.list ~~ (0x003B,), 'FE14 -> 003B';
ok Uni.new(0xFE15).NFKC.list ~~ (0x0021,), 'FE15 -> 0021';
ok Uni.new(0xFE16).NFKC.list ~~ (0x003F,), 'FE16 -> 003F';
ok Uni.new(0xFE17).NFKC.list ~~ (0x3016,), 'FE17 -> 3016';
ok Uni.new(0xFE18).NFKC.list ~~ (0x3017,), 'FE18 -> 3017';
ok Uni.new(0xFE19).NFKC.list ~~ (0x002E, 0x002E, 0x002E,), 'FE19 -> 002E 002E 002E';
ok Uni.new(0xFE30).NFKC.list ~~ (0x002E, 0x002E,), 'FE30 -> 002E 002E';
ok Uni.new(0xFE31).NFKC.list ~~ (0x2014,), 'FE31 -> 2014';
ok Uni.new(0xFE32).NFKC.list ~~ (0x2013,), 'FE32 -> 2013';
ok Uni.new(0xFE33).NFKC.list ~~ (0x005F,), 'FE33 -> 005F';
ok Uni.new(0xFE34).NFKC.list ~~ (0x005F,), 'FE34 -> 005F';
ok Uni.new(0xFE35).NFKC.list ~~ (0x0028,), 'FE35 -> 0028';
ok Uni.new(0xFE36).NFKC.list ~~ (0x0029,), 'FE36 -> 0029';
ok Uni.new(0xFE37).NFKC.list ~~ (0x007B,), 'FE37 -> 007B';
ok Uni.new(0xFE38).NFKC.list ~~ (0x007D,), 'FE38 -> 007D';
ok Uni.new(0xFE39).NFKC.list ~~ (0x3014,), 'FE39 -> 3014';
ok Uni.new(0xFE3A).NFKC.list ~~ (0x3015,), 'FE3A -> 3015';
ok Uni.new(0xFE3B).NFKC.list ~~ (0x3010,), 'FE3B -> 3010';
ok Uni.new(0xFE3C).NFKC.list ~~ (0x3011,), 'FE3C -> 3011';
ok Uni.new(0xFE3D).NFKC.list ~~ (0x300A,), 'FE3D -> 300A';
ok Uni.new(0xFE3E).NFKC.list ~~ (0x300B,), 'FE3E -> 300B';
ok Uni.new(0xFE3F).NFKC.list ~~ (0x3008,), 'FE3F -> 3008';
ok Uni.new(0xFE40).NFKC.list ~~ (0x3009,), 'FE40 -> 3009';
ok Uni.new(0xFE41).NFKC.list ~~ (0x300C,), 'FE41 -> 300C';
ok Uni.new(0xFE42).NFKC.list ~~ (0x300D,), 'FE42 -> 300D';
ok Uni.new(0xFE43).NFKC.list ~~ (0x300E,), 'FE43 -> 300E';
ok Uni.new(0xFE44).NFKC.list ~~ (0x300F,), 'FE44 -> 300F';
ok Uni.new(0xFE47).NFKC.list ~~ (0x005B,), 'FE47 -> 005B';
ok Uni.new(0xFE48).NFKC.list ~~ (0x005D,), 'FE48 -> 005D';
ok Uni.new(0xFE49).NFKC.list ~~ (0x0020, 0x0305,), 'FE49 -> 0020 0305';
ok Uni.new(0xFE4A).NFKC.list ~~ (0x0020, 0x0305,), 'FE4A -> 0020 0305';
ok Uni.new(0xFE4B).NFKC.list ~~ (0x0020, 0x0305,), 'FE4B -> 0020 0305';
ok Uni.new(0xFE4C).NFKC.list ~~ (0x0020, 0x0305,), 'FE4C -> 0020 0305';
ok Uni.new(0xFE4D).NFKC.list ~~ (0x005F,), 'FE4D -> 005F';
ok Uni.new(0xFE4E).NFKC.list ~~ (0x005F,), 'FE4E -> 005F';
ok Uni.new(0xFE4F).NFKC.list ~~ (0x005F,), 'FE4F -> 005F';
ok Uni.new(0xFE50).NFKC.list ~~ (0x002C,), 'FE50 -> 002C';
ok Uni.new(0xFE51).NFKC.list ~~ (0x3001,), 'FE51 -> 3001';
ok Uni.new(0xFE52).NFKC.list ~~ (0x002E,), 'FE52 -> 002E';
ok Uni.new(0xFE54).NFKC.list ~~ (0x003B,), 'FE54 -> 003B';
ok Uni.new(0xFE55).NFKC.list ~~ (0x003A,), 'FE55 -> 003A';
ok Uni.new(0xFE56).NFKC.list ~~ (0x003F,), 'FE56 -> 003F';
ok Uni.new(0xFE57).NFKC.list ~~ (0x0021,), 'FE57 -> 0021';
ok Uni.new(0xFE58).NFKC.list ~~ (0x2014,), 'FE58 -> 2014';
ok Uni.new(0xFE59).NFKC.list ~~ (0x0028,), 'FE59 -> 0028';
ok Uni.new(0xFE5A).NFKC.list ~~ (0x0029,), 'FE5A -> 0029';
ok Uni.new(0xFE5B).NFKC.list ~~ (0x007B,), 'FE5B -> 007B';
ok Uni.new(0xFE5C).NFKC.list ~~ (0x007D,), 'FE5C -> 007D';
ok Uni.new(0xFE5D).NFKC.list ~~ (0x3014,), 'FE5D -> 3014';
ok Uni.new(0xFE5E).NFKC.list ~~ (0x3015,), 'FE5E -> 3015';
ok Uni.new(0xFE5F).NFKC.list ~~ (0x0023,), 'FE5F -> 0023';
ok Uni.new(0xFE60).NFKC.list ~~ (0x0026,), 'FE60 -> 0026';
ok Uni.new(0xFE61).NFKC.list ~~ (0x002A,), 'FE61 -> 002A';
ok Uni.new(0xFE62).NFKC.list ~~ (0x002B,), 'FE62 -> 002B';
ok Uni.new(0xFE63).NFKC.list ~~ (0x002D,), 'FE63 -> 002D';
ok Uni.new(0xFE64).NFKC.list ~~ (0x003C,), 'FE64 -> 003C';
ok Uni.new(0xFE65).NFKC.list ~~ (0x003E,), 'FE65 -> 003E';
ok Uni.new(0xFE66).NFKC.list ~~ (0x003D,), 'FE66 -> 003D';
ok Uni.new(0xFE68).NFKC.list ~~ (0x005C,), 'FE68 -> 005C';
ok Uni.new(0xFE69).NFKC.list ~~ (0x0024,), 'FE69 -> 0024';
ok Uni.new(0xFE6A).NFKC.list ~~ (0x0025,), 'FE6A -> 0025';
ok Uni.new(0xFE6B).NFKC.list ~~ (0x0040,), 'FE6B -> 0040';
ok Uni.new(0xFE70).NFKC.list ~~ (0x0020, 0x064B,), 'FE70 -> 0020 064B';
ok Uni.new(0xFE71).NFKC.list ~~ (0x0640, 0x064B,), 'FE71 -> 0640 064B';
ok Uni.new(0xFE72).NFKC.list ~~ (0x0020, 0x064C,), 'FE72 -> 0020 064C';
ok Uni.new(0xFE74).NFKC.list ~~ (0x0020, 0x064D,), 'FE74 -> 0020 064D';
ok Uni.new(0xFE76).NFKC.list ~~ (0x0020, 0x064E,), 'FE76 -> 0020 064E';
ok Uni.new(0xFE77).NFKC.list ~~ (0x0640, 0x064E,), 'FE77 -> 0640 064E';
ok Uni.new(0xFE78).NFKC.list ~~ (0x0020, 0x064F,), 'FE78 -> 0020 064F';
ok Uni.new(0xFE79).NFKC.list ~~ (0x0640, 0x064F,), 'FE79 -> 0640 064F';
ok Uni.new(0xFE7A).NFKC.list ~~ (0x0020, 0x0650,), 'FE7A -> 0020 0650';
ok Uni.new(0xFE7B).NFKC.list ~~ (0x0640, 0x0650,), 'FE7B -> 0640 0650';
ok Uni.new(0xFE7C).NFKC.list ~~ (0x0020, 0x0651,), 'FE7C -> 0020 0651';
ok Uni.new(0xFE7D).NFKC.list ~~ (0x0640, 0x0651,), 'FE7D -> 0640 0651';
ok Uni.new(0xFE7E).NFKC.list ~~ (0x0020, 0x0652,), 'FE7E -> 0020 0652';
ok Uni.new(0xFE7F).NFKC.list ~~ (0x0640, 0x0652,), 'FE7F -> 0640 0652';
ok Uni.new(0xFE80).NFKC.list ~~ (0x0621,), 'FE80 -> 0621';
ok Uni.new(0xFE81).NFKC.list ~~ (0x0622,), 'FE81 -> 0622';
ok Uni.new(0xFE82).NFKC.list ~~ (0x0622,), 'FE82 -> 0622';
ok Uni.new(0xFE83).NFKC.list ~~ (0x0623,), 'FE83 -> 0623';
ok Uni.new(0xFE84).NFKC.list ~~ (0x0623,), 'FE84 -> 0623';
ok Uni.new(0xFE85).NFKC.list ~~ (0x0624,), 'FE85 -> 0624';
ok Uni.new(0xFE86).NFKC.list ~~ (0x0624,), 'FE86 -> 0624';
ok Uni.new(0xFE87).NFKC.list ~~ (0x0625,), 'FE87 -> 0625';
ok Uni.new(0xFE88).NFKC.list ~~ (0x0625,), 'FE88 -> 0625';
ok Uni.new(0xFE89).NFKC.list ~~ (0x0626,), 'FE89 -> 0626';
ok Uni.new(0xFE8A).NFKC.list ~~ (0x0626,), 'FE8A -> 0626';
ok Uni.new(0xFE8B).NFKC.list ~~ (0x0626,), 'FE8B -> 0626';
ok Uni.new(0xFE8C).NFKC.list ~~ (0x0626,), 'FE8C -> 0626';
ok Uni.new(0xFE8D).NFKC.list ~~ (0x0627,), 'FE8D -> 0627';
ok Uni.new(0xFE8E).NFKC.list ~~ (0x0627,), 'FE8E -> 0627';
ok Uni.new(0xFE8F).NFKC.list ~~ (0x0628,), 'FE8F -> 0628';
ok Uni.new(0xFE90).NFKC.list ~~ (0x0628,), 'FE90 -> 0628';
ok Uni.new(0xFE91).NFKC.list ~~ (0x0628,), 'FE91 -> 0628';
ok Uni.new(0xFE92).NFKC.list ~~ (0x0628,), 'FE92 -> 0628';
ok Uni.new(0xFE93).NFKC.list ~~ (0x0629,), 'FE93 -> 0629';
ok Uni.new(0xFE94).NFKC.list ~~ (0x0629,), 'FE94 -> 0629';
ok Uni.new(0xFE95).NFKC.list ~~ (0x062A,), 'FE95 -> 062A';
ok Uni.new(0xFE96).NFKC.list ~~ (0x062A,), 'FE96 -> 062A';
ok Uni.new(0xFE97).NFKC.list ~~ (0x062A,), 'FE97 -> 062A';
ok Uni.new(0xFE98).NFKC.list ~~ (0x062A,), 'FE98 -> 062A';
ok Uni.new(0xFE99).NFKC.list ~~ (0x062B,), 'FE99 -> 062B';
ok Uni.new(0xFE9A).NFKC.list ~~ (0x062B,), 'FE9A -> 062B';
ok Uni.new(0xFE9B).NFKC.list ~~ (0x062B,), 'FE9B -> 062B';
ok Uni.new(0xFE9C).NFKC.list ~~ (0x062B,), 'FE9C -> 062B';
ok Uni.new(0xFE9D).NFKC.list ~~ (0x062C,), 'FE9D -> 062C';
ok Uni.new(0xFE9E).NFKC.list ~~ (0x062C,), 'FE9E -> 062C';
ok Uni.new(0xFE9F).NFKC.list ~~ (0x062C,), 'FE9F -> 062C';
ok Uni.new(0xFEA0).NFKC.list ~~ (0x062C,), 'FEA0 -> 062C';
ok Uni.new(0xFEA1).NFKC.list ~~ (0x062D,), 'FEA1 -> 062D';
ok Uni.new(0xFEA2).NFKC.list ~~ (0x062D,), 'FEA2 -> 062D';
ok Uni.new(0xFEA3).NFKC.list ~~ (0x062D,), 'FEA3 -> 062D';
ok Uni.new(0xFEA4).NFKC.list ~~ (0x062D,), 'FEA4 -> 062D';
ok Uni.new(0xFEA5).NFKC.list ~~ (0x062E,), 'FEA5 -> 062E';
ok Uni.new(0xFEA6).NFKC.list ~~ (0x062E,), 'FEA6 -> 062E';
ok Uni.new(0xFEA7).NFKC.list ~~ (0x062E,), 'FEA7 -> 062E';
ok Uni.new(0xFEA8).NFKC.list ~~ (0x062E,), 'FEA8 -> 062E';
ok Uni.new(0xFEA9).NFKC.list ~~ (0x062F,), 'FEA9 -> 062F';
ok Uni.new(0xFEAA).NFKC.list ~~ (0x062F,), 'FEAA -> 062F';
ok Uni.new(0xFEAB).NFKC.list ~~ (0x0630,), 'FEAB -> 0630';
ok Uni.new(0xFEAC).NFKC.list ~~ (0x0630,), 'FEAC -> 0630';
ok Uni.new(0xFEAD).NFKC.list ~~ (0x0631,), 'FEAD -> 0631';
ok Uni.new(0xFEAE).NFKC.list ~~ (0x0631,), 'FEAE -> 0631';
ok Uni.new(0xFEAF).NFKC.list ~~ (0x0632,), 'FEAF -> 0632';
ok Uni.new(0xFEB0).NFKC.list ~~ (0x0632,), 'FEB0 -> 0632';
ok Uni.new(0xFEB1).NFKC.list ~~ (0x0633,), 'FEB1 -> 0633';
ok Uni.new(0xFEB2).NFKC.list ~~ (0x0633,), 'FEB2 -> 0633';
ok Uni.new(0xFEB3).NFKC.list ~~ (0x0633,), 'FEB3 -> 0633';
ok Uni.new(0xFEB4).NFKC.list ~~ (0x0633,), 'FEB4 -> 0633';
ok Uni.new(0xFEB5).NFKC.list ~~ (0x0634,), 'FEB5 -> 0634';
ok Uni.new(0xFEB6).NFKC.list ~~ (0x0634,), 'FEB6 -> 0634';
ok Uni.new(0xFEB7).NFKC.list ~~ (0x0634,), 'FEB7 -> 0634';
ok Uni.new(0xFEB8).NFKC.list ~~ (0x0634,), 'FEB8 -> 0634';
ok Uni.new(0xFEB9).NFKC.list ~~ (0x0635,), 'FEB9 -> 0635';
ok Uni.new(0xFEBA).NFKC.list ~~ (0x0635,), 'FEBA -> 0635';
ok Uni.new(0xFEBB).NFKC.list ~~ (0x0635,), 'FEBB -> 0635';
ok Uni.new(0xFEBC).NFKC.list ~~ (0x0635,), 'FEBC -> 0635';
ok Uni.new(0xFEBD).NFKC.list ~~ (0x0636,), 'FEBD -> 0636';
ok Uni.new(0xFEBE).NFKC.list ~~ (0x0636,), 'FEBE -> 0636';
ok Uni.new(0xFEBF).NFKC.list ~~ (0x0636,), 'FEBF -> 0636';
ok Uni.new(0xFEC0).NFKC.list ~~ (0x0636,), 'FEC0 -> 0636';
ok Uni.new(0xFEC1).NFKC.list ~~ (0x0637,), 'FEC1 -> 0637';
ok Uni.new(0xFEC2).NFKC.list ~~ (0x0637,), 'FEC2 -> 0637';
ok Uni.new(0xFEC3).NFKC.list ~~ (0x0637,), 'FEC3 -> 0637';
ok Uni.new(0xFEC4).NFKC.list ~~ (0x0637,), 'FEC4 -> 0637';
ok Uni.new(0xFEC5).NFKC.list ~~ (0x0638,), 'FEC5 -> 0638';
ok Uni.new(0xFEC6).NFKC.list ~~ (0x0638,), 'FEC6 -> 0638';
ok Uni.new(0xFEC7).NFKC.list ~~ (0x0638,), 'FEC7 -> 0638';
ok Uni.new(0xFEC8).NFKC.list ~~ (0x0638,), 'FEC8 -> 0638';
ok Uni.new(0xFEC9).NFKC.list ~~ (0x0639,), 'FEC9 -> 0639';
ok Uni.new(0xFECA).NFKC.list ~~ (0x0639,), 'FECA -> 0639';
ok Uni.new(0xFECB).NFKC.list ~~ (0x0639,), 'FECB -> 0639';
ok Uni.new(0xFECC).NFKC.list ~~ (0x0639,), 'FECC -> 0639';
ok Uni.new(0xFECD).NFKC.list ~~ (0x063A,), 'FECD -> 063A';
ok Uni.new(0xFECE).NFKC.list ~~ (0x063A,), 'FECE -> 063A';
ok Uni.new(0xFECF).NFKC.list ~~ (0x063A,), 'FECF -> 063A';
ok Uni.new(0xFED0).NFKC.list ~~ (0x063A,), 'FED0 -> 063A';
ok Uni.new(0xFED1).NFKC.list ~~ (0x0641,), 'FED1 -> 0641';
ok Uni.new(0xFED2).NFKC.list ~~ (0x0641,), 'FED2 -> 0641';
ok Uni.new(0xFED3).NFKC.list ~~ (0x0641,), 'FED3 -> 0641';
ok Uni.new(0xFED4).NFKC.list ~~ (0x0641,), 'FED4 -> 0641';
ok Uni.new(0xFED5).NFKC.list ~~ (0x0642,), 'FED5 -> 0642';
ok Uni.new(0xFED6).NFKC.list ~~ (0x0642,), 'FED6 -> 0642';
ok Uni.new(0xFED7).NFKC.list ~~ (0x0642,), 'FED7 -> 0642';
ok Uni.new(0xFED8).NFKC.list ~~ (0x0642,), 'FED8 -> 0642';
ok Uni.new(0xFED9).NFKC.list ~~ (0x0643,), 'FED9 -> 0643';
ok Uni.new(0xFEDA).NFKC.list ~~ (0x0643,), 'FEDA -> 0643';
ok Uni.new(0xFEDB).NFKC.list ~~ (0x0643,), 'FEDB -> 0643';
ok Uni.new(0xFEDC).NFKC.list ~~ (0x0643,), 'FEDC -> 0643';
ok Uni.new(0xFEDD).NFKC.list ~~ (0x0644,), 'FEDD -> 0644';
ok Uni.new(0xFEDE).NFKC.list ~~ (0x0644,), 'FEDE -> 0644';
ok Uni.new(0xFEDF).NFKC.list ~~ (0x0644,), 'FEDF -> 0644';
ok Uni.new(0xFEE0).NFKC.list ~~ (0x0644,), 'FEE0 -> 0644';
ok Uni.new(0xFEE1).NFKC.list ~~ (0x0645,), 'FEE1 -> 0645';
ok Uni.new(0xFEE2).NFKC.list ~~ (0x0645,), 'FEE2 -> 0645';
ok Uni.new(0xFEE3).NFKC.list ~~ (0x0645,), 'FEE3 -> 0645';
ok Uni.new(0xFEE4).NFKC.list ~~ (0x0645,), 'FEE4 -> 0645';
ok Uni.new(0xFEE5).NFKC.list ~~ (0x0646,), 'FEE5 -> 0646';
ok Uni.new(0xFEE6).NFKC.list ~~ (0x0646,), 'FEE6 -> 0646';
ok Uni.new(0xFEE7).NFKC.list ~~ (0x0646,), 'FEE7 -> 0646';
ok Uni.new(0xFEE8).NFKC.list ~~ (0x0646,), 'FEE8 -> 0646';
ok Uni.new(0xFEE9).NFKC.list ~~ (0x0647,), 'FEE9 -> 0647';
ok Uni.new(0xFEEA).NFKC.list ~~ (0x0647,), 'FEEA -> 0647';
ok Uni.new(0xFEEB).NFKC.list ~~ (0x0647,), 'FEEB -> 0647';
ok Uni.new(0xFEEC).NFKC.list ~~ (0x0647,), 'FEEC -> 0647';
ok Uni.new(0xFEED).NFKC.list ~~ (0x0648,), 'FEED -> 0648';
ok Uni.new(0xFEEE).NFKC.list ~~ (0x0648,), 'FEEE -> 0648';
ok Uni.new(0xFEEF).NFKC.list ~~ (0x0649,), 'FEEF -> 0649';
ok Uni.new(0xFEF0).NFKC.list ~~ (0x0649,), 'FEF0 -> 0649';
ok Uni.new(0xFEF1).NFKC.list ~~ (0x064A,), 'FEF1 -> 064A';
ok Uni.new(0xFEF2).NFKC.list ~~ (0x064A,), 'FEF2 -> 064A';
ok Uni.new(0xFEF3).NFKC.list ~~ (0x064A,), 'FEF3 -> 064A';
ok Uni.new(0xFEF4).NFKC.list ~~ (0x064A,), 'FEF4 -> 064A';
ok Uni.new(0xFEF5).NFKC.list ~~ (0x0644, 0x0622,), 'FEF5 -> 0644 0622';
ok Uni.new(0xFEF6).NFKC.list ~~ (0x0644, 0x0622,), 'FEF6 -> 0644 0622';
ok Uni.new(0xFEF7).NFKC.list ~~ (0x0644, 0x0623,), 'FEF7 -> 0644 0623';
ok Uni.new(0xFEF8).NFKC.list ~~ (0x0644, 0x0623,), 'FEF8 -> 0644 0623';
ok Uni.new(0xFEF9).NFKC.list ~~ (0x0644, 0x0625,), 'FEF9 -> 0644 0625';
ok Uni.new(0xFEFA).NFKC.list ~~ (0x0644, 0x0625,), 'FEFA -> 0644 0625';
ok Uni.new(0xFEFB).NFKC.list ~~ (0x0644, 0x0627,), 'FEFB -> 0644 0627';
ok Uni.new(0xFEFC).NFKC.list ~~ (0x0644, 0x0627,), 'FEFC -> 0644 0627';
ok Uni.new(0xFF01).NFKC.list ~~ (0x0021,), 'FF01 -> 0021';
ok Uni.new(0xFF02).NFKC.list ~~ (0x0022,), 'FF02 -> 0022';
ok Uni.new(0xFF03).NFKC.list ~~ (0x0023,), 'FF03 -> 0023';
ok Uni.new(0xFF04).NFKC.list ~~ (0x0024,), 'FF04 -> 0024';
ok Uni.new(0xFF05).NFKC.list ~~ (0x0025,), 'FF05 -> 0025';
ok Uni.new(0xFF06).NFKC.list ~~ (0x0026,), 'FF06 -> 0026';
ok Uni.new(0xFF07).NFKC.list ~~ (0x0027,), 'FF07 -> 0027';
ok Uni.new(0xFF08).NFKC.list ~~ (0x0028,), 'FF08 -> 0028';
ok Uni.new(0xFF09).NFKC.list ~~ (0x0029,), 'FF09 -> 0029';
ok Uni.new(0xFF0A).NFKC.list ~~ (0x002A,), 'FF0A -> 002A';
ok Uni.new(0xFF0B).NFKC.list ~~ (0x002B,), 'FF0B -> 002B';
ok Uni.new(0xFF0C).NFKC.list ~~ (0x002C,), 'FF0C -> 002C';
ok Uni.new(0xFF0D).NFKC.list ~~ (0x002D,), 'FF0D -> 002D';
ok Uni.new(0xFF0E).NFKC.list ~~ (0x002E,), 'FF0E -> 002E';
ok Uni.new(0xFF0F).NFKC.list ~~ (0x002F,), 'FF0F -> 002F';
ok Uni.new(0xFF10).NFKC.list ~~ (0x0030,), 'FF10 -> 0030';
ok Uni.new(0xFF11).NFKC.list ~~ (0x0031,), 'FF11 -> 0031';
ok Uni.new(0xFF12).NFKC.list ~~ (0x0032,), 'FF12 -> 0032';
ok Uni.new(0xFF13).NFKC.list ~~ (0x0033,), 'FF13 -> 0033';
ok Uni.new(0xFF14).NFKC.list ~~ (0x0034,), 'FF14 -> 0034';
ok Uni.new(0xFF15).NFKC.list ~~ (0x0035,), 'FF15 -> 0035';
ok Uni.new(0xFF16).NFKC.list ~~ (0x0036,), 'FF16 -> 0036';
ok Uni.new(0xFF17).NFKC.list ~~ (0x0037,), 'FF17 -> 0037';
ok Uni.new(0xFF18).NFKC.list ~~ (0x0038,), 'FF18 -> 0038';
ok Uni.new(0xFF19).NFKC.list ~~ (0x0039,), 'FF19 -> 0039';
ok Uni.new(0xFF1A).NFKC.list ~~ (0x003A,), 'FF1A -> 003A';
ok Uni.new(0xFF1B).NFKC.list ~~ (0x003B,), 'FF1B -> 003B';
ok Uni.new(0xFF1C).NFKC.list ~~ (0x003C,), 'FF1C -> 003C';
ok Uni.new(0xFF1D).NFKC.list ~~ (0x003D,), 'FF1D -> 003D';
ok Uni.new(0xFF1E).NFKC.list ~~ (0x003E,), 'FF1E -> 003E';
ok Uni.new(0xFF1F).NFKC.list ~~ (0x003F,), 'FF1F -> 003F';
ok Uni.new(0xFF20).NFKC.list ~~ (0x0040,), 'FF20 -> 0040';
ok Uni.new(0xFF21).NFKC.list ~~ (0x0041,), 'FF21 -> 0041';
ok Uni.new(0xFF22).NFKC.list ~~ (0x0042,), 'FF22 -> 0042';
ok Uni.new(0xFF23).NFKC.list ~~ (0x0043,), 'FF23 -> 0043';
ok Uni.new(0xFF24).NFKC.list ~~ (0x0044,), 'FF24 -> 0044';
ok Uni.new(0xFF25).NFKC.list ~~ (0x0045,), 'FF25 -> 0045';
ok Uni.new(0xFF26).NFKC.list ~~ (0x0046,), 'FF26 -> 0046';
ok Uni.new(0xFF27).NFKC.list ~~ (0x0047,), 'FF27 -> 0047';
ok Uni.new(0xFF28).NFKC.list ~~ (0x0048,), 'FF28 -> 0048';
ok Uni.new(0xFF29).NFKC.list ~~ (0x0049,), 'FF29 -> 0049';
ok Uni.new(0xFF2A).NFKC.list ~~ (0x004A,), 'FF2A -> 004A';
ok Uni.new(0xFF2B).NFKC.list ~~ (0x004B,), 'FF2B -> 004B';
ok Uni.new(0xFF2C).NFKC.list ~~ (0x004C,), 'FF2C -> 004C';
ok Uni.new(0xFF2D).NFKC.list ~~ (0x004D,), 'FF2D -> 004D';
ok Uni.new(0xFF2E).NFKC.list ~~ (0x004E,), 'FF2E -> 004E';
ok Uni.new(0xFF2F).NFKC.list ~~ (0x004F,), 'FF2F -> 004F';
ok Uni.new(0xFF30).NFKC.list ~~ (0x0050,), 'FF30 -> 0050';
ok Uni.new(0xFF31).NFKC.list ~~ (0x0051,), 'FF31 -> 0051';
ok Uni.new(0xFF32).NFKC.list ~~ (0x0052,), 'FF32 -> 0052';
ok Uni.new(0xFF33).NFKC.list ~~ (0x0053,), 'FF33 -> 0053';
ok Uni.new(0xFF34).NFKC.list ~~ (0x0054,), 'FF34 -> 0054';
ok Uni.new(0xFF35).NFKC.list ~~ (0x0055,), 'FF35 -> 0055';
ok Uni.new(0xFF36).NFKC.list ~~ (0x0056,), 'FF36 -> 0056';
ok Uni.new(0xFF37).NFKC.list ~~ (0x0057,), 'FF37 -> 0057';
ok Uni.new(0xFF38).NFKC.list ~~ (0x0058,), 'FF38 -> 0058';
ok Uni.new(0xFF39).NFKC.list ~~ (0x0059,), 'FF39 -> 0059';
ok Uni.new(0xFF3A).NFKC.list ~~ (0x005A,), 'FF3A -> 005A';
ok Uni.new(0xFF3B).NFKC.list ~~ (0x005B,), 'FF3B -> 005B';
ok Uni.new(0xFF3C).NFKC.list ~~ (0x005C,), 'FF3C -> 005C';
ok Uni.new(0xFF3D).NFKC.list ~~ (0x005D,), 'FF3D -> 005D';
ok Uni.new(0xFF3E).NFKC.list ~~ (0x005E,), 'FF3E -> 005E';
ok Uni.new(0xFF3F).NFKC.list ~~ (0x005F,), 'FF3F -> 005F';
ok Uni.new(0xFF40).NFKC.list ~~ (0x0060,), 'FF40 -> 0060';
ok Uni.new(0xFF41).NFKC.list ~~ (0x0061,), 'FF41 -> 0061';
ok Uni.new(0xFF42).NFKC.list ~~ (0x0062,), 'FF42 -> 0062';
ok Uni.new(0xFF43).NFKC.list ~~ (0x0063,), 'FF43 -> 0063';
ok Uni.new(0xFF44).NFKC.list ~~ (0x0064,), 'FF44 -> 0064';
ok Uni.new(0xFF45).NFKC.list ~~ (0x0065,), 'FF45 -> 0065';
ok Uni.new(0xFF46).NFKC.list ~~ (0x0066,), 'FF46 -> 0066';
ok Uni.new(0xFF47).NFKC.list ~~ (0x0067,), 'FF47 -> 0067';
ok Uni.new(0xFF48).NFKC.list ~~ (0x0068,), 'FF48 -> 0068';
ok Uni.new(0xFF49).NFKC.list ~~ (0x0069,), 'FF49 -> 0069';
ok Uni.new(0xFF4A).NFKC.list ~~ (0x006A,), 'FF4A -> 006A';
ok Uni.new(0xFF4B).NFKC.list ~~ (0x006B,), 'FF4B -> 006B';
ok Uni.new(0xFF4C).NFKC.list ~~ (0x006C,), 'FF4C -> 006C';
ok Uni.new(0xFF4D).NFKC.list ~~ (0x006D,), 'FF4D -> 006D';
ok Uni.new(0xFF4E).NFKC.list ~~ (0x006E,), 'FF4E -> 006E';
ok Uni.new(0xFF4F).NFKC.list ~~ (0x006F,), 'FF4F -> 006F';
ok Uni.new(0xFF50).NFKC.list ~~ (0x0070,), 'FF50 -> 0070';
ok Uni.new(0xFF51).NFKC.list ~~ (0x0071,), 'FF51 -> 0071';
ok Uni.new(0xFF52).NFKC.list ~~ (0x0072,), 'FF52 -> 0072';
ok Uni.new(0xFF53).NFKC.list ~~ (0x0073,), 'FF53 -> 0073';
ok Uni.new(0xFF54).NFKC.list ~~ (0x0074,), 'FF54 -> 0074';
ok Uni.new(0xFF55).NFKC.list ~~ (0x0075,), 'FF55 -> 0075';
ok Uni.new(0xFF56).NFKC.list ~~ (0x0076,), 'FF56 -> 0076';
ok Uni.new(0xFF57).NFKC.list ~~ (0x0077,), 'FF57 -> 0077';
ok Uni.new(0xFF58).NFKC.list ~~ (0x0078,), 'FF58 -> 0078';
ok Uni.new(0xFF59).NFKC.list ~~ (0x0079,), 'FF59 -> 0079';
ok Uni.new(0xFF5A).NFKC.list ~~ (0x007A,), 'FF5A -> 007A';
ok Uni.new(0xFF5B).NFKC.list ~~ (0x007B,), 'FF5B -> 007B';
ok Uni.new(0xFF5C).NFKC.list ~~ (0x007C,), 'FF5C -> 007C';
ok Uni.new(0xFF5D).NFKC.list ~~ (0x007D,), 'FF5D -> 007D';
ok Uni.new(0xFF5E).NFKC.list ~~ (0x007E,), 'FF5E -> 007E';
ok Uni.new(0xFF5F).NFKC.list ~~ (0x2985,), 'FF5F -> 2985';
ok Uni.new(0xFF60).NFKC.list ~~ (0x2986,), 'FF60 -> 2986';
ok Uni.new(0xFF61).NFKC.list ~~ (0x3002,), 'FF61 -> 3002';
ok Uni.new(0xFF62).NFKC.list ~~ (0x300C,), 'FF62 -> 300C';
ok Uni.new(0xFF63).NFKC.list ~~ (0x300D,), 'FF63 -> 300D';
ok Uni.new(0xFF64).NFKC.list ~~ (0x3001,), 'FF64 -> 3001';
ok Uni.new(0xFF65).NFKC.list ~~ (0x30FB,), 'FF65 -> 30FB';
ok Uni.new(0xFF66).NFKC.list ~~ (0x30F2,), 'FF66 -> 30F2';
ok Uni.new(0xFF67).NFKC.list ~~ (0x30A1,), 'FF67 -> 30A1';
ok Uni.new(0xFF68).NFKC.list ~~ (0x30A3,), 'FF68 -> 30A3';
ok Uni.new(0xFF69).NFKC.list ~~ (0x30A5,), 'FF69 -> 30A5';
ok Uni.new(0xFF6A).NFKC.list ~~ (0x30A7,), 'FF6A -> 30A7';
ok Uni.new(0xFF6B).NFKC.list ~~ (0x30A9,), 'FF6B -> 30A9';
ok Uni.new(0xFF6C).NFKC.list ~~ (0x30E3,), 'FF6C -> 30E3';
ok Uni.new(0xFF6D).NFKC.list ~~ (0x30E5,), 'FF6D -> 30E5';
ok Uni.new(0xFF6E).NFKC.list ~~ (0x30E7,), 'FF6E -> 30E7';
ok Uni.new(0xFF6F).NFKC.list ~~ (0x30C3,), 'FF6F -> 30C3';
ok Uni.new(0xFF70).NFKC.list ~~ (0x30FC,), 'FF70 -> 30FC';
ok Uni.new(0xFF71).NFKC.list ~~ (0x30A2,), 'FF71 -> 30A2';
ok Uni.new(0xFF72).NFKC.list ~~ (0x30A4,), 'FF72 -> 30A4';
ok Uni.new(0xFF73).NFKC.list ~~ (0x30A6,), 'FF73 -> 30A6';
ok Uni.new(0xFF74).NFKC.list ~~ (0x30A8,), 'FF74 -> 30A8';
ok Uni.new(0xFF75).NFKC.list ~~ (0x30AA,), 'FF75 -> 30AA';
ok Uni.new(0xFF76).NFKC.list ~~ (0x30AB,), 'FF76 -> 30AB';
ok Uni.new(0xFF77).NFKC.list ~~ (0x30AD,), 'FF77 -> 30AD';
ok Uni.new(0xFF78).NFKC.list ~~ (0x30AF,), 'FF78 -> 30AF';
ok Uni.new(0xFF79).NFKC.list ~~ (0x30B1,), 'FF79 -> 30B1';
ok Uni.new(0xFF7A).NFKC.list ~~ (0x30B3,), 'FF7A -> 30B3';
ok Uni.new(0xFF7B).NFKC.list ~~ (0x30B5,), 'FF7B -> 30B5';
ok Uni.new(0xFF7C).NFKC.list ~~ (0x30B7,), 'FF7C -> 30B7';
ok Uni.new(0xFF7D).NFKC.list ~~ (0x30B9,), 'FF7D -> 30B9';
ok Uni.new(0xFF7E).NFKC.list ~~ (0x30BB,), 'FF7E -> 30BB';
ok Uni.new(0xFF7F).NFKC.list ~~ (0x30BD,), 'FF7F -> 30BD';
ok Uni.new(0xFF80).NFKC.list ~~ (0x30BF,), 'FF80 -> 30BF';
ok Uni.new(0xFF81).NFKC.list ~~ (0x30C1,), 'FF81 -> 30C1';
ok Uni.new(0xFF82).NFKC.list ~~ (0x30C4,), 'FF82 -> 30C4';
ok Uni.new(0xFF83).NFKC.list ~~ (0x30C6,), 'FF83 -> 30C6';
ok Uni.new(0xFF84).NFKC.list ~~ (0x30C8,), 'FF84 -> 30C8';
ok Uni.new(0xFF85).NFKC.list ~~ (0x30CA,), 'FF85 -> 30CA';
ok Uni.new(0xFF86).NFKC.list ~~ (0x30CB,), 'FF86 -> 30CB';
ok Uni.new(0xFF87).NFKC.list ~~ (0x30CC,), 'FF87 -> 30CC';
ok Uni.new(0xFF88).NFKC.list ~~ (0x30CD,), 'FF88 -> 30CD';
ok Uni.new(0xFF89).NFKC.list ~~ (0x30CE,), 'FF89 -> 30CE';
ok Uni.new(0xFF8A).NFKC.list ~~ (0x30CF,), 'FF8A -> 30CF';
ok Uni.new(0xFF8B).NFKC.list ~~ (0x30D2,), 'FF8B -> 30D2';
ok Uni.new(0xFF8C).NFKC.list ~~ (0x30D5,), 'FF8C -> 30D5';
ok Uni.new(0xFF8D).NFKC.list ~~ (0x30D8,), 'FF8D -> 30D8';
ok Uni.new(0xFF8E).NFKC.list ~~ (0x30DB,), 'FF8E -> 30DB';
ok Uni.new(0xFF8F).NFKC.list ~~ (0x30DE,), 'FF8F -> 30DE';
ok Uni.new(0xFF90).NFKC.list ~~ (0x30DF,), 'FF90 -> 30DF';
ok Uni.new(0xFF91).NFKC.list ~~ (0x30E0,), 'FF91 -> 30E0';
ok Uni.new(0xFF92).NFKC.list ~~ (0x30E1,), 'FF92 -> 30E1';
ok Uni.new(0xFF93).NFKC.list ~~ (0x30E2,), 'FF93 -> 30E2';
ok Uni.new(0xFF94).NFKC.list ~~ (0x30E4,), 'FF94 -> 30E4';
ok Uni.new(0xFF95).NFKC.list ~~ (0x30E6,), 'FF95 -> 30E6';
ok Uni.new(0xFF96).NFKC.list ~~ (0x30E8,), 'FF96 -> 30E8';
ok Uni.new(0xFF97).NFKC.list ~~ (0x30E9,), 'FF97 -> 30E9';
ok Uni.new(0xFF98).NFKC.list ~~ (0x30EA,), 'FF98 -> 30EA';
ok Uni.new(0xFF99).NFKC.list ~~ (0x30EB,), 'FF99 -> 30EB';
ok Uni.new(0xFF9A).NFKC.list ~~ (0x30EC,), 'FF9A -> 30EC';
ok Uni.new(0xFF9B).NFKC.list ~~ (0x30ED,), 'FF9B -> 30ED';
ok Uni.new(0xFF9C).NFKC.list ~~ (0x30EF,), 'FF9C -> 30EF';
ok Uni.new(0xFF9D).NFKC.list ~~ (0x30F3,), 'FF9D -> 30F3';
ok Uni.new(0xFF9E).NFKC.list ~~ (0x3099,), 'FF9E -> 3099';
ok Uni.new(0xFF9F).NFKC.list ~~ (0x309A,), 'FF9F -> 309A';
ok Uni.new(0xFFA0).NFKC.list ~~ (0x1160,), 'FFA0 -> 1160';
ok Uni.new(0xFFA1).NFKC.list ~~ (0x1100,), 'FFA1 -> 1100';
ok Uni.new(0xFFA2).NFKC.list ~~ (0x1101,), 'FFA2 -> 1101';
ok Uni.new(0xFFA3).NFKC.list ~~ (0x11AA,), 'FFA3 -> 11AA';
ok Uni.new(0xFFA4).NFKC.list ~~ (0x1102,), 'FFA4 -> 1102';
ok Uni.new(0xFFA5).NFKC.list ~~ (0x11AC,), 'FFA5 -> 11AC';
ok Uni.new(0xFFA6).NFKC.list ~~ (0x11AD,), 'FFA6 -> 11AD';
ok Uni.new(0xFFA7).NFKC.list ~~ (0x1103,), 'FFA7 -> 1103';
ok Uni.new(0xFFA8).NFKC.list ~~ (0x1104,), 'FFA8 -> 1104';
ok Uni.new(0xFFA9).NFKC.list ~~ (0x1105,), 'FFA9 -> 1105';
ok Uni.new(0xFFAA).NFKC.list ~~ (0x11B0,), 'FFAA -> 11B0';
ok Uni.new(0xFFAB).NFKC.list ~~ (0x11B1,), 'FFAB -> 11B1';
ok Uni.new(0xFFAC).NFKC.list ~~ (0x11B2,), 'FFAC -> 11B2';
ok Uni.new(0xFFAD).NFKC.list ~~ (0x11B3,), 'FFAD -> 11B3';
ok Uni.new(0xFFAE).NFKC.list ~~ (0x11B4,), 'FFAE -> 11B4';
ok Uni.new(0xFFAF).NFKC.list ~~ (0x11B5,), 'FFAF -> 11B5';
ok Uni.new(0xFFB0).NFKC.list ~~ (0x111A,), 'FFB0 -> 111A';
ok Uni.new(0xFFB1).NFKC.list ~~ (0x1106,), 'FFB1 -> 1106';
ok Uni.new(0xFFB2).NFKC.list ~~ (0x1107,), 'FFB2 -> 1107';
ok Uni.new(0xFFB3).NFKC.list ~~ (0x1108,), 'FFB3 -> 1108';
ok Uni.new(0xFFB4).NFKC.list ~~ (0x1121,), 'FFB4 -> 1121';
ok Uni.new(0xFFB5).NFKC.list ~~ (0x1109,), 'FFB5 -> 1109';
ok Uni.new(0xFFB6).NFKC.list ~~ (0x110A,), 'FFB6 -> 110A';
ok Uni.new(0xFFB7).NFKC.list ~~ (0x110B,), 'FFB7 -> 110B';
ok Uni.new(0xFFB8).NFKC.list ~~ (0x110C,), 'FFB8 -> 110C';
ok Uni.new(0xFFB9).NFKC.list ~~ (0x110D,), 'FFB9 -> 110D';
ok Uni.new(0xFFBA).NFKC.list ~~ (0x110E,), 'FFBA -> 110E';
ok Uni.new(0xFFBB).NFKC.list ~~ (0x110F,), 'FFBB -> 110F';
ok Uni.new(0xFFBC).NFKC.list ~~ (0x1110,), 'FFBC -> 1110';
ok Uni.new(0xFFBD).NFKC.list ~~ (0x1111,), 'FFBD -> 1111';
ok Uni.new(0xFFBE).NFKC.list ~~ (0x1112,), 'FFBE -> 1112';
ok Uni.new(0xFFC2).NFKC.list ~~ (0x1161,), 'FFC2 -> 1161';
ok Uni.new(0xFFC3).NFKC.list ~~ (0x1162,), 'FFC3 -> 1162';
ok Uni.new(0xFFC4).NFKC.list ~~ (0x1163,), 'FFC4 -> 1163';
ok Uni.new(0xFFC5).NFKC.list ~~ (0x1164,), 'FFC5 -> 1164';
ok Uni.new(0xFFC6).NFKC.list ~~ (0x1165,), 'FFC6 -> 1165';
ok Uni.new(0xFFC7).NFKC.list ~~ (0x1166,), 'FFC7 -> 1166';
ok Uni.new(0xFFCA).NFKC.list ~~ (0x1167,), 'FFCA -> 1167';
ok Uni.new(0xFFCB).NFKC.list ~~ (0x1168,), 'FFCB -> 1168';
ok Uni.new(0xFFCC).NFKC.list ~~ (0x1169,), 'FFCC -> 1169';
ok Uni.new(0xFFCD).NFKC.list ~~ (0x116A,), 'FFCD -> 116A';
ok Uni.new(0xFFCE).NFKC.list ~~ (0x116B,), 'FFCE -> 116B';
ok Uni.new(0xFFCF).NFKC.list ~~ (0x116C,), 'FFCF -> 116C';
ok Uni.new(0xFFD2).NFKC.list ~~ (0x116D,), 'FFD2 -> 116D';
ok Uni.new(0xFFD3).NFKC.list ~~ (0x116E,), 'FFD3 -> 116E';
ok Uni.new(0xFFD4).NFKC.list ~~ (0x116F,), 'FFD4 -> 116F';
ok Uni.new(0xFFD5).NFKC.list ~~ (0x1170,), 'FFD5 -> 1170';
ok Uni.new(0xFFD6).NFKC.list ~~ (0x1171,), 'FFD6 -> 1171';
ok Uni.new(0xFFD7).NFKC.list ~~ (0x1172,), 'FFD7 -> 1172';
ok Uni.new(0xFFDA).NFKC.list ~~ (0x1173,), 'FFDA -> 1173';
ok Uni.new(0xFFDB).NFKC.list ~~ (0x1174,), 'FFDB -> 1174';
ok Uni.new(0xFFDC).NFKC.list ~~ (0x1175,), 'FFDC -> 1175';
ok Uni.new(0xFFE0).NFKC.list ~~ (0x00A2,), 'FFE0 -> 00A2';
ok Uni.new(0xFFE1).NFKC.list ~~ (0x00A3,), 'FFE1 -> 00A3';
ok Uni.new(0xFFE2).NFKC.list ~~ (0x00AC,), 'FFE2 -> 00AC';
ok Uni.new(0xFFE3).NFKC.list ~~ (0x0020, 0x0304,), 'FFE3 -> 0020 0304';
ok Uni.new(0xFFE4).NFKC.list ~~ (0x00A6,), 'FFE4 -> 00A6';
ok Uni.new(0xFFE5).NFKC.list ~~ (0x00A5,), 'FFE5 -> 00A5';
ok Uni.new(0xFFE6).NFKC.list ~~ (0x20A9,), 'FFE6 -> 20A9';
ok Uni.new(0xFFE8).NFKC.list ~~ (0x2502,), 'FFE8 -> 2502';
ok Uni.new(0xFFE9).NFKC.list ~~ (0x2190,), 'FFE9 -> 2190';
ok Uni.new(0xFFEA).NFKC.list ~~ (0x2191,), 'FFEA -> 2191';
ok Uni.new(0xFFEB).NFKC.list ~~ (0x2192,), 'FFEB -> 2192';
ok Uni.new(0xFFEC).NFKC.list ~~ (0x2193,), 'FFEC -> 2193';
ok Uni.new(0xFFED).NFKC.list ~~ (0x25A0,), 'FFED -> 25A0';
ok Uni.new(0xFFEE).NFKC.list ~~ (0x25CB,), 'FFEE -> 25CB';
ok Uni.new(0x10781).NFKC.list ~~ (0x02D0,), '10781 -> 02D0';
ok Uni.new(0x10782).NFKC.list ~~ (0x02D1,), '10782 -> 02D1';
ok Uni.new(0x10783).NFKC.list ~~ (0x00E6,), '10783 -> 00E6';
ok Uni.new(0x10784).NFKC.list ~~ (0x0299,), '10784 -> 0299';
ok Uni.new(0x10785).NFKC.list ~~ (0x0253,), '10785 -> 0253';
ok Uni.new(0x10787).NFKC.list ~~ (0x02A3,), '10787 -> 02A3';
ok Uni.new(0x10788).NFKC.list ~~ (0xAB66,), '10788 -> AB66';
ok Uni.new(0x10789).NFKC.list ~~ (0x02A5,), '10789 -> 02A5';
ok Uni.new(0x1078A).NFKC.list ~~ (0x02A4,), '1078A -> 02A4';
ok Uni.new(0x1078B).NFKC.list ~~ (0x0256,), '1078B -> 0256';
ok Uni.new(0x1078C).NFKC.list ~~ (0x0257,), '1078C -> 0257';
ok Uni.new(0x1078D).NFKC.list ~~ (0x1D91,), '1078D -> 1D91';
ok Uni.new(0x1078E).NFKC.list ~~ (0x0258,), '1078E -> 0258';
ok Uni.new(0x1078F).NFKC.list ~~ (0x025E,), '1078F -> 025E';
ok Uni.new(0x10790).NFKC.list ~~ (0x02A9,), '10790 -> 02A9';
ok Uni.new(0x10791).NFKC.list ~~ (0x0264,), '10791 -> 0264';
ok Uni.new(0x10792).NFKC.list ~~ (0x0262,), '10792 -> 0262';
ok Uni.new(0x10793).NFKC.list ~~ (0x0260,), '10793 -> 0260';
ok Uni.new(0x10794).NFKC.list ~~ (0x029B,), '10794 -> 029B';
ok Uni.new(0x10795).NFKC.list ~~ (0x0127,), '10795 -> 0127';
ok Uni.new(0x10796).NFKC.list ~~ (0x029C,), '10796 -> 029C';
ok Uni.new(0x10797).NFKC.list ~~ (0x0267,), '10797 -> 0267';
ok Uni.new(0x10798).NFKC.list ~~ (0x0284,), '10798 -> 0284';
ok Uni.new(0x10799).NFKC.list ~~ (0x02AA,), '10799 -> 02AA';
ok Uni.new(0x1079A).NFKC.list ~~ (0x02AB,), '1079A -> 02AB';
ok Uni.new(0x1079B).NFKC.list ~~ (0x026C,), '1079B -> 026C';
ok Uni.new(0x1079C).NFKC.list ~~ (0x1DF04,), '1079C -> 1DF04';
ok Uni.new(0x1079D).NFKC.list ~~ (0xA78E,), '1079D -> A78E';
ok Uni.new(0x1079E).NFKC.list ~~ (0x026E,), '1079E -> 026E';
ok Uni.new(0x1079F).NFKC.list ~~ (0x1DF05,), '1079F -> 1DF05';
ok Uni.new(0x107A0).NFKC.list ~~ (0x028E,), '107A0 -> 028E';
ok Uni.new(0x107A1).NFKC.list ~~ (0x1DF06,), '107A1 -> 1DF06';
ok Uni.new(0x107A2).NFKC.list ~~ (0x00F8,), '107A2 -> 00F8';
ok Uni.new(0x107A3).NFKC.list ~~ (0x0276,), '107A3 -> 0276';
ok Uni.new(0x107A4).NFKC.list ~~ (0x0277,), '107A4 -> 0277';
ok Uni.new(0x107A5).NFKC.list ~~ (0x0071,), '107A5 -> 0071';
ok Uni.new(0x107A6).NFKC.list ~~ (0x027A,), '107A6 -> 027A';
ok Uni.new(0x107A7).NFKC.list ~~ (0x1DF08,), '107A7 -> 1DF08';
ok Uni.new(0x107A8).NFKC.list ~~ (0x027D,), '107A8 -> 027D';
ok Uni.new(0x107A9).NFKC.list ~~ (0x027E,), '107A9 -> 027E';
ok Uni.new(0x107AA).NFKC.list ~~ (0x0280,), '107AA -> 0280';
ok Uni.new(0x107AB).NFKC.list ~~ (0x02A8,), '107AB -> 02A8';
ok Uni.new(0x107AC).NFKC.list ~~ (0x02A6,), '107AC -> 02A6';
ok Uni.new(0x107AD).NFKC.list ~~ (0xAB67,), '107AD -> AB67';
ok Uni.new(0x107AE).NFKC.list ~~ (0x02A7,), '107AE -> 02A7';
ok Uni.new(0x107AF).NFKC.list ~~ (0x0288,), '107AF -> 0288';
ok Uni.new(0x107B0).NFKC.list ~~ (0x2C71,), '107B0 -> 2C71';
ok Uni.new(0x107B2).NFKC.list ~~ (0x028F,), '107B2 -> 028F';
ok Uni.new(0x107B3).NFKC.list ~~ (0x02A1,), '107B3 -> 02A1';
ok Uni.new(0x107B4).NFKC.list ~~ (0x02A2,), '107B4 -> 02A2';
ok Uni.new(0x107B5).NFKC.list ~~ (0x0298,), '107B5 -> 0298';
ok Uni.new(0x107B6).NFKC.list ~~ (0x01C0,), '107B6 -> 01C0';
ok Uni.new(0x107B7).NFKC.list ~~ (0x01C1,), '107B7 -> 01C1';
ok Uni.new(0x107B8).NFKC.list ~~ (0x01C2,), '107B8 -> 01C2';
ok Uni.new(0x107B9).NFKC.list ~~ (0x1DF0A,), '107B9 -> 1DF0A';
ok Uni.new(0x107BA).NFKC.list ~~ (0x1DF1E,), '107BA -> 1DF1E';
ok Uni.new(0x1109A).NFKC.list ~~ (0x1109A,), '1109A -> 1109A';
ok Uni.new(0x1109C).NFKC.list ~~ (0x1109C,), '1109C -> 1109C';
ok Uni.new(0x110AB).NFKC.list ~~ (0x110AB,), '110AB -> 110AB';
ok Uni.new(0x1112E).NFKC.list ~~ (0x1112E,), '1112E -> 1112E';
ok Uni.new(0x1112F).NFKC.list ~~ (0x1112F,), '1112F -> 1112F';
ok Uni.new(0x1134B).NFKC.list ~~ (0x1134B,), '1134B -> 1134B';
ok Uni.new(0x1134C).NFKC.list ~~ (0x1134C,), '1134C -> 1134C';
ok Uni.new(0x114BB).NFKC.list ~~ (0x114BB,), '114BB -> 114BB';
ok Uni.new(0x114BC).NFKC.list ~~ (0x114BC,), '114BC -> 114BC';
ok Uni.new(0x114BE).NFKC.list ~~ (0x114BE,), '114BE -> 114BE';
ok Uni.new(0x115BA).NFKC.list ~~ (0x115BA,), '115BA -> 115BA';
ok Uni.new(0x115BB).NFKC.list ~~ (0x115BB,), '115BB -> 115BB';
ok Uni.new(0x11938).NFKC.list ~~ (0x11938,), '11938 -> 11938';
ok Uni.new(0x1D15E).NFKC.list ~~ (0x1D157, 0x1D165,), '1D15E -> 1D157 1D165';
ok Uni.new(0x1D15F).NFKC.list ~~ (0x1D158, 0x1D165,), '1D15F -> 1D158 1D165';
ok Uni.new(0x1D160).NFKC.list ~~ (0x1D158, 0x1D165, 0x1D16E,), '1D160 -> 1D158 1D165 1D16E';
ok Uni.new(0x1D161).NFKC.list ~~ (0x1D158, 0x1D165, 0x1D16F,), '1D161 -> 1D158 1D165 1D16F';
ok Uni.new(0x1D162).NFKC.list ~~ (0x1D158, 0x1D165, 0x1D170,), '1D162 -> 1D158 1D165 1D170';
ok Uni.new(0x1D163).NFKC.list ~~ (0x1D158, 0x1D165, 0x1D171,), '1D163 -> 1D158 1D165 1D171';
ok Uni.new(0x1D164).NFKC.list ~~ (0x1D158, 0x1D165, 0x1D172,), '1D164 -> 1D158 1D165 1D172';
ok Uni.new(0x1D1BB).NFKC.list ~~ (0x1D1B9, 0x1D165,), '1D1BB -> 1D1B9 1D165';
ok Uni.new(0x1D1BC).NFKC.list ~~ (0x1D1BA, 0x1D165,), '1D1BC -> 1D1BA 1D165';
ok Uni.new(0x1D1BD).NFKC.list ~~ (0x1D1B9, 0x1D165, 0x1D16E,), '1D1BD -> 1D1B9 1D165 1D16E';
ok Uni.new(0x1D1BE).NFKC.list ~~ (0x1D1BA, 0x1D165, 0x1D16E,), '1D1BE -> 1D1BA 1D165 1D16E';
ok Uni.new(0x1D1BF).NFKC.list ~~ (0x1D1B9, 0x1D165, 0x1D16F,), '1D1BF -> 1D1B9 1D165 1D16F';
ok Uni.new(0x1D1C0).NFKC.list ~~ (0x1D1BA, 0x1D165, 0x1D16F,), '1D1C0 -> 1D1BA 1D165 1D16F';
ok Uni.new(0x1D400).NFKC.list ~~ (0x0041,), '1D400 -> 0041';
ok Uni.new(0x1D401).NFKC.list ~~ (0x0042,), '1D401 -> 0042';
ok Uni.new(0x1D402).NFKC.list ~~ (0x0043,), '1D402 -> 0043';
ok Uni.new(0x1D403).NFKC.list ~~ (0x0044,), '1D403 -> 0044';
ok Uni.new(0x1D404).NFKC.list ~~ (0x0045,), '1D404 -> 0045';
ok Uni.new(0x1D405).NFKC.list ~~ (0x0046,), '1D405 -> 0046';
ok Uni.new(0x1D406).NFKC.list ~~ (0x0047,), '1D406 -> 0047';
ok Uni.new(0x1D407).NFKC.list ~~ (0x0048,), '1D407 -> 0048';
ok Uni.new(0x1D408).NFKC.list ~~ (0x0049,), '1D408 -> 0049';
ok Uni.new(0x1D409).NFKC.list ~~ (0x004A,), '1D409 -> 004A';
ok Uni.new(0x1D40A).NFKC.list ~~ (0x004B,), '1D40A -> 004B';
ok Uni.new(0x1D40B).NFKC.list ~~ (0x004C,), '1D40B -> 004C';
ok Uni.new(0x1D40C).NFKC.list ~~ (0x004D,), '1D40C -> 004D';
ok Uni.new(0x1D40D).NFKC.list ~~ (0x004E,), '1D40D -> 004E';
ok Uni.new(0x1D40E).NFKC.list ~~ (0x004F,), '1D40E -> 004F';
ok Uni.new(0x1D40F).NFKC.list ~~ (0x0050,), '1D40F -> 0050';
ok Uni.new(0x1D410).NFKC.list ~~ (0x0051,), '1D410 -> 0051';
ok Uni.new(0x1D411).NFKC.list ~~ (0x0052,), '1D411 -> 0052';
ok Uni.new(0x1D412).NFKC.list ~~ (0x0053,), '1D412 -> 0053';
ok Uni.new(0x1D413).NFKC.list ~~ (0x0054,), '1D413 -> 0054';
ok Uni.new(0x1D414).NFKC.list ~~ (0x0055,), '1D414 -> 0055';
ok Uni.new(0x1D415).NFKC.list ~~ (0x0056,), '1D415 -> 0056';
ok Uni.new(0x1D416).NFKC.list ~~ (0x0057,), '1D416 -> 0057';
ok Uni.new(0x1D417).NFKC.list ~~ (0x0058,), '1D417 -> 0058';
ok Uni.new(0x1D418).NFKC.list ~~ (0x0059,), '1D418 -> 0059';
ok Uni.new(0x1D419).NFKC.list ~~ (0x005A,), '1D419 -> 005A';
ok Uni.new(0x1D41A).NFKC.list ~~ (0x0061,), '1D41A -> 0061';
ok Uni.new(0x1D41B).NFKC.list ~~ (0x0062,), '1D41B -> 0062';
ok Uni.new(0x1D41C).NFKC.list ~~ (0x0063,), '1D41C -> 0063';
ok Uni.new(0x1D41D).NFKC.list ~~ (0x0064,), '1D41D -> 0064';
ok Uni.new(0x1D41E).NFKC.list ~~ (0x0065,), '1D41E -> 0065';
ok Uni.new(0x1D41F).NFKC.list ~~ (0x0066,), '1D41F -> 0066';
ok Uni.new(0x1D420).NFKC.list ~~ (0x0067,), '1D420 -> 0067';
ok Uni.new(0x1D421).NFKC.list ~~ (0x0068,), '1D421 -> 0068';
ok Uni.new(0x1D422).NFKC.list ~~ (0x0069,), '1D422 -> 0069';
ok Uni.new(0x1D423).NFKC.list ~~ (0x006A,), '1D423 -> 006A';
ok Uni.new(0x1D424).NFKC.list ~~ (0x006B,), '1D424 -> 006B';
ok Uni.new(0x1D425).NFKC.list ~~ (0x006C,), '1D425 -> 006C';
ok Uni.new(0x1D426).NFKC.list ~~ (0x006D,), '1D426 -> 006D';
ok Uni.new(0x1D427).NFKC.list ~~ (0x006E,), '1D427 -> 006E';
ok Uni.new(0x1D428).NFKC.list ~~ (0x006F,), '1D428 -> 006F';
ok Uni.new(0x1D429).NFKC.list ~~ (0x0070,), '1D429 -> 0070';
ok Uni.new(0x1D42A).NFKC.list ~~ (0x0071,), '1D42A -> 0071';
ok Uni.new(0x1D42B).NFKC.list ~~ (0x0072,), '1D42B -> 0072';
ok Uni.new(0x1D42C).NFKC.list ~~ (0x0073,), '1D42C -> 0073';
ok Uni.new(0x1D42D).NFKC.list ~~ (0x0074,), '1D42D -> 0074';
ok Uni.new(0x1D42E).NFKC.list ~~ (0x0075,), '1D42E -> 0075';
ok Uni.new(0x1D42F).NFKC.list ~~ (0x0076,), '1D42F -> 0076';
ok Uni.new(0x1D430).NFKC.list ~~ (0x0077,), '1D430 -> 0077';
ok Uni.new(0x1D431).NFKC.list ~~ (0x0078,), '1D431 -> 0078';
ok Uni.new(0x1D432).NFKC.list ~~ (0x0079,), '1D432 -> 0079';
ok Uni.new(0x1D433).NFKC.list ~~ (0x007A,), '1D433 -> 007A';
ok Uni.new(0x1D434).NFKC.list ~~ (0x0041,), '1D434 -> 0041';
ok Uni.new(0x1D435).NFKC.list ~~ (0x0042,), '1D435 -> 0042';
ok Uni.new(0x1D436).NFKC.list ~~ (0x0043,), '1D436 -> 0043';
ok Uni.new(0x1D437).NFKC.list ~~ (0x0044,), '1D437 -> 0044';
ok Uni.new(0x1D438).NFKC.list ~~ (0x0045,), '1D438 -> 0045';
ok Uni.new(0x1D439).NFKC.list ~~ (0x0046,), '1D439 -> 0046';
ok Uni.new(0x1D43A).NFKC.list ~~ (0x0047,), '1D43A -> 0047';
ok Uni.new(0x1D43B).NFKC.list ~~ (0x0048,), '1D43B -> 0048';
ok Uni.new(0x1D43C).NFKC.list ~~ (0x0049,), '1D43C -> 0049';
ok Uni.new(0x1D43D).NFKC.list ~~ (0x004A,), '1D43D -> 004A';
ok Uni.new(0x1D43E).NFKC.list ~~ (0x004B,), '1D43E -> 004B';
ok Uni.new(0x1D43F).NFKC.list ~~ (0x004C,), '1D43F -> 004C';
ok Uni.new(0x1D440).NFKC.list ~~ (0x004D,), '1D440 -> 004D';
ok Uni.new(0x1D441).NFKC.list ~~ (0x004E,), '1D441 -> 004E';
ok Uni.new(0x1D442).NFKC.list ~~ (0x004F,), '1D442 -> 004F';
ok Uni.new(0x1D443).NFKC.list ~~ (0x0050,), '1D443 -> 0050';
ok Uni.new(0x1D444).NFKC.list ~~ (0x0051,), '1D444 -> 0051';
ok Uni.new(0x1D445).NFKC.list ~~ (0x0052,), '1D445 -> 0052';
ok Uni.new(0x1D446).NFKC.list ~~ (0x0053,), '1D446 -> 0053';
ok Uni.new(0x1D447).NFKC.list ~~ (0x0054,), '1D447 -> 0054';
ok Uni.new(0x1D448).NFKC.list ~~ (0x0055,), '1D448 -> 0055';
ok Uni.new(0x1D449).NFKC.list ~~ (0x0056,), '1D449 -> 0056';
ok Uni.new(0x1D44A).NFKC.list ~~ (0x0057,), '1D44A -> 0057';
ok Uni.new(0x1D44B).NFKC.list ~~ (0x0058,), '1D44B -> 0058';
ok Uni.new(0x1D44C).NFKC.list ~~ (0x0059,), '1D44C -> 0059';
ok Uni.new(0x1D44D).NFKC.list ~~ (0x005A,), '1D44D -> 005A';
ok Uni.new(0x1D44E).NFKC.list ~~ (0x0061,), '1D44E -> 0061';
ok Uni.new(0x1D44F).NFKC.list ~~ (0x0062,), '1D44F -> 0062';
ok Uni.new(0x1D450).NFKC.list ~~ (0x0063,), '1D450 -> 0063';
ok Uni.new(0x1D451).NFKC.list ~~ (0x0064,), '1D451 -> 0064';
ok Uni.new(0x1D452).NFKC.list ~~ (0x0065,), '1D452 -> 0065';
ok Uni.new(0x1D453).NFKC.list ~~ (0x0066,), '1D453 -> 0066';
ok Uni.new(0x1D454).NFKC.list ~~ (0x0067,), '1D454 -> 0067';
ok Uni.new(0x1D456).NFKC.list ~~ (0x0069,), '1D456 -> 0069';
ok Uni.new(0x1D457).NFKC.list ~~ (0x006A,), '1D457 -> 006A';
ok Uni.new(0x1D458).NFKC.list ~~ (0x006B,), '1D458 -> 006B';
ok Uni.new(0x1D459).NFKC.list ~~ (0x006C,), '1D459 -> 006C';
ok Uni.new(0x1D45A).NFKC.list ~~ (0x006D,), '1D45A -> 006D';
ok Uni.new(0x1D45B).NFKC.list ~~ (0x006E,), '1D45B -> 006E';
ok Uni.new(0x1D45C).NFKC.list ~~ (0x006F,), '1D45C -> 006F';
ok Uni.new(0x1D45D).NFKC.list ~~ (0x0070,), '1D45D -> 0070';
ok Uni.new(0x1D45E).NFKC.list ~~ (0x0071,), '1D45E -> 0071';
ok Uni.new(0x1D45F).NFKC.list ~~ (0x0072,), '1D45F -> 0072';
ok Uni.new(0x1D460).NFKC.list ~~ (0x0073,), '1D460 -> 0073';
ok Uni.new(0x1D461).NFKC.list ~~ (0x0074,), '1D461 -> 0074';
ok Uni.new(0x1D462).NFKC.list ~~ (0x0075,), '1D462 -> 0075';
ok Uni.new(0x1D463).NFKC.list ~~ (0x0076,), '1D463 -> 0076';
ok Uni.new(0x1D464).NFKC.list ~~ (0x0077,), '1D464 -> 0077';
ok Uni.new(0x1D465).NFKC.list ~~ (0x0078,), '1D465 -> 0078';
ok Uni.new(0x1D466).NFKC.list ~~ (0x0079,), '1D466 -> 0079';
ok Uni.new(0x1D467).NFKC.list ~~ (0x007A,), '1D467 -> 007A';
ok Uni.new(0x1D468).NFKC.list ~~ (0x0041,), '1D468 -> 0041';
ok Uni.new(0x1D469).NFKC.list ~~ (0x0042,), '1D469 -> 0042';
ok Uni.new(0x1D46A).NFKC.list ~~ (0x0043,), '1D46A -> 0043';
ok Uni.new(0x1D46B).NFKC.list ~~ (0x0044,), '1D46B -> 0044';
ok Uni.new(0x1D46C).NFKC.list ~~ (0x0045,), '1D46C -> 0045';
ok Uni.new(0x1D46D).NFKC.list ~~ (0x0046,), '1D46D -> 0046';
ok Uni.new(0x1D46E).NFKC.list ~~ (0x0047,), '1D46E -> 0047';
ok Uni.new(0x1D46F).NFKC.list ~~ (0x0048,), '1D46F -> 0048';
ok Uni.new(0x1D470).NFKC.list ~~ (0x0049,), '1D470 -> 0049';
ok Uni.new(0x1D471).NFKC.list ~~ (0x004A,), '1D471 -> 004A';
ok Uni.new(0x1D472).NFKC.list ~~ (0x004B,), '1D472 -> 004B';
ok Uni.new(0x1D473).NFKC.list ~~ (0x004C,), '1D473 -> 004C';
ok Uni.new(0x1D474).NFKC.list ~~ (0x004D,), '1D474 -> 004D';
ok Uni.new(0x1D475).NFKC.list ~~ (0x004E,), '1D475 -> 004E';
ok Uni.new(0x1D476).NFKC.list ~~ (0x004F,), '1D476 -> 004F';
ok Uni.new(0x1D477).NFKC.list ~~ (0x0050,), '1D477 -> 0050';
ok Uni.new(0x1D478).NFKC.list ~~ (0x0051,), '1D478 -> 0051';
ok Uni.new(0x1D479).NFKC.list ~~ (0x0052,), '1D479 -> 0052';
ok Uni.new(0x1D47A).NFKC.list ~~ (0x0053,), '1D47A -> 0053';
ok Uni.new(0x1D47B).NFKC.list ~~ (0x0054,), '1D47B -> 0054';
ok Uni.new(0x1D47C).NFKC.list ~~ (0x0055,), '1D47C -> 0055';
ok Uni.new(0x1D47D).NFKC.list ~~ (0x0056,), '1D47D -> 0056';
ok Uni.new(0x1D47E).NFKC.list ~~ (0x0057,), '1D47E -> 0057';
ok Uni.new(0x1D47F).NFKC.list ~~ (0x0058,), '1D47F -> 0058';
ok Uni.new(0x1D480).NFKC.list ~~ (0x0059,), '1D480 -> 0059';
ok Uni.new(0x1D481).NFKC.list ~~ (0x005A,), '1D481 -> 005A';
ok Uni.new(0x1D482).NFKC.list ~~ (0x0061,), '1D482 -> 0061';
ok Uni.new(0x1D483).NFKC.list ~~ (0x0062,), '1D483 -> 0062';
ok Uni.new(0x1D484).NFKC.list ~~ (0x0063,), '1D484 -> 0063';
ok Uni.new(0x1D485).NFKC.list ~~ (0x0064,), '1D485 -> 0064';
ok Uni.new(0x1D486).NFKC.list ~~ (0x0065,), '1D486 -> 0065';
ok Uni.new(0x1D487).NFKC.list ~~ (0x0066,), '1D487 -> 0066';
ok Uni.new(0x1D488).NFKC.list ~~ (0x0067,), '1D488 -> 0067';
ok Uni.new(0x1D489).NFKC.list ~~ (0x0068,), '1D489 -> 0068';
ok Uni.new(0x1D48A).NFKC.list ~~ (0x0069,), '1D48A -> 0069';
ok Uni.new(0x1D48B).NFKC.list ~~ (0x006A,), '1D48B -> 006A';
ok Uni.new(0x1D48C).NFKC.list ~~ (0x006B,), '1D48C -> 006B';
ok Uni.new(0x1D48D).NFKC.list ~~ (0x006C,), '1D48D -> 006C';
ok Uni.new(0x1D48E).NFKC.list ~~ (0x006D,), '1D48E -> 006D';
ok Uni.new(0x1D48F).NFKC.list ~~ (0x006E,), '1D48F -> 006E';
ok Uni.new(0x1D490).NFKC.list ~~ (0x006F,), '1D490 -> 006F';
ok Uni.new(0x1D491).NFKC.list ~~ (0x0070,), '1D491 -> 0070';
ok Uni.new(0x1D492).NFKC.list ~~ (0x0071,), '1D492 -> 0071';
ok Uni.new(0x1D493).NFKC.list ~~ (0x0072,), '1D493 -> 0072';
ok Uni.new(0x1D494).NFKC.list ~~ (0x0073,), '1D494 -> 0073';
ok Uni.new(0x1D495).NFKC.list ~~ (0x0074,), '1D495 -> 0074';
ok Uni.new(0x1D496).NFKC.list ~~ (0x0075,), '1D496 -> 0075';
ok Uni.new(0x1D497).NFKC.list ~~ (0x0076,), '1D497 -> 0076';
ok Uni.new(0x1D498).NFKC.list ~~ (0x0077,), '1D498 -> 0077';
ok Uni.new(0x1D499).NFKC.list ~~ (0x0078,), '1D499 -> 0078';
ok Uni.new(0x1D49A).NFKC.list ~~ (0x0079,), '1D49A -> 0079';
ok Uni.new(0x1D49B).NFKC.list ~~ (0x007A,), '1D49B -> 007A';
ok Uni.new(0x1D49C).NFKC.list ~~ (0x0041,), '1D49C -> 0041';
ok Uni.new(0x1D49E).NFKC.list ~~ (0x0043,), '1D49E -> 0043';
ok Uni.new(0x1D49F).NFKC.list ~~ (0x0044,), '1D49F -> 0044';
ok Uni.new(0x1D4A2).NFKC.list ~~ (0x0047,), '1D4A2 -> 0047';
ok Uni.new(0x1D4A5).NFKC.list ~~ (0x004A,), '1D4A5 -> 004A';
ok Uni.new(0x1D4A6).NFKC.list ~~ (0x004B,), '1D4A6 -> 004B';
ok Uni.new(0x1D4A9).NFKC.list ~~ (0x004E,), '1D4A9 -> 004E';
ok Uni.new(0x1D4AA).NFKC.list ~~ (0x004F,), '1D4AA -> 004F';
ok Uni.new(0x1D4AB).NFKC.list ~~ (0x0050,), '1D4AB -> 0050';
ok Uni.new(0x1D4AC).NFKC.list ~~ (0x0051,), '1D4AC -> 0051';
ok Uni.new(0x1D4AE).NFKC.list ~~ (0x0053,), '1D4AE -> 0053';
ok Uni.new(0x1D4AF).NFKC.list ~~ (0x0054,), '1D4AF -> 0054';
ok Uni.new(0x1D4B0).NFKC.list ~~ (0x0055,), '1D4B0 -> 0055';
ok Uni.new(0x1D4B1).NFKC.list ~~ (0x0056,), '1D4B1 -> 0056';
ok Uni.new(0x1D4B2).NFKC.list ~~ (0x0057,), '1D4B2 -> 0057';
ok Uni.new(0x1D4B3).NFKC.list ~~ (0x0058,), '1D4B3 -> 0058';
ok Uni.new(0x1D4B4).NFKC.list ~~ (0x0059,), '1D4B4 -> 0059';
ok Uni.new(0x1D4B5).NFKC.list ~~ (0x005A,), '1D4B5 -> 005A';
ok Uni.new(0x1D4B6).NFKC.list ~~ (0x0061,), '1D4B6 -> 0061';
ok Uni.new(0x1D4B7).NFKC.list ~~ (0x0062,), '1D4B7 -> 0062';
ok Uni.new(0x1D4B8).NFKC.list ~~ (0x0063,), '1D4B8 -> 0063';
ok Uni.new(0x1D4B9).NFKC.list ~~ (0x0064,), '1D4B9 -> 0064';
ok Uni.new(0x1D4BB).NFKC.list ~~ (0x0066,), '1D4BB -> 0066';
ok Uni.new(0x1D4BD).NFKC.list ~~ (0x0068,), '1D4BD -> 0068';
ok Uni.new(0x1D4BE).NFKC.list ~~ (0x0069,), '1D4BE -> 0069';
ok Uni.new(0x1D4BF).NFKC.list ~~ (0x006A,), '1D4BF -> 006A';
ok Uni.new(0x1D4C0).NFKC.list ~~ (0x006B,), '1D4C0 -> 006B';
ok Uni.new(0x1D4C1).NFKC.list ~~ (0x006C,), '1D4C1 -> 006C';
ok Uni.new(0x1D4C2).NFKC.list ~~ (0x006D,), '1D4C2 -> 006D';
ok Uni.new(0x1D4C3).NFKC.list ~~ (0x006E,), '1D4C3 -> 006E';
ok Uni.new(0x1D4C5).NFKC.list ~~ (0x0070,), '1D4C5 -> 0070';
ok Uni.new(0x1D4C6).NFKC.list ~~ (0x0071,), '1D4C6 -> 0071';
ok Uni.new(0x1D4C7).NFKC.list ~~ (0x0072,), '1D4C7 -> 0072';
ok Uni.new(0x1D4C8).NFKC.list ~~ (0x0073,), '1D4C8 -> 0073';
ok Uni.new(0x1D4C9).NFKC.list ~~ (0x0074,), '1D4C9 -> 0074';
ok Uni.new(0x1D4CA).NFKC.list ~~ (0x0075,), '1D4CA -> 0075';
ok Uni.new(0x1D4CB).NFKC.list ~~ (0x0076,), '1D4CB -> 0076';
ok Uni.new(0x1D4CC).NFKC.list ~~ (0x0077,), '1D4CC -> 0077';
ok Uni.new(0x1D4CD).NFKC.list ~~ (0x0078,), '1D4CD -> 0078';
ok Uni.new(0x1D4CE).NFKC.list ~~ (0x0079,), '1D4CE -> 0079';
ok Uni.new(0x1D4CF).NFKC.list ~~ (0x007A,), '1D4CF -> 007A';
ok Uni.new(0x1D4D0).NFKC.list ~~ (0x0041,), '1D4D0 -> 0041';
ok Uni.new(0x1D4D1).NFKC.list ~~ (0x0042,), '1D4D1 -> 0042';
ok Uni.new(0x1D4D2).NFKC.list ~~ (0x0043,), '1D4D2 -> 0043';
ok Uni.new(0x1D4D3).NFKC.list ~~ (0x0044,), '1D4D3 -> 0044';
ok Uni.new(0x1D4D4).NFKC.list ~~ (0x0045,), '1D4D4 -> 0045';
ok Uni.new(0x1D4D5).NFKC.list ~~ (0x0046,), '1D4D5 -> 0046';
ok Uni.new(0x1D4D6).NFKC.list ~~ (0x0047,), '1D4D6 -> 0047';
ok Uni.new(0x1D4D7).NFKC.list ~~ (0x0048,), '1D4D7 -> 0048';
ok Uni.new(0x1D4D8).NFKC.list ~~ (0x0049,), '1D4D8 -> 0049';
ok Uni.new(0x1D4D9).NFKC.list ~~ (0x004A,), '1D4D9 -> 004A';
ok Uni.new(0x1D4DA).NFKC.list ~~ (0x004B,), '1D4DA -> 004B';
ok Uni.new(0x1D4DB).NFKC.list ~~ (0x004C,), '1D4DB -> 004C';
ok Uni.new(0x1D4DC).NFKC.list ~~ (0x004D,), '1D4DC -> 004D';
ok Uni.new(0x1D4DD).NFKC.list ~~ (0x004E,), '1D4DD -> 004E';
ok Uni.new(0x1D4DE).NFKC.list ~~ (0x004F,), '1D4DE -> 004F';
ok Uni.new(0x1D4DF).NFKC.list ~~ (0x0050,), '1D4DF -> 0050';
ok Uni.new(0x1D4E0).NFKC.list ~~ (0x0051,), '1D4E0 -> 0051';
ok Uni.new(0x1D4E1).NFKC.list ~~ (0x0052,), '1D4E1 -> 0052';
ok Uni.new(0x1D4E2).NFKC.list ~~ (0x0053,), '1D4E2 -> 0053';
ok Uni.new(0x1D4E3).NFKC.list ~~ (0x0054,), '1D4E3 -> 0054';
ok Uni.new(0x1D4E4).NFKC.list ~~ (0x0055,), '1D4E4 -> 0055';
ok Uni.new(0x1D4E5).NFKC.list ~~ (0x0056,), '1D4E5 -> 0056';
ok Uni.new(0x1D4E6).NFKC.list ~~ (0x0057,), '1D4E6 -> 0057';
ok Uni.new(0x1D4E7).NFKC.list ~~ (0x0058,), '1D4E7 -> 0058';
ok Uni.new(0x1D4E8).NFKC.list ~~ (0x0059,), '1D4E8 -> 0059';
ok Uni.new(0x1D4E9).NFKC.list ~~ (0x005A,), '1D4E9 -> 005A';
ok Uni.new(0x1D4EA).NFKC.list ~~ (0x0061,), '1D4EA -> 0061';
ok Uni.new(0x1D4EB).NFKC.list ~~ (0x0062,), '1D4EB -> 0062';
ok Uni.new(0x1D4EC).NFKC.list ~~ (0x0063,), '1D4EC -> 0063';
ok Uni.new(0x1D4ED).NFKC.list ~~ (0x0064,), '1D4ED -> 0064';
ok Uni.new(0x1D4EE).NFKC.list ~~ (0x0065,), '1D4EE -> 0065';
ok Uni.new(0x1D4EF).NFKC.list ~~ (0x0066,), '1D4EF -> 0066';
ok Uni.new(0x1D4F0).NFKC.list ~~ (0x0067,), '1D4F0 -> 0067';
ok Uni.new(0x1D4F1).NFKC.list ~~ (0x0068,), '1D4F1 -> 0068';
ok Uni.new(0x1D4F2).NFKC.list ~~ (0x0069,), '1D4F2 -> 0069';
ok Uni.new(0x1D4F3).NFKC.list ~~ (0x006A,), '1D4F3 -> 006A';
ok Uni.new(0x1D4F4).NFKC.list ~~ (0x006B,), '1D4F4 -> 006B';
ok Uni.new(0x1D4F5).NFKC.list ~~ (0x006C,), '1D4F5 -> 006C';
ok Uni.new(0x1D4F6).NFKC.list ~~ (0x006D,), '1D4F6 -> 006D';
ok Uni.new(0x1D4F7).NFKC.list ~~ (0x006E,), '1D4F7 -> 006E';
ok Uni.new(0x1D4F8).NFKC.list ~~ (0x006F,), '1D4F8 -> 006F';
ok Uni.new(0x1D4F9).NFKC.list ~~ (0x0070,), '1D4F9 -> 0070';
ok Uni.new(0x1D4FA).NFKC.list ~~ (0x0071,), '1D4FA -> 0071';
ok Uni.new(0x1D4FB).NFKC.list ~~ (0x0072,), '1D4FB -> 0072';
ok Uni.new(0x1D4FC).NFKC.list ~~ (0x0073,), '1D4FC -> 0073';
ok Uni.new(0x1D4FD).NFKC.list ~~ (0x0074,), '1D4FD -> 0074';
ok Uni.new(0x1D4FE).NFKC.list ~~ (0x0075,), '1D4FE -> 0075';
ok Uni.new(0x1D4FF).NFKC.list ~~ (0x0076,), '1D4FF -> 0076';
ok Uni.new(0x1D500).NFKC.list ~~ (0x0077,), '1D500 -> 0077';
ok Uni.new(0x1D501).NFKC.list ~~ (0x0078,), '1D501 -> 0078';
ok Uni.new(0x1D502).NFKC.list ~~ (0x0079,), '1D502 -> 0079';
ok Uni.new(0x1D503).NFKC.list ~~ (0x007A,), '1D503 -> 007A';
ok Uni.new(0x1D504).NFKC.list ~~ (0x0041,), '1D504 -> 0041';
ok Uni.new(0x1D505).NFKC.list ~~ (0x0042,), '1D505 -> 0042';
ok Uni.new(0x1D507).NFKC.list ~~ (0x0044,), '1D507 -> 0044';
ok Uni.new(0x1D508).NFKC.list ~~ (0x0045,), '1D508 -> 0045';
ok Uni.new(0x1D509).NFKC.list ~~ (0x0046,), '1D509 -> 0046';
ok Uni.new(0x1D50A).NFKC.list ~~ (0x0047,), '1D50A -> 0047';
ok Uni.new(0x1D50D).NFKC.list ~~ (0x004A,), '1D50D -> 004A';
ok Uni.new(0x1D50E).NFKC.list ~~ (0x004B,), '1D50E -> 004B';
ok Uni.new(0x1D50F).NFKC.list ~~ (0x004C,), '1D50F -> 004C';
ok Uni.new(0x1D510).NFKC.list ~~ (0x004D,), '1D510 -> 004D';
ok Uni.new(0x1D511).NFKC.list ~~ (0x004E,), '1D511 -> 004E';
ok Uni.new(0x1D512).NFKC.list ~~ (0x004F,), '1D512 -> 004F';
ok Uni.new(0x1D513).NFKC.list ~~ (0x0050,), '1D513 -> 0050';
ok Uni.new(0x1D514).NFKC.list ~~ (0x0051,), '1D514 -> 0051';
ok Uni.new(0x1D516).NFKC.list ~~ (0x0053,), '1D516 -> 0053';
ok Uni.new(0x1D517).NFKC.list ~~ (0x0054,), '1D517 -> 0054';
ok Uni.new(0x1D518).NFKC.list ~~ (0x0055,), '1D518 -> 0055';
ok Uni.new(0x1D519).NFKC.list ~~ (0x0056,), '1D519 -> 0056';
ok Uni.new(0x1D51A).NFKC.list ~~ (0x0057,), '1D51A -> 0057';
ok Uni.new(0x1D51B).NFKC.list ~~ (0x0058,), '1D51B -> 0058';
ok Uni.new(0x1D51C).NFKC.list ~~ (0x0059,), '1D51C -> 0059';
ok Uni.new(0x1D51E).NFKC.list ~~ (0x0061,), '1D51E -> 0061';
ok Uni.new(0x1D51F).NFKC.list ~~ (0x0062,), '1D51F -> 0062';
ok Uni.new(0x1D520).NFKC.list ~~ (0x0063,), '1D520 -> 0063';
ok Uni.new(0x1D521).NFKC.list ~~ (0x0064,), '1D521 -> 0064';
ok Uni.new(0x1D522).NFKC.list ~~ (0x0065,), '1D522 -> 0065';
ok Uni.new(0x1D523).NFKC.list ~~ (0x0066,), '1D523 -> 0066';
ok Uni.new(0x1D524).NFKC.list ~~ (0x0067,), '1D524 -> 0067';
ok Uni.new(0x1D525).NFKC.list ~~ (0x0068,), '1D525 -> 0068';
ok Uni.new(0x1D526).NFKC.list ~~ (0x0069,), '1D526 -> 0069';
ok Uni.new(0x1D527).NFKC.list ~~ (0x006A,), '1D527 -> 006A';
ok Uni.new(0x1D528).NFKC.list ~~ (0x006B,), '1D528 -> 006B';
ok Uni.new(0x1D529).NFKC.list ~~ (0x006C,), '1D529 -> 006C';
ok Uni.new(0x1D52A).NFKC.list ~~ (0x006D,), '1D52A -> 006D';
ok Uni.new(0x1D52B).NFKC.list ~~ (0x006E,), '1D52B -> 006E';
ok Uni.new(0x1D52C).NFKC.list ~~ (0x006F,), '1D52C -> 006F';
ok Uni.new(0x1D52D).NFKC.list ~~ (0x0070,), '1D52D -> 0070';
ok Uni.new(0x1D52E).NFKC.list ~~ (0x0071,), '1D52E -> 0071';
ok Uni.new(0x1D52F).NFKC.list ~~ (0x0072,), '1D52F -> 0072';
ok Uni.new(0x1D530).NFKC.list ~~ (0x0073,), '1D530 -> 0073';
ok Uni.new(0x1D531).NFKC.list ~~ (0x0074,), '1D531 -> 0074';
ok Uni.new(0x1D532).NFKC.list ~~ (0x0075,), '1D532 -> 0075';
ok Uni.new(0x1D533).NFKC.list ~~ (0x0076,), '1D533 -> 0076';
ok Uni.new(0x1D534).NFKC.list ~~ (0x0077,), '1D534 -> 0077';
ok Uni.new(0x1D535).NFKC.list ~~ (0x0078,), '1D535 -> 0078';
ok Uni.new(0x1D536).NFKC.list ~~ (0x0079,), '1D536 -> 0079';
ok Uni.new(0x1D537).NFKC.list ~~ (0x007A,), '1D537 -> 007A';
ok Uni.new(0x1D538).NFKC.list ~~ (0x0041,), '1D538 -> 0041';
ok Uni.new(0x1D539).NFKC.list ~~ (0x0042,), '1D539 -> 0042';
ok Uni.new(0x1D53B).NFKC.list ~~ (0x0044,), '1D53B -> 0044';
ok Uni.new(0x1D53C).NFKC.list ~~ (0x0045,), '1D53C -> 0045';
ok Uni.new(0x1D53D).NFKC.list ~~ (0x0046,), '1D53D -> 0046';
ok Uni.new(0x1D53E).NFKC.list ~~ (0x0047,), '1D53E -> 0047';
ok Uni.new(0x1D540).NFKC.list ~~ (0x0049,), '1D540 -> 0049';
ok Uni.new(0x1D541).NFKC.list ~~ (0x004A,), '1D541 -> 004A';
ok Uni.new(0x1D542).NFKC.list ~~ (0x004B,), '1D542 -> 004B';
ok Uni.new(0x1D543).NFKC.list ~~ (0x004C,), '1D543 -> 004C';
ok Uni.new(0x1D544).NFKC.list ~~ (0x004D,), '1D544 -> 004D';
ok Uni.new(0x1D546).NFKC.list ~~ (0x004F,), '1D546 -> 004F';
ok Uni.new(0x1D54A).NFKC.list ~~ (0x0053,), '1D54A -> 0053';
ok Uni.new(0x1D54B).NFKC.list ~~ (0x0054,), '1D54B -> 0054';
ok Uni.new(0x1D54C).NFKC.list ~~ (0x0055,), '1D54C -> 0055';
ok Uni.new(0x1D54D).NFKC.list ~~ (0x0056,), '1D54D -> 0056';
ok Uni.new(0x1D54E).NFKC.list ~~ (0x0057,), '1D54E -> 0057';
ok Uni.new(0x1D54F).NFKC.list ~~ (0x0058,), '1D54F -> 0058';
ok Uni.new(0x1D550).NFKC.list ~~ (0x0059,), '1D550 -> 0059';
ok Uni.new(0x1D552).NFKC.list ~~ (0x0061,), '1D552 -> 0061';
ok Uni.new(0x1D553).NFKC.list ~~ (0x0062,), '1D553 -> 0062';
ok Uni.new(0x1D554).NFKC.list ~~ (0x0063,), '1D554 -> 0063';
ok Uni.new(0x1D555).NFKC.list ~~ (0x0064,), '1D555 -> 0064';
ok Uni.new(0x1D556).NFKC.list ~~ (0x0065,), '1D556 -> 0065';
ok Uni.new(0x1D557).NFKC.list ~~ (0x0066,), '1D557 -> 0066';
ok Uni.new(0x1D558).NFKC.list ~~ (0x0067,), '1D558 -> 0067';
ok Uni.new(0x1D559).NFKC.list ~~ (0x0068,), '1D559 -> 0068';
ok Uni.new(0x1D55A).NFKC.list ~~ (0x0069,), '1D55A -> 0069';
ok Uni.new(0x1D55B).NFKC.list ~~ (0x006A,), '1D55B -> 006A';
ok Uni.new(0x1D55C).NFKC.list ~~ (0x006B,), '1D55C -> 006B';
ok Uni.new(0x1D55D).NFKC.list ~~ (0x006C,), '1D55D -> 006C';
ok Uni.new(0x1D55E).NFKC.list ~~ (0x006D,), '1D55E -> 006D';
ok Uni.new(0x1D55F).NFKC.list ~~ (0x006E,), '1D55F -> 006E';
ok Uni.new(0x1D560).NFKC.list ~~ (0x006F,), '1D560 -> 006F';
ok Uni.new(0x1D561).NFKC.list ~~ (0x0070,), '1D561 -> 0070';
ok Uni.new(0x1D562).NFKC.list ~~ (0x0071,), '1D562 -> 0071';
ok Uni.new(0x1D563).NFKC.list ~~ (0x0072,), '1D563 -> 0072';
ok Uni.new(0x1D564).NFKC.list ~~ (0x0073,), '1D564 -> 0073';
ok Uni.new(0x1D565).NFKC.list ~~ (0x0074,), '1D565 -> 0074';
ok Uni.new(0x1D566).NFKC.list ~~ (0x0075,), '1D566 -> 0075';
ok Uni.new(0x1D567).NFKC.list ~~ (0x0076,), '1D567 -> 0076';
ok Uni.new(0x1D568).NFKC.list ~~ (0x0077,), '1D568 -> 0077';
ok Uni.new(0x1D569).NFKC.list ~~ (0x0078,), '1D569 -> 0078';
ok Uni.new(0x1D56A).NFKC.list ~~ (0x0079,), '1D56A -> 0079';
ok Uni.new(0x1D56B).NFKC.list ~~ (0x007A,), '1D56B -> 007A';
ok Uni.new(0x1D56C).NFKC.list ~~ (0x0041,), '1D56C -> 0041';
ok Uni.new(0x1D56D).NFKC.list ~~ (0x0042,), '1D56D -> 0042';
ok Uni.new(0x1D56E).NFKC.list ~~ (0x0043,), '1D56E -> 0043';
ok Uni.new(0x1D56F).NFKC.list ~~ (0x0044,), '1D56F -> 0044';
ok Uni.new(0x1D570).NFKC.list ~~ (0x0045,), '1D570 -> 0045';
ok Uni.new(0x1D571).NFKC.list ~~ (0x0046,), '1D571 -> 0046';
ok Uni.new(0x1D572).NFKC.list ~~ (0x0047,), '1D572 -> 0047';
ok Uni.new(0x1D573).NFKC.list ~~ (0x0048,), '1D573 -> 0048';
ok Uni.new(0x1D574).NFKC.list ~~ (0x0049,), '1D574 -> 0049';
ok Uni.new(0x1D575).NFKC.list ~~ (0x004A,), '1D575 -> 004A';
ok Uni.new(0x1D576).NFKC.list ~~ (0x004B,), '1D576 -> 004B';
ok Uni.new(0x1D577).NFKC.list ~~ (0x004C,), '1D577 -> 004C';
ok Uni.new(0x1D578).NFKC.list ~~ (0x004D,), '1D578 -> 004D';
ok Uni.new(0x1D579).NFKC.list ~~ (0x004E,), '1D579 -> 004E';
ok Uni.new(0x1D57A).NFKC.list ~~ (0x004F,), '1D57A -> 004F';
ok Uni.new(0x1D57B).NFKC.list ~~ (0x0050,), '1D57B -> 0050';
ok Uni.new(0x1D57C).NFKC.list ~~ (0x0051,), '1D57C -> 0051';
ok Uni.new(0x1D57D).NFKC.list ~~ (0x0052,), '1D57D -> 0052';
ok Uni.new(0x1D57E).NFKC.list ~~ (0x0053,), '1D57E -> 0053';
ok Uni.new(0x1D57F).NFKC.list ~~ (0x0054,), '1D57F -> 0054';
ok Uni.new(0x1D580).NFKC.list ~~ (0x0055,), '1D580 -> 0055';
ok Uni.new(0x1D581).NFKC.list ~~ (0x0056,), '1D581 -> 0056';
ok Uni.new(0x1D582).NFKC.list ~~ (0x0057,), '1D582 -> 0057';
ok Uni.new(0x1D583).NFKC.list ~~ (0x0058,), '1D583 -> 0058';
ok Uni.new(0x1D584).NFKC.list ~~ (0x0059,), '1D584 -> 0059';
ok Uni.new(0x1D585).NFKC.list ~~ (0x005A,), '1D585 -> 005A';
ok Uni.new(0x1D586).NFKC.list ~~ (0x0061,), '1D586 -> 0061';
ok Uni.new(0x1D587).NFKC.list ~~ (0x0062,), '1D587 -> 0062';
ok Uni.new(0x1D588).NFKC.list ~~ (0x0063,), '1D588 -> 0063';
ok Uni.new(0x1D589).NFKC.list ~~ (0x0064,), '1D589 -> 0064';
ok Uni.new(0x1D58A).NFKC.list ~~ (0x0065,), '1D58A -> 0065';
ok Uni.new(0x1D58B).NFKC.list ~~ (0x0066,), '1D58B -> 0066';
ok Uni.new(0x1D58C).NFKC.list ~~ (0x0067,), '1D58C -> 0067';
ok Uni.new(0x1D58D).NFKC.list ~~ (0x0068,), '1D58D -> 0068';
ok Uni.new(0x1D58E).NFKC.list ~~ (0x0069,), '1D58E -> 0069';
ok Uni.new(0x1D58F).NFKC.list ~~ (0x006A,), '1D58F -> 006A';
ok Uni.new(0x1D590).NFKC.list ~~ (0x006B,), '1D590 -> 006B';
ok Uni.new(0x1D591).NFKC.list ~~ (0x006C,), '1D591 -> 006C';
ok Uni.new(0x1D592).NFKC.list ~~ (0x006D,), '1D592 -> 006D';
ok Uni.new(0x1D593).NFKC.list ~~ (0x006E,), '1D593 -> 006E';
ok Uni.new(0x1D594).NFKC.list ~~ (0x006F,), '1D594 -> 006F';
ok Uni.new(0x1D595).NFKC.list ~~ (0x0070,), '1D595 -> 0070';
ok Uni.new(0x1D596).NFKC.list ~~ (0x0071,), '1D596 -> 0071';
ok Uni.new(0x1D597).NFKC.list ~~ (0x0072,), '1D597 -> 0072';
ok Uni.new(0x1D598).NFKC.list ~~ (0x0073,), '1D598 -> 0073';
ok Uni.new(0x1D599).NFKC.list ~~ (0x0074,), '1D599 -> 0074';
ok Uni.new(0x1D59A).NFKC.list ~~ (0x0075,), '1D59A -> 0075';
ok Uni.new(0x1D59B).NFKC.list ~~ (0x0076,), '1D59B -> 0076';
ok Uni.new(0x1D59C).NFKC.list ~~ (0x0077,), '1D59C -> 0077';
ok Uni.new(0x1D59D).NFKC.list ~~ (0x0078,), '1D59D -> 0078';
ok Uni.new(0x1D59E).NFKC.list ~~ (0x0079,), '1D59E -> 0079';
ok Uni.new(0x1D59F).NFKC.list ~~ (0x007A,), '1D59F -> 007A';
ok Uni.new(0x1D5A0).NFKC.list ~~ (0x0041,), '1D5A0 -> 0041';
ok Uni.new(0x1D5A1).NFKC.list ~~ (0x0042,), '1D5A1 -> 0042';
ok Uni.new(0x1D5A2).NFKC.list ~~ (0x0043,), '1D5A2 -> 0043';
ok Uni.new(0x1D5A3).NFKC.list ~~ (0x0044,), '1D5A3 -> 0044';
ok Uni.new(0x1D5A4).NFKC.list ~~ (0x0045,), '1D5A4 -> 0045';
ok Uni.new(0x1D5A5).NFKC.list ~~ (0x0046,), '1D5A5 -> 0046';
ok Uni.new(0x1D5A6).NFKC.list ~~ (0x0047,), '1D5A6 -> 0047';
ok Uni.new(0x1D5A7).NFKC.list ~~ (0x0048,), '1D5A7 -> 0048';
ok Uni.new(0x1D5A8).NFKC.list ~~ (0x0049,), '1D5A8 -> 0049';
ok Uni.new(0x1D5A9).NFKC.list ~~ (0x004A,), '1D5A9 -> 004A';
ok Uni.new(0x1D5AA).NFKC.list ~~ (0x004B,), '1D5AA -> 004B';
ok Uni.new(0x1D5AB).NFKC.list ~~ (0x004C,), '1D5AB -> 004C';
ok Uni.new(0x1D5AC).NFKC.list ~~ (0x004D,), '1D5AC -> 004D';
ok Uni.new(0x1D5AD).NFKC.list ~~ (0x004E,), '1D5AD -> 004E';
ok Uni.new(0x1D5AE).NFKC.list ~~ (0x004F,), '1D5AE -> 004F';
ok Uni.new(0x1D5AF).NFKC.list ~~ (0x0050,), '1D5AF -> 0050';
ok Uni.new(0x1D5B0).NFKC.list ~~ (0x0051,), '1D5B0 -> 0051';
ok Uni.new(0x1D5B1).NFKC.list ~~ (0x0052,), '1D5B1 -> 0052';
ok Uni.new(0x1D5B2).NFKC.list ~~ (0x0053,), '1D5B2 -> 0053';
ok Uni.new(0x1D5B3).NFKC.list ~~ (0x0054,), '1D5B3 -> 0054';
ok Uni.new(0x1D5B4).NFKC.list ~~ (0x0055,), '1D5B4 -> 0055';
ok Uni.new(0x1D5B5).NFKC.list ~~ (0x0056,), '1D5B5 -> 0056';
ok Uni.new(0x1D5B6).NFKC.list ~~ (0x0057,), '1D5B6 -> 0057';
ok Uni.new(0x1D5B7).NFKC.list ~~ (0x0058,), '1D5B7 -> 0058';
ok Uni.new(0x1D5B8).NFKC.list ~~ (0x0059,), '1D5B8 -> 0059';
ok Uni.new(0x1D5B9).NFKC.list ~~ (0x005A,), '1D5B9 -> 005A';
ok Uni.new(0x1D5BA).NFKC.list ~~ (0x0061,), '1D5BA -> 0061';
ok Uni.new(0x1D5BB).NFKC.list ~~ (0x0062,), '1D5BB -> 0062';
ok Uni.new(0x1D5BC).NFKC.list ~~ (0x0063,), '1D5BC -> 0063';
ok Uni.new(0x1D5BD).NFKC.list ~~ (0x0064,), '1D5BD -> 0064';
ok Uni.new(0x1D5BE).NFKC.list ~~ (0x0065,), '1D5BE -> 0065';
ok Uni.new(0x1D5BF).NFKC.list ~~ (0x0066,), '1D5BF -> 0066';
ok Uni.new(0x1D5C0).NFKC.list ~~ (0x0067,), '1D5C0 -> 0067';
ok Uni.new(0x1D5C1).NFKC.list ~~ (0x0068,), '1D5C1 -> 0068';
ok Uni.new(0x1D5C2).NFKC.list ~~ (0x0069,), '1D5C2 -> 0069';
ok Uni.new(0x1D5C3).NFKC.list ~~ (0x006A,), '1D5C3 -> 006A';
ok Uni.new(0x1D5C4).NFKC.list ~~ (0x006B,), '1D5C4 -> 006B';
ok Uni.new(0x1D5C5).NFKC.list ~~ (0x006C,), '1D5C5 -> 006C';
ok Uni.new(0x1D5C6).NFKC.list ~~ (0x006D,), '1D5C6 -> 006D';
ok Uni.new(0x1D5C7).NFKC.list ~~ (0x006E,), '1D5C7 -> 006E';
ok Uni.new(0x1D5C8).NFKC.list ~~ (0x006F,), '1D5C8 -> 006F';
ok Uni.new(0x1D5C9).NFKC.list ~~ (0x0070,), '1D5C9 -> 0070';
ok Uni.new(0x1D5CA).NFKC.list ~~ (0x0071,), '1D5CA -> 0071';
ok Uni.new(0x1D5CB).NFKC.list ~~ (0x0072,), '1D5CB -> 0072';
ok Uni.new(0x1D5CC).NFKC.list ~~ (0x0073,), '1D5CC -> 0073';
ok Uni.new(0x1D5CD).NFKC.list ~~ (0x0074,), '1D5CD -> 0074';
ok Uni.new(0x1D5CE).NFKC.list ~~ (0x0075,), '1D5CE -> 0075';
ok Uni.new(0x1D5CF).NFKC.list ~~ (0x0076,), '1D5CF -> 0076';
ok Uni.new(0x1D5D0).NFKC.list ~~ (0x0077,), '1D5D0 -> 0077';
ok Uni.new(0x1D5D1).NFKC.list ~~ (0x0078,), '1D5D1 -> 0078';
ok Uni.new(0x1D5D2).NFKC.list ~~ (0x0079,), '1D5D2 -> 0079';
ok Uni.new(0x1D5D3).NFKC.list ~~ (0x007A,), '1D5D3 -> 007A';
ok Uni.new(0x1D5D4).NFKC.list ~~ (0x0041,), '1D5D4 -> 0041';
ok Uni.new(0x1D5D5).NFKC.list ~~ (0x0042,), '1D5D5 -> 0042';
ok Uni.new(0x1D5D6).NFKC.list ~~ (0x0043,), '1D5D6 -> 0043';
ok Uni.new(0x1D5D7).NFKC.list ~~ (0x0044,), '1D5D7 -> 0044';
ok Uni.new(0x1D5D8).NFKC.list ~~ (0x0045,), '1D5D8 -> 0045';
ok Uni.new(0x1D5D9).NFKC.list ~~ (0x0046,), '1D5D9 -> 0046';
ok Uni.new(0x1D5DA).NFKC.list ~~ (0x0047,), '1D5DA -> 0047';
ok Uni.new(0x1D5DB).NFKC.list ~~ (0x0048,), '1D5DB -> 0048';
ok Uni.new(0x1D5DC).NFKC.list ~~ (0x0049,), '1D5DC -> 0049';
ok Uni.new(0x1D5DD).NFKC.list ~~ (0x004A,), '1D5DD -> 004A';
ok Uni.new(0x1D5DE).NFKC.list ~~ (0x004B,), '1D5DE -> 004B';
ok Uni.new(0x1D5DF).NFKC.list ~~ (0x004C,), '1D5DF -> 004C';
ok Uni.new(0x1D5E0).NFKC.list ~~ (0x004D,), '1D5E0 -> 004D';
ok Uni.new(0x1D5E1).NFKC.list ~~ (0x004E,), '1D5E1 -> 004E';
ok Uni.new(0x1D5E2).NFKC.list ~~ (0x004F,), '1D5E2 -> 004F';
ok Uni.new(0x1D5E3).NFKC.list ~~ (0x0050,), '1D5E3 -> 0050';
ok Uni.new(0x1D5E4).NFKC.list ~~ (0x0051,), '1D5E4 -> 0051';
ok Uni.new(0x1D5E5).NFKC.list ~~ (0x0052,), '1D5E5 -> 0052';
ok Uni.new(0x1D5E6).NFKC.list ~~ (0x0053,), '1D5E6 -> 0053';
ok Uni.new(0x1D5E7).NFKC.list ~~ (0x0054,), '1D5E7 -> 0054';
ok Uni.new(0x1D5E8).NFKC.list ~~ (0x0055,), '1D5E8 -> 0055';
ok Uni.new(0x1D5E9).NFKC.list ~~ (0x0056,), '1D5E9 -> 0056';
ok Uni.new(0x1D5EA).NFKC.list ~~ (0x0057,), '1D5EA -> 0057';
ok Uni.new(0x1D5EB).NFKC.list ~~ (0x0058,), '1D5EB -> 0058';
ok Uni.new(0x1D5EC).NFKC.list ~~ (0x0059,), '1D5EC -> 0059';
ok Uni.new(0x1D5ED).NFKC.list ~~ (0x005A,), '1D5ED -> 005A';
ok Uni.new(0x1D5EE).NFKC.list ~~ (0x0061,), '1D5EE -> 0061';
ok Uni.new(0x1D5EF).NFKC.list ~~ (0x0062,), '1D5EF -> 0062';
ok Uni.new(0x1D5F0).NFKC.list ~~ (0x0063,), '1D5F0 -> 0063';
ok Uni.new(0x1D5F1).NFKC.list ~~ (0x0064,), '1D5F1 -> 0064';
ok Uni.new(0x1D5F2).NFKC.list ~~ (0x0065,), '1D5F2 -> 0065';
ok Uni.new(0x1D5F3).NFKC.list ~~ (0x0066,), '1D5F3 -> 0066';
ok Uni.new(0x1D5F4).NFKC.list ~~ (0x0067,), '1D5F4 -> 0067';
ok Uni.new(0x1D5F5).NFKC.list ~~ (0x0068,), '1D5F5 -> 0068';
ok Uni.new(0x1D5F6).NFKC.list ~~ (0x0069,), '1D5F6 -> 0069';
ok Uni.new(0x1D5F7).NFKC.list ~~ (0x006A,), '1D5F7 -> 006A';
ok Uni.new(0x1D5F8).NFKC.list ~~ (0x006B,), '1D5F8 -> 006B';
ok Uni.new(0x1D5F9).NFKC.list ~~ (0x006C,), '1D5F9 -> 006C';
ok Uni.new(0x1D5FA).NFKC.list ~~ (0x006D,), '1D5FA -> 006D';
ok Uni.new(0x1D5FB).NFKC.list ~~ (0x006E,), '1D5FB -> 006E';
ok Uni.new(0x1D5FC).NFKC.list ~~ (0x006F,), '1D5FC -> 006F';
ok Uni.new(0x1D5FD).NFKC.list ~~ (0x0070,), '1D5FD -> 0070';
ok Uni.new(0x1D5FE).NFKC.list ~~ (0x0071,), '1D5FE -> 0071';
ok Uni.new(0x1D5FF).NFKC.list ~~ (0x0072,), '1D5FF -> 0072';
ok Uni.new(0x1D600).NFKC.list ~~ (0x0073,), '1D600 -> 0073';
ok Uni.new(0x1D601).NFKC.list ~~ (0x0074,), '1D601 -> 0074';
ok Uni.new(0x1D602).NFKC.list ~~ (0x0075,), '1D602 -> 0075';
ok Uni.new(0x1D603).NFKC.list ~~ (0x0076,), '1D603 -> 0076';
ok Uni.new(0x1D604).NFKC.list ~~ (0x0077,), '1D604 -> 0077';
ok Uni.new(0x1D605).NFKC.list ~~ (0x0078,), '1D605 -> 0078';
ok Uni.new(0x1D606).NFKC.list ~~ (0x0079,), '1D606 -> 0079';
ok Uni.new(0x1D607).NFKC.list ~~ (0x007A,), '1D607 -> 007A';
ok Uni.new(0x1D608).NFKC.list ~~ (0x0041,), '1D608 -> 0041';
ok Uni.new(0x1D609).NFKC.list ~~ (0x0042,), '1D609 -> 0042';
ok Uni.new(0x1D60A).NFKC.list ~~ (0x0043,), '1D60A -> 0043';
ok Uni.new(0x1D60B).NFKC.list ~~ (0x0044,), '1D60B -> 0044';
ok Uni.new(0x1D60C).NFKC.list ~~ (0x0045,), '1D60C -> 0045';
ok Uni.new(0x1D60D).NFKC.list ~~ (0x0046,), '1D60D -> 0046';
ok Uni.new(0x1D60E).NFKC.list ~~ (0x0047,), '1D60E -> 0047';
ok Uni.new(0x1D60F).NFKC.list ~~ (0x0048,), '1D60F -> 0048';
ok Uni.new(0x1D610).NFKC.list ~~ (0x0049,), '1D610 -> 0049';
ok Uni.new(0x1D611).NFKC.list ~~ (0x004A,), '1D611 -> 004A';
ok Uni.new(0x1D612).NFKC.list ~~ (0x004B,), '1D612 -> 004B';
ok Uni.new(0x1D613).NFKC.list ~~ (0x004C,), '1D613 -> 004C';
ok Uni.new(0x1D614).NFKC.list ~~ (0x004D,), '1D614 -> 004D';
ok Uni.new(0x1D615).NFKC.list ~~ (0x004E,), '1D615 -> 004E';
ok Uni.new(0x1D616).NFKC.list ~~ (0x004F,), '1D616 -> 004F';
ok Uni.new(0x1D617).NFKC.list ~~ (0x0050,), '1D617 -> 0050';
ok Uni.new(0x1D618).NFKC.list ~~ (0x0051,), '1D618 -> 0051';
ok Uni.new(0x1D619).NFKC.list ~~ (0x0052,), '1D619 -> 0052';
ok Uni.new(0x1D61A).NFKC.list ~~ (0x0053,), '1D61A -> 0053';
ok Uni.new(0x1D61B).NFKC.list ~~ (0x0054,), '1D61B -> 0054';
ok Uni.new(0x1D61C).NFKC.list ~~ (0x0055,), '1D61C -> 0055';
ok Uni.new(0x1D61D).NFKC.list ~~ (0x0056,), '1D61D -> 0056';
ok Uni.new(0x1D61E).NFKC.list ~~ (0x0057,), '1D61E -> 0057';
ok Uni.new(0x1D61F).NFKC.list ~~ (0x0058,), '1D61F -> 0058';
ok Uni.new(0x1D620).NFKC.list ~~ (0x0059,), '1D620 -> 0059';
ok Uni.new(0x1D621).NFKC.list ~~ (0x005A,), '1D621 -> 005A';
ok Uni.new(0x1D622).NFKC.list ~~ (0x0061,), '1D622 -> 0061';
ok Uni.new(0x1D623).NFKC.list ~~ (0x0062,), '1D623 -> 0062';
ok Uni.new(0x1D624).NFKC.list ~~ (0x0063,), '1D624 -> 0063';
ok Uni.new(0x1D625).NFKC.list ~~ (0x0064,), '1D625 -> 0064';
ok Uni.new(0x1D626).NFKC.list ~~ (0x0065,), '1D626 -> 0065';
ok Uni.new(0x1D627).NFKC.list ~~ (0x0066,), '1D627 -> 0066';
ok Uni.new(0x1D628).NFKC.list ~~ (0x0067,), '1D628 -> 0067';
ok Uni.new(0x1D629).NFKC.list ~~ (0x0068,), '1D629 -> 0068';
ok Uni.new(0x1D62A).NFKC.list ~~ (0x0069,), '1D62A -> 0069';
ok Uni.new(0x1D62B).NFKC.list ~~ (0x006A,), '1D62B -> 006A';
ok Uni.new(0x1D62C).NFKC.list ~~ (0x006B,), '1D62C -> 006B';
ok Uni.new(0x1D62D).NFKC.list ~~ (0x006C,), '1D62D -> 006C';
ok Uni.new(0x1D62E).NFKC.list ~~ (0x006D,), '1D62E -> 006D';
ok Uni.new(0x1D62F).NFKC.list ~~ (0x006E,), '1D62F -> 006E';
ok Uni.new(0x1D630).NFKC.list ~~ (0x006F,), '1D630 -> 006F';
ok Uni.new(0x1D631).NFKC.list ~~ (0x0070,), '1D631 -> 0070';
ok Uni.new(0x1D632).NFKC.list ~~ (0x0071,), '1D632 -> 0071';
ok Uni.new(0x1D633).NFKC.list ~~ (0x0072,), '1D633 -> 0072';
ok Uni.new(0x1D634).NFKC.list ~~ (0x0073,), '1D634 -> 0073';
ok Uni.new(0x1D635).NFKC.list ~~ (0x0074,), '1D635 -> 0074';
ok Uni.new(0x1D636).NFKC.list ~~ (0x0075,), '1D636 -> 0075';
ok Uni.new(0x1D637).NFKC.list ~~ (0x0076,), '1D637 -> 0076';
ok Uni.new(0x1D638).NFKC.list ~~ (0x0077,), '1D638 -> 0077';
ok Uni.new(0x1D639).NFKC.list ~~ (0x0078,), '1D639 -> 0078';
ok Uni.new(0x1D63A).NFKC.list ~~ (0x0079,), '1D63A -> 0079';
ok Uni.new(0x1D63B).NFKC.list ~~ (0x007A,), '1D63B -> 007A';
ok Uni.new(0x1D63C).NFKC.list ~~ (0x0041,), '1D63C -> 0041';
ok Uni.new(0x1D63D).NFKC.list ~~ (0x0042,), '1D63D -> 0042';
ok Uni.new(0x1D63E).NFKC.list ~~ (0x0043,), '1D63E -> 0043';
ok Uni.new(0x1D63F).NFKC.list ~~ (0x0044,), '1D63F -> 0044';
ok Uni.new(0x1D640).NFKC.list ~~ (0x0045,), '1D640 -> 0045';
ok Uni.new(0x1D641).NFKC.list ~~ (0x0046,), '1D641 -> 0046';
ok Uni.new(0x1D642).NFKC.list ~~ (0x0047,), '1D642 -> 0047';
ok Uni.new(0x1D643).NFKC.list ~~ (0x0048,), '1D643 -> 0048';
ok Uni.new(0x1D644).NFKC.list ~~ (0x0049,), '1D644 -> 0049';
ok Uni.new(0x1D645).NFKC.list ~~ (0x004A,), '1D645 -> 004A';
ok Uni.new(0x1D646).NFKC.list ~~ (0x004B,), '1D646 -> 004B';
ok Uni.new(0x1D647).NFKC.list ~~ (0x004C,), '1D647 -> 004C';
ok Uni.new(0x1D648).NFKC.list ~~ (0x004D,), '1D648 -> 004D';
ok Uni.new(0x1D649).NFKC.list ~~ (0x004E,), '1D649 -> 004E';
ok Uni.new(0x1D64A).NFKC.list ~~ (0x004F,), '1D64A -> 004F';
ok Uni.new(0x1D64B).NFKC.list ~~ (0x0050,), '1D64B -> 0050';
ok Uni.new(0x1D64C).NFKC.list ~~ (0x0051,), '1D64C -> 0051';
ok Uni.new(0x1D64D).NFKC.list ~~ (0x0052,), '1D64D -> 0052';
ok Uni.new(0x1D64E).NFKC.list ~~ (0x0053,), '1D64E -> 0053';
ok Uni.new(0x1D64F).NFKC.list ~~ (0x0054,), '1D64F -> 0054';
ok Uni.new(0x1D650).NFKC.list ~~ (0x0055,), '1D650 -> 0055';
ok Uni.new(0x1D651).NFKC.list ~~ (0x0056,), '1D651 -> 0056';
ok Uni.new(0x1D652).NFKC.list ~~ (0x0057,), '1D652 -> 0057';
ok Uni.new(0x1D653).NFKC.list ~~ (0x0058,), '1D653 -> 0058';
ok Uni.new(0x1D654).NFKC.list ~~ (0x0059,), '1D654 -> 0059';
ok Uni.new(0x1D655).NFKC.list ~~ (0x005A,), '1D655 -> 005A';
ok Uni.new(0x1D656).NFKC.list ~~ (0x0061,), '1D656 -> 0061';
ok Uni.new(0x1D657).NFKC.list ~~ (0x0062,), '1D657 -> 0062';
ok Uni.new(0x1D658).NFKC.list ~~ (0x0063,), '1D658 -> 0063';
ok Uni.new(0x1D659).NFKC.list ~~ (0x0064,), '1D659 -> 0064';
ok Uni.new(0x1D65A).NFKC.list ~~ (0x0065,), '1D65A -> 0065';
ok Uni.new(0x1D65B).NFKC.list ~~ (0x0066,), '1D65B -> 0066';
ok Uni.new(0x1D65C).NFKC.list ~~ (0x0067,), '1D65C -> 0067';
ok Uni.new(0x1D65D).NFKC.list ~~ (0x0068,), '1D65D -> 0068';
ok Uni.new(0x1D65E).NFKC.list ~~ (0x0069,), '1D65E -> 0069';
ok Uni.new(0x1D65F).NFKC.list ~~ (0x006A,), '1D65F -> 006A';
ok Uni.new(0x1D660).NFKC.list ~~ (0x006B,), '1D660 -> 006B';
ok Uni.new(0x1D661).NFKC.list ~~ (0x006C,), '1D661 -> 006C';
ok Uni.new(0x1D662).NFKC.list ~~ (0x006D,), '1D662 -> 006D';
ok Uni.new(0x1D663).NFKC.list ~~ (0x006E,), '1D663 -> 006E';
ok Uni.new(0x1D664).NFKC.list ~~ (0x006F,), '1D664 -> 006F';
ok Uni.new(0x1D665).NFKC.list ~~ (0x0070,), '1D665 -> 0070';
ok Uni.new(0x1D666).NFKC.list ~~ (0x0071,), '1D666 -> 0071';
ok Uni.new(0x1D667).NFKC.list ~~ (0x0072,), '1D667 -> 0072';
ok Uni.new(0x1D668).NFKC.list ~~ (0x0073,), '1D668 -> 0073';
ok Uni.new(0x1D669).NFKC.list ~~ (0x0074,), '1D669 -> 0074';
ok Uni.new(0x1D66A).NFKC.list ~~ (0x0075,), '1D66A -> 0075';
ok Uni.new(0x1D66B).NFKC.list ~~ (0x0076,), '1D66B -> 0076';
ok Uni.new(0x1D66C).NFKC.list ~~ (0x0077,), '1D66C -> 0077';
ok Uni.new(0x1D66D).NFKC.list ~~ (0x0078,), '1D66D -> 0078';
ok Uni.new(0x1D66E).NFKC.list ~~ (0x0079,), '1D66E -> 0079';
ok Uni.new(0x1D66F).NFKC.list ~~ (0x007A,), '1D66F -> 007A';
ok Uni.new(0x1D670).NFKC.list ~~ (0x0041,), '1D670 -> 0041';
ok Uni.new(0x1D671).NFKC.list ~~ (0x0042,), '1D671 -> 0042';
ok Uni.new(0x1D672).NFKC.list ~~ (0x0043,), '1D672 -> 0043';
ok Uni.new(0x1D673).NFKC.list ~~ (0x0044,), '1D673 -> 0044';
ok Uni.new(0x1D674).NFKC.list ~~ (0x0045,), '1D674 -> 0045';
ok Uni.new(0x1D675).NFKC.list ~~ (0x0046,), '1D675 -> 0046';
ok Uni.new(0x1D676).NFKC.list ~~ (0x0047,), '1D676 -> 0047';
ok Uni.new(0x1D677).NFKC.list ~~ (0x0048,), '1D677 -> 0048';
ok Uni.new(0x1D678).NFKC.list ~~ (0x0049,), '1D678 -> 0049';
ok Uni.new(0x1D679).NFKC.list ~~ (0x004A,), '1D679 -> 004A';
ok Uni.new(0x1D67A).NFKC.list ~~ (0x004B,), '1D67A -> 004B';
ok Uni.new(0x1D67B).NFKC.list ~~ (0x004C,), '1D67B -> 004C';
ok Uni.new(0x1D67C).NFKC.list ~~ (0x004D,), '1D67C -> 004D';
ok Uni.new(0x1D67D).NFKC.list ~~ (0x004E,), '1D67D -> 004E';
ok Uni.new(0x1D67E).NFKC.list ~~ (0x004F,), '1D67E -> 004F';
ok Uni.new(0x1D67F).NFKC.list ~~ (0x0050,), '1D67F -> 0050';
ok Uni.new(0x1D680).NFKC.list ~~ (0x0051,), '1D680 -> 0051';
ok Uni.new(0x1D681).NFKC.list ~~ (0x0052,), '1D681 -> 0052';
ok Uni.new(0x1D682).NFKC.list ~~ (0x0053,), '1D682 -> 0053';
ok Uni.new(0x1D683).NFKC.list ~~ (0x0054,), '1D683 -> 0054';
ok Uni.new(0x1D684).NFKC.list ~~ (0x0055,), '1D684 -> 0055';
ok Uni.new(0x1D685).NFKC.list ~~ (0x0056,), '1D685 -> 0056';
ok Uni.new(0x1D686).NFKC.list ~~ (0x0057,), '1D686 -> 0057';
ok Uni.new(0x1D687).NFKC.list ~~ (0x0058,), '1D687 -> 0058';
ok Uni.new(0x1D688).NFKC.list ~~ (0x0059,), '1D688 -> 0059';
ok Uni.new(0x1D689).NFKC.list ~~ (0x005A,), '1D689 -> 005A';
ok Uni.new(0x1D68A).NFKC.list ~~ (0x0061,), '1D68A -> 0061';
ok Uni.new(0x1D68B).NFKC.list ~~ (0x0062,), '1D68B -> 0062';
ok Uni.new(0x1D68C).NFKC.list ~~ (0x0063,), '1D68C -> 0063';
ok Uni.new(0x1D68D).NFKC.list ~~ (0x0064,), '1D68D -> 0064';
ok Uni.new(0x1D68E).NFKC.list ~~ (0x0065,), '1D68E -> 0065';
ok Uni.new(0x1D68F).NFKC.list ~~ (0x0066,), '1D68F -> 0066';
ok Uni.new(0x1D690).NFKC.list ~~ (0x0067,), '1D690 -> 0067';
ok Uni.new(0x1D691).NFKC.list ~~ (0x0068,), '1D691 -> 0068';
ok Uni.new(0x1D692).NFKC.list ~~ (0x0069,), '1D692 -> 0069';
ok Uni.new(0x1D693).NFKC.list ~~ (0x006A,), '1D693 -> 006A';
ok Uni.new(0x1D694).NFKC.list ~~ (0x006B,), '1D694 -> 006B';
ok Uni.new(0x1D695).NFKC.list ~~ (0x006C,), '1D695 -> 006C';
ok Uni.new(0x1D696).NFKC.list ~~ (0x006D,), '1D696 -> 006D';
ok Uni.new(0x1D697).NFKC.list ~~ (0x006E,), '1D697 -> 006E';
ok Uni.new(0x1D698).NFKC.list ~~ (0x006F,), '1D698 -> 006F';
ok Uni.new(0x1D699).NFKC.list ~~ (0x0070,), '1D699 -> 0070';
ok Uni.new(0x1D69A).NFKC.list ~~ (0x0071,), '1D69A -> 0071';
ok Uni.new(0x1D69B).NFKC.list ~~ (0x0072,), '1D69B -> 0072';
ok Uni.new(0x1D69C).NFKC.list ~~ (0x0073,), '1D69C -> 0073';
ok Uni.new(0x1D69D).NFKC.list ~~ (0x0074,), '1D69D -> 0074';
ok Uni.new(0x1D69E).NFKC.list ~~ (0x0075,), '1D69E -> 0075';
ok Uni.new(0x1D69F).NFKC.list ~~ (0x0076,), '1D69F -> 0076';
ok Uni.new(0x1D6A0).NFKC.list ~~ (0x0077,), '1D6A0 -> 0077';
ok Uni.new(0x1D6A1).NFKC.list ~~ (0x0078,), '1D6A1 -> 0078';
ok Uni.new(0x1D6A2).NFKC.list ~~ (0x0079,), '1D6A2 -> 0079';
ok Uni.new(0x1D6A3).NFKC.list ~~ (0x007A,), '1D6A3 -> 007A';
ok Uni.new(0x1D6A4).NFKC.list ~~ (0x0131,), '1D6A4 -> 0131';
ok Uni.new(0x1D6A5).NFKC.list ~~ (0x0237,), '1D6A5 -> 0237';
ok Uni.new(0x1D6A8).NFKC.list ~~ (0x0391,), '1D6A8 -> 0391';
ok Uni.new(0x1D6A9).NFKC.list ~~ (0x0392,), '1D6A9 -> 0392';
ok Uni.new(0x1D6AA).NFKC.list ~~ (0x0393,), '1D6AA -> 0393';
ok Uni.new(0x1D6AB).NFKC.list ~~ (0x0394,), '1D6AB -> 0394';
ok Uni.new(0x1D6AC).NFKC.list ~~ (0x0395,), '1D6AC -> 0395';
ok Uni.new(0x1D6AD).NFKC.list ~~ (0x0396,), '1D6AD -> 0396';
ok Uni.new(0x1D6AE).NFKC.list ~~ (0x0397,), '1D6AE -> 0397';
ok Uni.new(0x1D6AF).NFKC.list ~~ (0x0398,), '1D6AF -> 0398';
ok Uni.new(0x1D6B0).NFKC.list ~~ (0x0399,), '1D6B0 -> 0399';
ok Uni.new(0x1D6B1).NFKC.list ~~ (0x039A,), '1D6B1 -> 039A';
ok Uni.new(0x1D6B2).NFKC.list ~~ (0x039B,), '1D6B2 -> 039B';
ok Uni.new(0x1D6B3).NFKC.list ~~ (0x039C,), '1D6B3 -> 039C';
ok Uni.new(0x1D6B4).NFKC.list ~~ (0x039D,), '1D6B4 -> 039D';
ok Uni.new(0x1D6B5).NFKC.list ~~ (0x039E,), '1D6B5 -> 039E';
ok Uni.new(0x1D6B6).NFKC.list ~~ (0x039F,), '1D6B6 -> 039F';
ok Uni.new(0x1D6B7).NFKC.list ~~ (0x03A0,), '1D6B7 -> 03A0';
ok Uni.new(0x1D6B8).NFKC.list ~~ (0x03A1,), '1D6B8 -> 03A1';
ok Uni.new(0x1D6B9).NFKC.list ~~ (0x0398,), '1D6B9 -> 0398';
ok Uni.new(0x1D6BA).NFKC.list ~~ (0x03A3,), '1D6BA -> 03A3';
ok Uni.new(0x1D6BB).NFKC.list ~~ (0x03A4,), '1D6BB -> 03A4';
ok Uni.new(0x1D6BC).NFKC.list ~~ (0x03A5,), '1D6BC -> 03A5';
ok Uni.new(0x1D6BD).NFKC.list ~~ (0x03A6,), '1D6BD -> 03A6';
ok Uni.new(0x1D6BE).NFKC.list ~~ (0x03A7,), '1D6BE -> 03A7';
ok Uni.new(0x1D6BF).NFKC.list ~~ (0x03A8,), '1D6BF -> 03A8';
ok Uni.new(0x1D6C0).NFKC.list ~~ (0x03A9,), '1D6C0 -> 03A9';
ok Uni.new(0x1D6C1).NFKC.list ~~ (0x2207,), '1D6C1 -> 2207';
ok Uni.new(0x1D6C2).NFKC.list ~~ (0x03B1,), '1D6C2 -> 03B1';
ok Uni.new(0x1D6C3).NFKC.list ~~ (0x03B2,), '1D6C3 -> 03B2';
ok Uni.new(0x1D6C4).NFKC.list ~~ (0x03B3,), '1D6C4 -> 03B3';
ok Uni.new(0x1D6C5).NFKC.list ~~ (0x03B4,), '1D6C5 -> 03B4';
ok Uni.new(0x1D6C6).NFKC.list ~~ (0x03B5,), '1D6C6 -> 03B5';
ok Uni.new(0x1D6C7).NFKC.list ~~ (0x03B6,), '1D6C7 -> 03B6';
ok Uni.new(0x1D6C8).NFKC.list ~~ (0x03B7,), '1D6C8 -> 03B7';
ok Uni.new(0x1D6C9).NFKC.list ~~ (0x03B8,), '1D6C9 -> 03B8';
ok Uni.new(0x1D6CA).NFKC.list ~~ (0x03B9,), '1D6CA -> 03B9';
ok Uni.new(0x1D6CB).NFKC.list ~~ (0x03BA,), '1D6CB -> 03BA';
ok Uni.new(0x1D6CC).NFKC.list ~~ (0x03BB,), '1D6CC -> 03BB';
ok Uni.new(0x1D6CD).NFKC.list ~~ (0x03BC,), '1D6CD -> 03BC';
ok Uni.new(0x1D6CE).NFKC.list ~~ (0x03BD,), '1D6CE -> 03BD';
ok Uni.new(0x1D6CF).NFKC.list ~~ (0x03BE,), '1D6CF -> 03BE';
ok Uni.new(0x1D6D0).NFKC.list ~~ (0x03BF,), '1D6D0 -> 03BF';
ok Uni.new(0x1D6D1).NFKC.list ~~ (0x03C0,), '1D6D1 -> 03C0';
ok Uni.new(0x1D6D2).NFKC.list ~~ (0x03C1,), '1D6D2 -> 03C1';
ok Uni.new(0x1D6D3).NFKC.list ~~ (0x03C2,), '1D6D3 -> 03C2';
ok Uni.new(0x1D6D4).NFKC.list ~~ (0x03C3,), '1D6D4 -> 03C3';
ok Uni.new(0x1D6D5).NFKC.list ~~ (0x03C4,), '1D6D5 -> 03C4';
ok Uni.new(0x1D6D6).NFKC.list ~~ (0x03C5,), '1D6D6 -> 03C5';
ok Uni.new(0x1D6D7).NFKC.list ~~ (0x03C6,), '1D6D7 -> 03C6';
ok Uni.new(0x1D6D8).NFKC.list ~~ (0x03C7,), '1D6D8 -> 03C7';
ok Uni.new(0x1D6D9).NFKC.list ~~ (0x03C8,), '1D6D9 -> 03C8';
ok Uni.new(0x1D6DA).NFKC.list ~~ (0x03C9,), '1D6DA -> 03C9';
ok Uni.new(0x1D6DB).NFKC.list ~~ (0x2202,), '1D6DB -> 2202';
ok Uni.new(0x1D6DC).NFKC.list ~~ (0x03B5,), '1D6DC -> 03B5';
ok Uni.new(0x1D6DD).NFKC.list ~~ (0x03B8,), '1D6DD -> 03B8';
ok Uni.new(0x1D6DE).NFKC.list ~~ (0x03BA,), '1D6DE -> 03BA';
ok Uni.new(0x1D6DF).NFKC.list ~~ (0x03C6,), '1D6DF -> 03C6';
ok Uni.new(0x1D6E0).NFKC.list ~~ (0x03C1,), '1D6E0 -> 03C1';
ok Uni.new(0x1D6E1).NFKC.list ~~ (0x03C0,), '1D6E1 -> 03C0';
ok Uni.new(0x1D6E2).NFKC.list ~~ (0x0391,), '1D6E2 -> 0391';
ok Uni.new(0x1D6E3).NFKC.list ~~ (0x0392,), '1D6E3 -> 0392';
ok Uni.new(0x1D6E4).NFKC.list ~~ (0x0393,), '1D6E4 -> 0393';
ok Uni.new(0x1D6E5).NFKC.list ~~ (0x0394,), '1D6E5 -> 0394';
ok Uni.new(0x1D6E6).NFKC.list ~~ (0x0395,), '1D6E6 -> 0395';
ok Uni.new(0x1D6E7).NFKC.list ~~ (0x0396,), '1D6E7 -> 0396';
ok Uni.new(0x1D6E8).NFKC.list ~~ (0x0397,), '1D6E8 -> 0397';
ok Uni.new(0x1D6E9).NFKC.list ~~ (0x0398,), '1D6E9 -> 0398';
ok Uni.new(0x1D6EA).NFKC.list ~~ (0x0399,), '1D6EA -> 0399';
ok Uni.new(0x1D6EB).NFKC.list ~~ (0x039A,), '1D6EB -> 039A';
ok Uni.new(0x1D6EC).NFKC.list ~~ (0x039B,), '1D6EC -> 039B';
ok Uni.new(0x1D6ED).NFKC.list ~~ (0x039C,), '1D6ED -> 039C';
ok Uni.new(0x1D6EE).NFKC.list ~~ (0x039D,), '1D6EE -> 039D';
ok Uni.new(0x1D6EF).NFKC.list ~~ (0x039E,), '1D6EF -> 039E';
ok Uni.new(0x1D6F0).NFKC.list ~~ (0x039F,), '1D6F0 -> 039F';
ok Uni.new(0x1D6F1).NFKC.list ~~ (0x03A0,), '1D6F1 -> 03A0';
ok Uni.new(0x1D6F2).NFKC.list ~~ (0x03A1,), '1D6F2 -> 03A1';
ok Uni.new(0x1D6F3).NFKC.list ~~ (0x0398,), '1D6F3 -> 0398';
ok Uni.new(0x1D6F4).NFKC.list ~~ (0x03A3,), '1D6F4 -> 03A3';
ok Uni.new(0x1D6F5).NFKC.list ~~ (0x03A4,), '1D6F5 -> 03A4';
ok Uni.new(0x1D6F6).NFKC.list ~~ (0x03A5,), '1D6F6 -> 03A5';
ok Uni.new(0x1D6F7).NFKC.list ~~ (0x03A6,), '1D6F7 -> 03A6';
ok Uni.new(0x1D6F8).NFKC.list ~~ (0x03A7,), '1D6F8 -> 03A7';
ok Uni.new(0x1D6F9).NFKC.list ~~ (0x03A8,), '1D6F9 -> 03A8';
ok Uni.new(0x1D6FA).NFKC.list ~~ (0x03A9,), '1D6FA -> 03A9';
ok Uni.new(0x1D6FB).NFKC.list ~~ (0x2207,), '1D6FB -> 2207';
ok Uni.new(0x1D6FC).NFKC.list ~~ (0x03B1,), '1D6FC -> 03B1';
ok Uni.new(0x1D6FD).NFKC.list ~~ (0x03B2,), '1D6FD -> 03B2';
ok Uni.new(0x1D6FE).NFKC.list ~~ (0x03B3,), '1D6FE -> 03B3';
ok Uni.new(0x1D6FF).NFKC.list ~~ (0x03B4,), '1D6FF -> 03B4';
ok Uni.new(0x1D700).NFKC.list ~~ (0x03B5,), '1D700 -> 03B5';
ok Uni.new(0x1D701).NFKC.list ~~ (0x03B6,), '1D701 -> 03B6';
ok Uni.new(0x1D702).NFKC.list ~~ (0x03B7,), '1D702 -> 03B7';
ok Uni.new(0x1D703).NFKC.list ~~ (0x03B8,), '1D703 -> 03B8';
ok Uni.new(0x1D704).NFKC.list ~~ (0x03B9,), '1D704 -> 03B9';
ok Uni.new(0x1D705).NFKC.list ~~ (0x03BA,), '1D705 -> 03BA';
ok Uni.new(0x1D706).NFKC.list ~~ (0x03BB,), '1D706 -> 03BB';
ok Uni.new(0x1D707).NFKC.list ~~ (0x03BC,), '1D707 -> 03BC';
ok Uni.new(0x1D708).NFKC.list ~~ (0x03BD,), '1D708 -> 03BD';
ok Uni.new(0x1D709).NFKC.list ~~ (0x03BE,), '1D709 -> 03BE';
ok Uni.new(0x1D70A).NFKC.list ~~ (0x03BF,), '1D70A -> 03BF';
ok Uni.new(0x1D70B).NFKC.list ~~ (0x03C0,), '1D70B -> 03C0';
ok Uni.new(0x1D70C).NFKC.list ~~ (0x03C1,), '1D70C -> 03C1';
ok Uni.new(0x1D70D).NFKC.list ~~ (0x03C2,), '1D70D -> 03C2';
ok Uni.new(0x1D70E).NFKC.list ~~ (0x03C3,), '1D70E -> 03C3';
ok Uni.new(0x1D70F).NFKC.list ~~ (0x03C4,), '1D70F -> 03C4';
ok Uni.new(0x1D710).NFKC.list ~~ (0x03C5,), '1D710 -> 03C5';
ok Uni.new(0x1D711).NFKC.list ~~ (0x03C6,), '1D711 -> 03C6';
ok Uni.new(0x1D712).NFKC.list ~~ (0x03C7,), '1D712 -> 03C7';
ok Uni.new(0x1D713).NFKC.list ~~ (0x03C8,), '1D713 -> 03C8';
ok Uni.new(0x1D714).NFKC.list ~~ (0x03C9,), '1D714 -> 03C9';
ok Uni.new(0x1D715).NFKC.list ~~ (0x2202,), '1D715 -> 2202';
ok Uni.new(0x1D716).NFKC.list ~~ (0x03B5,), '1D716 -> 03B5';
ok Uni.new(0x1D717).NFKC.list ~~ (0x03B8,), '1D717 -> 03B8';
ok Uni.new(0x1D718).NFKC.list ~~ (0x03BA,), '1D718 -> 03BA';
ok Uni.new(0x1D719).NFKC.list ~~ (0x03C6,), '1D719 -> 03C6';
ok Uni.new(0x1D71A).NFKC.list ~~ (0x03C1,), '1D71A -> 03C1';
ok Uni.new(0x1D71B).NFKC.list ~~ (0x03C0,), '1D71B -> 03C0';
ok Uni.new(0x1D71C).NFKC.list ~~ (0x0391,), '1D71C -> 0391';
ok Uni.new(0x1D71D).NFKC.list ~~ (0x0392,), '1D71D -> 0392';
ok Uni.new(0x1D71E).NFKC.list ~~ (0x0393,), '1D71E -> 0393';
ok Uni.new(0x1D71F).NFKC.list ~~ (0x0394,), '1D71F -> 0394';
ok Uni.new(0x1D720).NFKC.list ~~ (0x0395,), '1D720 -> 0395';
ok Uni.new(0x1D721).NFKC.list ~~ (0x0396,), '1D721 -> 0396';
ok Uni.new(0x1D722).NFKC.list ~~ (0x0397,), '1D722 -> 0397';
ok Uni.new(0x1D723).NFKC.list ~~ (0x0398,), '1D723 -> 0398';
ok Uni.new(0x1D724).NFKC.list ~~ (0x0399,), '1D724 -> 0399';
ok Uni.new(0x1D725).NFKC.list ~~ (0x039A,), '1D725 -> 039A';
ok Uni.new(0x1D726).NFKC.list ~~ (0x039B,), '1D726 -> 039B';
ok Uni.new(0x1D727).NFKC.list ~~ (0x039C,), '1D727 -> 039C';
ok Uni.new(0x1D728).NFKC.list ~~ (0x039D,), '1D728 -> 039D';
ok Uni.new(0x1D729).NFKC.list ~~ (0x039E,), '1D729 -> 039E';
ok Uni.new(0x1D72A).NFKC.list ~~ (0x039F,), '1D72A -> 039F';
ok Uni.new(0x1D72B).NFKC.list ~~ (0x03A0,), '1D72B -> 03A0';
ok Uni.new(0x1D72C).NFKC.list ~~ (0x03A1,), '1D72C -> 03A1';
ok Uni.new(0x1D72D).NFKC.list ~~ (0x0398,), '1D72D -> 0398';
ok Uni.new(0x1D72E).NFKC.list ~~ (0x03A3,), '1D72E -> 03A3';
ok Uni.new(0x1D72F).NFKC.list ~~ (0x03A4,), '1D72F -> 03A4';
ok Uni.new(0x1D730).NFKC.list ~~ (0x03A5,), '1D730 -> 03A5';
ok Uni.new(0x1D731).NFKC.list ~~ (0x03A6,), '1D731 -> 03A6';
ok Uni.new(0x1D732).NFKC.list ~~ (0x03A7,), '1D732 -> 03A7';
ok Uni.new(0x1D733).NFKC.list ~~ (0x03A8,), '1D733 -> 03A8';
ok Uni.new(0x1D734).NFKC.list ~~ (0x03A9,), '1D734 -> 03A9';
ok Uni.new(0x1D735).NFKC.list ~~ (0x2207,), '1D735 -> 2207';
ok Uni.new(0x1D736).NFKC.list ~~ (0x03B1,), '1D736 -> 03B1';
ok Uni.new(0x1D737).NFKC.list ~~ (0x03B2,), '1D737 -> 03B2';
ok Uni.new(0x1D738).NFKC.list ~~ (0x03B3,), '1D738 -> 03B3';
ok Uni.new(0x1D739).NFKC.list ~~ (0x03B4,), '1D739 -> 03B4';
ok Uni.new(0x1D73A).NFKC.list ~~ (0x03B5,), '1D73A -> 03B5';
ok Uni.new(0x1D73B).NFKC.list ~~ (0x03B6,), '1D73B -> 03B6';
ok Uni.new(0x1D73C).NFKC.list ~~ (0x03B7,), '1D73C -> 03B7';
ok Uni.new(0x1D73D).NFKC.list ~~ (0x03B8,), '1D73D -> 03B8';
ok Uni.new(0x1D73E).NFKC.list ~~ (0x03B9,), '1D73E -> 03B9';
ok Uni.new(0x1D73F).NFKC.list ~~ (0x03BA,), '1D73F -> 03BA';
ok Uni.new(0x1D740).NFKC.list ~~ (0x03BB,), '1D740 -> 03BB';
ok Uni.new(0x1D741).NFKC.list ~~ (0x03BC,), '1D741 -> 03BC';
ok Uni.new(0x1D742).NFKC.list ~~ (0x03BD,), '1D742 -> 03BD';
ok Uni.new(0x1D743).NFKC.list ~~ (0x03BE,), '1D743 -> 03BE';
ok Uni.new(0x1D744).NFKC.list ~~ (0x03BF,), '1D744 -> 03BF';
ok Uni.new(0x1D745).NFKC.list ~~ (0x03C0,), '1D745 -> 03C0';
ok Uni.new(0x1D746).NFKC.list ~~ (0x03C1,), '1D746 -> 03C1';
ok Uni.new(0x1D747).NFKC.list ~~ (0x03C2,), '1D747 -> 03C2';
ok Uni.new(0x1D748).NFKC.list ~~ (0x03C3,), '1D748 -> 03C3';
ok Uni.new(0x1D749).NFKC.list ~~ (0x03C4,), '1D749 -> 03C4';
ok Uni.new(0x1D74A).NFKC.list ~~ (0x03C5,), '1D74A -> 03C5';
ok Uni.new(0x1D74B).NFKC.list ~~ (0x03C6,), '1D74B -> 03C6';
ok Uni.new(0x1D74C).NFKC.list ~~ (0x03C7,), '1D74C -> 03C7';
ok Uni.new(0x1D74D).NFKC.list ~~ (0x03C8,), '1D74D -> 03C8';
ok Uni.new(0x1D74E).NFKC.list ~~ (0x03C9,), '1D74E -> 03C9';
ok Uni.new(0x1D74F).NFKC.list ~~ (0x2202,), '1D74F -> 2202';
ok Uni.new(0x1D750).NFKC.list ~~ (0x03B5,), '1D750 -> 03B5';
ok Uni.new(0x1D751).NFKC.list ~~ (0x03B8,), '1D751 -> 03B8';
ok Uni.new(0x1D752).NFKC.list ~~ (0x03BA,), '1D752 -> 03BA';
ok Uni.new(0x1D753).NFKC.list ~~ (0x03C6,), '1D753 -> 03C6';
ok Uni.new(0x1D754).NFKC.list ~~ (0x03C1,), '1D754 -> 03C1';
ok Uni.new(0x1D755).NFKC.list ~~ (0x03C0,), '1D755 -> 03C0';
ok Uni.new(0x1D756).NFKC.list ~~ (0x0391,), '1D756 -> 0391';
ok Uni.new(0x1D757).NFKC.list ~~ (0x0392,), '1D757 -> 0392';
ok Uni.new(0x1D758).NFKC.list ~~ (0x0393,), '1D758 -> 0393';
ok Uni.new(0x1D759).NFKC.list ~~ (0x0394,), '1D759 -> 0394';
ok Uni.new(0x1D75A).NFKC.list ~~ (0x0395,), '1D75A -> 0395';
